/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.store.access.heap;

import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.ModuleControl;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.ModuleSupportable;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.Monitor;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.services.uuid.UUIDFactory;
import com.pivotal.gemfirexd.internal.iapi.store.access.ColumnOrdering;
import com.pivotal.gemfirexd.internal.iapi.store.access.conglomerate.Conglomerate;
import com.pivotal.gemfirexd.internal.iapi.store.access.conglomerate.ConglomerateFactory;
import com.pivotal.gemfirexd.internal.iapi.store.access.conglomerate.TransactionManager;
import com.pivotal.gemfirexd.internal.iapi.store.raw.ContainerHandle;
import com.pivotal.gemfirexd.internal.iapi.store.raw.ContainerKey;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Page;
import com.pivotal.gemfirexd.internal.iapi.store.raw.RecordHandle;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.impl.store.access.heap.Heap;
import com.pivotal.gemfirexd.internal.impl.store.access.heap.Heap_v10_2;
import java.util.Properties;

public class HeapConglomerateFactory
implements ConglomerateFactory,
ModuleControl,
ModuleSupportable {
    private static final String IMPLEMENTATIONID = "heap";
    private static final String FORMATUUIDSTRING = "D2976090-D9F5-11d0-B54D-00A024BF8878";
    private UUID formatUUID;

    @Override
    public Properties defaultProperties() {
        return new Properties();
    }

    @Override
    public boolean supportsImplementation(String implementationId) {
        return implementationId.equals(IMPLEMENTATIONID);
    }

    @Override
    public String primaryImplementationType() {
        return IMPLEMENTATIONID;
    }

    @Override
    public boolean supportsFormat(UUID formatid) {
        return formatid.equals(this.formatUUID);
    }

    @Override
    public UUID primaryFormat() {
        return this.formatUUID;
    }

    @Override
    public int getConglomerateFactoryId() {
        return 0;
    }

    @Override
    public Conglomerate createConglomerate(TransactionManager xact_mgr, int segment, long input_containerid, DataValueDescriptor[] template, ColumnOrdering[] columnOrder, int[] collationIds, Properties properties, int temporaryFlag) throws StandardException {
        Heap heap = null;
        heap = xact_mgr.checkVersion(10, 3, null) ? new Heap() : new Heap_v10_2();
        heap.create(xact_mgr.getRawStoreXact(), segment, input_containerid, template, columnOrder, collationIds, properties, heap.getTypeFormatId(), temporaryFlag);
        return heap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Conglomerate readConglomerate(TransactionManager xact_mgr, ContainerKey container_key) throws StandardException {
        ContainerHandle container = null;
        Page page = null;
        Object[] control_row = new DataValueDescriptor[1];
        try {
            container = xact_mgr.getRawStoreXact().openContainer(container_key, null, 0);
            if (container == null) {
                throw StandardException.newException("XSAI2.S", new Long(container_key.getContainerId()));
            }
            control_row[0] = new Heap();
            page = container.getPage(1L);
            RecordHandle rh = page.fetchFromSlot(null, 0, control_row, null, true);
            SanityManager.ASSERT((rh != null ? 1 : 0) != 0);
            SanityManager.ASSERT((rh.getId() == 6 ? 1 : 0) != 0);
        }
        finally {
            if (page != null) {
                page.unlatch();
            }
            if (container != null) {
                container.close();
            }
        }
        return (Conglomerate)control_row[0];
    }

    @Override
    public boolean canSupport(String identifier, Properties startParams) {
        String impl = startParams.getProperty("gemfirexd.access.Conglomerate.type");
        if (impl == null) {
            return false;
        }
        return this.supportsImplementation(impl);
    }

    @Override
    public void boot(boolean create, Properties startParams) throws StandardException {
        UUIDFactory uuidFactory = Monitor.getMonitor().getUUIDFactory();
        this.formatUUID = uuidFactory.recreateUUID(FORMATUUIDSTRING);
    }

    @Override
    public void stop() {
    }
}

