/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.store.access.btree;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.i18n.MessageService;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.store.access.ScanInfo;
import com.pivotal.gemfirexd.internal.impl.store.access.btree.BTreeScan;
import java.util.Properties;

class BTreeScanInfo
implements ScanInfo {
    private int stat_numpages_visited = 0;
    private int stat_numrows_visited = 0;
    private int stat_numrows_qualified = 0;
    private int stat_numdeleted_rows_visited = 0;
    private int stat_numColumnsFetched = 0;
    private int stat_treeHeight = 0;
    private FormatableBitSet stat_validColumns = null;

    BTreeScanInfo(BTreeScan scan) {
        this.stat_numpages_visited = scan.stat_numpages_visited;
        this.stat_numrows_visited = scan.stat_numrows_visited;
        this.stat_numrows_qualified = scan.stat_numrows_qualified;
        this.stat_numdeleted_rows_visited = scan.stat_numdeleted_rows_visited;
        FormatableBitSet formatableBitSet = this.stat_validColumns = scan.init_scanColumnList == null ? null : scan.init_scanColumnList.clone();
        if (this.stat_validColumns == null) {
            this.stat_numColumnsFetched = scan.init_template.length;
        } else {
            for (int i = 0; i < this.stat_validColumns.getLength(); ++i) {
                if (!this.stat_validColumns.get(i)) continue;
                ++this.stat_numColumnsFetched;
            }
        }
        try {
            this.stat_treeHeight = scan.getHeight();
        }
        catch (Throwable t) {
            this.stat_treeHeight = -1;
        }
    }

    @Override
    public Properties getAllScanInfo(Properties prop) throws StandardException {
        if (prop == null) {
            prop = new Properties();
        }
        prop.put(MessageService.getTextMessage("XSAJ0.U"), MessageService.getTextMessage("XSAJF.U"));
        prop.put(MessageService.getTextMessage("XSAJ1.U"), Integer.toString(this.stat_numpages_visited));
        prop.put(MessageService.getTextMessage("XSAJ2.U"), Integer.toString(this.stat_numrows_visited));
        prop.put(MessageService.getTextMessage("XSAJ3.U"), Integer.toString(this.stat_numdeleted_rows_visited));
        prop.put(MessageService.getTextMessage("XSAJ4.U"), Integer.toString(this.stat_numrows_qualified));
        prop.put(MessageService.getTextMessage("XSAJ7.U"), Integer.toString(this.stat_treeHeight));
        prop.put(MessageService.getTextMessage("XSAJ5.U"), Integer.toString(this.stat_numColumnsFetched));
        prop.put(MessageService.getTextMessage("XSAJ6.U"), this.stat_validColumns == null ? MessageService.getTextMessage("XSAJE.U") : this.stat_validColumns.toString());
        return prop;
    }
}

