/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.store.access.btree;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.CostEstimate;
import com.pivotal.gemfirexd.internal.iapi.store.access.StoreCostController;
import com.pivotal.gemfirexd.internal.iapi.store.access.StoreCostResult;
import com.pivotal.gemfirexd.internal.iapi.store.access.conglomerate.Conglomerate;
import com.pivotal.gemfirexd.internal.iapi.store.access.conglomerate.TransactionManager;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Transaction;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import com.pivotal.gemfirexd.internal.impl.store.access.btree.BTree;
import com.pivotal.gemfirexd.internal.impl.store.access.btree.ControlRow;
import com.pivotal.gemfirexd.internal.impl.store.access.btree.OpenBTree;
import com.pivotal.gemfirexd.internal.impl.store.access.btree.SearchParameters;
import java.util.Properties;

public class BTreeCostController
extends OpenBTree
implements StoreCostController {
    private static final double BTREE_CACHED_FETCH_BY_KEY_PER_LEVEL = 0.2705;
    private static final double BTREE_SORTMERGE_FETCH_BY_KEY_PER_LEVEL = 0.716;
    private static final double BTREE_UNCACHED_FETCH_BY_KEY_PER_LEVEL = 1.5715;
    TransactionManager init_xact_manager;
    Transaction init_rawtran;
    Conglomerate init_conglomerate;
    long num_pages;
    long num_rows;
    long page_size;
    int tree_height;

    public void init(TransactionManager xact_manager, BTree conglomerate, Transaction rawtran) throws StandardException {
        super.init(xact_manager, xact_manager, null, rawtran, false, 8, 5, null, conglomerate, null, null);
        this.num_pages = this.container.getEstimatedPageCount(0);
        this.num_rows = this.container.getEstimatedRowCount(0) - this.num_pages;
        Properties prop = new Properties();
        prop.put("gemfirexd.storage.pageSize", "");
        this.container.getContainerProperties(prop);
        this.page_size = Integer.parseInt(prop.getProperty("gemfirexd.storage.pageSize"));
        this.tree_height = this.getHeight();
    }

    @Override
    public void close() throws StandardException {
        super.close();
    }

    @Override
    public double getFetchFromRowLocationCost(FormatableBitSet validColumns, int access_type) throws StandardException {
        throw StandardException.newException("XSCB3.S");
    }

    @Override
    public double getFetchFromFullKeyCost(FormatableBitSet validColumns, int access_type, CostEstimate costEstimate) throws StandardException {
        double ret_cost = (access_type & 1) == 0 ? 1.5715 : 0.716;
        ret_cost *= (double)this.tree_height;
        if (costEstimate != null) {
            costEstimate.setEstimatedCost(ret_cost);
        }
        return ret_cost;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getScanCost(int scan_type, long row_count, int group_size, boolean forUpdate, FormatableBitSet scanColumnList, DataValueDescriptor[] template, DataValueDescriptor[] startKeyValue, int startSearchOperator, DataValueDescriptor[] stopKeyValue, int stopSearchOperator, boolean reopen_scan, int access_type, StoreCostResult cost_result) throws StandardException {
        ControlRow control_row = null;
        long input_row_count = row_count < 0L ? this.num_rows : row_count;
        try {
            float left_of_stop;
            SearchParameters sp;
            float left_of_start;
            if (startKeyValue == null) {
                left_of_start = 0.0f;
            } else {
                sp = new SearchParameters(startKeyValue, startSearchOperator == 1 ? 1 : -1, template, this, true);
                control_row = ControlRow.get(this, 1L).search(sp);
                control_row.release();
                control_row = null;
                left_of_start = sp.left_fraction;
            }
            if (stopKeyValue == null) {
                left_of_stop = 1.0f;
            } else {
                sp = new SearchParameters(stopKeyValue, stopSearchOperator == 1 ? 1 : -1, template, this, true);
                control_row = ControlRow.get(this, 1L).search(sp);
                control_row.release();
                control_row = null;
                left_of_stop = sp.left_fraction;
            }
            float ret_fraction = left_of_stop - left_of_start;
            if (ret_fraction < 0.0f) {
                ret_fraction = 0.0f;
            }
            if (ret_fraction > 1.0f) {
                ret_fraction = 1.0f;
            }
            float estimated_row_count = (float)input_row_count * ret_fraction;
            double cost = this.getFetchFromFullKeyCost(scanColumnList, access_type, null);
            cost += (double)((float)this.num_pages * ret_fraction) * 1.5;
            long cached_row_count = (long)estimated_row_count - this.num_pages;
            if (cached_row_count < 0L) {
                cached_row_count = 0L;
            }
            cost = scan_type == 2 ? (cost += (double)cached_row_count * 0.12) : (cost += (double)cached_row_count * 0.14);
            long row_size = input_row_count == 0L ? 4L : this.num_pages * this.page_size / input_row_count;
            cost += (double)(estimated_row_count * (float)row_size) * 0.004;
            if (cost < 0.0) {
                SanityManager.THROWASSERT((String)("cost " + cost));
            }
            if (estimated_row_count < 0.0f) {
                SanityManager.THROWASSERT((String)("estimated_row_count = " + estimated_row_count));
            }
            cost_result.setEstimatedCost(cost);
            cost_result.setEstimatedRowCount(Math.round(estimated_row_count));
        }
        finally {
            if (control_row != null) {
                control_row.release();
            }
        }
    }

    @Override
    public RowLocation newRowLocationTemplate() throws StandardException {
        throw StandardException.newException("XSCB3.S");
    }
}

