/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.store.access.btree;

import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapResourceHolder;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.store.access.ConglomerateController;
import com.pivotal.gemfirexd.internal.iapi.store.access.DynamicCompiledOpenConglomInfo;
import com.pivotal.gemfirexd.internal.iapi.store.access.RowLocationRetRowSource;
import com.pivotal.gemfirexd.internal.iapi.store.access.RowUtil;
import com.pivotal.gemfirexd.internal.iapi.store.access.StaticCompiledOpenConglomInfo;
import com.pivotal.gemfirexd.internal.iapi.store.access.conglomerate.LogicalUndo;
import com.pivotal.gemfirexd.internal.iapi.store.access.conglomerate.TransactionManager;
import com.pivotal.gemfirexd.internal.iapi.store.raw.ContainerHandle;
import com.pivotal.gemfirexd.internal.iapi.store.raw.FetchDescriptor;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Page;
import com.pivotal.gemfirexd.internal.iapi.store.raw.RecordHandle;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Transaction;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import com.pivotal.gemfirexd.internal.impl.store.access.btree.BTree;
import com.pivotal.gemfirexd.internal.impl.store.access.btree.BTreeLockingPolicy;
import com.pivotal.gemfirexd.internal.impl.store.access.btree.BranchRow;
import com.pivotal.gemfirexd.internal.impl.store.access.btree.ControlRow;
import com.pivotal.gemfirexd.internal.impl.store.access.btree.LeafControlRow;
import com.pivotal.gemfirexd.internal.impl.store.access.btree.OpenBTree;
import com.pivotal.gemfirexd.internal.impl.store.access.btree.SearchParameters;
import com.pivotal.gemfirexd.internal.impl.store.access.btree.WaitError;
import com.pivotal.gemfirexd.internal.impl.store.access.conglomerate.ConglomerateUtil;
import com.pivotal.gemfirexd.internal.impl.store.access.conglomerate.TemplateRow;
import java.util.Properties;

public class BTreeController
extends OpenBTree
implements ConglomerateController {
    transient DataValueDescriptor[] scratch_template = null;
    boolean get_insert_row_lock;
    private static final int NO_MATCH = 0;
    private static final int MATCH_FOUND = 1;
    private static final int RESCAN_REQUIRED = 2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean reclaim_deleted_rows(OpenBTree open_btree, long pageno) throws StandardException {
        boolean purged_at_least_one_row = false;
        ControlRow controlRow = null;
        try {
            block9: {
                controlRow = ControlRow.get(open_btree, pageno);
                if (controlRow == null) {
                    boolean bl = false;
                    return bl;
                }
                LeafControlRow leaf = (LeafControlRow)controlRow;
                BTreeLockingPolicy btree_locking_policy = open_btree.getLockingPolicy();
                int num_possible_commit_delete = leaf.page.recordCount() - 1 - leaf.page.nonDeletedRecordCount();
                if (num_possible_commit_delete <= 0) break block9;
                if (!btree_locking_policy.lockScanForReclaimSpace(leaf)) break;
                Page page = leaf.page;
                FetchDescriptor lock_fetch_desc = RowUtil.getFetchDescriptorConstant(this.scratch_template.length - 1);
                for (int slot_no = page.recordCount() - 1; slot_no > 0; --slot_no) {
                    if (!page.isDeletedAtSlot(slot_no) || !btree_locking_policy.lockScanCommittedDeletedRow(open_btree, leaf, this.scratch_template, lock_fetch_desc, slot_no)) continue;
                    page.purgeAtSlot(slot_no, 1, true);
                    purged_at_least_one_row = true;
                }
                break;
            }
        }
        catch (ClassCastException classCastException) {}
        finally {
            if (controlRow != null) {
                controlRow.release();
            }
            return purged_at_least_one_row;
        }
    }

    private long start_xact_and_dosplit(boolean attempt_to_reclaim_deleted_rows, long leaf_pageno, DataValueDescriptor[] scratch_template, DataValueDescriptor[] rowToInsert, int flag) throws StandardException {
        TransactionManager split_xact = null;
        OpenBTree split_open_btree = null;
        ControlRow root = null;
        split_xact = this.init_open_user_scans.getInternalTransaction();
        if ((this.getOpenMode() & 4) != 4) {
            SanityManager.THROWASSERT((String)"Container not opened with update should not cause split");
        }
        boolean do_split = true;
        if (attempt_to_reclaim_deleted_rows) {
            ConglomerateController base_cc = null;
            try {
                base_cc = this.getConglomerate().lockTable(split_xact, 132, 6, 4);
            }
            catch (StandardException standardException) {
                // empty catch block
            }
            if (base_cc != null) {
                split_open_btree = new OpenBTree();
                split_open_btree.init(this.init_open_user_scans, split_xact, null, split_xact.getRawStoreXact(), false, 132, 6, this.getConglomerate().getBtreeLockingPolicy(split_xact.getRawStoreXact(), 6, 1, 4, base_cc, split_open_btree), this.getConglomerate(), null, null);
                do_split = !this.reclaim_deleted_rows(split_open_btree, leaf_pageno);
                split_open_btree.close();
            }
        }
        long new_leaf_pageno = leaf_pageno;
        if (do_split) {
            split_open_btree = new OpenBTree();
            split_open_btree.init(this.init_open_user_scans, split_xact, null, split_xact.getRawStoreXact(), false, this.getOpenMode(), 5, this.getConglomerate().getBtreeLockingPolicy(split_xact.getRawStoreXact(), this.init_lock_level, 1, 4, null, split_open_btree), this.getConglomerate(), null, null);
            root = ControlRow.get(split_open_btree, 1L);
            SanityManager.ASSERT((boolean)root.page.isLatched());
            new_leaf_pageno = root.splitFor(split_open_btree, scratch_template, null, rowToInsert, flag);
            split_open_btree.close();
        }
        split_xact.commit();
        split_xact.destroy();
        return new_leaf_pageno;
    }

    private int comparePreviousRecord(int slot, LeafControlRow leaf, DataValueDescriptor[] rows, DataValueDescriptor[] oldRows) throws StandardException {
        RecordHandle rh = null;
        boolean newLeaf = false;
        LeafControlRow originalLeaf = leaf;
        while (leaf != null) {
            if (slot == 0) {
                LeafControlRow oldLeaf = leaf;
                try {
                    leaf = (LeafControlRow)leaf.getLeftSibling(this);
                    if (leaf == null) {
                        return 0;
                    }
                    slot = leaf.page.recordCount() - 1;
                    if (newLeaf) {
                        oldLeaf.release();
                    }
                    newLeaf = true;
                }
                catch (WaitError we) {
                    if (newLeaf) {
                        oldLeaf.release();
                    }
                    originalLeaf.release();
                    return 2;
                }
            }
            if ((rh = leaf.page.fetchFromSlot(null, slot, rows, null, true)) != null) {
                int ret = this.compareRowsForInsert(rows, oldRows, leaf, slot);
                if (ret == 2 && newLeaf) {
                    originalLeaf.release();
                }
                if (ret != 2 && newLeaf) {
                    leaf.release();
                }
                return ret;
            }
            ++slot;
        }
        return 0;
    }

    private int compareNextRecord(int slot, LeafControlRow leaf, DataValueDescriptor[] rows, DataValueDescriptor[] oldRows) throws StandardException {
        RecordHandle rh = null;
        boolean newLeaf = false;
        LeafControlRow originalLeaf = leaf;
        while (leaf != null) {
            if (slot >= leaf.page.recordCount()) {
                LeafControlRow oldLeaf = leaf;
                leaf = (LeafControlRow)leaf.getRightSibling(this);
                if (newLeaf) {
                    oldLeaf.release();
                }
                newLeaf = true;
                if (leaf == null) {
                    return 0;
                }
                slot = 1;
            }
            if ((rh = leaf.page.fetchFromSlot(null, slot, rows, null, true)) != null) {
                int ret = this.compareRowsForInsert(rows, oldRows, leaf, slot);
                if (ret == 2 && newLeaf) {
                    originalLeaf.release();
                }
                if (ret != 2 && newLeaf) {
                    leaf.release();
                }
                return ret;
            }
            ++slot;
        }
        return 0;
    }

    private int compareRowsForInsert(DataValueDescriptor[] originalRow, DataValueDescriptor[] newRow, LeafControlRow leaf, int slot) throws StandardException {
        boolean latch_released;
        for (int i = 0; i < originalRow.length - 1; ++i) {
            if (originalRow[i].equals(newRow[i])) continue;
            return 0;
        }
        DataValueDescriptor[] template = this.runtime_mem.get_template(this.getRawTran());
        FetchDescriptor lock_fetch_desc = RowUtil.getFetchDescriptorConstant(template.length - 1);
        RowLocation lock_row_loc = (RowLocation)this.scratch_template[this.scratch_template.length - 1];
        boolean bl = latch_released = !this.getLockingPolicy().lockNonScanRowOnPage(this.getConglomerate(), leaf, slot, lock_fetch_desc, template, lock_row_loc, 1);
        if (latch_released) {
            return 2;
        }
        if (!leaf.page.isDeletedAtSlot(slot)) {
            return 1;
        }
        return 0;
    }

    private int compareLeftAndRightSiblings(DataValueDescriptor[] rowToInsert, int insert_slot, LeafControlRow targetleaf) throws StandardException {
        if (this.getConglomerate().isUniqueWithDuplicateNulls()) {
            int keyParts = rowToInsert.length - 1;
            boolean hasnull = false;
            for (int i = 0; i < keyParts; ++i) {
                if (!rowToInsert[i].isNull()) continue;
                return 0;
            }
            if (!hasnull) {
                DataValueDescriptor[] index = this.runtime_mem.get_template(this.getRawTran());
                int ret = this.comparePreviousRecord(insert_slot - 1, targetleaf, index, rowToInsert);
                if (ret > 0) {
                    return ret;
                }
                return this.compareNextRecord(insert_slot, targetleaf, index, rowToInsert);
            }
        }
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int doIns(DataValueDescriptor[] rowToInsert) throws StandardException {
        LeafControlRow targetleaf = null;
        Object save_targetleaf = null;
        int insert_slot = 0;
        int result_slot = 0;
        int ret_val = 0;
        boolean reclaim_deleted_rows_attempted = false;
        if (this.scratch_template == null) {
            this.scratch_template = this.runtime_mem.get_template(this.getRawTran());
        }
        this.isIndexableRowConsistent(rowToInsert);
        SearchParameters sp = new SearchParameters(rowToInsert, 1, this.scratch_template, this, false);
        FetchDescriptor lock_fetch_desc = RowUtil.getFetchDescriptorConstant(this.scratch_template.length - 1);
        RowLocation lock_row_loc = (RowLocation)this.scratch_template[this.scratch_template.length - 1];
        if (this.get_insert_row_lock) {
            this.getLockingPolicy().lockNonScanRow(this.getConglomerate(), null, null, rowToInsert, 3);
        }
        while (true) {
            int ret;
            SanityManager.ASSERT((this.container != null ? 1 : 0) != 0);
            targetleaf = (LeafControlRow)ControlRow.get(this, 1L).search(sp);
            int slot_after_previous = sp.resultExact ? sp.resultSlot : sp.resultSlot + 1;
            boolean latch_released = false;
            latch_released = !this.getLockingPolicy().lockNonScanPreviousRow(this.getConglomerate(), targetleaf, slot_after_previous, lock_fetch_desc, this.scratch_template, lock_row_loc, this, 5, 1);
            latch_released = BTreeController.test_errors(this, "BTreeController_doIns", false, this.getLockingPolicy(), targetleaf, latch_released);
            if (latch_released) {
                targetleaf = null;
                continue;
            }
            if (sp.resultExact) {
                result_slot = insert_slot = sp.resultSlot;
                if (this.getConglomerate().nKeyFields != this.getConglomerate().nUniqueColumns) {
                    boolean bl = latch_released = !this.getLockingPolicy().lockNonScanRowOnPage(this.getConglomerate(), targetleaf, insert_slot, lock_fetch_desc, this.scratch_template, lock_row_loc, 1);
                    if (latch_released) {
                        targetleaf = null;
                        continue;
                    }
                }
                if (!targetleaf.page.isDeletedAtSlot(insert_slot)) {
                    ret_val = 1;
                    break;
                }
                if (this.getConglomerate().nKeyFields == this.getConglomerate().nUniqueColumns) {
                    targetleaf.page.deleteAtSlot(insert_slot, false, this.btree_undo);
                    break;
                }
                if (this.getConglomerate().nUniqueColumns != this.getConglomerate().nKeyFields - 1) throw StandardException.newException("XSCB3.S");
                targetleaf.page.deleteAtSlot(insert_slot, false, this.btree_undo);
                boolean update_succeeded = true;
                try {
                    int rowloc_index = this.getConglomerate().nKeyFields - 1;
                    targetleaf.page.updateFieldAtSlot(insert_slot, rowloc_index, RowUtil.getColumn(rowToInsert, (FormatableBitSet)null, rowloc_index), this.btree_undo);
                }
                catch (StandardException se) {
                    if (!se.getMessageId().equals("XSDA3.S")) {
                        throw se;
                    }
                    update_succeeded = false;
                    targetleaf.page.deleteAtSlot(insert_slot, true, this.btree_undo);
                }
                if (update_succeeded) {
                    break;
                }
            } else {
                int n = targetleaf.page.recordCount() - 1;
                this.getConglomerate();
                if (n < BTree.maxRowsPerPage) {
                    insert_slot = sp.resultSlot + 1;
                    result_slot = insert_slot + 1;
                    if (this.getConglomerate().isUniqueWithDuplicateNulls()) {
                        ret = this.compareLeftAndRightSiblings(rowToInsert, insert_slot, targetleaf);
                        if (ret == 1) {
                            ret_val = 1;
                            break;
                        }
                        if (ret == 2) continue;
                    }
                    if (targetleaf.page.insertAtSlot(insert_slot, rowToInsert, null, this.btree_undo, (byte)1, 50) != null) break;
                    if (targetleaf.page.recordCount() <= 2) {
                        throw StandardException.newException("XSCB6.S");
                    }
                }
            }
            if (this.getConglomerate().isUniqueWithDuplicateNulls()) {
                ret = this.compareLeftAndRightSiblings(rowToInsert, insert_slot, targetleaf);
                if (ret == 1) {
                    ret_val = 1;
                    break;
                }
                if (ret == 2) continue;
            }
            int flag = 0;
            if (insert_slot == 1) {
                flag |= 4;
                if (targetleaf.isLeftmostLeaf()) {
                    flag |= 8;
                }
            } else if (insert_slot == targetleaf.page.recordCount()) {
                flag |= 1;
                if (targetleaf.isRightmostLeaf()) {
                    flag |= 2;
                }
            }
            long targetleaf_pageno = targetleaf.page.getPageNumber();
            if (targetleaf.page.recordCount() - targetleaf.page.nonDeletedRecordCount() <= 0) {
                reclaim_deleted_rows_attempted = true;
            }
            BranchRow branchrow = BranchRow.createBranchRowFromOldLeafRow(rowToInsert, targetleaf_pageno);
            targetleaf.release();
            targetleaf = null;
            this.start_xact_and_dosplit(!reclaim_deleted_rows_attempted, targetleaf_pageno, this.scratch_template, branchrow.getRow(), flag);
            reclaim_deleted_rows_attempted = true;
        }
        targetleaf.last_search_result = result_slot;
        if (SanityManager.DEBUG_ON((String)"enableBtreeConsistencyCheck")) {
            targetleaf.checkConsistency(this, null, true);
        }
        targetleaf.release();
        return ret_val;
    }

    private boolean do_load_insert(DataValueDescriptor[] rowToInsert, LeafControlRow leaf, int insert_slot) throws StandardException {
        Object old_leaf = null;
        boolean row_inserted = false;
        int num_rows_on_page = leaf.page.recordCount() - 1;
        SanityManager.ASSERT((insert_slot == leaf.page.recordCount() ? 1 : 0) != 0);
        SanityManager.ASSERT((leaf.getrightSiblingPageNumber() == -1L ? 1 : 0) != 0);
        this.isIndexableRowConsistent(rowToInsert);
        this.getConglomerate();
        if (num_rows_on_page < BTree.maxRowsPerPage) {
            int compare_result;
            if (insert_slot > 1 && (compare_result = ControlRow.compareIndexRowFromPageToKey(leaf, insert_slot - 1, this.scratch_template, rowToInsert, this.getConglomerate().nUniqueColumns, 0, this.getConglomerate().ascDescInfo)) >= 0) {
                SanityManager.THROWASSERT((String)("result = " + compare_result));
            }
            if (leaf.page.insertAtSlot(insert_slot, rowToInsert, null, this.btree_undo, (byte)1, 50) != null) {
                row_inserted = true;
            } else if (leaf.page.recordCount() <= 2) {
                throw StandardException.newException("XSCB6.S");
            }
        }
        if (SanityManager.DEBUG_ON((String)"enableBtreeConsistencyCheck")) {
            leaf.checkConsistency(this, null, true);
        }
        return row_inserted;
    }

    private LeafControlRow do_load_split(DataValueDescriptor[] rowToInsert, LeafControlRow leaf) throws StandardException {
        LeafControlRow new_leaf = null;
        BranchRow branchrow = BranchRow.createBranchRowFromOldLeafRow(rowToInsert, leaf.page.getPageNumber());
        long old_leafpage = leaf.page.getPageNumber();
        leaf.release();
        leaf = null;
        long new_leaf_pageno = this.start_xact_and_dosplit(false, old_leafpage, this.scratch_template, branchrow.getRow(), 3);
        new_leaf = (LeafControlRow)ControlRow.get(this, new_leaf_pageno);
        if (new_leaf.getrightSiblingPageNumber() != -1L) {
            SanityManager.THROWASSERT((String)("new_leaf.getrightSiblingPageNumber() = " + new_leaf.getrightSiblingPageNumber()));
        }
        if (new_leaf.page.recordCount() <= 1) {
            SanityManager.THROWASSERT((String)("new_leaf.page.recordCount() = " + new_leaf.page.recordCount()));
        }
        return new_leaf;
    }

    public void init(TransactionManager xact_manager, boolean hold, ContainerHandle container, Transaction rawtran, int open_mode, int lock_level, BTreeLockingPolicy btree_locking_policy, BTree conglomerate, LogicalUndo undo, StaticCompiledOpenConglomInfo static_info, DynamicCompiledOpenConglomInfo dynamic_info) throws StandardException {
        this.get_insert_row_lock = (open_mode & 0x4000) == 0;
        super.init(xact_manager, xact_manager, container, rawtran, hold, open_mode, lock_level, btree_locking_policy, conglomerate, undo, dynamic_info);
    }

    @Override
    public void close() throws StandardException {
        super.close();
        if (this.getXactMgr() != null) {
            this.getXactMgr().closeMe(this);
        }
    }

    @Override
    public boolean closeForEndTransaction(boolean closeHeldScan) throws StandardException {
        super.close();
        if (!this.getHold() || closeHeldScan) {
            if (this.getXactMgr() != null) {
                this.getXactMgr().closeMe(this);
            }
            return true;
        }
        return false;
    }

    @Override
    public int insert(DataValueDescriptor[] row) throws StandardException {
        if (this.isClosed()) {
            if (this.getHold()) {
                this.reopen();
            } else {
                throw StandardException.newException("XSCB8.S", new Long(this.err_containerid));
            }
        }
        SanityManager.ASSERT((this.container != null ? 1 : 0) != 0);
        TemplateRow.checkPartialColumnTypes(this.getConglomerate().format_ids, null, null, row);
        return this.doIns(row);
    }

    @Override
    public boolean isKeyed() {
        return true;
    }

    @Override
    public void getTableProperties(Properties prop) throws StandardException {
        if (this.container == null) {
            throw StandardException.newException("XSCB8.S", new Long(this.err_containerid));
        }
        this.container.getContainerProperties(prop);
    }

    @Override
    public Properties getInternalTablePropertySet(Properties prop) throws StandardException {
        Properties ret_properties = ConglomerateUtil.createRawStorePropertySet(prop);
        this.getTableProperties(ret_properties);
        return ret_properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long load(TransactionManager xact_manager, boolean createConglom, RowLocationRetRowSource rowSource) throws StandardException {
        long num_rows_loaded = 0L;
        SanityManager.ASSERT((boolean)createConglom, (String)"Cannot load a btree incrementally - it must either be entirely logged, or entirely not logged.  Doesn't make sense to log only the allocation when one cannot guarantee to not touch any pre-existing pages");
        if (this.scratch_template == null) {
            this.scratch_template = this.runtime_mem.get_template(this.getRawTran());
        }
        LeafControlRow current_leaf = null;
        try {
            DataValueDescriptor[] row;
            current_leaf = (LeafControlRow)ControlRow.get(this, 1L);
            int current_insert_slot = 1;
            SanityManager.ASSERT((current_leaf.page.recordCount() == 1 ? 1 : 0) != 0);
            FormatableBitSet validColumns = rowSource.getValidColumns();
            while ((row = rowSource.getNextRowFromRowSource().getRowArray()) != null) {
                ++num_rows_loaded;
                SanityManager.ASSERT((validColumns == null ? 1 : 0) != 0, (String)"Does not support partial row");
                while (!this.do_load_insert(row, current_leaf, current_insert_slot)) {
                    current_leaf = this.do_load_split(row, current_leaf);
                    current_insert_slot = current_leaf.page.recordCount();
                }
                ++current_insert_slot;
            }
            current_leaf.release();
            current_leaf = null;
            if (!this.getConglomerate().isTemporary()) {
                this.container.flushContainer();
            }
        }
        finally {
            this.close();
        }
        return num_rows_loaded;
    }

    @Override
    public boolean delete(RowLocation loc) throws StandardException {
        throw StandardException.newException("XSCB3.S");
    }

    @Override
    public RowLocation fetch(RowLocation loc, DataValueDescriptor[] row, FormatableBitSet validColumns, boolean faultIn) throws StandardException {
        throw StandardException.newException("XSCB3.S");
    }

    @Override
    public RowLocation fetch(RowLocation loc, ExecRow row, FormatableBitSet validColumns, boolean faultIn) throws StandardException {
        throw StandardException.newException("XSCB3.S");
    }

    @Override
    public RowLocation fetch(RowLocation loc, ExecRow destRow, FormatableBitSet validColumns, boolean faultIn, OffHeapResourceHolder offheapOwner) throws StandardException {
        throw StandardException.newException("XSCB3.S");
    }

    @Override
    public RowLocation fetch(RowLocation loc, DataValueDescriptor[] row, FormatableBitSet validColumns, boolean waitForLock, boolean faultIn) throws StandardException {
        throw StandardException.newException("XSCB3.S");
    }

    @Override
    public RowLocation insertAndFetchLocation(DataValueDescriptor[] row, RowLocation templateRowLocation) throws StandardException {
        throw StandardException.newException("XSCB3.S");
    }

    @Override
    public RowLocation newRowLocationTemplate() throws StandardException {
        throw StandardException.newException("XSCB3.S");
    }

    @Override
    public boolean lockRow(RowLocation loc, int lock_operation, boolean wait, int lock_duration) throws StandardException {
        throw StandardException.newException("XSCB3.S");
    }

    @Override
    public boolean lockRow(long page_num, int record_id, int lock_operation, boolean wait, int lock_duration) throws StandardException {
        throw StandardException.newException("XSCB3.S");
    }

    @Override
    public void unlockRowAfterRead(RowLocation loc, boolean forUpdate, boolean row_qualifies) throws StandardException {
        throw StandardException.newException("XSCB3.S");
    }

    @Override
    public boolean replace(RowLocation loc, DataValueDescriptor[] row, FormatableBitSet validColumns) throws StandardException {
        throw StandardException.newException("XSCB3.S");
    }
}

