/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.rules;

import com.pivotal.gemfirexd.internal.engine.GfxdConstants;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.DMLQueryInfo;
import com.pivotal.gemfirexd.internal.iapi.services.property.PropertyUtil;
import com.pivotal.gemfirexd.internal.impl.sql.rules.AnyOneOfExecutionEngineRule;
import com.pivotal.gemfirexd.internal.impl.sql.rules.ColumnTableExecutionEngineRule;
import com.pivotal.gemfirexd.internal.impl.sql.rules.ExecutionEngineRule;
import com.pivotal.gemfirexd.internal.impl.sql.rules.ExecutionRuleContext;
import com.pivotal.gemfirexd.internal.impl.sql.rules.ReplicatedTableExecutionEngineRule;
import java.util.LinkedList;

public class ExecutionEngineArbiter {
    LinkedList<ExecutionEngineRule> executionEngineRules = new LinkedList();
    private static Boolean enableRoutingArbitor = Boolean.parseBoolean(PropertyUtil.getSystemProperty(GfxdConstants.GFXD_ROUTE_SELECTED_STORE_QUERIES_TO_SPARK, "true"));

    public ExecutionEngineArbiter() {
        this.executionEngineRules.add(new ColumnTableExecutionEngineRule());
        if (enableRoutingArbitor.booleanValue()) {
            this.executionEngineRules.add(new ReplicatedTableExecutionEngineRule());
            this.executionEngineRules.add(new AnyOneOfExecutionEngineRule());
        }
    }

    public ExecutionEngineRule.ExecutionEngine getExecutionEngine(DMLQueryInfo qInfo) {
        ExecutionRuleContext context = new ExecutionRuleContext(ExecutionEngineRule.ExecutionEngine.NOT_DECIDED);
        for (ExecutionEngineRule rule : this.executionEngineRules) {
            ExecutionEngineRule.ExecutionEngine engine = rule.getExecutionEngine(qInfo, context);
            if (engine == ExecutionEngineRule.ExecutionEngine.NOT_DECIDED) continue;
            return engine;
        }
        return ExecutionEngineRule.ExecutionEngine.STORE;
    }
}

