/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute.rts;

import com.pivotal.gemfirexd.internal.iapi.services.i18n.MessageService;
import com.pivotal.gemfirexd.internal.impl.sql.execute.rts.RealNoPutResultSetStatistics;

public class RealLastIndexKeyScanStatistics
extends RealNoPutResultSetStatistics {
    public String isolationLevel;
    public String tableName;
    public String indexName;
    public String lockString;

    public RealLastIndexKeyScanStatistics(int numOpens, long constructorTime, long openTime, long nextTime, long closeTime, int resultSetNumber, String tableName, String indexName, String isolationLevel, String lockString, double optimizerEstimatedRowCount, double optimizerEstimatedCost) {
        super(numOpens, 1, 0, constructorTime, openTime, nextTime, closeTime, resultSetNumber, optimizerEstimatedRowCount, optimizerEstimatedCost);
        this.tableName = tableName;
        this.indexName = indexName;
        this.isolationLevel = isolationLevel;
        this.lockString = lockString;
    }

    @Override
    public String getStatementExecutionPlanText(int depth) {
        Object isolationString = null;
        this.initFormatInfo(depth);
        String header = this.indent + MessageService.getTextMessage("43X71.U", this.tableName, this.indexName);
        header = header + MessageService.getTextMessage("43X72.U", this.isolationLevel, this.lockString);
        header = header + "\n";
        return header + this.indent + MessageService.getTextMessage("43X03.U") + " = " + this.numOpens + "\n" + this.indent + MessageService.getTextMessage("43X04.U") + " = " + this.numOpens + "\n" + this.dumpTimeStats(this.indent, this.subIndent) + "\n" + (this.rowsSeen > 0 ? this.subIndent + MessageService.getTextMessage("43X33.U") + " = " + this.nextTime / (long)this.numOpens + "\n" : "") + "\n" + this.dumpEstimatedCosts(this.subIndent);
    }

    @Override
    public String getScanStatisticsText(String tableName, int depth) {
        if (tableName == null || tableName.equals(this.tableName)) {
            return this.getStatementExecutionPlanText(depth);
        }
        return "";
    }

    public String toString() {
        return this.getStatementExecutionPlanText(0);
    }

    @Override
    public String getNodeName() {
        return MessageService.getTextMessage(this.indexName == null ? "43X73.U" : "43X74.U");
    }

    @Override
    public String getNodeOn() {
        if (this.indexName == null) {
            return MessageService.getTextMessage("43X75.U", this.tableName);
        }
        return MessageService.getTextMessage("43X38.U", this.tableName, this.indexName);
    }
}

