/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.jdbc.ConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TriggerDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.CursorResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.NoPutResultSet;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.impl.sql.execute.GenericExecutionFactory;
import com.pivotal.gemfirexd.internal.impl.sql.execute.GenericTriggerExecutor;
import com.pivotal.gemfirexd.internal.impl.sql.execute.InternalTriggerExecutionContext;
import com.pivotal.gemfirexd.internal.impl.sql.execute.RowTriggerExecutor;
import com.pivotal.gemfirexd.internal.impl.sql.execute.StatementTriggerExecutor;
import com.pivotal.gemfirexd.internal.impl.sql.execute.TriggerEvent;
import com.pivotal.gemfirexd.internal.impl.sql.execute.TriggerInfo;
import java.util.Vector;

class TriggerEventActivator {
    private LanguageConnectionContext lcc;
    private TriggerInfo triggerInfo;
    private InternalTriggerExecutionContext tec;
    private GenericTriggerExecutor[][] executors;
    private Activation activation;
    private ConnectionContext cc;
    private String statementText;
    private int dmlType;
    private UUID tableId;
    private String tableName;
    private Vector aiCounters;

    TriggerEventActivator(LanguageConnectionContext lcc, TransactionController tc, UUID tableId, TriggerInfo triggerInfo, int dmlType, Activation activation, Vector aiCounters) throws StandardException {
        if (triggerInfo == null) {
            return;
        }
        this.tableName = triggerInfo.triggerArray[0].getTableDescriptor().getQualifiedName();
        this.lcc = lcc;
        this.activation = activation;
        this.tableId = tableId;
        this.dmlType = dmlType;
        this.triggerInfo = triggerInfo;
        this.cc = (ConnectionContext)((Object)lcc.getContextManager().getContext("JDBC_ConnectionContext"));
        this.statementText = lcc.getStatementContext().getStatementText();
        this.tec = ((GenericExecutionFactory)lcc.getLanguageConnectionFactory().getExecutionFactory()).getTriggerExecutionContext(lcc, this.cc, this.statementText, dmlType, triggerInfo.columnIds, triggerInfo.columnNames, tableId, this.tableName, aiCounters);
        this.setupExecutors(triggerInfo);
    }

    void reopen() throws StandardException {
        this.tec = ((GenericExecutionFactory)this.lcc.getLanguageConnectionFactory().getExecutionFactory()).getTriggerExecutionContext(this.lcc, this.cc, this.statementText, this.dmlType, this.triggerInfo.columnIds, this.triggerInfo.columnNames, this.tableId, this.tableName, this.aiCounters);
        this.setupExecutors(this.triggerInfo);
    }

    private void setupExecutors(TriggerInfo triggerInfo) throws StandardException {
        int i;
        this.executors = new GenericTriggerExecutor[6][];
        Vector[] executorLists = new Vector[6];
        for (i = 0; i < 6; ++i) {
            executorLists[i] = new Vector();
        }
        block6: for (i = 0; i < triggerInfo.triggerArray.length; ++i) {
            TriggerDescriptor td = triggerInfo.triggerArray[i];
            switch (td.getTriggerEventMask()) {
                case 4: {
                    if (td.isBeforeTrigger()) {
                        executorLists[0].addElement(td);
                        continue block6;
                    }
                    executorLists[3].addElement(td);
                    continue block6;
                }
                case 2: {
                    if (td.isBeforeTrigger()) {
                        executorLists[1].addElement(td);
                        continue block6;
                    }
                    executorLists[4].addElement(td);
                    continue block6;
                }
                case 1: {
                    if (td.isBeforeTrigger()) {
                        executorLists[2].addElement(td);
                        continue block6;
                    }
                    executorLists[5].addElement(td);
                    continue block6;
                }
                default: {
                    SanityManager.THROWASSERT((String)("bad trigger event " + td.getTriggerEventMask()));
                }
            }
        }
        for (i = 0; i < executorLists.length; ++i) {
            int size = executorLists[i].size();
            if (size <= 0) continue;
            this.executors[i] = new GenericTriggerExecutor[size];
            for (int j = 0; j < size; ++j) {
                TriggerDescriptor td = (TriggerDescriptor)executorLists[i].elementAt(j);
                this.executors[i][j] = td.isRowTrigger() ? new RowTriggerExecutor(this.tec, td, this.activation, this.lcc) : new StatementTriggerExecutor(this.tec, td, this.activation, this.lcc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyEvent(TriggerEvent event, CursorResultSet brs, CursorResultSet ars) throws StandardException {
        if (this.executors == null) {
            return;
        }
        int eventNumber = event.getNumber();
        if (this.executors[eventNumber] == null) {
            return;
        }
        this.tec.setCurrentTriggerEvent(event);
        try {
            if (brs != null) {
                brs.open();
            }
            if (ars != null) {
                ars.open();
            }
            this.lcc.pushExecutionStmtValidator(this.tec);
            for (int i = 0; i < this.executors[eventNumber].length; ++i) {
                if (i > 0) {
                    if (brs != null) {
                        ((NoPutResultSet)((Object)brs)).reopenCore();
                    }
                    if (ars != null) {
                        ((NoPutResultSet)((Object)ars)).reopenCore();
                    }
                }
                this.tec.resetAICounters(true);
                this.executors[eventNumber][i].fireTrigger(event, brs, ars);
            }
        }
        finally {
            this.lcc.popExecutionStmtValidator(this.tec);
            this.tec.clearCurrentTriggerEvent();
        }
    }

    void cleanup(boolean cleanupOnError) throws StandardException {
        if (this.tec != null) {
            this.tec.cleanup(cleanupOnError);
        }
    }
}

