/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecAggregator;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.NumberDataValue;
import com.pivotal.gemfirexd.internal.iapi.types.SQLDouble;
import com.pivotal.gemfirexd.internal.iapi.types.SQLInteger;
import com.pivotal.gemfirexd.internal.iapi.types.SQLLongint;
import com.pivotal.gemfirexd.internal.iapi.types.TypeId;
import com.pivotal.gemfirexd.internal.impl.sql.execute.OrderableAggregator;

public class SumAggregator
extends OrderableAggregator {
    protected boolean typePromoted;

    @Override
    protected void basicAccumulate(DataValueDescriptor addend) throws StandardException {
        if (this.value == null) {
            this.value = addend.getClone();
        } else if (this.value.isNull()) {
            if (!addend.isNull()) {
                this.value.setValue(addend);
            }
        } else {
            NumberDataValue input = (NumberDataValue)addend;
            NumberDataValue nv = (NumberDataValue)this.value;
            try {
                this.value = nv.plus(input, nv, nv);
            }
            catch (StandardException se) {
                if (!se.getMessageId().equals("22003")) {
                    throw se;
                }
                this.value = this.promoteType();
                this.basicAccumulate(addend);
            }
        }
    }

    @Override
    public void clear() {
        if (this.value != null) {
            if (this.typePromoted) {
                this.value = null;
                this.typePromoted = false;
            } else {
                this.value.restoreToNull();
            }
        }
        super.clear();
    }

    protected final DataValueDescriptor promoteType() throws StandardException {
        DataValueDescriptor newValue;
        switch (this.value.getTypeFormatId()) {
            case 80: {
                newValue = new SQLLongint();
                break;
            }
            case 83: 
            case 199: {
                newValue = new SQLInteger();
                break;
            }
            case 81: {
                newValue = new SQLDouble();
                break;
            }
            default: {
                TypeId decimalTypeId = TypeId.getBuiltInTypeId(3);
                newValue = decimalTypeId.getNull();
            }
        }
        newValue.setValue(this.value);
        this.typePromoted = true;
        return newValue;
    }

    @Override
    public ExecAggregator newAggregator() {
        return new SumAggregator();
    }

    @Override
    public int getTypeFormatId() {
        return 154;
    }
}

