/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.gemstone.gemfire.internal.cache.TXState;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.sql.execute.AbstractGemFireResultSet;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.CursorResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.NoPutResultSet;
import com.pivotal.gemfirexd.internal.iapi.store.access.BackingStoreHashtable;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import com.pivotal.gemfirexd.internal.iapi.types.SQLBoolean;
import com.pivotal.gemfirexd.internal.iapi.types.SQLInteger;
import com.pivotal.gemfirexd.internal.impl.sql.execute.CursorActivation;
import com.pivotal.gemfirexd.internal.impl.sql.execute.NoPutResultSetImpl;
import com.pivotal.gemfirexd.internal.impl.sql.execute.PlanUtils;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ProjectRestrictResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ResultSetStatisticsVisitor;
import com.pivotal.gemfirexd.internal.impl.sql.execute.xplain.XPLAINUtil;

public class ScrollInsensitiveResultSet
extends NoPutResultSetImpl
implements CursorResultSet {
    public NoPutResultSet source;
    private int sourceRowWidth;
    private BackingStoreHashtable ht;
    private ExecRow resultRow;
    private int positionInSource;
    private int currentPosition;
    private int lastPosition;
    private boolean seenFirst;
    private boolean seenLast;
    private boolean beforeFirst = true;
    private boolean afterLast;
    public int numFromHashTable;
    public int numToHashTable;
    private int maxRows;
    private boolean keepAfterCommit;
    private int extraColumns;
    private SQLInteger positionInHashTable;
    private CursorResultSet target;
    private boolean needsRepositioning;
    private static final int POS_ROWLOCATION = 1;
    private static final int POS_ROWDELETED = 2;
    private static final int POS_ROWUPDATED = 3;
    private static final int LAST_EXTRA_COLUMN = 3;
    private boolean hasLockReference;

    public ScrollInsensitiveResultSet(NoPutResultSet source, Activation activation, int resultSetNumber, int sourceRowWidth, double optimizerEstimatedRowCount, double optimizerEstimatedCost) throws StandardException {
        super(activation, resultSetNumber, optimizerEstimatedRowCount, optimizerEstimatedCost);
        this.source = source;
        this.sourceRowWidth = sourceRowWidth;
        this.keepAfterCommit = activation.getResultSetHoldability();
        this.maxRows = activation.getMaxRows();
        SanityManager.ASSERT((this.maxRows != -1 ? 1 : 0) != 0, (String)"maxRows not expected to be -1");
        this.positionInHashTable = new SQLInteger();
        this.needsRepositioning = false;
        if (this.isForUpdate()) {
            this.target = ((CursorActivation)activation).getTargetResultSet();
            this.extraColumns = 4;
        } else {
            this.target = null;
            this.extraColumns = 1;
        }
        this.initLocalTXState();
        this.recordConstructorTime();
        this.printResultSetHierarchy();
    }

    @Override
    public void openCore() throws StandardException {
        this.beginTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
        SanityManager.ASSERT((!this.isOpen ? 1 : 0) != 0, (String)"ScrollInsensitiveResultSet already open");
        this.isOpen = true;
        this.source.openCore();
        ++this.numOpens;
        int[] keyCols = new int[]{0};
        this.ht = new BackingStoreHashtable(this.getTransactionController(), null, keyCols, false, -1L, -1L, -1, -1.0f, false, this.keepAfterCommit);
        this.lastPosition = 0;
        this.needsRepositioning = false;
        this.numFromHashTable = 0;
        this.numToHashTable = 0;
        this.positionInSource = 0;
        this.seenFirst = false;
        this.seenLast = false;
        this.maxRows = this.activation.getMaxRows();
        if (this.statisticsTimingOn) {
            this.openTime += this.getElapsedNanos(this.beginTime);
        }
        this.setBeforeFirstRow();
    }

    @Override
    public void reopenCore() throws StandardException {
        boolean constantEval = true;
        this.beginTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
        SanityManager.ASSERT((boolean)this.isOpen, (String)"ScrollInsensitiveResultSet already open");
        SanityManager.THROWASSERT((String)"reopenCore() not expected to be called");
        this.setBeforeFirstRow();
    }

    @Override
    public ExecRow getAbsoluteRow(int row) throws StandardException {
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S.0", "absolute");
        }
        this.attachStatementContext();
        if (!this.isTopResultSet) {
            SanityManager.THROWASSERT((String)(this + "expected to be the top ResultSet"));
        }
        if (row == 0) {
            this.setBeforeFirstRow();
            return null;
        }
        if (this.seenLast && row > this.lastPosition) {
            return this.setAfterLastRow();
        }
        if (row > 0) {
            if (row <= this.positionInSource) {
                return this.getRowFromHashTable(row);
            }
            ExecRow result = null;
            for (int diff = row - this.positionInSource; diff > 0 && (result = this.getNextRowFromSource()) != null; --diff) {
            }
            if (result != null) {
                result = this.getRowFromHashTable(row);
            }
            this.currentRow = result;
            return result;
        }
        if (row < 0) {
            int beyondResult;
            if (!this.seenLast) {
                this.getLastRow();
            }
            if ((beyondResult = this.lastPosition + 1) + row > 0) {
                return this.getRowFromHashTable(beyondResult + row);
            }
            return this.setBeforeFirstRow();
        }
        this.currentRow = null;
        return null;
    }

    @Override
    public ExecRow getRelativeRow(int row) throws StandardException {
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S.0", "relative");
        }
        this.attachStatementContext();
        if (!this.isTopResultSet) {
            SanityManager.THROWASSERT((String)(this + "expected to be the top ResultSet"));
        }
        if (row == 0) {
            if (this.beforeFirst || this.afterLast || this.currentPosition == 0) {
                return null;
            }
            return this.getRowFromHashTable(this.currentPosition);
        }
        if (row > 0) {
            return this.getAbsoluteRow(this.currentPosition + row);
        }
        if (this.currentPosition + row < 0) {
            return this.setBeforeFirstRow();
        }
        return this.getAbsoluteRow(this.currentPosition + row);
    }

    @Override
    public ExecRow setBeforeFirstRow() {
        this.currentPosition = 0;
        this.beforeFirst = true;
        this.afterLast = false;
        this.currentRow = null;
        return null;
    }

    @Override
    public ExecRow getFirstRow() throws StandardException {
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S.0", "first");
        }
        if (this.seenFirst) {
            return this.getRowFromHashTable(1);
        }
        this.attachStatementContext();
        if (!this.isTopResultSet) {
            SanityManager.THROWASSERT((String)(this + "expected to be the top ResultSet"));
        }
        return this.getNextRowCore();
    }

    @Override
    public ExecRow getNextRowCore() throws StandardException {
        ExecRow result = null;
        long l = this.beginTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S.0", "next");
        }
        if (this.seenLast && this.currentPosition == this.lastPosition) {
            return this.setAfterLastRow();
        }
        if (this.currentPosition == this.positionInSource) {
            result = this.getNextRowFromSource();
            if (result != null) {
                result = this.getRowFromHashTable(this.currentPosition);
            }
        } else {
            result = this.currentPosition < this.positionInSource ? this.getRowFromHashTable(this.currentPosition + 1) : null;
        }
        if (result != null) {
            ++this.rowsSeen;
            this.afterLast = false;
        }
        this.setCurrentRow(result);
        this.beforeFirst = false;
        if (this.localTXState != null && this.isTopResultSet && result != null && this.isForUpdate()) {
            this.updateRowLocationPostRead();
        }
        if (this.statisticsTimingOn) {
            this.nextTime += this.getElapsedNanos(this.beginTime);
        }
        return result;
    }

    @Override
    public ExecRow getPreviousRow() throws StandardException {
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S.0", "next");
        }
        if (!this.isTopResultSet) {
            SanityManager.THROWASSERT((String)(this + "expected to be the top ResultSet"));
        }
        if (this.beforeFirst || this.currentPosition == 0) {
            this.currentRow = null;
            return null;
        }
        if (this.afterLast) {
            if (this.lastPosition == 0) {
                this.afterLast = false;
                this.beforeFirst = false;
                this.currentRow = null;
                return null;
            }
            return this.getRowFromHashTable(this.lastPosition);
        }
        --this.currentPosition;
        if (this.currentPosition == 0) {
            this.setBeforeFirstRow();
            return null;
        }
        return this.getRowFromHashTable(this.currentPosition);
    }

    @Override
    public ExecRow getLastRow() throws StandardException {
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S.0", "next");
        }
        if (!this.seenLast) {
            this.attachStatementContext();
            if (!this.isTopResultSet) {
                SanityManager.THROWASSERT((String)(this + "expected to be the top ResultSet"));
            }
            ExecRow result = null;
            while ((result = this.getNextRowFromSource()) != null) {
            }
        }
        if (!this.seenLast) {
            SanityManager.THROWASSERT((String)(this + "expected to have seen last"));
        }
        this.beforeFirst = false;
        this.afterLast = false;
        if (this.lastPosition == 0) {
            this.currentRow = null;
            return null;
        }
        return this.getRowFromHashTable(this.lastPosition);
    }

    @Override
    public ExecRow setAfterLastRow() throws StandardException {
        if (!this.seenLast) {
            this.getLastRow();
        }
        if (this.lastPosition == 0) {
            this.currentPosition = 0;
            this.afterLast = false;
        } else {
            this.currentPosition = this.lastPosition + 1;
            this.afterLast = true;
        }
        this.beforeFirst = false;
        this.currentRow = null;
        return null;
    }

    @Override
    public boolean checkRowPosition(int isType) throws StandardException {
        switch (isType) {
            case 101: {
                if (!this.beforeFirst) {
                    return false;
                }
                if (this.seenFirst) {
                    return true;
                }
                ExecRow firstRow = this.getFirstRow();
                if (firstRow == null) {
                    return false;
                }
                this.getPreviousRow();
                return true;
            }
            case 102: {
                return this.currentPosition == 1;
            }
            case 103: {
                if (this.beforeFirst || this.afterLast || this.currentPosition == 0 || this.currentPosition < this.positionInSource) {
                    return false;
                }
                if (this.seenLast) {
                    return this.currentPosition == this.lastPosition;
                }
                int savePosition = this.currentPosition;
                boolean retval = this.getNextRowFromSource() == null;
                this.getRowFromHashTable(savePosition);
                return retval;
            }
            case 104: {
                return this.afterLast;
            }
        }
        return false;
    }

    @Override
    public int getRowNumber() {
        return this.currentRow == null ? 0 : this.currentPosition;
    }

    private ExecRow getNextRowFromSource() throws StandardException {
        ExecRow sourceRow = null;
        Object result = null;
        if (this.maxRows > 0 && this.maxRows == this.positionInSource) {
            this.seenLast = true;
            this.lastPosition = this.positionInSource;
            this.afterLast = true;
            return null;
        }
        if (this.needsRepositioning) {
            this.positionInLastFetchedRow();
            this.needsRepositioning = false;
        }
        if ((sourceRow = this.source.getNextRowCore()) != null) {
            this.seenFirst = true;
            this.beforeFirst = false;
            if (this.resultRow == null) {
                this.resultRow = this.activation.getExecutionFactory().getValueRow(this.sourceRowWidth);
            }
            ++this.positionInSource;
            this.currentPosition = this.positionInSource;
            RowLocation rowLoc = null;
            if (this.source.isForUpdate()) {
                rowLoc = ((CursorResultSet)((Object)this.source)).getRowLocation();
            }
            this.addRowToHashTable(sourceRow, this.currentPosition, rowLoc, false);
            this.source.releasePreviousByteSource();
        } else {
            if (!this.seenLast) {
                this.lastPosition = this.positionInSource;
            }
            this.seenLast = true;
            if (this.positionInSource == 0) {
                this.afterLast = false;
            } else {
                this.afterLast = true;
                this.currentPosition = this.positionInSource + 1;
            }
        }
        return sourceRow;
    }

    @Override
    public void close(boolean cleanupOnError) throws StandardException {
        long l = this.beginTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
        if (this.isOpen) {
            this.currentRow = null;
            this.source.close(cleanupOnError);
            if (this.ht != null) {
                this.ht.close();
                this.ht = null;
            }
            super.close(cleanupOnError);
        } else {
            SanityManager.DEBUG((String)"CloseRepeatInfo", (String)"Close of ScrollInsensitiveResultSet repeated");
        }
        this.setBeforeFirstRow();
        if (this.statisticsTimingOn) {
            this.closeTime += this.getElapsedNanos(this.beginTime);
        }
    }

    @Override
    public void finish() throws StandardException {
        this.source.finish();
        this.finishAndRTS();
    }

    @Override
    public final long getTimeSpent(int type, int timeType) {
        long time = PlanUtils.getTimeSpent(this.constructorTime, this.openTime, this.nextTime, this.closeTime, timeType);
        if (type == 0) {
            return time - this.source.getTimeSpent(1, timeType);
        }
        return timeType == 0 ? time - this.constructorTime : time;
    }

    @Override
    public RowLocation getRowLocation() throws StandardException {
        SanityManager.ASSERT((boolean)(this.source instanceof CursorResultSet), (String)"source not CursorResultSet");
        return ((CursorResultSet)((Object)this.source)).getRowLocation();
    }

    @Override
    public ExecRow getCurrentRow() throws StandardException {
        if (this.isForUpdate() && this.isDeleted()) {
            return null;
        }
        return this.currentRow;
    }

    private void addRowToHashTable(ExecRow sourceRow, int position, RowLocation rowLoc, boolean rowUpdated) throws StandardException {
        DataValueDescriptor[] hashRowArray = new DataValueDescriptor[this.sourceRowWidth + this.extraColumns];
        hashRowArray[0] = new SQLInteger(position);
        if (this.isForUpdate()) {
            hashRowArray[1] = rowLoc.getClone();
            hashRowArray[2] = new SQLBoolean(false);
            hashRowArray[3] = new SQLBoolean(rowUpdated);
        }
        DataValueDescriptor[] sourceRowArray = sourceRow.getRowArray();
        System.arraycopy(sourceRowArray, 0, hashRowArray, this.extraColumns, this.sourceRowWidth);
        this.ht.putRow(true, hashRowArray, null);
        ++this.numToHashTable;
    }

    private ExecRow getRowFromHashTable(int position) throws StandardException {
        this.positionInHashTable.setValue(position);
        DataValueDescriptor[] hashRowArray = (DataValueDescriptor[])this.ht.get(this.positionInHashTable);
        SanityManager.ASSERT((hashRowArray != null ? 1 : 0) != 0, (String)"hashRowArray expected to be non-null");
        DataValueDescriptor[] resultRowArray = new DataValueDescriptor[hashRowArray.length - this.extraColumns];
        System.arraycopy(hashRowArray, this.extraColumns, resultRowArray, 0, resultRowArray.length);
        this.resultRow.setRowArray(resultRowArray);
        this.currentPosition = position;
        ++this.numFromHashTable;
        if (this.resultRow != null) {
            this.beforeFirst = false;
            this.afterLast = false;
        }
        if (this.isForUpdate()) {
            RowLocation rowLoc = (RowLocation)hashRowArray[1];
            ((NoPutResultSet)((Object)this.target)).setCurrentRow(this.resultRow);
            ((NoPutResultSet)((Object)this.target)).positionScanAtRowLocation(rowLoc);
            this.needsRepositioning = true;
        }
        this.setCurrentRow(this.resultRow);
        return this.resultRow;
    }

    private DataValueDescriptor[] getRowArrayFromHashTable(int position) throws StandardException {
        this.positionInHashTable.setValue(position);
        DataValueDescriptor[] hashRowArray = (DataValueDescriptor[])this.ht.get(this.positionInHashTable);
        DataValueDescriptor[] resultRowArray = new DataValueDescriptor[hashRowArray.length - this.extraColumns];
        System.arraycopy(hashRowArray, this.extraColumns, resultRowArray, 0, resultRowArray.length);
        return resultRowArray;
    }

    private void positionInLastFetchedRow() throws StandardException {
        if (this.positionInSource > 0) {
            this.positionInHashTable.setValue(this.positionInSource);
            DataValueDescriptor[] hashRowArray = (DataValueDescriptor[])this.ht.get(this.positionInHashTable);
            RowLocation rowLoc = (RowLocation)hashRowArray[1];
            ((NoPutResultSet)((Object)this.target)).positionScanAtRowLocation(rowLoc);
            this.currentPosition = this.positionInSource;
        }
    }

    @Override
    public void updateRow(ExecRow row) throws StandardException {
        ExecRow newRow = row;
        boolean undoProjection = false;
        if (this.source instanceof ProjectRestrictResultSet) {
            newRow = ((ProjectRestrictResultSet)this.source).doBaseRowProjection(row);
            undoProjection = true;
        }
        this.positionInHashTable.setValue(this.currentPosition);
        DataValueDescriptor[] hashRowArray = (DataValueDescriptor[])this.ht.get(this.positionInHashTable);
        RowLocation rowLoc = (RowLocation)hashRowArray[1];
        this.ht.remove(new SQLInteger(this.currentPosition));
        this.addRowToHashTable(newRow, this.currentPosition, rowLoc, true);
        if (undoProjection) {
            DataValueDescriptor[] newRowData = newRow.getRowArray();
            int[] origPos = ((ProjectRestrictResultSet)this.source).getBaseProjectMapping();
            DataValueDescriptor[] backedData = this.getRowArrayFromHashTable(this.currentPosition);
            for (int i = 0; i < origPos.length; ++i) {
                if (origPos[i] < 0) continue;
                row.setColumn(origPos[i], backedData[i]);
            }
        } else {
            row.setRowArray(this.getRowArrayFromHashTable(this.currentPosition));
        }
    }

    @Override
    public void markRowAsDeleted() throws StandardException {
        this.positionInHashTable.setValue(this.currentPosition);
        DataValueDescriptor[] hashRowArray = (DataValueDescriptor[])this.ht.get(this.positionInHashTable);
        RowLocation rowLoc = (RowLocation)hashRowArray[1];
        this.ht.remove(new SQLInteger(this.currentPosition));
        ((SQLBoolean)hashRowArray[2]).setValue(true);
        for (int i = this.extraColumns; i < hashRowArray.length; ++i) {
            hashRowArray[i].setToNull();
        }
        this.ht.putRow(true, hashRowArray, null);
    }

    public boolean isDeleted() throws StandardException {
        if (this.currentPosition <= this.positionInSource && this.currentPosition > 0) {
            this.positionInHashTable.setValue(this.currentPosition);
            DataValueDescriptor[] hashRowArray = (DataValueDescriptor[])this.ht.get(this.positionInHashTable);
            return hashRowArray[2].getBoolean();
        }
        return false;
    }

    public boolean isUpdated() throws StandardException {
        if (this.currentPosition <= this.positionInSource && this.currentPosition > 0) {
            this.positionInHashTable.setValue(this.currentPosition);
            DataValueDescriptor[] hashRowArray = (DataValueDescriptor[])this.ht.get(this.positionInHashTable);
            return hashRowArray[3].getBoolean();
        }
        return false;
    }

    @Override
    public boolean isForUpdate() {
        return this.source.isForUpdate();
    }

    public void setSourceRowWidth(int width) {
        this.sourceRowWidth = width;
    }

    @Override
    public void updateRowLocationPostRead() throws StandardException {
        this.source.updateRowLocationPostRead();
    }

    @Override
    public void filteredRowLocationPostRead(TXState localTXState) throws StandardException {
        this.source.filteredRowLocationPostRead(localTXState);
    }

    @Override
    public void releasePreviousByteSource() {
        this.source.releasePreviousByteSource();
    }

    @Override
    public void accept(ResultSetStatisticsVisitor visitor) {
        if (this.source != null) {
            visitor.setNumberOfChildren(1);
        } else {
            visitor.setNumberOfChildren(0);
        }
        visitor.visit(this);
        if (this.source != null) {
            this.source.accept(visitor);
        }
    }

    @Override
    public void resetStatistics() {
        super.resetStatistics();
        this.source.resetStatistics();
    }

    @Override
    public boolean isDistributedResultSet() {
        return this.source.isDistributedResultSet();
    }

    @Override
    protected AbstractGemFireResultSet getWrappedGemFireRS() {
        return this.source instanceof AbstractGemFireResultSet ? (AbstractGemFireResultSet)((Object)this.source) : null;
    }

    @Override
    protected void attachStatementContext() throws StandardException {
        if (!this.isDistributedResultSet()) {
            super.attachStatementContext();
        }
    }

    @Override
    public boolean addLockReference(GemFireTransaction tran) {
        tran.getLockSpace().addResultSetRef();
        this.hasLockReference = true;
        return true;
    }

    @Override
    public boolean releaseLocks(GemFireTransaction tran) {
        if (this.hasLockReference) {
            tran.releaseAllLocks(false, true);
            this.hasLockReference = false;
            return true;
        }
        return false;
    }

    @Override
    public StringBuilder buildQueryPlan(StringBuilder builder, PlanUtils.Context context) {
        super.buildQueryPlan(builder, context);
        PlanUtils.xmlTermTag(builder, context, "GROUPBY");
        if (this.source != null) {
            this.source.buildQueryPlan(builder, context.pushContext());
        }
        PlanUtils.xmlCloseTag(builder, context, this);
        return builder;
    }

    @Override
    public void printResultSetHierarchy() {
        if (GemFireXDUtils.TraceNCJ) {
            SanityManager.DEBUG_PRINT((String)"TraceNCJ", (String)("ResultSet Created: " + this.getClass().getSimpleName() + " with resultSetNumber=" + this.resultSetNumber + " with source = " + (this.source != null ? this.source.getClass().getSimpleName() : null) + " and source ResultSetNumber = " + (this.source != null ? this.source.resultSetNumber() : -1)));
        }
    }
}

