/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.IndexRowGenerator;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.RowChanger;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.TemporaryRowHolder;
import com.pivotal.gemfirexd.internal.iapi.store.access.ConglomerateController;
import com.pivotal.gemfirexd.internal.iapi.store.access.DynamicCompiledOpenConglomInfo;
import com.pivotal.gemfirexd.internal.iapi.store.access.StaticCompiledOpenConglomInfo;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import com.pivotal.gemfirexd.internal.impl.sql.execute.IndexSetChanger;
import com.pivotal.gemfirexd.internal.impl.sql.execute.RowUtil;
import com.pivotal.gemfirexd.internal.impl.sql.execute.TemporaryRowHolderImpl;
import java.util.Arrays;

public class RowChangerImpl
implements RowChanger {
    boolean isOpen = false;
    boolean[] fixOnUpdate = null;
    long heapConglom;
    DynamicCompiledOpenConglomInfo heapDCOCI;
    StaticCompiledOpenConglomInfo heapSCOCI;
    long[] indexCIDS = null;
    DynamicCompiledOpenConglomInfo[] indexDCOCIs;
    StaticCompiledOpenConglomInfo[] indexSCOCIs;
    IndexRowGenerator[] irgs = null;
    private final Activation activation;
    TransactionController tc;
    FormatableBitSet changedColumnBitSet;
    FormatableBitSet baseRowReadList;
    private int[] baseRowReadMap;
    int[] changedColumnIds;
    TemporaryRowHolderImpl rowHolder;
    String[] indexNames;
    private ConglomerateController baseCC;
    private RowLocation baseRowLocation;
    private IndexSetChanger isc;
    private DataValueDescriptor[] sparseRowArray;
    private int[] partialChangedColumnIds;
    private final boolean isTransactional;

    public RowChangerImpl(long heapConglom, StaticCompiledOpenConglomInfo heapSCOCI, DynamicCompiledOpenConglomInfo heapDCOCI, IndexRowGenerator[] irgs, long[] indexCIDS, StaticCompiledOpenConglomInfo[] indexSCOCIs, DynamicCompiledOpenConglomInfo[] indexDCOCIs, int numberOfColumns, int[] changedColumnIdsInput, TransactionController tc, FormatableBitSet baseRowReadList, int[] baseRowReadMap, Activation activation) throws StandardException {
        this.heapConglom = heapConglom;
        this.heapSCOCI = heapSCOCI;
        this.heapDCOCI = heapDCOCI;
        this.irgs = irgs;
        this.indexCIDS = indexCIDS;
        this.indexSCOCIs = indexSCOCIs;
        this.indexDCOCIs = indexDCOCIs;
        this.tc = tc;
        this.baseRowReadList = baseRowReadList;
        this.baseRowReadMap = baseRowReadMap;
        this.activation = activation;
        GemFireTransaction tran = (GemFireTransaction)tc;
        this.isTransactional = tran != null && tran.isTransactional();
        SanityManager.ASSERT((indexCIDS != null ? 1 : 0) != 0, (String)"indexCIDS is null");
        if (changedColumnIdsInput != null) {
            int[] nArray = this.changedColumnIds = RowUtil.inAscendingOrder(changedColumnIdsInput) ? changedColumnIdsInput : this.sortArray(changedColumnIdsInput);
            if (!this.isTransactional) {
                this.sparseRowArray = new DataValueDescriptor[this.changedColumnIds[this.changedColumnIds.length - 1] + 1];
            }
            this.changedColumnBitSet = new FormatableBitSet(numberOfColumns);
            for (int i = 0; i < this.changedColumnIds.length; ++i) {
                this.changedColumnBitSet.grow(this.changedColumnIds[i]);
                this.changedColumnBitSet.set(this.changedColumnIds[i] - 1);
            }
            if (baseRowReadList != null) {
                this.partialChangedColumnIds = new int[this.changedColumnIds.length];
                int partialColumnNumber = 1;
                int currentColumn = 0;
                for (int i = 0; i < this.changedColumnIds.length; ++i) {
                    while (currentColumn < this.changedColumnIds[i]) {
                        if (baseRowReadList.get(currentColumn)) {
                            ++partialColumnNumber;
                        }
                        ++currentColumn;
                    }
                    this.partialChangedColumnIds[i] = partialColumnNumber;
                }
            }
        }
        SanityManager.ASSERT((indexCIDS != null ? 1 : 0) != 0, (String)"indexCIDS is null");
    }

    @Override
    public void setRowHolder(TemporaryRowHolder rowHolder) {
        this.rowHolder = (TemporaryRowHolderImpl)rowHolder;
    }

    @Override
    public void setIndexNames(String[] indexNames) {
        this.indexNames = indexNames;
    }

    @Override
    public void open(int lockMode) throws StandardException {
        this.open(lockMode, true);
    }

    @Override
    public void open(int lockMode, boolean wait) throws StandardException {
        if (this.fixOnUpdate == null) {
            this.fixOnUpdate = new boolean[this.irgs.length];
            for (int ix = 0; ix < this.irgs.length; ++ix) {
                this.fixOnUpdate[ix] = true;
            }
        }
        this.openForUpdate(this.fixOnUpdate, lockMode, wait);
    }

    @Override
    public void openForUpdate(boolean[] fixOnUpdate, int lockMode, boolean wait) throws StandardException {
        LanguageConnectionContext lcc = null;
        if (this.isOpen) {
            this.close();
        }
        SanityManager.ASSERT((!this.isOpen ? 1 : 0) != 0, (String)"RowChanger already open");
        if (this.activation != null) {
            lcc = this.activation.getLanguageConnectionContext();
        }
        int isolationLevel = lcc == null ? 2 : lcc.getCurrentIsolationLevel();
        switch (isolationLevel) {
            case 1: {
                isolationLevel = 1;
                break;
            }
            case 2: {
                isolationLevel = 2;
                break;
            }
            case 3: {
                isolationLevel = 4;
                break;
            }
            case 4: {
                isolationLevel = 5;
                break;
            }
        }
        try {
            this.baseCC = this.heapSCOCI != null ? this.tc.openCompiledConglomerate(false, 4 | (wait ? 0 : 128), lockMode, isolationLevel, this.heapSCOCI, this.heapDCOCI) : this.tc.openConglomerate(this.heapConglom, false, 4 | (wait ? 0 : 128), lockMode, isolationLevel);
        }
        catch (StandardException se) {
            if (this.activation != null) {
                this.activation.checkStatementValidity();
            }
            throw se;
        }
        if (this.activation != null) {
            this.activation.checkStatementValidity();
            this.activation.setHeapConglomerateController(this.baseCC);
        }
        if (this.indexCIDS.length != 0) {
            if (this.isc == null) {
                this.isc = new IndexSetChanger(this.irgs, this.indexCIDS, this.indexSCOCIs, this.indexDCOCIs, this.indexNames, this.baseCC, this.tc, lockMode, this.baseRowReadList, isolationLevel, this.activation);
                this.isc.setRowHolder(this.rowHolder);
            } else {
                this.isc.setBaseCC(this.baseCC);
            }
            this.isc.open(fixOnUpdate);
            if (this.baseRowLocation == null) {
                this.baseRowLocation = this.baseCC.newRowLocationTemplate();
            }
        }
        this.isOpen = true;
    }

    @Override
    public void insertRow(ExecRow baseRow) throws StandardException {
        SanityManager.ASSERT((!this.baseCC.isKeyed() ? 1 : 0) != 0, (String)"Keyed inserts not yet supported");
        if (!this.baseCC.isKeyed()) {
            if (this.isc != null) {
                this.baseRowLocation = this.baseCC.insertAndFetchLocation(baseRow.getRowArray(), this.baseRowLocation);
            } else {
                this.baseCC.insert(baseRow.getRowArray());
            }
        }
    }

    @Override
    public boolean deleteRow(ExecRow baseRow, RowLocation baseRowLocation) throws StandardException {
        if (this.isc != null) {
            this.isc.delete(baseRow, baseRowLocation);
        }
        return this.baseCC.delete(baseRowLocation);
    }

    @Override
    public boolean updateRow(ExecRow oldBaseRow, ExecRow newBaseRow, RowLocation baseRowLocation) throws StandardException {
        if (this.isc != null) {
            this.isc.update(oldBaseRow, newBaseRow, baseRowLocation);
        }
        if (this.changedColumnBitSet != null) {
            if (this.isTransactional) {
                this.sparseRowArray = new DataValueDescriptor[this.changedColumnIds[this.changedColumnIds.length - 1] + 1];
            }
            DataValueDescriptor[] baseRowArray = newBaseRow.getRowArray();
            int[] changedColumnArray = this.partialChangedColumnIds == null ? this.changedColumnIds : this.partialChangedColumnIds;
            int nextColumnToUpdate = -1;
            for (int i = 0; i < changedColumnArray.length; ++i) {
                int copyFrom = changedColumnArray[i] - 1;
                SanityManager.ASSERT(((nextColumnToUpdate = this.changedColumnBitSet.anySetBit(nextColumnToUpdate)) >= 0 ? 1 : 0) != 0, (String)"More columns in changedColumnArray than in changedColumnBitSet");
                this.sparseRowArray[nextColumnToUpdate] = this.isTransactional ? baseRowArray[copyFrom].getClone() : baseRowArray[copyFrom];
            }
        } else {
            this.sparseRowArray = this.isTransactional ? newBaseRow.getRowArrayClone() : newBaseRow.getRowArray();
        }
        return this.baseCC.replace(baseRowLocation, this.sparseRowArray, this.changedColumnBitSet);
    }

    @Override
    public void finish() throws StandardException {
        if (this.isc != null) {
            this.isc.finish();
        }
    }

    @Override
    public void close() throws StandardException {
        if (this.isc != null) {
            this.isc.close();
        }
        if (this.baseCC != null) {
            if (this.activation == null || this.activation.getForUpdateIndexScan() == null) {
                this.baseCC.close();
            }
            this.baseCC = null;
        }
        this.isOpen = false;
        if (this.activation != null) {
            this.activation.clearHeapConglomerateController();
        }
    }

    @Override
    public ConglomerateController getHeapConglomerateController() {
        return this.baseCC;
    }

    private int[] sortArray(int[] input) {
        int[] output = new int[input.length];
        System.arraycopy(input, 0, output, 0, input.length);
        Arrays.sort(output);
        return output;
    }
}

