/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.gemstone.gemfire.internal.cache.TXState;
import com.gemstone.gemfire.internal.util.ArrayUtils;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.loader.GeneratedMethod;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.NoPutResultSet;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.execute.NestedLoopJoinResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.PlanUtils;
import com.pivotal.gemfirexd.internal.impl.sql.execute.xplain.XPLAINUtil;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;

class NestedLoopLeftOuterJoinResultSet
extends NestedLoopJoinResultSet {
    protected GeneratedMethod emptyRowFun;
    private boolean wasRightOuterJoin;
    private boolean returnedEmptyRight = false;
    private ExecRow rightEmptyRow = null;
    public int emptyRightRowsReturned = 0;

    @Override
    public ExecRow getNextRowCore() throws StandardException {
        ExecRow result = null;
        boolean haveRow = false;
        boolean restrict = false;
        long l = this.beginTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S.0", "next");
        }
        TXState localTXState = this.localTXState;
        if (GemFireXDUtils.TraceOuterJoin) {
            SanityManager.DEBUG_PRINT((String)"TraceOuterJoinMerge", (String)("NestedLoopLeftOuterJoinResultSet::getNextRowCore this is: " + System.identityHashCode(this) + " leftresultset is: " + this.leftResultSet + "(" + System.identityHashCode(this.leftResultSet) + " rightresultset is: " + this.rightResultSet + "(" + System.identityHashCode(this.rightResultSet)));
        }
        if (this.observer != null) {
            this.observer.onGetNextRowCore(this);
        }
        this.checkCancellationFlag();
        if (this.returnedEmptyRight) {
            this.leftResultSet.releasePreviousByteSource();
            this.leftRow = this.leftResultSet.getNextRowCore();
            if (this.leftRow == null) {
                this.closeRight();
            } else {
                ++this.rowsSeenLeft;
                this.openRight();
            }
            this.returnedEmptyRight = false;
        }
        while (this.leftRow != null && !haveRow) {
            this.rightResultSet.releasePreviousByteSource();
            this.rightRow = this.rightResultSet.getNextRowCore();
            if (this.rightRow == null) {
                if (!this.matchRight) {
                    haveRow = true;
                    this.returnedEmptyRight = true;
                    if (this.rightEmptyRow == null) {
                        this.rightEmptyRow = (ExecRow)this.emptyRowFun.invoke(this.activation);
                    }
                    this.getMergedRow(this.leftRow, this.rightEmptyRow);
                    ++this.emptyRightRowsReturned;
                    this.leftResultSet.filteredRowLocationPostRead(localTXState);
                    continue;
                }
                this.matchRight = false;
                this.leftResultSet.releasePreviousByteSource();
                this.leftRow = this.leftResultSet.getNextRowCore();
                if (this.leftRow == null) {
                    this.closeRight();
                    continue;
                }
                ++this.rowsSeenLeft;
                this.openRight();
                continue;
            }
            ++this.rowsSeenRight;
            if (this.restriction != null) {
                DataValueDescriptor restrictBoolean = (DataValueDescriptor)this.restriction.invoke(this.activation);
                boolean bl = restrict = !restrictBoolean.isNull() && restrictBoolean.getBoolean();
                if (!restrict) {
                    ++this.rowsFiltered;
                    this.rightResultSet.filteredRowLocationPostRead(localTXState);
                    continue;
                }
            }
            this.matchRight = true;
            this.getMergedRow(this.leftRow, this.rightRow);
            haveRow = true;
        }
        if (haveRow) {
            result = this.mergedRow;
            this.setCurrentRow(this.mergedRow);
            ++this.rowsReturned;
        } else {
            this.clearCurrentRow();
        }
        if (this.statisticsTimingOn) {
            this.nextTime += this.getElapsedNanos(this.beginTime);
        }
        return result;
    }

    protected void getMergedRow(ExecRow leftRow, ExecRow rightRow) throws StandardException {
        int rightNumCols;
        int leftNumCols;
        if (this.wasRightOuterJoin) {
            ExecRow tmp = leftRow;
            leftRow = rightRow;
            rightRow = tmp;
            leftNumCols = this.rightNumCols;
            rightNumCols = this.leftNumCols;
        } else {
            leftNumCols = this.leftNumCols;
            rightNumCols = this.rightNumCols;
        }
        if (this.mergedRow == null) {
            this.mergedRow = this.getExecutionFactory().getValueRow(leftNumCols + rightNumCols);
        }
        int colInCtr = 1;
        int colOutCtr = 1;
        while (colInCtr <= leftNumCols) {
            this.mergedRow.setColumn(colOutCtr, leftRow.getColumn(colInCtr));
            ++colInCtr;
            ++colOutCtr;
        }
        colInCtr = 1;
        while (colInCtr <= rightNumCols) {
            this.mergedRow.setColumn(colOutCtr, rightRow.getColumn(colInCtr));
            ++colInCtr;
            ++colOutCtr;
        }
        if (this.mergedRow != null) {
            this.mergedRow.clearAllRegionAndKeyInfo();
            if (GemFireXDUtils.TraceOuterJoin) {
                SanityManager.DEBUG_PRINT((String)"TraceOuterJoinMerge", (String)("NestedLoopLeftOuterJoin::getMergedRow: left row rak: " + leftRow.getAllRegionAndKeyInfo() + " for " + ArrayUtils.objectRefString((Object)leftRow) + "[ " + leftRow + " ], right row rak: " + rightRow.getAllRegionAndKeyInfo() + " for " + ArrayUtils.objectRefString((Object)rightRow) + "[ " + rightRow + " ]"));
            }
            this.mergedRow.addAllKeys(leftRow.getAllRegionAndKeyInfo());
            this.mergedRow.addAllKeys(rightRow.getAllRegionAndKeyInfo());
        }
    }

    @Override
    void clearScanState() {
        this.matchRight = false;
        this.returnedEmptyRight = false;
        this.rightEmptyRow = null;
        this.emptyRightRowsReturned = 0;
        super.clearScanState();
    }

    @Override
    public void filteredRowLocationPostRead(TXState localTXState) throws StandardException {
        if (this.isRightOpen && !this.returnedEmptyRight) {
            super.filteredRowLocationPostRead(localTXState);
        }
    }

    NestedLoopLeftOuterJoinResultSet(NoPutResultSet leftResultSet, int leftNumCols, NoPutResultSet rightResultSet, int rightNumCols, Activation activation, GeneratedMethod restriction, int resultSetNumber, GeneratedMethod emptyRowFun, boolean wasRightOuterJoin, boolean oneRowRightSide, boolean notExistsRightSide, double optimizerEstimatedRowCount, double optimizerEstimatedCost, String userSuppliedOptimizerOverrides, int leftResultColumnNames, int rightResultColumnNames) {
        super(leftResultSet, leftNumCols, rightResultSet, rightNumCols, activation, restriction, resultSetNumber, oneRowRightSide, notExistsRightSide, optimizerEstimatedRowCount, optimizerEstimatedCost, userSuppliedOptimizerOverrides, leftResultColumnNames, rightResultColumnNames);
        this.emptyRowFun = emptyRowFun;
        this.wasRightOuterJoin = wasRightOuterJoin;
    }

    @Override
    public StringBuilder buildQueryPlan(StringBuilder builder, PlanUtils.Context context) {
        boolean isSuccess = context.setNested();
        super.buildQueryPlan(builder, context);
        if (!isSuccess) {
            return builder;
        }
        PlanUtils.xmlTermTag(builder, context, "LOUTERNLJOIN");
        this.endBuildQueryPlan(builder, context);
        PlanUtils.xmlCloseTag(builder, context, this);
        return builder;
    }
}

