/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.gemstone.gemfire.internal.cache.TXState;
import com.pivotal.gemfirexd.internal.engine.GfxdConstants;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.CursorResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.NoPutResultSet;
import com.pivotal.gemfirexd.internal.iapi.store.access.ConglomerateController;
import com.pivotal.gemfirexd.internal.iapi.store.access.ScanController;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import com.pivotal.gemfirexd.internal.impl.sql.execute.NoPutResultSetImpl;
import com.pivotal.gemfirexd.internal.impl.sql.execute.PlanUtils;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ResultSetStatisticsVisitor;
import com.pivotal.gemfirexd.internal.impl.sql.execute.xplain.XPLAINUtil;
import java.util.Properties;

class MaterializedResultSet
extends NoPutResultSetImpl
implements CursorResultSet {
    public NoPutResultSet source;
    private ExecRow materializedRowBuffer;
    protected long materializedCID;
    public boolean materializedCreated;
    private boolean fromSource = true;
    protected ConglomerateController materializedCC;
    protected ScanController materializedScan;
    private TransactionController tc;
    private boolean sourceDrained;
    public long createTCTime;
    public long fetchTCTime;

    public MaterializedResultSet(NoPutResultSet source, Activation activation, int resultSetNumber, double optimizerEstimatedRowCount, double optimizerEstimatedCost) throws StandardException {
        super(activation, resultSetNumber, optimizerEstimatedRowCount, optimizerEstimatedCost);
        this.source = source;
        this.tc = activation.getTransactionController();
        this.initLocalTXState();
        this.recordConstructorTime();
        this.printResultSetHierarchy();
    }

    @Override
    public void openCore() throws StandardException {
        this.beginTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
        SanityManager.ASSERT((!this.isOpen ? 1 : 0) != 0, (String)"MaterializedResultSet already open");
        this.isOpen = true;
        this.source.openCore();
        ++this.numOpens;
        if (this.statisticsTimingOn) {
            this.openTime += this.getElapsedNanos(this.beginTime);
        }
    }

    @Override
    public void reopenCore() throws StandardException {
        boolean constantEval = true;
        this.beginTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
        SanityManager.ASSERT((boolean)this.isOpen, (String)"MaterializedResultSet already open");
        while (!this.sourceDrained) {
            this.getNextRowFromSource();
        }
        this.fromSource = false;
        if (this.materializedScan != null) {
            this.materializedScan.close();
        }
        if (this.materializedCID != 0L) {
            this.materializedScan = this.tc.openScan(this.materializedCID, false, 0, 7, 5, null, null, 0, null, null, 0, null);
            this.isOpen = true;
        }
        ++this.numOpens;
        if (this.statisticsTimingOn) {
            this.openTime += this.getElapsedNanos(this.beginTime);
        }
    }

    @Override
    public ExecRow getNextRowCore() throws StandardException {
        ExecRow result = null;
        long l = this.beginTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S.0", "next");
        }
        result = this.fromSource ? this.getNextRowFromSource() : this.getNextRowFromTempTable();
        if (result != null) {
            ++this.rowsSeen;
        }
        this.setCurrentRow(result);
        if (this.localTXState != null && this.isTopResultSet && result != null && this.isForUpdate()) {
            this.updateRowLocationPostRead();
        }
        if (this.statisticsTimingOn) {
            this.nextTime += this.getElapsedNanos(this.beginTime);
        }
        return result;
    }

    private ExecRow getNextRowFromSource() throws StandardException {
        if (this.sourceDrained) {
            return null;
        }
        ExecRow sourceRow = null;
        Object result = null;
        sourceRow = this.source.getNextRowCore();
        if (sourceRow != null) {
            long beginTCTime;
            long l = beginTCTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
            if (this.materializedRowBuffer == null) {
                this.materializedRowBuffer = sourceRow.getClone();
                this.tc = this.activation.getTransactionController();
                Properties properties = new Properties();
                properties.setProperty(GfxdConstants.PROPERTY_SCHEMA_NAME, "SESSION");
                properties.setProperty(GfxdConstants.PROPERTY_TABLE_NAME, "temp_{id}");
                this.materializedCID = this.tc.createConglomerate("heap", this.materializedRowBuffer.getRowArray(), null, null, properties, 3);
                this.materializedCreated = true;
                this.materializedCC = this.tc.openConglomerate(this.materializedCID, false, 4, 7, 5);
            }
            this.materializedCC.insert(sourceRow.getRowArray());
            if (this.statisticsTimingOn) {
                this.createTCTime += this.getElapsedNanos(beginTCTime);
            }
        } else {
            this.sourceDrained = true;
        }
        return sourceRow;
    }

    private ExecRow getNextRowFromTempTable() throws StandardException {
        long beginTCTime;
        long l = beginTCTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
        if (this.materializedScan != null && this.materializedScan.fetchNext(this.materializedRowBuffer)) {
            if (this.statisticsTimingOn) {
                this.fetchTCTime += this.getElapsedNanos(beginTCTime);
            }
            return this.materializedRowBuffer;
        }
        return null;
    }

    @Override
    public void close(boolean cleanupOnError) throws StandardException {
        long l = this.beginTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
        if (this.isOpen) {
            this.currentRow = null;
            this.source.close(cleanupOnError);
            if (this.materializedScan != null) {
                this.materializedScan.close();
            }
            this.materializedScan = null;
            if (this.materializedCC != null) {
                this.materializedCC.close();
            }
            this.materializedCC = null;
            if (this.materializedCreated) {
                this.tc.dropConglomerate(this.materializedCID);
            }
            this.materializedCreated = false;
            super.close(cleanupOnError);
        } else {
            SanityManager.DEBUG((String)"CloseRepeatInfo", (String)"Close of MaterializedResultSet repeated");
        }
        if (this.statisticsTimingOn) {
            this.closeTime += this.getElapsedNanos(this.beginTime);
        }
    }

    @Override
    public final long getTimeSpent(int type, int timeType) {
        long time = PlanUtils.getTimeSpent(this.constructorTime, this.openTime, this.nextTime, this.closeTime, timeType);
        if (type == 0) {
            return time - this.source.getTimeSpent(1, timeType);
        }
        return timeType == 0 ? time - this.constructorTime : time;
    }

    @Override
    public RowLocation getRowLocation() throws StandardException {
        SanityManager.ASSERT((boolean)(this.source instanceof CursorResultSet), (String)"source not CursorResultSet");
        return ((CursorResultSet)((Object)this.source)).getRowLocation();
    }

    @Override
    public ExecRow getCurrentRow() {
        return this.currentRow;
    }

    @Override
    public boolean isForUpdate() {
        return this.source.isForUpdate();
    }

    @Override
    public void updateRowLocationPostRead() throws StandardException {
        this.source.updateRowLocationPostRead();
    }

    @Override
    public void filteredRowLocationPostRead(TXState localTXState) throws StandardException {
        this.source.filteredRowLocationPostRead(localTXState);
    }

    @Override
    public boolean supportsMoveToNextKey() {
        return this.source.supportsMoveToNextKey();
    }

    @Override
    public int getScanKeyGroupID() {
        return this.source.getScanKeyGroupID();
    }

    @Override
    public void accept(ResultSetStatisticsVisitor visitor) {
        visitor.setNumberOfChildren(1);
        visitor.visit(this);
        this.source.accept(visitor);
    }

    @Override
    public void resetStatistics() {
        SanityManager.ASSERT((boolean)this.isClosed());
        this.createTCTime = 0L;
        this.fetchTCTime = 0L;
        super.resetStatistics();
    }

    @Override
    public StringBuilder buildQueryPlan(StringBuilder builder, PlanUtils.Context context) {
        super.buildQueryPlan(builder, context);
        PlanUtils.xmlTermTag(builder, context, "TABLESCAN");
        if (this.source != null) {
            this.source.buildQueryPlan(builder, context);
        }
        PlanUtils.xmlCloseTag(builder, context, this);
        return builder;
    }

    @Override
    public void printResultSetHierarchy() {
        if (GemFireXDUtils.TraceNCJ) {
            SanityManager.DEBUG_PRINT((String)"TraceNCJ", (String)("ResultSet Created: " + this.getClass().getSimpleName() + " with resultSetNumber=" + this.resultSetNumber + " with source = " + (this.source != null ? this.source.getClass().getSimpleName() : null) + " and source ResultSetNumber = " + (this.source != null ? this.source.resultSetNumber() : -1)));
        }
    }
}

