/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.gemstone.gemfire.internal.cache.TXState;
import com.pivotal.gemfirexd.internal.catalog.types.ReferencedColumnsDescriptorImpl;
import com.pivotal.gemfirexd.internal.engine.access.heap.MemHeap;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.RegionAndKey;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.store.AbstractCompactExecRow;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.engine.store.RowFormatter;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapResourceHolder;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.services.loader.GeneratedMethod;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ColumnDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.CursorResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.NoPutResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.TemporaryRowHolder;
import com.pivotal.gemfirexd.internal.iapi.store.access.DynamicCompiledOpenConglomInfo;
import com.pivotal.gemfirexd.internal.iapi.store.access.StaticCompiledOpenConglomInfo;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import com.pivotal.gemfirexd.internal.impl.sql.execute.NoPutResultSetImpl;
import com.pivotal.gemfirexd.internal.impl.sql.execute.PlanUtils;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ResultSetStatisticsVisitor;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ScanResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.TableScanResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.TemporaryRowHolderResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.xplain.XPLAINUtil;

public final class IndexRowToBaseRowResultSet
extends NoPutResultSetImpl
implements CursorResultSet {
    public NoPutResultSet source;
    private GeneratedMethod restriction;
    public FormatableBitSet accessedHeapCols;
    private FormatableBitSet accessedAllCols;
    public String indexName;
    private int[] indexCols;
    private DynamicCompiledOpenConglomInfo dcoci;
    private StaticCompiledOpenConglomInfo scoci;
    private ExecRow resultRow;
    private boolean forUpdate;
    private ExecRow baseRow;
    private boolean addRegionAndKey;
    private boolean addKeyForSelectForUpdate;
    private String regionName;
    private boolean isReplicate;
    private final boolean delayScanOpening;
    private boolean faultInValues;
    boolean isStartStopKeySame = false;
    protected final GemFireContainer gfc;
    RowLocation baseRowLocation;
    boolean copiedFromSource;
    public long restrictionTime;
    protected boolean currentRowPrescanned;
    private boolean sourceIsForUpdateIndexScan;
    private final boolean isSourceOfTypeOffHeapResourceHolder;

    @Override
    public boolean isReplicateIfSetOpSupported() {
        return this.isReplicate;
    }

    IndexRowToBaseRowResultSet(long conglomId, int scociItem, Activation a, NoPutResultSet source, GeneratedMethod resultRowAllocator, int resultSetNumber, String indexName, int heapColRefItem, int allColRefItem, int heapOnlyColRefItem, int indexColMapItem, GeneratedMethod restriction, boolean forUpdate, double optimizerEstimatedRowCount, double optimizerEstimatedCost, boolean delayScanOpening) throws StandardException {
        super(a, resultSetNumber, optimizerEstimatedRowCount, optimizerEstimatedCost);
        boolean useBytes;
        Object[] saved = a.getSavedObjects();
        this.scoci = (StaticCompiledOpenConglomInfo)saved[scociItem];
        TransactionController tc = this.activation.getTransactionController();
        this.dcoci = tc.getDynamicCompiledConglomInfo(conglomId);
        this.source = source;
        this.indexName = indexName;
        this.forUpdate = forUpdate;
        this.restriction = restriction;
        this.isSourceOfTypeOffHeapResourceHolder = this.source instanceof OffHeapResourceHolder;
        this.delayScanOpening = delayScanOpening;
        if (heapColRefItem != -1) {
            this.accessedHeapCols = (FormatableBitSet)saved[heapColRefItem];
        }
        if (allColRefItem != -1) {
            this.accessedAllCols = (FormatableBitSet)saved[allColRefItem];
        }
        this.indexCols = ((ReferencedColumnsDescriptorImpl)saved[indexColMapItem]).getReferencedColumnPositions();
        this.gfc = ((MemHeap)this.scoci).getGemFireContainer();
        this.regionName = this.gfc.getQualifiedTableName();
        if (GemFireXDUtils.TraceOuterJoin && this.gfc != null && this.gfc.isApplicationTable()) {
            SanityManager.DEBUG_PRINT((String)"TraceOuterJoinMerge", (String)("IndexRowToBaseRowResultset::IndexRowToBaseRow gfc is" + this.gfc + " activation is: " + System.identityHashCode(a) + " addregionandkey from a: " + a.isSpecialCaseOuterJoin()));
        }
        if (this.lcc != null) {
            this.addRegionAndKey = a.isSpecialCaseOuterJoin();
            if (a.getFunctionContext() != null) {
                this.addKeyForSelectForUpdate = a.needKeysForSelectForUpdate();
            }
        }
        this.isReplicate = !this.gfc.isPartitioned();
        RowFormatter rf = this.gfc.getCurrentRowFormatter();
        TableDescriptor td = this.gfc.getTableDescriptor();
        boolean getWholeRow = false;
        if (td != null) {
            int numCols = td.getNumberOfColumns();
            getWholeRow = true;
            if (this.accessedAllCols != null) {
                for (int i = 0; i < numCols; ++i) {
                    if (this.accessedAllCols.isSet(i)) continue;
                    getWholeRow = false;
                    break;
                }
            }
        }
        if (getWholeRow && forUpdate) {
            getWholeRow = this.accessedAllCols == null && this.accessedHeapCols == null || this.accessedAllCols != null && this.accessedAllCols.equals(this.accessedHeapCols);
        }
        boolean bl = useBytes = this.gfc.isByteArrayStore() && getWholeRow;
        if (useBytes) {
            this.accessedAllCols = null;
            this.accessedHeapCols = null;
            this.resultRow = this.gfc.newTemplateRow();
        } else {
            this.resultRow = (ExecRow)resultRowAllocator.invoke(this.activation);
        }
        this.getCompactRow(this.resultRow, this.accessedAllCols, false, useBytes, this.gfc, rf, true);
        if (this.accessedHeapCols == null) {
            this.baseRow = this.resultRow;
        } else {
            DataValueDescriptor[] resultRowArray = this.resultRow.getRowArray();
            FormatableBitSet heapOnly = (FormatableBitSet)saved[heapOnlyColRefItem];
            int heapOnlyLen = heapOnly.getLength();
            DataValueDescriptor[] dvds = new DataValueDescriptor[heapOnlyLen];
            int minLen = Math.min(resultRowArray.length, heapOnlyLen);
            for (int i = 0; i < minLen; ++i) {
                if (resultRowArray[i] == null || !heapOnly.isSet(i)) continue;
                dvds[i] = resultRowArray[i];
            }
            this.baseRow = this.gfc.newValueRow(dvds);
        }
        this.initLocalTXState();
        this.recordConstructorTime();
        this.printResultSetHierarchy();
    }

    @Override
    public void openCore() throws StandardException {
        if (!this.delayScanOpening) {
            this.basicOpenCore();
        }
    }

    public void basicOpenCore() throws StandardException {
        boolean lockingRequired = false;
        SanityManager.ASSERT((!this.isOpen ? 1 : 0) != 0, (String)"IndexRowToBaseRowResultSet already open");
        this.beginTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
        this.isOpen = true;
        this.source.openCore();
        this.faultInValues = false;
        if (this.source instanceof TableScanResultSet) {
            TableScanResultSet ts = (TableScanResultSet)this.source;
            if (ts.startPosition != null && ts.stopPosition != null) {
                this.faultInValues = true;
                if (ts.startPosition.equals(ts.stopPosition)) {
                    this.isStartStopKeySame = true;
                }
            }
        }
        if (this.source.requiresRelocking()) {
            lockingRequired = true;
        }
        TransactionController tc = this.activation.getTransactionController();
        int openMode = this.forUpdate ? 4 : 0;
        int isolationLevel = this.source.getScanIsolationLevel();
        if (!lockingRequired) {
            openMode |= 0x2000;
        }
        ++this.numOpens;
        if (this.statisticsTimingOn) {
            this.openTime += this.getElapsedNanos(this.beginTime);
        }
    }

    @Override
    public void reopenCore() throws StandardException {
        if (!this.delayScanOpening) {
            this.basicReopenCore();
        }
    }

    public void basicReopenCore() throws StandardException {
        SanityManager.ASSERT((boolean)this.isOpen, (String)"IndexRowToBaseRowResultSet already open");
        this.beginTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
        this.source.reopenCore();
        ++this.numOpens;
        if (this.statisticsTimingOn) {
            this.openTime += this.getElapsedNanos(this.beginTime);
        }
    }

    @Override
    public ExecRow getNextRowCore() throws StandardException {
        ScanResultSet src;
        TemporaryRowHolder futureForUpdateRows;
        if (this.delayScanOpening) {
            if (!this.isOpen && this.numOpens == 0) {
                this.basicOpenCore();
            } else if (!this.isOpen) {
                this.basicReopenCore();
            }
        }
        ExecRow sourceRow = null;
        ExecRow retval = null;
        boolean restrict = false;
        long beginRT = 0L;
        long l = this.beginTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S.0", "next");
        }
        TXState localTXState = this.localTXState;
        if (GemFireXDUtils.TraceOuterJoin && this.gfc != null && this.gfc.isApplicationTable()) {
            SanityManager.DEBUG_PRINT((String)"TraceOuterJoinMerge", (String)("IndexRowToBaseRowResultset::getNextRowCore addregionkeyinfo: " + this.addRegionAndKey + " this is: " + System.identityHashCode(this)));
        }
        if (this.sourceIsForUpdateIndexScan && (futureForUpdateRows = (src = (ScanResultSet)this.source).getFutureForUpdateRows()) != null) {
            this.currentRowPrescanned = false;
            TemporaryRowHolderResultSet futureRowRS = src.getFutureRowResultSet();
            if (futureRowRS == null) {
                futureRowRS = (TemporaryRowHolderResultSet)futureForUpdateRows.getResultSet();
                src.setFutureRowResultSet(futureRowRS);
                futureRowRS.openCore();
            }
            ExecRow ridRow = futureRowRS.getNextRowCore();
            this.currentRow = null;
            if (ridRow != null) {
                futureRowRS.deleteCurrentRow();
                this.baseRowLocation = (RowLocation)ridRow.getColumn(1);
                this.baseRowLocation = this.source.fetch(this.baseRowLocation, this.compactRow, this.accessedAllCols, this.faultInValues, this.gfc);
                if (this.baseRowLocation != null) {
                    ridRow.setColumn(1, this.baseRowLocation);
                }
                this.currentRow = this.compactRow;
                this.currentRowPrescanned = true;
            } else if (src.sourceDrained()) {
                this.currentRowPrescanned = true;
            }
            if (this.currentRowPrescanned) {
                this.setCurrentRow(this.currentRow);
                this.setRegionAndKeyInfo(this.currentRow);
                if (localTXState != null && this.forUpdate && this.isTopResultSet && this.baseRowLocation != null) {
                    this.upgradeReadLockToWrite(this.baseRowLocation, this.gfc);
                }
                if (this.statisticsTimingOn) {
                    this.nextTime += this.getElapsedNanos(this.beginTime);
                }
                return this.currentRow;
            }
        }
        do {
            if ((sourceRow = this.source.getNextRowCore()) != null) {
                boolean row_exists;
                SanityManager.ASSERT((boolean)(sourceRow.getLastColumn() instanceof RowLocation), (String)"Last column of source row is not a RowLocation");
                this.baseRowLocation = (RowLocation)sourceRow.getLastColumn();
                this.baseRowLocation = this.source.fetch(this.baseRowLocation, this.baseRow, this.accessedHeapCols, this.faultInValues, this.gfc);
                boolean bl = row_exists = this.baseRowLocation != null;
                if (row_exists) {
                    if (!(this.baseRow instanceof AbstractCompactExecRow)) {
                        if (!this.copiedFromSource) {
                            this.copiedFromSource = true;
                            for (int index = 0; index < this.indexCols.length; ++index) {
                                if (this.indexCols[index] == -1) continue;
                                this.compactRow.setColumn(index + 1, sourceRow.getColumn(this.indexCols[index] + 1));
                            }
                        }
                        this.setCurrentRow(this.compactRow);
                    } else {
                        this.setCurrentRow(this.baseRow);
                    }
                    if (!this.isStartStopKeySame) {
                        DataValueDescriptor restrictBoolean = (DataValueDescriptor)(this.restriction == null ? null : this.restriction.invoke(this.activation));
                        if (this.statisticsTimingOn) {
                            this.restrictionTime += this.getElapsedNanos(beginRT);
                        }
                        restrict = restrictBoolean == null || !restrictBoolean.isNull() && restrictBoolean.getBoolean();
                    } else {
                        restrict = this.isStartStopKeySame;
                    }
                }
                if (!restrict || !row_exists) {
                    ++this.rowsFiltered;
                    this.filteredRowLocationPostRead(localTXState);
                    this.baseRowLocation = null;
                } else {
                    this.currentRow = this.compactRow;
                }
                ++this.rowsSeen;
                retval = this.currentRow;
                continue;
            }
            this.clearCurrentRow();
            this.baseRowLocation = null;
            retval = null;
        } while (sourceRow != null && !restrict);
        this.setRegionAndKeyInfo(retval);
        if (localTXState != null && this.forUpdate && this.isTopResultSet && this.baseRowLocation != null) {
            this.upgradeReadLockToWrite(this.baseRowLocation, this.gfc);
        }
        if (this.statisticsTimingOn) {
            this.nextTime += this.getElapsedNanos(this.beginTime);
        }
        return retval;
    }

    @Override
    public void close(boolean cleanupOnError) throws StandardException {
        long l = this.beginTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
        if (this.isOpen) {
            this.clearCurrentRow();
            this.source.close(cleanupOnError);
            super.close(cleanupOnError);
        } else {
            SanityManager.DEBUG((String)"CloseRepeatInfo", (String)"Close of IndexRowToBaseRowResultSet repeated");
        }
        if (this.statisticsTimingOn) {
            this.closeTime += this.getElapsedNanos(this.beginTime);
        }
    }

    @Override
    public final long getTimeSpent(int type, int timeType) {
        long time = PlanUtils.getTimeSpent(this.constructorTime, this.openTime, this.nextTime, this.closeTime, timeType);
        if (type == 0) {
            return time - this.source.getTimeSpent(1, timeType);
        }
        return timeType == 0 ? time - this.constructorTime : time;
    }

    @Override
    public RowLocation getRowLocation() throws StandardException {
        return this.baseRowLocation;
    }

    @Override
    public void positionScanAtRowLocation(RowLocation rl) throws StandardException {
        this.baseRowLocation = rl;
        this.source.positionScanAtRowLocation(rl);
    }

    @Override
    public ExecRow getCurrentRow() throws StandardException {
        return this.activation.getCurrentRow(this.resultSetNumber);
    }

    public ExecRow _getCurrentRow() throws StandardException {
        boolean row_exists;
        ExecRow sourceRow = null;
        SanityManager.ASSERT((boolean)this.isOpen, (String)"IndexRowToBaseRowResultSet is expected to be open");
        if (this.currentRowPrescanned) {
            this.setRegionAndKeyInfo(this.currentRow);
            return this.currentRow;
        }
        if (this.currentRow == null) {
            return null;
        }
        sourceRow = this.activation.getExecutionFactory().getValueRow(this.indexCols.length);
        sourceRow.setRowArray(this.baseRow);
        this.baseRowLocation = this.source.fetch(this.baseRowLocation, sourceRow, null, this.faultInValues, this.gfc);
        boolean bl = row_exists = this.baseRowLocation != null;
        if (row_exists) {
            this.setCurrentRow(sourceRow);
        } else {
            this.clearCurrentRow();
        }
        this.setRegionAndKeyInfo(this.currentRow);
        return this.currentRow;
    }

    @Override
    public boolean isForUpdate() {
        return this.source.isForUpdate();
    }

    private void setRegionAndKeyInfo(ExecRow currRow) {
        if (GemFireXDUtils.TraceOuterJoin && this.gfc != null && this.gfc.isApplicationTable()) {
            SanityManager.DEBUG_PRINT((String)"TraceOuterJoinMerge", (String)("IndexRowToBaseRowResultset::setRak: current row: " + currRow + ", addRegionAndKey = " + this.addRegionAndKey + ", region name = " + this.regionName + ", isreplicate = " + this.isReplicate + " IndexRowToBaseRowResultSet is: " + System.identityHashCode(this)));
        }
        if (currRow != null && (this.addRegionAndKey || this.addKeyForSelectForUpdate)) {
            Object currBaseKey = this.baseRowLocation.getKeyCopy();
            if (this.addRegionAndKey) {
                assert (!this.addKeyForSelectForUpdate);
                currRow.clearAllRegionAndKeyInfo();
                RegionAndKey rak = new RegionAndKey(this.regionName, currBaseKey, this.isReplicate);
                currRow.addRegionAndKey(rak);
                if (GemFireXDUtils.TraceOuterJoin && this.gfc != null && this.gfc.isApplicationTable()) {
                    SanityManager.DEBUG_PRINT((String)"TraceOuterJoinMerge", (String)("IndexRowToBaseRowResultset::setRak: added region and key info: " + rak + " to current row: " + currRow + " IndexRowToBaseRowResultSet is: " + System.identityHashCode(this)));
                }
            }
            if (this.addKeyForSelectForUpdate) {
                assert (!this.addRegionAndKey);
                currRow.clearAllRegionAndKeyInfo();
                currRow.addRegionAndKey(new RegionAndKey(null, currBaseKey, this.isReplicate));
            }
        }
    }

    @Override
    public void updateRowLocationPostRead() throws StandardException {
        this.upgradeReadLockToWrite(this.baseRowLocation, this.gfc);
    }

    @Override
    public void filteredRowLocationPostRead(TXState localTXState) throws StandardException {
        if (localTXState != null) {
            this.releaseRowLocationLock(this.baseRowLocation, this.gfc);
        }
        if (this.isSourceOfTypeOffHeapResourceHolder) {
            this.basicReleasePreviousByteSource();
        }
    }

    private void basicReleasePreviousByteSource() {
        if (this.gfc.isOffHeap() && this.baseRowLocation != null) {
            ((OffHeapResourceHolder)((Object)this.source)).releaseByteSource(0);
        }
    }

    @Override
    public void releasePreviousByteSource() {
        if (this.isSourceOfTypeOffHeapResourceHolder && ((OffHeapResourceHolder)((Object)this.source)).optimizedForOffHeap()) {
            this.basicReleasePreviousByteSource();
        }
    }

    @Override
    public boolean supportsMoveToNextKey() {
        return this.source.supportsMoveToNextKey();
    }

    @Override
    public int getScanKeyGroupID() {
        return this.source.getScanKeyGroupID();
    }

    @Override
    public void accept(ResultSetStatisticsVisitor visitor) {
        if (this.source != null) {
            visitor.setNumberOfChildren(1);
        } else {
            visitor.setNumberOfChildren(0);
        }
        visitor.visit(this);
        if (this.source != null) {
            this.source.accept(visitor);
        }
    }

    @Override
    public void resetStatistics() {
        this.restrictionTime = 0L;
        super.resetStatistics();
        this.source.resetStatistics();
    }

    @Override
    public StringBuilder buildQueryPlan(StringBuilder builder, PlanUtils.Context context) {
        super.buildQueryPlan(builder, context);
        RowFormatter rf = this.gfc.getCurrentRowFormatter();
        StringBuilder accessedCols = new StringBuilder(this.indexName).append(" : ");
        boolean first = true;
        if (this.accessedHeapCols != null && rf != null) {
            for (int inPosition = 0; inPosition < this.accessedHeapCols.getLength(); ++inPosition) {
                ColumnDescriptor cd;
                if (!this.accessedHeapCols.isSet(inPosition) || (cd = rf.getColumnDescriptor(inPosition)) == null) continue;
                if (!first) {
                    accessedCols.append(", ");
                } else {
                    first = false;
                }
                accessedCols.append(cd.getColumnName());
            }
        }
        PlanUtils.xmlAttribute(builder, "node_details", accessedCols);
        PlanUtils.xmlTermTag(builder, context, "INDEXSCAN");
        if (this.source != null) {
            this.source.buildQueryPlan(builder, context.pushContext());
        }
        PlanUtils.xmlCloseTag(builder, context, this);
        return builder;
    }

    @Override
    public void printResultSetHierarchy() {
        if (GemFireXDUtils.TraceNCJ) {
            SanityManager.DEBUG_PRINT((String)"TraceNCJ", (String)("ResultSet Created: " + this.getClass().getSimpleName() + " with resultSetNumber=" + this.resultSetNumber + " with source = " + (this.source != null ? this.source.getClass().getSimpleName() : null) + " and source ResultSetNumber = " + (this.source != null ? this.source.resultSetNumber() : -1)));
        }
    }
}

