/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.impl.sql.execute.DDLConstantAction;
import com.pivotal.gemfirexd.internal.impl.sql.execute.PrivilegeInfo;
import java.util.List;

class GrantRevokeConstantAction
extends DDLConstantAction {
    private boolean grant;
    private PrivilegeInfo privileges;
    private List grantees;

    GrantRevokeConstantAction(boolean grant, PrivilegeInfo privileges, List grantees) {
        this.grant = grant;
        this.privileges = privileges;
        this.grantees = grantees;
    }

    public String toString() {
        return this.grant ? "GRANT" : "REVOKE";
    }

    @Override
    public void executeConstantAction(Activation activation) throws StandardException {
        this.privileges.executeGrantRevoke(activation, this.grant, this.grantees);
    }

    @Override
    public String getSchemaName() {
        return this.privileges.getSchemaName();
    }

    @Override
    public String getTableName() {
        return this.privileges.getTableName();
    }

    @Override
    public final String getObjectName() {
        return this.privileges.getObjectName();
    }

    @Override
    public boolean isCancellable() {
        return false;
    }
}

