/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SchemaDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.execute.DDLConstantAction;

public final class DropSchemaConstantAction
extends DDLConstantAction {
    private final String schemaName;
    private final boolean onlyIfExists;

    DropSchemaConstantAction(String schemaName, boolean onlyIfExists) {
        this.schemaName = schemaName;
        this.onlyIfExists = onlyIfExists;
    }

    public String toString() {
        return "DROP SCHEMA " + (this.onlyIfExists ? "IF EXISTS " : "") + this.schemaName;
    }

    @Override
    public void executeConstantAction(Activation activation) throws StandardException {
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        dd.startWriting(lcc);
        SchemaDescriptor sd = null;
        try {
            sd = dd.getSchemaDescriptor(this.schemaName, null, true);
        }
        catch (StandardException e) {
            if (e.getSQLState().equals("42Y07") && this.onlyIfExists) {
                return;
            }
            throw e;
        }
        sd.drop(lcc);
        Misc.getMemStore().dropSchemaRegion(this.schemaName, lcc.getTransactionExecute());
    }

    @Override
    public boolean isReplayable() {
        return !"SESSION".equalsIgnoreCase(this.schemaName);
    }

    @Override
    public String getSchemaName() {
        return this.schemaName;
    }

    @Override
    public boolean isDropStatement() {
        return true;
    }

    @Override
    public boolean isCancellable() {
        return false;
    }
}

