/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.depend.DependencyManager;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConstraintDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConstraintDescriptorList;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ForeignKeyConstraintDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ReferencedKeyConstraintDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SchemaDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.impl.sql.execute.AlterTableConstantAction;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ConstraintConstantAction;
import com.pivotal.gemfirexd.internal.impl.sql.execute.IndexConstantAction;

public class DropConstraintConstantAction
extends ConstraintConstantAction {
    private boolean cascade;
    private String constraintSchemaName;
    private int verifyType;
    private int constraintIdentifier;

    DropConstraintConstantAction(String constraintName, String constraintSchemaName, String tableName, UUID tableId, String tableSchemaName, IndexConstantAction indexAction, int behavior, int verifyType) {
        super(constraintName, 5, tableName, tableId, tableSchemaName, indexAction);
        this.cascade = behavior == 0;
        this.constraintSchemaName = constraintSchemaName;
        this.verifyType = verifyType;
    }

    public String toString() {
        if (this.constraintName == null) {
            return "DROP PRIMARY KEY";
        }
        String ss = this.constraintSchemaName == null ? this.schemaName : this.constraintSchemaName;
        return "DROP CONSTRAINT " + ss + "." + this.constraintName;
    }

    @Override
    public void executeConstantAction(Activation activation) throws StandardException {
        boolean cascadeOnRefKey;
        int numBuckets;
        ConstraintDescriptor conDesc = null;
        Object indexId = null;
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        DependencyManager dm = dd.getDependencyManager();
        TransactionController tc = lcc.getTransactionExecute();
        dd.startWriting(lcc);
        TableDescriptor td = dd.getTableDescriptor(this.tableId);
        if (td == null) {
            throw StandardException.newException("X0X05.S", this.tableName);
        }
        SchemaDescriptor tdSd = td.getSchemaDescriptor();
        SchemaDescriptor constraintSd = this.constraintSchemaName == null ? tdSd : dd.getSchemaDescriptor(this.constraintSchemaName, tc, true);
        conDesc = this.constraintName == null ? dd.getConstraintDescriptors(td).getPrimaryKey() : dd.getConstraintDescriptorByName(td, constraintSd, this.constraintName, true);
        if (conDesc == null) {
            String errorName = this.constraintName == null ? "PRIMARY KEY" : constraintSd.getSchemaName() + "." + this.constraintName;
            throw StandardException.newException("42X86", (Object)errorName, (Object)td.getQualifiedName());
        }
        this.constraintIdentifier = conDesc.getConstraintType();
        int constraintType = this.constraintIdentifier;
        if (constraintType == 2 && (numBuckets = AlterTableConstantAction.getNumBucketsOrSize(Misc.getRegionForTableByPath(Misc.getFullTableName(td, lcc), true), lcc)) > 0) {
            throw StandardException.newException("0A000.S", "PRIMARY KEY drop in ALTER TABLE with data or data history");
        }
        switch (this.verifyType) {
            case 3: {
                if (conDesc.getConstraintType() == this.verifyType) break;
                throw StandardException.newException("42Z9E", (Object)this.constraintName, (Object)"UNIQUE");
            }
            case 4: {
                if (conDesc.getConstraintType() == this.verifyType) break;
                throw StandardException.newException("42Z9E", (Object)this.constraintName, (Object)"CHECK");
            }
            case 6: {
                if (conDesc.getConstraintType() == this.verifyType) break;
                throw StandardException.newException("42Z9E", (Object)this.constraintName, (Object)"FOREIGN KEY");
            }
        }
        boolean bl = cascadeOnRefKey = this.cascade && conDesc instanceof ReferencedKeyConstraintDescriptor;
        if (!cascadeOnRefKey) {
            dm.invalidateFor(conDesc, 19, lcc);
        }
        if (constraintType == 6) {
            dm.invalidateFor(((ForeignKeyConstraintDescriptor)conDesc).getReferencedConstraint().getTableDescriptor(), 19, lcc);
        }
        this.dropConstraint(conDesc, activation, lcc, !cascadeOnRefKey);
        if (cascadeOnRefKey) {
            ReferencedKeyConstraintDescriptor cd = (ReferencedKeyConstraintDescriptor)conDesc;
            ConstraintDescriptorList cdl = cd.getForeignKeyConstraints(3);
            int cdlSize = cdl.size();
            for (int index = 0; index < cdlSize; ++index) {
                ForeignKeyConstraintDescriptor fkcd = (ForeignKeyConstraintDescriptor)cdl.elementAt(index);
                dm.invalidateFor(fkcd, 19, lcc);
                this.dropConstraint(fkcd, activation, lcc, true);
            }
            dm.invalidateFor(conDesc, 19, lcc);
            dm.clearDependencies(lcc, conDesc);
        }
    }

    @Override
    public String getSchemaName() {
        return null;
    }

    @Override
    String getFullConstraintName() {
        return this.constraintSchemaName + '.' + this.constraintName;
    }

    public boolean isForeignKeyConstraint() {
        return this.constraintIdentifier == 6;
    }
}

