/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.AliasDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SchemaDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.execute.DDLConstantAction;

public final class DropAliasConstantAction
extends DDLConstantAction {
    private SchemaDescriptor sd;
    private final String aliasName;
    private final char nameSpace;
    private boolean onlyIfExists;

    DropAliasConstantAction(SchemaDescriptor sd, String aliasName, char nameSpace, boolean onlyIfExists) {
        this.sd = sd;
        this.aliasName = aliasName;
        this.nameSpace = nameSpace;
        this.onlyIfExists = onlyIfExists;
    }

    public String toString() {
        return "DROP ALIAS " + this.aliasName;
    }

    @Override
    public void executeConstantAction(Activation activation) throws StandardException {
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        dd.startWriting(lcc);
        if (this.sd == null && this.onlyIfExists) {
            this.invalidatePreparedStatement(activation, 6);
            return;
        }
        String lockObject = this.sd.getSchemaName() + '.' + this.aliasName;
        GemFireXDUtils.lockObject(null, lockObject, true, lcc.getTransactionExecute());
        AliasDescriptor ad = dd.getAliasDescriptor(this.sd.getUUID().toString(), this.aliasName, this.nameSpace);
        if (ad == null) {
            if (this.onlyIfExists) {
                this.invalidatePreparedStatement(activation, 6);
                return;
            }
            throw StandardException.newException("42X94", (Object)AliasDescriptor.getAliasType(this.nameSpace), (Object)this.aliasName);
        }
        this.adjustUDTDependencies(lcc, dd, ad, false);
        ad.drop(lcc);
        GemFireXDUtils.freeLockResources(lockObject, lcc.getTransactionExecute());
    }

    @Override
    public final String getSchemaName() {
        return this.sd == null ? null : this.sd.getSchemaName();
    }

    @Override
    public final boolean isDropStatement() {
        return true;
    }

    @Override
    public final String getObjectName() {
        return this.aliasName;
    }

    @Override
    public boolean isCancellable() {
        return false;
    }

    @Override
    public boolean isDropIfExists() {
        return this.onlyIfExists;
    }
}

