/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.gemstone.gemfire.cache.DiskStoreFactory;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.access.operations.DiskStoreCreateOperation;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.engine.store.GemFireStore;
import com.pivotal.gemfirexd.internal.engine.store.ServerGroupUtils;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.impl.sql.compile.NumericConstantNode;
import com.pivotal.gemfirexd.internal.impl.sql.execute.DDLConstantAction;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CreateDiskStoreConstantAction
extends DDLConstantAction {
    private final String diskStoreName;
    private final List<String> dirPaths;
    private final List<Integer> dirSizes;
    private final Map otherAttribs;
    public static final String REGION_PREFIX_FOR_CONFLATION = "__GFXD_INTERNAL_DISKSTORE_";

    CreateDiskStoreConstantAction(String diskStoreName, List<String> dirPaths, List<Integer> dirSizes, Map otherAttribs) {
        this.diskStoreName = diskStoreName;
        this.dirPaths = dirPaths;
        this.dirSizes = dirSizes;
        this.otherAttribs = otherAttribs;
    }

    @Override
    public final String getSchemaName() {
        return "SYS";
    }

    @Override
    public final String getTableName() {
        return REGION_PREFIX_FOR_CONFLATION + this.diskStoreName;
    }

    public String toString() {
        return this.constructToString("CREATE DISKSTORE ", this.diskStoreName);
    }

    public static boolean isFilenameValid(String file) {
        Pattern illegalCharsPattern = Pattern.compile("[*?<>|;]");
        Matcher matcher = illegalCharsPattern.matcher(file);
        return !matcher.find();
    }

    @Override
    public void executeConstantAction(Activation activation) throws StandardException {
        if (!ServerGroupUtils.isDataStore()) {
            SanityManager.DEBUG_PRINT((String)"TraceConglom", (String)("Skipping create diskstore for " + this.diskStoreName + " on JVM of kind " + GemFireXDUtils.getMyVMKind()));
            return;
        }
        DiskStoreFactory dsf = Misc.getGemFireCache().createDiskStoreFactory();
        GemFireStore store = Misc.getMemStore();
        int numDirs = this.dirPaths.size();
        StringBuilder dirPathsAndSizes = new StringBuilder();
        if (numDirs > 0) {
            File[] dirs = new File[numDirs];
            int[] sizes = new int[numDirs];
            boolean[] dirCreated = new boolean[numDirs];
            Arrays.fill(dirCreated, false);
            Hashtable<String, String> ht = new Hashtable<String, String>();
            String canonicalPath = null;
            boolean foundExplicitSize = false;
            for (int i = 0; i < numDirs; ++i) {
                String fileStr = this.dirPaths.get(i);
                if (!CreateDiskStoreConstantAction.isFilenameValid(fileStr = store.generatePersistentDirName(fileStr))) {
                    throw StandardException.newException("0A000.S", "Directory name " + this.dirPaths.get(i) + " was not valid");
                }
                dirs[i] = new File(fileStr).getAbsoluteFile();
                dirPathsAndSizes.append(dirs[i].getAbsolutePath());
                dirCreated[i] = dirs[i].mkdir();
                try {
                    canonicalPath = dirs[i].getCanonicalPath();
                }
                catch (IOException ie) {
                    throw GemFireXDRuntimeException.newRuntimeException("Unexpected exception while accessing the directory " + dirs[i].toString(), ie);
                }
                if (ht.put(canonicalPath, canonicalPath) != null) {
                    for (int k = 0; k <= i; ++k) {
                        if (!dirCreated[k]) continue;
                        dirs[k].delete();
                    }
                    throw StandardException.newException("X0Z19.S", canonicalPath);
                }
                int temp = this.dirSizes.get(i);
                if (temp > 0) {
                    sizes[i] = temp;
                    dirPathsAndSizes.append("(");
                    dirPathsAndSizes.append(temp);
                    dirPathsAndSizes.append(")");
                    foundExplicitSize = true;
                }
                dirPathsAndSizes.append(",");
            }
            dirPathsAndSizes.deleteCharAt(dirPathsAndSizes.length() - 1);
            if (foundExplicitSize) {
                dsf.setDiskDirsAndSizes(dirs, sizes);
            } else {
                dsf.setDiskDirs(dirs);
            }
        } else {
            String defaultDir = store.generatePersistentDirName(null);
            File[] dirs = new File[]{new File(defaultDir).getAbsoluteFile()};
            dirPathsAndSizes.append(dirs[0].getAbsolutePath());
            String fileNameToCheck = defaultDir + "\\" + this.diskStoreName;
            if (!CreateDiskStoreConstantAction.isFilenameValid(fileNameToCheck)) {
                throw StandardException.newException("0A000.S", "Disk Store name " + this.diskStoreName + " was not valid");
            }
            dirs[0].mkdir();
            dsf.setDiskDirs(dirs);
        }
        for (Map.Entry entry : this.otherAttribs.entrySet()) {
            String key = (String)entry.getKey();
            Object vn = entry.getValue();
            try {
                String val;
                NumericConstantNode ncn;
                if (key.equalsIgnoreCase("maxlogsize")) {
                    ncn = (NumericConstantNode)vn;
                    dsf.setMaxOplogSize(ncn.getValue().getLong());
                    continue;
                }
                if (key.equalsIgnoreCase("compactionthreshold")) {
                    ncn = (NumericConstantNode)vn;
                    dsf.setCompactionThreshold(ncn.getValue().getInt());
                    continue;
                }
                if (key.equalsIgnoreCase("timeinterval")) {
                    ncn = (NumericConstantNode)vn;
                    dsf.setTimeInterval((long)ncn.getValue().getInt());
                    continue;
                }
                if (key.equalsIgnoreCase("writebuffersize")) {
                    ncn = (NumericConstantNode)vn;
                    dsf.setWriteBufferSize(ncn.getValue().getInt());
                    continue;
                }
                if (key.equalsIgnoreCase("queuesize")) {
                    ncn = (NumericConstantNode)vn;
                    dsf.setQueueSize(ncn.getValue().getInt());
                    continue;
                }
                if (key.equalsIgnoreCase("autocompact")) {
                    val = (String)vn;
                    if (val.equalsIgnoreCase("true")) {
                        dsf.setAutoCompact(Boolean.TRUE.booleanValue());
                        continue;
                    }
                    if (!val.equalsIgnoreCase("false")) continue;
                    dsf.setAutoCompact(Boolean.FALSE.booleanValue());
                    continue;
                }
                if (!key.equalsIgnoreCase("allowforcecompaction")) continue;
                val = (String)vn;
                if (val.equalsIgnoreCase("true")) {
                    dsf.setAllowForceCompaction(Boolean.TRUE.booleanValue());
                    continue;
                }
                if (!val.equalsIgnoreCase("false")) continue;
                dsf.setAllowForceCompaction(Boolean.FALSE.booleanValue());
            }
            catch (IllegalArgumentException e) {
                throw StandardException.newException("0A000.S", "Value for " + key + " was not valid");
            }
        }
        DiskStoreCreateOperation startOp = new DiskStoreCreateOperation(dsf, this.diskStoreName, dirPathsAndSizes.toString());
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        GemFireTransaction gft = (GemFireTransaction)lcc.getTransactionExecute();
        gft.logAndDo(startOp);
    }
}

