/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.TXEntryState;
import com.gemstone.gemfire.internal.cache.TXState;
import com.gemstone.gemfire.internal.cache.TXStateInterface;
import com.gemstone.gemfire.internal.cache.TXStateProxy;
import com.gemstone.gemfire.internal.cache.locks.ExclusiveSharedLockObject;
import com.gemstone.gemfire.internal.cache.locks.LockingPolicy;
import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.sql.execute.AbstractGemFireResultSet;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.engine.store.RowFormatter;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.i18n.MessageService;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.StatementContext;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecutionFactory;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.NoPutResultSet;
import com.pivotal.gemfirexd.internal.iapi.store.access.RowUtil;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import com.pivotal.gemfirexd.internal.impl.sql.execute.PlanUtils;
import com.pivotal.gemfirexd.internal.impl.sql.execute.xplain.XPLAINUtil;
import java.sql.SQLWarning;
import java.sql.Timestamp;
import java.util.ArrayList;

public abstract class BasicNoPutResultSetImpl
implements NoPutResultSet {
    protected boolean isOpen;
    protected boolean finished;
    protected ExecRow currentRow;
    protected boolean isTopResultSet;
    private SQLWarning warnings;
    protected final GemFireXDQueryObserver observer = GemFireXDQueryObserverHolder.getInstance();
    protected final LanguageConnectionContext lcc;
    protected boolean localTXStateSet;
    protected TXState localTXState;
    protected Object lockContext;
    protected UUID executionPlanID;
    protected boolean isLocallyExecuted = false;
    protected boolean hasLockReference;
    public int numOpens;
    public int rowsSeen;
    public int rowsFiltered;
    protected long startExecutionTime;
    protected long endExecutionTime;
    public volatile long beginTime;
    public long constructorTime;
    public long openTime;
    public long nextTime;
    public long closeTime;
    public double optimizerEstimatedRowCount;
    public double optimizerEstimatedCost;
    private StatementContext statementContext;
    public NoPutResultSet[] subqueryTrackingArray;
    ExecRow compactRow;
    protected final Activation activation;
    protected boolean statisticsTimingOn;
    protected boolean runtimeStatisticsOn;
    protected boolean explainConnection;
    protected boolean statsEnabled;
    private transient TransactionController tc;
    protected int[] baseColumnMap;

    protected BasicNoPutResultSetImpl(Activation activation, double optimizerEstimatedRowCount, double optimizerEstimatedCost) {
        this.statisticsTimingOn = activation.getLanguageConnectionContext().getStatisticsTiming();
        if (this.statisticsTimingOn) {
            this.beginTime = XPLAINUtil.nanoTime();
            this.startExecutionTime = XPLAINUtil.currentTimeMillis();
        }
        this.activation = activation;
        this.optimizerEstimatedRowCount = optimizerEstimatedRowCount;
        this.optimizerEstimatedCost = optimizerEstimatedCost;
        this.lcc = activation.getLanguageConnectionContext();
        if (this.isTopResultSet) {
            this.runtimeStatisticsOn = this.lcc.getRunTimeStatisticsMode();
            this.explainConnection = this.lcc.explainConnection();
            this.statsEnabled = this.lcc.statsEnabled();
        }
    }

    protected final void recordConstructorTime() {
        if (this.statisticsTimingOn) {
            this.constructorTime = this.getElapsedNanos(this.beginTime);
        }
    }

    @Override
    public final Activation getActivation() {
        return this.activation;
    }

    @Override
    public void reopenCore() throws StandardException {
        this.close(false);
        this.openCore();
    }

    @Override
    public abstract ExecRow getNextRowCore() throws StandardException;

    @Override
    public int getPointOfAttachment() {
        SanityManager.THROWASSERT((String)("getPointOfAttachment() not expected to be called for " + this.getClass().getName()));
        return -1;
    }

    @Override
    public void markAsTopResultSet() {
        this.isTopResultSet = true;
    }

    @Override
    public int getScanIsolationLevel() {
        SanityManager.THROWASSERT((String)("getScanIsolationLevel() not expected to be called for " + this.getClass().getName()));
        return 0;
    }

    @Override
    public double getEstimatedRowCount() {
        return this.optimizerEstimatedRowCount;
    }

    @Override
    public boolean requiresRelocking() {
        SanityManager.THROWASSERT((String)("requiresRelocking() not expected to be called for " + this.getClass().getName()));
        return false;
    }

    @Override
    public final void open() throws StandardException {
        if (!this.isTopResultSet) {
            SanityManager.THROWASSERT((String)(this + "expected to be the top ResultSet"));
        }
        if (this.isOpen && this.isDistributedResultSet()) {
            return;
        }
        this.statisticsTimingOn = this.lcc.getStatisticsTiming();
        if (this.statisticsTimingOn && this.startExecutionTime == 0L) {
            this.startExecutionTime = XPLAINUtil.currentTimeMillis();
        }
        if (this.isTopResultSet) {
            this.runtimeStatisticsOn = this.lcc.getRunTimeStatisticsMode();
            this.explainConnection = this.lcc.explainConnection();
            this.statsEnabled = this.lcc.statsEnabled();
        }
        AbstractGemFireResultSet gfSource = null;
        if (this.observer != null && (gfSource = this.getWrappedGemFireRS()) != null) {
            this.observer.beforeGemFireResultSetOpen(gfSource, this.lcc);
        }
        this.finished = false;
        this.attachStatementContext();
        try {
            if (this.isOpen) {
                this.reopenCore();
            } else {
                this.openCore();
            }
        }
        catch (StandardException se) {
            this.activation.checkStatementValidity();
            throw se;
        }
        this.activation.checkStatementValidity();
        if (this.observer != null && gfSource != null) {
            this.observer.afterGemFireResultSetOpen(gfSource, this.lcc);
        }
    }

    @Override
    public ExecRow getAbsoluteRow(int row) throws StandardException {
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S.0", "absolute");
        }
        this.attachStatementContext();
        if (!this.isTopResultSet) {
            SanityManager.THROWASSERT((String)(this + "expected to be the top ResultSet"));
        }
        SanityManager.THROWASSERT((String)("getAbsoluteRow() not expected to be called for " + this.getClass().getName()));
        return null;
    }

    @Override
    public ExecRow getRelativeRow(int row) throws StandardException {
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S.0", "relative");
        }
        this.attachStatementContext();
        if (!this.isTopResultSet) {
            SanityManager.THROWASSERT((String)(this + "expected to be the top ResultSet"));
        }
        SanityManager.THROWASSERT((String)("getRelativeRow() not expected to be called for " + this.getClass().getName()));
        return null;
    }

    @Override
    public ExecRow setBeforeFirstRow() throws StandardException {
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S.0", "first");
        }
        if (!this.isTopResultSet) {
            SanityManager.THROWASSERT((String)(this + "expected to be the top ResultSet"));
        }
        SanityManager.THROWASSERT((String)("setBeforeFirstRow() not expected to be called for " + this.getClass().getName()));
        return null;
    }

    @Override
    public boolean checkRowPosition(int isType) throws StandardException {
        return false;
    }

    @Override
    public int getRowNumber() {
        return 0;
    }

    @Override
    public ExecRow getFirstRow() throws StandardException {
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S.0", "first");
        }
        this.attachStatementContext();
        if (!this.isTopResultSet) {
            SanityManager.THROWASSERT((String)(this + "expected to be the top ResultSet"));
        }
        SanityManager.THROWASSERT((String)("getFirstRow() not expected to be called for " + this.getClass().getName()));
        return null;
    }

    @Override
    public final ExecRow getNextRow() throws StandardException {
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S.0", "next");
        }
        if (!this.isTopResultSet) {
            SanityManager.THROWASSERT((String)(this + "expected to be the top ResultSet"));
        }
        this.attachStatementContext();
        return this.getNextRowCore();
    }

    @Override
    public ExecRow getPreviousRow() throws StandardException {
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S.0", "previous");
        }
        this.attachStatementContext();
        if (!this.isTopResultSet) {
            SanityManager.THROWASSERT((String)(this + "expected to be the top ResultSet"));
        }
        SanityManager.THROWASSERT((String)"getPreviousRow() not expected to be called.");
        return null;
    }

    @Override
    public ExecRow getLastRow() throws StandardException {
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S.0", "last");
        }
        this.attachStatementContext();
        if (!this.isTopResultSet) {
            SanityManager.THROWASSERT((String)(this + "expected to be the top ResultSet"));
        }
        SanityManager.THROWASSERT((String)"getLastRow() not expected to be called.");
        return null;
    }

    @Override
    public ExecRow setAfterLastRow() throws StandardException {
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S.0", "last");
        }
        if (!this.isTopResultSet) {
            SanityManager.THROWASSERT((String)(this + "expected to be the top ResultSet"));
        }
        SanityManager.THROWASSERT((String)"setAfterLastRow() not expected to be called.");
        return null;
    }

    @Override
    public boolean returnsRows() {
        return true;
    }

    @Override
    public final int modifiedRowCount() {
        return 0;
    }

    @Override
    public void cleanUp(boolean cleanupOnError) throws StandardException {
        if (this.isOpen) {
            this.close(cleanupOnError);
        }
    }

    @Override
    public final boolean isClosed() {
        return !this.isOpen;
    }

    @Override
    public void finish() throws StandardException {
        this.finishAndRTS();
    }

    protected final void finishAndRTS() throws StandardException {
        if (!this.finished) {
            if (!this.isClosed()) {
                this.close(false);
            }
            this.finished = true;
            if (this.isTopResultSet && this.activation.isSingleExecution()) {
                this.activation.close();
            }
        }
    }

    @Override
    public long getExecuteTime() {
        return this.getTimeSpent(1, 0) + this.constructorTime;
    }

    @Override
    public Timestamp getBeginExecutionTimestamp() {
        if (this.startExecutionTime == 0L) {
            return null;
        }
        return new Timestamp(this.startExecutionTime);
    }

    @Override
    public Timestamp getEndExecutionTimestamp() {
        if (this.endExecutionTime == 0L) {
            return null;
        }
        return new Timestamp(this.endExecutionTime);
    }

    @Override
    public final NoPutResultSet[] getSubqueryTrackingArray(int numSubqueries) {
        if (this.subqueryTrackingArray == null) {
            this.subqueryTrackingArray = new NoPutResultSet[numSubqueries];
        }
        return this.subqueryTrackingArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void upgradeReadLockToWrite(RowLocation rl, GemFireContainer container) {
        TXState tx = this.localTXState;
        RegionEntry entry = rl.getUnderlyingRegionEntry();
        LocalRegion dataRegion = tx.removeReadLockForScan((ExclusiveSharedLockObject)entry, this.lockContext);
        if (dataRegion != null) {
            Object region;
            if (container != null) {
                region = container.getRegion();
            } else {
                region = dataRegion.isUsedForPartitionedRegionBucket() ? dataRegion.getPartitionedRegion() : dataRegion;
                container = (GemFireContainer)region.getUserAttribute();
            }
            try {
                TXStateProxy txProxy = tx.getProxy();
                if (this.observer != null) {
                    this.observer.lockingRowForTX(txProxy, container, entry, true);
                }
                txProxy.lockEntry(entry, entry.getKey(), GemFireXDUtils.getRoutingObject(rl.getBucketID()), region, dataRegion, true, TXEntryState.getLockForUpdateOp());
            }
            finally {
                LockingPolicy lockPolicy = tx.getLockingPolicy();
                GemFireXDUtils.unlockEntryAfterRead(tx.getTransactionId(), lockPolicy, lockPolicy.getReadLockMode(), entry, container, dataRegion);
            }
        }
    }

    protected final void releaseRowLocationLock(RowLocation rl, GemFireContainer container) {
        if (rl != null) {
            assert (this.localTXStateSet && this.localTXState != null) : "unexpected localTXState=" + this.localTXState;
            TXState tx = this.localTXState;
            LockingPolicy lockPolicy = tx.getLockingPolicy();
            GemFireXDUtils.releaseLockForReadOnPreviousEntry(rl.getUnderlyingRegionEntry(), tx, tx.getTransactionId(), lockPolicy, lockPolicy.getReadLockMode(), container, null, this.lockContext);
        }
    }

    @Override
    public boolean hasAutoGeneratedKeysResultSet() {
        return false;
    }

    @Override
    public void flushBatch() {
    }

    @Override
    public void closeBatch() {
    }

    protected AbstractGemFireResultSet getWrappedGemFireRS() {
        return null;
    }

    @Override
    public ResultSet getAutoGeneratedKeysResultset() {
        return null;
    }

    protected final long getElapsedNanos(long beginTime) {
        SanityManager.ASSERT((boolean)this.statisticsTimingOn, (String)"getElapsedNanos: unexpected call with statisticsTimingOn as false");
        long ts = XPLAINUtil.nanoTime();
        long delta = ts - beginTime;
        if (GemFireXDUtils.TracePlanAssertion) {
            SanityManager.ASSERT((delta >= 0L ? 1 : 0) != 0, (String)(delta + " " + ts + " " + beginTime));
        }
        return delta >= 0L ? delta : 0L;
    }

    protected final String dumpTimeStats(String indent, String subIndent) {
        return indent + MessageService.getTextMessage("42Z30.U") + " " + this.getTimeSpent(0, 0) + "\n" + indent + MessageService.getTextMessage("42Z31.U") + " " + this.getTimeSpent(1, 0) + "\n" + indent + MessageService.getTextMessage("42Z32.U") + "\n" + subIndent + MessageService.getTextMessage("42Z33.U") + " " + this.constructorTime + "\n" + subIndent + MessageService.getTextMessage("42Z34.U") + " " + this.openTime + "\n" + subIndent + MessageService.getTextMessage("42Z35.U") + " " + this.nextTime + "\n" + subIndent + MessageService.getTextMessage("42Z36.U") + " " + this.closeTime;
    }

    protected void attachStatementContext() throws StandardException {
        if (this.isTopResultSet) {
            if (this.statementContext == null || !this.statementContext.onStack()) {
                this.statementContext = this.getLanguageConnectionContext().getStatementContext();
            }
            this.statementContext.setTopResultSet(this, this.subqueryTrackingArray);
            if (this.subqueryTrackingArray == null) {
                this.subqueryTrackingArray = this.statementContext.getSubqueryTrackingArray();
            }
        } else if (this.statementContext == null || !this.statementContext.onStack()) {
            StatementContext localStatementContext = this.getLanguageConnectionContext().getStatementContext();
            this.statementContext = localStatementContext != null && localStatementContext.isLightWeight() ? localStatementContext : null;
        }
    }

    protected final LanguageConnectionContext getLanguageConnectionContext() {
        return this.lcc;
    }

    @Override
    public int resultSetNumber() {
        SanityManager.THROWASSERT((String)("resultSetNumber() should not be called on a " + this.getClass().getName()));
        return 0;
    }

    final ExecutionFactory getExecutionFactory() {
        return this.activation.getExecutionFactory();
    }

    final TransactionController getTransactionController() {
        if (this.tc == null) {
            this.tc = this.getLanguageConnectionContext().getTransactionExecute();
        }
        return this.tc;
    }

    protected final ExecRow getCompactRow(ExecRow candidate, FormatableBitSet accessedCols, boolean isKeyed) throws StandardException {
        return this.getCompactRow(candidate, accessedCols, isKeyed, false, null, null, true);
    }

    protected final ExecRow getCompactRow(ExecRow candidate, FormatableBitSet accessedCols, boolean isKeyed, boolean useByteStorage, GemFireContainer gfc, RowFormatter rf, boolean copyColumns) throws StandardException {
        int numCols;
        int numCandidateCols = candidate.nColumns();
        if (accessedCols == null || (numCols = accessedCols.getNumBitsSet()) == numCandidateCols && accessedCols.lastSetBit() == numCandidateCols - 1) {
            this.compactRow = candidate;
        } else {
            this.baseColumnMap = new int[numCols];
            if (this.compactRow == null) {
                if (isKeyed) {
                    ExecutionFactory ex = this.getLanguageConnectionContext().getLanguageConnectionFactory().getExecutionFactory();
                    this.compactRow = ex.getIndexableRow(numCols);
                } else if (useByteStorage) {
                    this.compactRow = gfc.newCompactExecRow(null, rf);
                } else {
                    ExecutionFactory ex = this.getLanguageConnectionContext().getLanguageConnectionFactory().getExecutionFactory();
                    this.compactRow = ex.getValueRow(numCols);
                }
            }
            this.compactRow.setCompactColumns(accessedCols, candidate, this.baseColumnMap, copyColumns);
        }
        return this.compactRow;
    }

    protected final ExecRow setCompactRow(ExecRow candidateRow, ExecRow compactRow) throws StandardException {
        ExecRow retval;
        if (this.baseColumnMap == null || this.baseColumnMap.length == 0) {
            retval = candidateRow;
        } else {
            retval = compactRow;
            int[] lbcm = this.baseColumnMap;
            if (lbcm != null) {
                compactRow.setColumns(lbcm, true, candidateRow);
            } else {
                compactRow.setColumns(compactRow.nColumns(), candidateRow);
            }
        }
        return retval;
    }

    @Override
    public final TXState initLocalTXState() {
        if (this.localTXStateSet) {
            return this.localTXState;
        }
        this.localTXState = null;
        TXStateInterface tx = ((GemFireTransaction)this.lcc.getTransactionExecute()).getActiveTXState();
        if (tx != null) {
            if (this.isForUpdate()) {
                this.localTXState = tx.getTXStateForWrite();
                this.initLocalTXState(this.localTXState, true);
            } else if (!tx.getLockingPolicy().zeroDurationReadLocks()) {
                this.localTXState = tx.getTXStateForRead();
                this.initLocalTXState(this.localTXState, false);
            }
        }
        this.localTXStateSet = true;
        return this.localTXState;
    }

    protected void initLocalTXState(TXState localTXState, boolean forUpdate) {
        this.lockContext = localTXState.getReadLocksForScanContext((Object)this.lcc);
    }

    @Override
    public void deleteRowDirectly() throws StandardException {
        throw new UnsupportedOperationException("This method should not have been invoked");
    }

    @Override
    public boolean canUpdateInPlace() {
        return false;
    }

    @Override
    public boolean supportsMoveToNextKey() {
        return false;
    }

    @Override
    public int getScanKeyGroupID() {
        throw new UnsupportedOperationException("not expected to be invoked");
    }

    protected final void setCompactRow(ExecRow compactRow, DataValueDescriptor[] sourceRow) throws StandardException {
        DataValueDescriptor[] srcValues = new DataValueDescriptor[compactRow.nColumns()];
        int[] lbcm = this.baseColumnMap;
        if (lbcm != null) {
            for (int i = 0; i < lbcm.length; ++i) {
                srcValues[i] = sourceRow[lbcm[i]];
            }
        } else {
            int size = compactRow.nColumns();
            for (int i = 0; i < size; ++i) {
                srcValues[i] = sourceRow[i];
            }
        }
        compactRow.setColumns(null, srcValues);
    }

    @Override
    public boolean isForUpdate() {
        return false;
    }

    @Override
    public final void checkCancellationFlag() throws StandardException {
        if (this.activation.isQueryCancelled()) {
            this.activation.checkCancellationFlag();
        }
    }

    protected final void addWarning(SQLWarning w) {
        ResultSet rs;
        if (this.isTopResultSet) {
            if (this.warnings == null) {
                this.warnings = w;
            } else {
                this.warnings.setNextWarning(w);
            }
            return;
        }
        if (this.activation != null && (rs = this.activation.getResultSet()) instanceof BasicNoPutResultSetImpl) {
            ((BasicNoPutResultSetImpl)rs).addWarning(w);
        }
    }

    @Override
    public final SQLWarning getWarnings() {
        SQLWarning w = this.warnings;
        this.warnings = null;
        return w;
    }

    @Override
    public UUID getExecutionPlanID() {
        return this.executionPlanID;
    }

    @Override
    public void markLocallyExecuted() {
        this.isLocallyExecuted = true;
    }

    public boolean isReplicateIfSetOpSupported() throws StandardException {
        SanityManager.DEBUG_PRINT((String)"info:Not yet implemented", (String)(" Set Operators do not yet supported for class: " + this.getClass().getSimpleName()));
        throw StandardException.newException("0A000.S", " Currently Set operators are not supported for these queries");
    }

    @Override
    public void resetStatistics() {
        this.startExecutionTime = 0L;
        this.endExecutionTime = 0L;
        this.openTime = 0L;
        this.closeTime = 0L;
        this.nextTime = 0L;
        this.numOpens = 0;
        this.rowsSeen = 0;
        this.rowsFiltered = 0;
    }

    @Override
    public boolean isDistributedResultSet() {
        return false;
    }

    @Override
    public boolean addLockReference(GemFireTransaction tran) {
        tran.getLockSpace().addResultSetRef();
        this.hasLockReference = true;
        return true;
    }

    @Override
    public boolean releaseLocks(GemFireTransaction tran) {
        if (this.hasLockReference) {
            tran.releaseAllLocks(false, true);
            this.hasLockReference = false;
            return true;
        }
        return false;
    }

    @Override
    public void setGfKeysForNCJoin(ArrayList<DataValueDescriptor> keys) throws StandardException {
        throw StandardException.newException("0A000.S", " Currently this method is not implemented or overridden for class " + this.getClass().getSimpleName());
    }

    @Override
    public PlanUtils.Context getNewPlanContext() {
        return new PlanUtils.Context();
    }

    @Override
    public StringBuilder buildQueryPlan(StringBuilder builder, PlanUtils.Context context) {
        PlanUtils.xmlBeginTag(builder, context, this);
        if (this.isTopResultSet) {
            PlanUtils.xmlAttribute(builder, "begin_execute_time", this.getBeginExecutionTimestamp());
            PlanUtils.xmlAttribute(builder, "end_execute_time", this.getEndExecutionTimestamp());
            context.totalExecTime = this.getExecuteTime();
            PlanUtils.xmlAttribute(builder, "total_execute_time", (double)context.totalExecTime / 1000000.0, " ms");
        }
        long v = this.getTimeSpent(0, 0);
        PlanUtils.xmlAttribute(builder, "net_execute_time", (double)v / 1000000.0, " ms");
        double percent = (double)v / (double)context.totalExecTime * 100.0;
        PlanUtils.xmlAttribute(builder, "percent_execute_time", PlanUtils.format.format(percent), "%");
        v = this.getTimeSpent(0, 1);
        PlanUtils.xmlAttribute(builder, "construct_time", v < 0L ? 0.0 : (double)v / 1000000.0, " ms");
        v = this.getTimeSpent(0, 2);
        PlanUtils.xmlAttribute(builder, "open_time", v < 0L ? 0.0 : (double)v / 1000000.0, " ms");
        v = this.getTimeSpent(0, 3);
        PlanUtils.xmlAttribute(builder, "next_time", v < 0L ? 0.0 : (double)v / 1000000.0, " ms");
        v = this.getTimeSpent(0, 4);
        PlanUtils.xmlAttribute(builder, "close_time", v < 0L ? 0.0 : (double)v / 1000000.0, " ms");
        PlanUtils.xmlAttribute(builder, "num_opens", this.numOpens);
        PlanUtils.xmlAttribute(builder, "rows_seen", this.rowsSeen);
        PlanUtils.xmlAttribute(builder, "rows_filtered", this.rowsFiltered);
        return builder;
    }

    @Override
    public RowLocation fetch(RowLocation loc, ExecRow destRow, FormatableBitSet validColumns, boolean faultIn, GemFireContainer container) throws StandardException {
        return RowUtil.fetch(loc, destRow, validColumns, faultIn, container, null, null, 0, (GemFireTransaction)this.lcc.getTransactionExecute());
    }

    @Override
    public void releasePreviousByteSource() {
    }

    @Override
    public void setMaxSortingLimit(long limit) {
    }

    @Override
    public void forceReOpenCore() throws StandardException {
    }
}

