/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.conn;

import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.cache.Cacheable;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.impl.sql.GenericPreparedStatement;
import com.pivotal.gemfirexd.internal.impl.sql.GenericStatement;

public class CachedStatement
implements Cacheable {
    private GenericPreparedStatement ps;
    private Object identity;

    public GenericPreparedStatement getPreparedStatement() {
        return this.ps;
    }

    @Override
    public void clean(boolean forRemove) {
    }

    @Override
    public Cacheable setIdentity(Object key) {
        this.identity = key;
        this.ps = new GenericPreparedStatement((GenericStatement)key);
        this.ps.setCacheHolder(this);
        return this;
    }

    @Override
    public Cacheable createIdentity(Object key, Object createParameter) {
        SanityManager.THROWASSERT((String)"Not expecting any create() calls");
        return null;
    }

    @Override
    public void clearIdentity() {
        try {
            LanguageConnectionContext lcc = Misc.getLanguageConnectionContext();
            Misc.getMemStore().getDatabase().getDataDictionary().getDependencyManager().clearDependencies(lcc, this.ps);
        }
        catch (StandardException ex) {
            throw GemFireXDRuntimeException.newRuntimeException("CachedStatement#clearIdentity: unexpected exception in clearing the dependencies for " + this.ps, ex);
        }
        SanityManager.DEBUG((String)"StatementCacheInfo", (String)("CLEARING IDENTITY: " + this.ps.getSource()));
        this.ps.setCacheHolder(null);
        this.identity = null;
        this.ps = null;
    }

    @Override
    public Object getIdentity() {
        return this.identity;
    }

    @Override
    public boolean isDirty() {
        return false;
    }
}

