/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.MethodBuilder;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ExpressionClassBuilder;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumn;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumnList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultSetNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNode;

public class VirtualColumnNode
extends ValueNode {
    private ResultSetNode sourceResultSet;
    private ResultColumn sourceColumn;
    int columnId;
    private boolean correlated = false;

    @Override
    public void init(Object sourceResultSet, Object sourceColumn, Object columnId) throws StandardException {
        ResultColumn source = (ResultColumn)sourceColumn;
        this.sourceResultSet = (ResultSetNode)sourceResultSet;
        this.sourceColumn = source;
        this.columnId = (Integer)columnId;
        this.setType(source.getTypeServices());
    }

    @Override
    public void printSubNodes(int depth) {
        super.printSubNodes(depth);
        this.printLabel(depth, "sourceColumn: ");
        this.sourceColumn.treePrint(depth + 1);
    }

    public ResultSetNode getSourceResultSet() {
        return this.sourceResultSet;
    }

    public ResultColumn getSourceColumn() {
        return this.sourceColumn;
    }

    @Override
    public String getTableName() {
        return this.sourceColumn.getTableName();
    }

    @Override
    public String getSchemaName() {
        return this.sourceColumn.getSchemaName();
    }

    @Override
    public boolean updatableByCursor() {
        return this.sourceColumn.updatableByCursor();
    }

    @Override
    public ResultColumn getSourceResultColumn() {
        return this.sourceColumn;
    }

    void setCorrelated() {
        this.correlated = true;
    }

    boolean getCorrelated() {
        return this.correlated;
    }

    @Override
    public boolean isCloneable() {
        return true;
    }

    @Override
    public void generateExpression(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        int sourceResultSetNumber = this.sourceColumn.getResultSetNumber();
        if (this.sourceColumn.isRedundant()) {
            this.sourceColumn.getExpression().generateExpression(acb, mb);
            return;
        }
        SanityManager.ASSERT((sourceResultSetNumber >= 0 ? 1 : 0) != 0, (String)("sourceResultSetNumber expected to be >= 0 for virtual column " + this.sourceColumn.getName()));
        acb.pushColumnReference(mb, sourceResultSetNumber, this.sourceColumn.getVirtualColumnId());
        mb.cast(this.sourceColumn.getTypeCompiler().interfaceName());
    }

    @Override
    protected int getOrderableVariantType() throws StandardException {
        return this.sourceColumn.getOrderableVariantType();
    }

    @Override
    public DataTypeDescriptor getTypeServices() {
        return this.sourceColumn.getTypeServices();
    }

    @Override
    public void setType(DataTypeDescriptor dtd) throws StandardException {
        this.sourceColumn.setType(dtd);
    }

    @Override
    protected boolean isEquivalent(ValueNode o) throws StandardException {
        if (this.isSameNodeType(o)) {
            VirtualColumnNode other = (VirtualColumnNode)o;
            return this.sourceColumn.isEquivalent(other.sourceColumn);
        }
        return false;
    }

    @Override
    public String toString() {
        return "sourceColumn: " + this.sourceColumn + '\n' + super.toString();
    }

    @Override
    public ValueNode genExpressionOperands(ResultColumnList outerResultColumns, ResultColumn parentRC, boolean remapToNew) throws StandardException {
        if (parentRC != null) {
            outerResultColumns.addResultColumn(parentRC);
            return this;
        }
        int columnID = -1;
        ResultColumn resultColumn = (ResultColumn)this.getNodeFactory().getNode(80, this.toString(), this, this.getContextManager());
        outerResultColumns.addResultColumn(resultColumn);
        columnID = outerResultColumns.size();
        if (remapToNew) {
            VirtualColumnNode newVC = (VirtualColumnNode)this.getNodeFactory().getNode(107, this.getSourceResultSet(), resultColumn, columnID, this.getContextManager());
            return newVC;
        }
        return this;
    }

    @Override
    public boolean hasExpression() {
        return this.sourceColumn.hasExpression();
    }

    @Override
    public boolean isTableColumn() {
        return false;
    }

    @Override
    public String findSourceSchemaName() {
        return this.sourceColumn.findSourceSchemaName();
    }

    @Override
    public String findSourceTableName() {
        return this.sourceColumn.findSourceTableName();
    }

    @Override
    public String findSourceColumnName() {
        return this.sourceColumn.findSourceColumnName();
    }

    public void ncjSetResultSetNumber(int rsNumber) {
        this.sourceColumn.ncjSetResultSetNumber(rsNumber);
    }
}

