/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.catalog.types.UserDefinedTypeIdImpl;
import com.pivotal.gemfirexd.internal.engine.sql.compile.types.DVDSet;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.MethodBuilder;
import com.pivotal.gemfirexd.internal.iapi.services.i18n.MessageService;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.NodeFactory;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Optimizable;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.TypeCompiler;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueFactory;
import com.pivotal.gemfirexd.internal.iapi.types.TypeId;
import com.pivotal.gemfirexd.internal.iapi.util.JBitSet;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ActivationClassBuilder;
import com.pivotal.gemfirexd.internal.impl.sql.compile.AndNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.BinaryRelationalOperatorNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.BooleanConstantNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ColumnReference;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ConstantNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ExpressionClassBuilder;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.IsNullNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.JavaValueNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.NotNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ParameterNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.PredicateList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.QueryTreeNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ReferencedTablesVisitor;
import com.pivotal.gemfirexd.internal.impl.sql.compile.RelationalOperator;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumn;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumnList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SubqueryList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SubqueryNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.TernaryOperatorNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.UnaryOperatorNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.VirtualColumnNode;
import java.util.Vector;

public abstract class ValueNode
extends QueryTreeNode {
    protected static final int NOTCOLOCATED = -1;
    protected static final int UNKNOWN = 0;
    protected static final int COMPLETELYCOLOCATED = 1;
    protected static final int PARTLYCOLOCATED = 2;
    protected static final int CONTINUE = 3;
    private DataTypeDescriptor dataTypeServices;
    boolean transformed;

    public ValueNode() {
    }

    final void setType(TypeId typeId, boolean isNullable, int maximumWidth) throws StandardException {
        this.setType(new DataTypeDescriptor(typeId, isNullable, maximumWidth));
    }

    final void setType(TypeId typeId, int precision, int scale, boolean isNullable, int maximumWidth) throws StandardException {
        this.setType(new DataTypeDescriptor(typeId, precision, scale, isNullable, maximumWidth));
    }

    @Override
    public void init(Object typeId, Object precision, Object scale, Object isNullable, Object maximumWidth) throws StandardException {
        this.setType(new DataTypeDescriptor((TypeId)typeId, (int)((Integer)precision), (int)((Integer)scale), (boolean)((Boolean)isNullable), (int)((Integer)maximumWidth)));
    }

    ValueNode(Object tcf, Object typeId, Object isNullable, Object maximumWidth) throws StandardException {
        this.setType(new DataTypeDescriptor((TypeId)typeId, (boolean)((Boolean)isNullable), (int)((Integer)maximumWidth)));
    }

    @Override
    public String toString() {
        return "dataTypeServices: " + (this.dataTypeServices != null ? this.dataTypeServices.toString() : "null") + "\n" + super.toString();
    }

    public DataTypeDescriptor getTypeServices() {
        return this.dataTypeServices;
    }

    public void setNullability(boolean nullability) throws StandardException {
        this.setType(this.getTypeServices().getNullabilityType(nullability));
    }

    public void setCollationInfo(DataTypeDescriptor collationInfoType) throws StandardException {
        this.setCollationInfo(collationInfoType.getCollationType(), collationInfoType.getCollationDerivation());
    }

    public void setCollationInfo(int collationType, int collationDerivation) throws StandardException {
        this.setType(this.getTypeServices().getCollatedType(collationType, collationDerivation));
    }

    public TypeId getTypeId() throws StandardException {
        DataTypeDescriptor dtd = this.getTypeServices();
        if (dtd != null) {
            return dtd.getTypeId();
        }
        return null;
    }

    protected final DataValueFactory getDataValueFactory() {
        return this.getLanguageConnectionContext().getDataValueFactory();
    }

    public final TypeCompiler getTypeCompiler() throws StandardException {
        return this.getTypeCompiler(this.getTypeId());
    }

    public void setType(DataTypeDescriptor dataTypeServices) throws StandardException {
        if (dataTypeServices != null) {
            dataTypeServices = this.bindUserType(dataTypeServices);
        }
        this.dataTypeServices = dataTypeServices;
        if (dataTypeServices != null) {
            this.createTypeDependency(dataTypeServices);
        }
    }

    protected final void setCollationUsingCompilationSchema() throws StandardException {
        this.setCollationUsingCompilationSchema(1);
    }

    protected final void setCollationUsingCompilationSchema(int collationDerivation) throws StandardException {
        this.setCollationInfo(this.getSchemaDescriptor(null, false).getCollationType(), collationDerivation);
    }

    public ResultColumn getSourceResultColumn() {
        return null;
    }

    void setTransformed() {
        this.transformed = true;
    }

    boolean getTransformed() {
        return this.transformed;
    }

    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector aggregateVector) throws StandardException {
        return this.bindExpression(fromList, subqueryList, aggregateVector, false);
    }

    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector aggregateVector, boolean forQueryRewrite) throws StandardException {
        SanityManager.ASSERT((boolean)false, (String)("bindExpression() not expected to be called on a " + this.getClass().toString()));
        return this;
    }

    public ValueNode genSQLJavaSQLTree() throws StandardException {
        SanityManager.ASSERT((this.getTypeId() != null ? 1 : 0) != 0, (String)"genSQLJavaSQLTree() only expected to be called on a bound node");
        SanityManager.ASSERT((boolean)this.getTypeId().userType(), (String)"genSQLJavaSQLTree() only expected to be called on user types");
        JavaValueNode stjvn = (JavaValueNode)this.getNodeFactory().getNode(28, this, this.getContextManager());
        ValueNode jtsvn = (ValueNode)this.getNodeFactory().getNode(36, stjvn, this.getContextManager());
        DataTypeDescriptor dtd = this.getTypeServices();
        if (dtd.getTypeId().getBaseTypeId().getSQLTypeName().endsWith(DVDSet.class.getSimpleName())) {
            if (this instanceof UnaryOperatorNode) {
                jtsvn.setType(DataTypeDescriptor.getSQLDataTypeDescriptor(stjvn.getJavaTypeName(), ((UnaryOperatorNode)this).getOperand().getTypeServices(), true));
            } else {
                jtsvn.setType(DataTypeDescriptor.getSQLDataTypeDescriptor(stjvn.getJavaTypeName(), ((UserDefinedTypeIdImpl)dtd.getTypeId().getBaseTypeId()).getClassParam(), true));
            }
        } else {
            jtsvn.setType(DataTypeDescriptor.getSQLDataTypeDescriptor(stjvn.getJavaTypeName()));
        }
        return jtsvn;
    }

    public ValueNode preprocess(int numTables, FromList outerFromList, SubqueryList outerSubqueryList, PredicateList outerPredicateList) throws StandardException {
        return this;
    }

    public ValueNode eliminateNots(boolean underNotNode) throws StandardException {
        if (!underNotNode) {
            return this;
        }
        if (!this.getTypeId().isBooleanTypeId()) {
            SanityManager.ASSERT((boolean)this.getTypeId().isBooleanTypeId(), (String)("Node's type (" + this.getTypeId().getSQLTypeName() + ") is expected to be boolean"));
        }
        return this.genEqualsFalseTree();
    }

    public ValueNode genEqualsFalseTree() throws StandardException {
        NodeFactory nodeFactory = this.getNodeFactory();
        BooleanConstantNode falseNode = (BooleanConstantNode)nodeFactory.getNode(38, Boolean.FALSE, this.getContextManager());
        BinaryRelationalOperatorNode equalsNode = (BinaryRelationalOperatorNode)nodeFactory.getNode(41, this, falseNode, this.getContextManager());
        boolean nullableResult = this.getTypeServices().isNullable();
        equalsNode.setType(new DataTypeDescriptor(TypeId.BOOLEAN_ID, nullableResult));
        return equalsNode;
    }

    public ValueNode genIsNullTree() throws StandardException {
        IsNullNode isNullNode = (IsNullNode)this.getNodeFactory().getNode(25, this, this.getContextManager());
        isNullNode.setType(new DataTypeDescriptor(TypeId.BOOLEAN_ID, false));
        return isNullNode;
    }

    public boolean verifyEliminateNots() {
        return !(this instanceof NotNode);
    }

    public ValueNode putAndsOnTop() throws StandardException {
        NodeFactory nodeFactory = this.getNodeFactory();
        QueryTreeNode trueNode = nodeFactory.getNode(38, Boolean.TRUE, this.getContextManager());
        AndNode andNode = (AndNode)nodeFactory.getNode(39, this, trueNode, this.getContextManager());
        andNode.postBindFixup();
        return andNode;
    }

    public boolean verifyPutAndsOnTop() {
        return true;
    }

    public ValueNode changeToCNF(boolean underTopAndNode) throws StandardException {
        return this;
    }

    public boolean verifyChangeToCNF() {
        return true;
    }

    public boolean categorize(JBitSet referencedTabs, boolean simplePredsOnly) throws StandardException {
        return true;
    }

    public String getSchemaName() {
        return null;
    }

    public String getTableName() {
        return null;
    }

    public boolean updatableByCursor() {
        return false;
    }

    public String getColumnName() {
        return null;
    }

    JBitSet getTablesReferenced() throws StandardException {
        ReferencedTablesVisitor rtv = new ReferencedTablesVisitor(new JBitSet(0));
        this.accept(rtv);
        return rtv.getTableMap();
    }

    public boolean isCloneable() {
        return false;
    }

    public ValueNode getClone() throws StandardException {
        SanityManager.ASSERT((boolean)false, (String)("getClone() not expected to be called for " + this.getClass().getName()));
        return null;
    }

    public void copyFields(ValueNode oldVN) throws StandardException {
        this.dataTypeServices = oldVN.getTypeServices();
    }

    public ValueNode remapColumnReferencesToExpressions() throws StandardException {
        return this;
    }

    public boolean isConstantExpression() {
        return false;
    }

    public boolean constantExpression(PredicateList whereClause) {
        return false;
    }

    public void checkReliability(String fragmentType, int fragmentBitMask) throws StandardException {
        if ((this.getCompilerContext().getReliability() & fragmentBitMask) != 0) {
            this.throwReliabilityException(fragmentType);
        }
    }

    public void checkReliability(int fragmentBitMask, String fragmentType) throws StandardException {
        if ((this.getCompilerContext().getReliability() & fragmentBitMask) != 0) {
            String fragmentTypeTxt = MessageService.getTextMessage(fragmentType);
            this.throwReliabilityException(fragmentTypeTxt);
        }
    }

    private void throwReliabilityException(String fragmentType) throws StandardException {
        String sqlState = this.getCompilerContext().getReliability() == 1192 ? "42Y84" : "42Y39";
        throw StandardException.newException(sqlState, fragmentType);
    }

    protected int getOrderableVariantType() throws StandardException {
        return 0;
    }

    public ValueNode checkIsBoolean() throws StandardException {
        ValueNode whereClause = this;
        TypeId whereTypeId = whereClause.getTypeId();
        if (whereTypeId.userType()) {
            whereClause = whereClause.genSQLJavaSQLTree();
            whereTypeId = whereClause.getTypeId();
        }
        if (!whereTypeId.equals(TypeId.BOOLEAN_ID)) {
            throw StandardException.newException("42X19", whereTypeId.getSQLTypeName());
        }
        return whereClause;
    }

    public Object getConstantValueAsObject() throws StandardException {
        return null;
    }

    @Override
    protected final void generate(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        this.generateExpression(acb, mb);
    }

    public void generateFilter(ExpressionClassBuilder ecb, MethodBuilder mb) throws StandardException {
        this.generateExpression(ecb, mb);
    }

    public double selectivity(Optimizable optTable) throws StandardException {
        if (this.transformed) {
            return 1.0;
        }
        return 0.5;
    }

    void checkTopPredicatesForEqualsConditions(int tableNumber, boolean[] eqOuterCols, int[] tableNumbers, JBitSet[] tableColMap, boolean resultColTable) throws StandardException {
        ValueNode whereWalker = this;
        while (whereWalker instanceof AndNode) {
            AndNode and = (AndNode)whereWalker;
            if (and.getLeftOperand().isRelationalOperator() && ((RelationalOperator)((Object)and.getLeftOperand())).getOperator() == 1) {
                int resultTable;
                BinaryRelationalOperatorNode beon = (BinaryRelationalOperatorNode)and.getLeftOperand();
                ValueNode left = beon.getLeftOperand();
                ValueNode right = beon.getRightOperand();
                if (resultColTable) {
                    for (resultTable = 0; resultTable < tableNumbers.length && tableNumbers[resultTable] != tableNumber; ++resultTable) {
                    }
                } else {
                    resultTable = -1;
                }
                if (left instanceof ColumnReference && ((ColumnReference)left).getTableNumber() == tableNumber) {
                    this.updateMaps(tableColMap, eqOuterCols, tableNumbers, tableNumber, resultTable, right, left);
                } else if (right instanceof ColumnReference && ((ColumnReference)right).getTableNumber() == tableNumber) {
                    this.updateMaps(tableColMap, eqOuterCols, tableNumbers, tableNumber, resultTable, left, right);
                }
            }
            whereWalker = ((AndNode)whereWalker).getRightOperand();
        }
    }

    boolean isBooleanTrue() {
        return false;
    }

    boolean isBooleanFalse() {
        return false;
    }

    public void generateExpression(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        SanityManager.ASSERT((boolean)false, (String)"Code generation for this type of ValueNode is unimplemented");
    }

    private void updateMaps(JBitSet[] tableColMap, boolean[] eqOuterCols, int[] tableNumbers, int tableNumber, int resultTable, ValueNode arg1, ValueNode arg2) throws StandardException {
        if (arg1 instanceof ConstantNode) {
            this.setValueCols(tableColMap, eqOuterCols, ((ColumnReference)arg2).getColumnNumber(), resultTable);
        } else if (arg1 instanceof ColumnReference && ((ColumnReference)arg1).getTableNumber() != tableNumber) {
            int index;
            int otherTN = ((ColumnReference)arg1).getTableNumber();
            int colNumber = ((ColumnReference)arg2).getColumnNumber();
            for (index = 0; index < tableNumbers.length && otherTN != tableNumbers[index]; ++index) {
            }
            if (index == tableNumbers.length) {
                this.setValueCols(tableColMap, eqOuterCols, colNumber, resultTable);
            } else if (tableColMap != null) {
                tableColMap[index].set(colNumber);
            }
        } else {
            int index;
            JBitSet referencedTables = arg1.getTablesReferenced();
            int colNumber = ((ColumnReference)arg2).getColumnNumber();
            for (index = 0; index < tableNumbers.length && !referencedTables.get(tableNumbers[index]); ++index) {
            }
            if (index == tableNumbers.length) {
                this.setValueCols(tableColMap, eqOuterCols, colNumber, resultTable);
            } else if (tableColMap != null && !referencedTables.get(tableNumber)) {
                tableColMap[index].set(colNumber);
            }
        }
    }

    private void setValueCols(JBitSet[] tableColMap, boolean[] eqOuterCols, int colReference, int resultTable) {
        if (eqOuterCols != null) {
            eqOuterCols[colReference] = true;
        }
        if (tableColMap != null) {
            if (resultTable == -1) {
                for (int i = 0; i < tableColMap.length; ++i) {
                    tableColMap[i].set(colReference);
                }
            } else {
                tableColMap[resultTable].set(colReference);
            }
        }
    }

    public boolean isRelationalOperator() {
        return false;
    }

    public boolean isBinaryEqualsOperatorNode() {
        return false;
    }

    public boolean isInListProbeNode() {
        return false;
    }

    public boolean optimizableEqualityNode(Optimizable optTable, int columnNumber, boolean isNullOkay) throws StandardException {
        return false;
    }

    public boolean requiresTypeFromContext() {
        return false;
    }

    public boolean isParameterNode() {
        return false;
    }

    protected abstract boolean isEquivalent(ValueNode var1) throws StandardException;

    protected final boolean isSameNodeType(ValueNode other) {
        if (other != null) {
            return other.getNodeType() == this.getNodeType();
        }
        return false;
    }

    public ValueNode genExpressionOperands(ResultColumnList outerResultColumns, ResultColumn parentRC, boolean remapToNew) throws StandardException {
        if (!(ConstantNode.class.isInstance(this) || VirtualColumnNode.class.isInstance(this) || TernaryOperatorNode.class.isInstance(this) || ParameterNode.class.isInstance(this) || SubqueryNode.class.isInstance(this))) {
            SanityManager.THROWASSERT((String)("ValueNode::genExpressionOperands() - UnExpected Call in " + this.getClass() + ".. no action will be taken for it."));
        }
        if (parentRC != null) {
            outerResultColumns.addResultColumn(parentRC);
        }
        return this;
    }

    public boolean isParameterizedConstantNode() {
        return false;
    }

    public boolean hasExpression() {
        return true;
    }

    public boolean isTableColumn() {
        return !this.hasExpression();
    }

    public String printExplainInfo() {
        return "";
    }

    public String ncjGenerateSql() {
        SanityManager.THROWASSERT((String)("Not added support yet for " + this.getClass().getSimpleName()));
        return null;
    }

    public int setColocatedWith(Optimizable src, Optimizable tgt, JBitSet srcPCols, JBitSet tgtPCols) throws StandardException {
        SanityManager.THROWASSERT((String)("colocation not handled for " + this.getClass().getSimpleName()));
        return 0;
    }

    public String findSourceSchemaName() {
        return this.getSchemaName();
    }

    public String findSourceTableName() {
        return this.getTableName();
    }

    public String findSourceColumnName() {
        return this.getColumnName();
    }
}

