/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.catalog.types.UserDefinedTypeIdImpl;
import com.pivotal.gemfirexd.internal.engine.sql.compile.types.DVDSet;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.LocalField;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.MethodBuilder;
import com.pivotal.gemfirexd.internal.iapi.services.loader.ClassFactory;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.TypeId;
import com.pivotal.gemfirexd.internal.impl.sql.compile.BaseTypeCompiler;
import com.pivotal.gemfirexd.internal.impl.sql.compile.NumericTypeCompiler;

public class UserDefinedTypeCompiler
extends BaseTypeCompiler {
    @Override
    public boolean convertible(TypeId otherType, boolean forDataTypeFunction) {
        if (this.getTypeId().getBaseTypeId().isAnsiUDT()) {
            if (!otherType.getBaseTypeId().isAnsiUDT()) {
                return false;
            }
            UserDefinedTypeIdImpl thisTypeID = (UserDefinedTypeIdImpl)this.getTypeId().getBaseTypeId();
            UserDefinedTypeIdImpl thatTypeID = (UserDefinedTypeIdImpl)otherType.getBaseTypeId();
            return thisTypeID.getSQLTypeName().equals(thatTypeID.getSQLTypeName());
        }
        return true;
    }

    @Override
    public boolean compatible(TypeId otherType) {
        return this.convertible(otherType, false);
    }

    @Override
    public boolean storable(TypeId otherType, ClassFactory cf) {
        if (!otherType.isUserDefinedTypeId()) {
            return false;
        }
        UserDefinedTypeIdImpl thisTypeID = (UserDefinedTypeIdImpl)this.getTypeId().getBaseTypeId();
        UserDefinedTypeIdImpl thatTypeID = (UserDefinedTypeIdImpl)otherType.getBaseTypeId();
        if (thisTypeID.isAnsiUDT() != thatTypeID.isAnsiUDT()) {
            return false;
        }
        if (thisTypeID.isAnsiUDT()) {
            return thisTypeID.getSQLTypeName().equals(thatTypeID.getSQLTypeName());
        }
        return cf.getClassInspector().assignableTo(otherType.getCorrespondingJavaTypeName(), this.getTypeId().getCorrespondingJavaTypeName());
    }

    @Override
    public String interfaceName() {
        return "com.pivotal.gemfirexd.internal.iapi.types.UserDataValue";
    }

    @Override
    public String getCorrespondingPrimitiveTypeName() {
        return this.getTypeId().getCorrespondingJavaTypeName();
    }

    @Override
    public int getCastToCharWidth(DataTypeDescriptor dts) {
        return -1;
    }

    @Override
    String nullMethodName() {
        if (DVDSet.class.getName().equals(this.getCorrespondingPrimitiveTypeName())) {
            return "getNull" + DVDSet.class.getSimpleName();
        }
        return "getNullObject";
    }

    @Override
    public void generateDataValue(MethodBuilder mb, int collationType, LocalField field) {
        mb.upCast("java.lang.Object");
        super.generateDataValue(mb, collationType, field);
    }

    @Override
    public DataTypeDescriptor resolveArithmeticOperation(DataTypeDescriptor leftType, DataTypeDescriptor rightType, String operator) throws StandardException {
        String leftJavaTypeName = leftType.getTypeId().getCorrespondingJavaTypeName();
        String rightJavaTypeName = rightType.getTypeId().getCorrespondingJavaTypeName();
        if (DVDSet.class.getName().equals(leftJavaTypeName) && DVDSet.class.getName().equals(rightJavaTypeName)) {
            TypeId cti = null;
            cti = leftType.getTypeId().typePrecedence() > rightType.getTypeId().typePrecedence() ? TypeId.getUserDefinedTypeId(DVDSet.class.getName(), ((UserDefinedTypeIdImpl)leftType.getTypeId().getBaseTypeId()).getClassParam(), false) : TypeId.getUserDefinedTypeId(DVDSet.class.getName(), ((UserDefinedTypeIdImpl)rightType.getTypeId().getBaseTypeId()).getClassParam(), false);
            return new DataTypeDescriptor(cti, false);
        }
        NumericTypeCompiler numeric = new NumericTypeCompiler();
        return numeric.resolveArithmeticOperation(rightType, leftType, operator);
    }
}

