/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.MethodBuilder;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.TypeId;
import com.pivotal.gemfirexd.internal.impl.sql.compile.CastNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ExpressionClassBuilder;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SubqueryList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.UnaryOperatorNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNode;
import java.util.Vector;

public class UnaryArithmeticOperatorNode
extends UnaryOperatorNode {
    private static final int UNARY_PLUS = 0;
    private static final int UNARY_MINUS = 1;
    private static final int SQRT = 2;
    private static final int ABSOLUTE = 3;
    private static final String[] UNARY_OPERATORS = new String[]{"+", "-", "SQRT", "ABS/ABSVAL"};
    private static final String[] UNARY_METHODS = new String[]{"plus", "minus", "sqrt", "absolute"};
    private int operatorType;

    @Override
    public void init(Object operand) {
        switch (this.getNodeType()) {
            case 30: {
                this.operatorType = 0;
                break;
            }
            case 29: {
                this.operatorType = 1;
                break;
            }
            case 189: {
                this.operatorType = 2;
                break;
            }
            case 188: {
                this.operatorType = 3;
                break;
            }
            default: {
                SanityManager.THROWASSERT((String)("init for UnaryArithmeticOperator called with wrong nodeType = " + this.getNodeType()));
            }
        }
        this.init(operand, UNARY_OPERATORS[this.operatorType], UNARY_METHODS[this.operatorType]);
    }

    @Override
    public boolean requiresTypeFromContext() {
        if (this.operatorType == 0 || this.operatorType == 1) {
            return this.operand.requiresTypeFromContext();
        }
        return false;
    }

    @Override
    public boolean isParameterNode() {
        if (this.operatorType == 0 || this.operatorType == 1) {
            return this.operand.isParameterNode();
        }
        return false;
    }

    @Override
    void bindParameter() throws StandardException {
        if (this.operatorType == 2 || this.operatorType == 3) {
            this.operand.setType(new DataTypeDescriptor(TypeId.getBuiltInTypeId(8), true));
            return;
        }
        if (this.operatorType == 1 || this.operatorType == 0) {
            return;
        }
        super.bindParameter();
    }

    @Override
    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector aggregateVector) throws StandardException {
        if (this.operand.requiresTypeFromContext() && (this.operatorType == 0 || this.operatorType == 1) && this.operand.getTypeServices() == null) {
            return this;
        }
        this.bindOperand(fromList, subqueryList, aggregateVector);
        if (this.operatorType == 2 || this.operatorType == 3) {
            this.bindSQRTABS();
        } else if (this.operatorType == 0 || this.operatorType == 1) {
            this.checkOperandIsNumeric(this.operand.getTypeId());
        }
        super.setType(this.operand.getTypeServices());
        return this;
    }

    private void checkOperandIsNumeric(TypeId operandType) throws StandardException {
        if (!operandType.isNumericTypeId()) {
            throw StandardException.newException("42X37", (Object)(this.operatorType == 0 ? "+" : "-"), (Object)operandType.getSQLTypeName());
        }
    }

    @Override
    public void generateExpression(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        if (this.operatorType == 0) {
            this.operand.generateExpression(acb, mb);
        } else {
            super.generateExpression(acb, mb);
        }
    }

    private void bindSQRTABS() throws StandardException {
        TypeId operandType = this.operand.getTypeId();
        if (operandType.userType()) {
            this.operand = this.operand.genSQLJavaSQLTree();
        }
        int jdbcType = operandType.getJDBCTypeId();
        if (!operandType.isNumericTypeId()) {
            throw StandardException.newException("42X25", (Object)this.getOperatorString(), (Object)operandType.getSQLTypeName());
        }
        if (this.operatorType == 2 && jdbcType != 8) {
            this.operand = (ValueNode)this.getNodeFactory().getNode(60, this.operand, new DataTypeDescriptor(TypeId.getBuiltInTypeId(8), true), this.getContextManager());
            ((CastNode)this.operand).bindCastNodeOnly();
        }
    }

    @Override
    public void setType(DataTypeDescriptor descriptor) throws StandardException {
        if (this.operand.requiresTypeFromContext() && this.operand.getTypeServices() == null) {
            this.checkOperandIsNumeric(descriptor.getTypeId());
            this.operand.setType(descriptor);
        }
        super.setType(descriptor);
    }
}

