/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.MethodBuilder;
import com.pivotal.gemfirexd.internal.iapi.services.loader.ClassInspector;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.util.JBitSet;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ExpressionClassBuilder;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.JavaValueNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.PredicateList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SubqueryList;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.util.Vector;

public final class StaticClassFieldReferenceNode
extends JavaValueNode {
    private String fieldName;
    private String javaClassName;
    private boolean classNameDelimitedIdentifier;
    private Member field;

    @Override
    public void init(Object javaClassName, Object fieldName, Object classNameDelimitedIdentifier) {
        this.fieldName = (String)fieldName;
        this.javaClassName = (String)javaClassName;
        this.classNameDelimitedIdentifier = (Boolean)classNameDelimitedIdentifier;
    }

    @Override
    public JavaValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector aggregateVector) throws StandardException {
        ClassInspector classInspector = this.getClassFactory().getClassInspector();
        if ((this.getCompilerContext().getReliability() & 0x400) != 0 || !this.javaClassName.startsWith("java.sql.")) {
            throw StandardException.newException("42X01", this.javaClassName + "::" + this.fieldName);
        }
        this.verifyClassExist(this.javaClassName);
        this.field = classInspector.findPublicField(this.javaClassName, this.fieldName, true);
        this.setJavaTypeName(classInspector.getType(this.field));
        return this;
    }

    @Override
    public void preprocess(int numTables, FromList outerFromList, SubqueryList outerSubqueryList, PredicateList outerPredicateList) throws StandardException {
    }

    @Override
    public boolean categorize(JBitSet referencedTabs, boolean simplePredsOnly) {
        return true;
    }

    @Override
    public JavaValueNode remapColumnReferencesToExpressions() throws StandardException {
        return this;
    }

    @Override
    protected int getOrderableVariantType() {
        SanityManager.ASSERT((this.field != null ? 1 : 0) != 0, (String)"field is expected to be non-null");
        if (Modifier.isFinal(this.field.getModifiers())) {
            return 3;
        }
        return 0;
    }

    @Override
    public void generateExpression(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        mb.getStaticField(this.field.getDeclaringClass().getName(), this.fieldName, this.getJavaTypeName());
    }

    public String getJavaClassName() {
        return this.javaClassName;
    }

    public String getFieldName() {
        return this.fieldName;
    }
}

