/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.MethodBuilder;
import com.pivotal.gemfirexd.internal.iapi.services.loader.GeneratedClass;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultDescription;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.store.access.ConglomerateController;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.iapi.util.ByteArray;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ActivationClassBuilder;
import com.pivotal.gemfirexd.internal.impl.sql.compile.CursorNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.QueryTreeNode;

public abstract class StatementNode
extends QueryTreeNode {
    static final int NEED_DDL_ACTIVATION = 5;
    static final int NEED_CURSOR_ACTIVATION = 4;
    static final int NEED_PARAM_ACTIVATION = 2;
    static final int NEED_ROW_ACTIVATION = 1;
    static final int NEED_NOTHING_ACTIVATION = 0;
    public final byte LOCAL_SCOPE = 0;
    public final byte GLOBAL_SCOPE = 1;
    private byte dataScope = 1;
    public final byte COORDINATOR_ROLE = 0;
    public final byte COHORT_ROLE = 1;
    private byte role = 0;

    @Override
    public boolean isAtomic() throws StandardException {
        return true;
    }

    public boolean needsSavepoint() {
        return true;
    }

    public String getSPSName() {
        return null;
    }

    public String executeStatementName() {
        return null;
    }

    public String executeSchemaName() {
        return null;
    }

    public ResultDescription makeResultDescription() {
        return null;
    }

    @Override
    public String toString() {
        return "statementType: " + this.statementToString() + "\n" + super.toString();
    }

    public abstract String statementToString();

    public void bindStatement() throws StandardException {
    }

    public void optimizeStatement() throws StandardException {
    }

    abstract int activationKind();

    protected TableDescriptor lockTableForCompilation(TableDescriptor td, boolean exclusive) throws StandardException {
        DataDictionary dd = this.getDataDictionary();
        if (dd.getCacheMode() == 1) {
            TransactionController tc = this.getLanguageConnectionContext().getTransactionCompile();
            ConglomerateController heapCC = tc.openConglomerate(td.getHeapConglomerateId(), false, exclusive ? 68 : 64, 6, 5);
            heapCC.close();
            String tableName = td.getQualifiedName();
            td = this.getTableDescriptor(td.getName(), this.getSchemaDescriptor(td.getSchemaName()));
            if (td == null) {
                throw StandardException.newException("42X05", tableName);
            }
        }
        return td;
    }

    public GeneratedClass generate(ByteArray byteCode) throws StandardException {
        String superClass;
        int nodeChoice = this.activationKind();
        switch (nodeChoice) {
            case 4: {
                superClass = "com.pivotal.gemfirexd.internal.impl.sql.execute.CursorActivation";
                break;
            }
            case 5: {
                return this.getClassFactory().loadGeneratedClass("com.pivotal.gemfirexd.internal.impl.sql.execute.ConstantActionActivation", null);
            }
            case 0: 
            case 1: 
            case 2: {
                superClass = "com.pivotal.gemfirexd.internal.impl.sql.execute.BaseActivation";
                break;
            }
            default: {
                throw StandardException.newException("42Z53", String.valueOf(nodeChoice));
            }
        }
        ActivationClassBuilder generatingClass = new ActivationClassBuilder(superClass, this.getCompilerContext());
        MethodBuilder executeMethod = generatingClass.getExecuteMethod();
        MethodBuilder mbWorker = generatingClass.getClassBuilder().newMethodBuilder(2, "com.pivotal.gemfirexd.internal.iapi.sql.ResultSet", "fillResultSet");
        mbWorker.addThrownException("com.pivotal.gemfirexd.internal.iapi.error.StandardException");
        this.generate(generatingClass, mbWorker);
        mbWorker.methodReturn();
        mbWorker.complete();
        executeMethod.pushThis();
        executeMethod.getField("com.pivotal.gemfirexd.internal.impl.sql.execute.BaseActivation", "resultSet", "com.pivotal.gemfirexd.internal.iapi.sql.ResultSet");
        executeMethod.conditionalIfNull();
        executeMethod.pushThis();
        executeMethod.callMethod((short)182, null, "fillResultSet", "com.pivotal.gemfirexd.internal.iapi.sql.ResultSet", 0);
        executeMethod.pushThis();
        executeMethod.swap();
        executeMethod.putField("com.pivotal.gemfirexd.internal.impl.sql.execute.BaseActivation", "resultSet", "com.pivotal.gemfirexd.internal.iapi.sql.ResultSet");
        executeMethod.startElseCode();
        executeMethod.pushThis();
        executeMethod.getField("com.pivotal.gemfirexd.internal.impl.sql.execute.BaseActivation", "resultSet", "com.pivotal.gemfirexd.internal.iapi.sql.ResultSet");
        executeMethod.completeConditional();
        generatingClass.finishExecuteMethod(this instanceof CursorNode);
        generatingClass.finishConstructor();
        try {
            GeneratedClass activationClass = generatingClass.getGeneratedClass(byteCode);
            return activationClass;
        }
        catch (StandardException e) {
            String msgId = e.getMessageId();
            if ("XBCM4.S".equals(msgId) || "XBCM1.S".equals(msgId)) {
                throw StandardException.newException("42ZA0", e);
            }
            throw e;
        }
    }

    public void setDataScope(byte scope) {
        assert (scope == 0 || scope == 1);
        this.dataScope = scope;
    }

    public boolean onLocalData() {
        return this.dataScope == 0;
    }

    public boolean onGlobalData() {
        return this.dataScope == 1;
    }

    public void setStatementRole(byte role) {
        assert (role == 0 || role == 1);
        this.role = role;
    }

    public boolean isCoordinator() {
        return this.role == 0;
    }

    public boolean isCohort() {
        return this.role == 1;
    }

    public StringBuilder makeShortDescription(StringBuilder buffer) {
        return buffer;
    }
}

