/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.MethodBuilder;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ConstantAction;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ActivationClassBuilder;
import com.pivotal.gemfirexd.internal.impl.sql.compile.MiscellaneousStatementNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ParameterNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNode;
import java.util.Vector;

public class SetRoleNode
extends MiscellaneousStatementNode {
    private String name;
    private int type;

    @Override
    public void init(Object roleName, Object type) {
        this.name = (String)roleName;
        if (type != null) {
            this.type = (Integer)type;
        }
    }

    @Override
    public String toString() {
        return super.toString() + (this.type == 1 ? "roleName: ?\n" : "rolename: " + this.name + "\n");
    }

    @Override
    public String statementToString() {
        return "SET ROLE";
    }

    @Override
    public ConstantAction makeConstantAction() throws StandardException {
        return this.getGenericConstantActionFactory().getSetRoleConstantAction(this.name, this.type);
    }

    @Override
    public void generate(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        if (this.type == 1) {
            this.generateParameterValueSet(acb);
        }
        acb.pushGetResultSetFactoryExpression(mb);
        acb.pushThisAsActivation(mb);
        mb.callMethod((short)185, null, "getMiscResultSet", "com.pivotal.gemfirexd.internal.iapi.sql.ResultSet", 1);
    }

    private void generateParameterValueSet(ActivationClassBuilder acb) throws StandardException {
        Vector<ValueNode> parameterList = this.getCompilerContext().getParameterList();
        SanityManager.ASSERT((parameterList != null && parameterList.size() == 1 ? 1 : 0) != 0);
        ParameterNode.generateParameterValueSet(acb, 1, parameterList);
    }

    @Override
    int activationKind() {
        Vector<ValueNode> parameterList = this.getCompilerContext().getParameterList();
        if (this.type == 1) {
            return 2;
        }
        return 0;
    }

    @Override
    public boolean isAtomic() {
        return false;
    }
}

