/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.engine.sql.compile.ParameterizedConstantNode;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.LocalField;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.MethodBuilder;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Visitable;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Visitor;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.JSQLType;
import com.pivotal.gemfirexd.internal.iapi.util.JBitSet;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ExpressionClassBuilder;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.JavaValueNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ParameterNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.PredicateList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumn;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumnList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SubqueryList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.UnaryOperatorNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNode;
import java.util.Vector;

public class SQLToJavaValueNode
extends JavaValueNode {
    ValueNode value;
    LocalField returnsNullOnNullState;

    @Override
    public void init(Object value) {
        this.value = (ValueNode)value;
    }

    @Override
    public void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this.value != null) {
            this.printLabel(depth, "value: ");
            this.value.treePrint(depth + 1);
        }
    }

    @Override
    public String getJavaTypeName() throws StandardException {
        JSQLType myType = this.getJSQLType();
        if (myType == null) {
            return "";
        }
        return this.mapToTypeID(myType).getCorrespondingJavaTypeName();
    }

    @Override
    public String getPrimitiveTypeName() throws StandardException {
        JSQLType myType = this.getJSQLType();
        if (myType == null) {
            return "";
        }
        return this.getTypeCompiler(this.mapToTypeID(myType)).getCorrespondingPrimitiveTypeName();
    }

    @Override
    public JSQLType getJSQLType() throws StandardException {
        if (this.jsqlType == null) {
            if (this.value.requiresTypeFromContext()) {
                ValueNode pn = this.value instanceof UnaryOperatorNode ? ((UnaryOperatorNode)this.value).getParameterOperand() : this.value;
                this.jsqlType = pn.isParameterizedConstantNode() ? ((ParameterizedConstantNode)pn).getJSQLType() : ((ParameterNode)pn).getJSQLType();
            } else {
                DataTypeDescriptor dtd = this.value.getTypeServices();
                if (dtd != null) {
                    this.jsqlType = new JSQLType(dtd);
                }
            }
        }
        return this.jsqlType;
    }

    @Override
    public JavaValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector aggregateVector) throws StandardException {
        this.value = this.value.bindExpression(fromList, subqueryList, aggregateVector);
        return this;
    }

    @Override
    public DataTypeDescriptor getDataType() throws StandardException {
        return this.value.getTypeServices();
    }

    @Override
    public JavaValueNode remapColumnReferencesToExpressions() throws StandardException {
        this.value = this.value.remapColumnReferencesToExpressions();
        return this;
    }

    @Override
    public boolean categorize(JBitSet referencedTabs, boolean simplePredsOnly) throws StandardException {
        return this.value.categorize(referencedTabs, simplePredsOnly);
    }

    @Override
    public void preprocess(int numTables, FromList outerFromList, SubqueryList outerSubqueryList, PredicateList outerPredicateList) throws StandardException {
        this.value.preprocess(numTables, outerFromList, outerSubqueryList, outerPredicateList);
    }

    @Override
    protected int getOrderableVariantType() throws StandardException {
        return this.value.getOrderableVariantType();
    }

    @Override
    public void generateExpression(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        this.generateSQLValue(acb, mb);
        this.generateJavaValue(acb, mb);
    }

    private void generateSQLValue(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        this.value.generateExpression(acb, mb);
    }

    private void generateJavaValue(ExpressionClassBuilder acb, MethodBuilder mbex) throws StandardException {
        if (this.isPrimitiveType() || this.mustCastToPrimitive()) {
            String primitiveTN = this.value.getTypeCompiler().getCorrespondingPrimitiveTypeName();
            String[] pd = new String[]{this.getSQLValueInterfaceName()};
            MethodBuilder mb = acb.newGeneratedFun(primitiveTN, 2, pd);
            mb.getParameter(0);
            if (this.returnsNullOnNullState != null) {
                this.generateReturnsNullOnNullCheck(mb);
            } else {
                mb.dup();
                mb.upCast("com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor");
                mb.push(primitiveTN);
                mb.callMethod((short)184, "com.pivotal.gemfirexd.internal.impl.sql.execute.BaseActivation", "nullToPrimitiveTest", "void", 2);
            }
            mb.callMethod((short)185, "com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor", this.value.getTypeCompiler().getPrimitiveMethodName(), primitiveTN, 0);
            mb.methodReturn();
            mb.complete();
            mbex.pushThis();
            mbex.swap();
            mbex.callMethod((short)182, null, mb.getName(), primitiveTN, 1);
        } else {
            if (this.returnsNullOnNullState != null) {
                this.generateReturnsNullOnNullCheck(mbex);
            }
            mbex.callMethod((short)185, "com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor", "getObject", "java.lang.Object", 0);
            mbex.cast(this.value.getTypeId().getCorrespondingJavaTypeName());
        }
    }

    private void generateReturnsNullOnNullCheck(MethodBuilder mb) {
        mb.dup();
        mb.callMethod((short)185, "com.pivotal.gemfirexd.internal.iapi.services.io.Storable", "isNull", "boolean", 0);
        mb.conditionalIf();
        mb.push(true);
        mb.startElseCode();
        mb.getField(this.returnsNullOnNullState);
        mb.completeConditional();
        mb.setField(this.returnsNullOnNullState);
    }

    private String getSQLValueInterfaceName() throws StandardException {
        return this.value.getTypeCompiler().interfaceName();
    }

    public ValueNode getSQLValueNode() {
        return this.value;
    }

    @Override
    Object getConstantValueAsObject() throws StandardException {
        return this.value.getConstantValueAsObject();
    }

    @Override
    public Visitable accept(Visitor v) throws StandardException {
        Visitable returnNode = v.visit(this);
        if (v.skipChildren(this)) {
            return returnNode;
        }
        if (this.value != null && !v.stopTraversal()) {
            this.value = (ValueNode)this.value.accept(v);
        }
        return returnNode;
    }

    public JavaValueNode genExpressionOperands(ResultColumnList outerResultColumns, ResultColumn parentRC, boolean remapToNew) throws StandardException {
        if (parentRC != null) {
            outerResultColumns.addResultColumn(parentRC);
            return this;
        }
        this.value = this.value.genExpressionOperands(outerResultColumns, null, remapToNew);
        return this;
    }
}

