/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Visitable;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.VisitorAdaptor;
import com.pivotal.gemfirexd.internal.iapi.util.JBitSet;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ColumnReference;
import com.pivotal.gemfirexd.internal.impl.sql.compile.Predicate;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultSetNode;

public class ReferencedTablesVisitor
extends VisitorAdaptor {
    private JBitSet tableMap;

    public ReferencedTablesVisitor(JBitSet tableMap) {
        this.tableMap = tableMap;
    }

    @Override
    public Visitable visit(Visitable node) throws StandardException {
        if (node instanceof ColumnReference) {
            ((ColumnReference)node).getTablesReferenced(this.tableMap);
        } else if (node instanceof Predicate) {
            Predicate pred = (Predicate)node;
            this.tableMap.or(pred.getReferencedSet());
        } else if (node instanceof ResultSetNode) {
            ResultSetNode rs = (ResultSetNode)node;
            this.tableMap.or(rs.getReferencedTableMap());
        }
        return node;
    }

    @Override
    public boolean skipChildren(Visitable node) {
        return node instanceof Predicate || node instanceof ResultSetNode;
    }

    @Override
    public boolean stopTraversal() {
        return false;
    }

    JBitSet getTableMap() {
        return this.tableMap;
    }
}

