/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.catalog.types.ReferencedColumnsDescriptorImpl;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.NcjHashMapWrapper;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfoContext;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.SelectQueryInfo;
import com.pivotal.gemfirexd.internal.engine.sql.compile.RemapSubqueryVisitor;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.MethodBuilder;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.AccessPath;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.CompilerContext;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.CostEstimate;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Optimizable;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.OptimizablePredicate;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.OptimizablePredicateList;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Optimizer;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.RowOrdering;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Visitable;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Visitor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.util.JBitSet;
import com.pivotal.gemfirexd.internal.impl.sql.compile.AccessPathImpl;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ActivationClassBuilder;
import com.pivotal.gemfirexd.internal.impl.sql.compile.BaseColumnNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.DistinctNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ExpressionClassBuilder;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromBaseTable;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromTable;
import com.pivotal.gemfirexd.internal.impl.sql.compile.GroupByList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.JoinNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.MaterializeResultSetNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.OrderByNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.Predicate;
import com.pivotal.gemfirexd.internal.impl.sql.compile.PredicateList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.QueryTreeNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ReferencedTablesVisitor;
import com.pivotal.gemfirexd.internal.impl.sql.compile.RemapCRsVisitor;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumn;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumnList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultSetNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.RowResultSetNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SelectNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SetOperatorNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SingleChildResultSetNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SubqueryList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SubqueryNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.UnionNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;

public class ProjectRestrictNode
extends SingleChildResultSetNode {
    public ValueNode restriction;
    ValueNode constantRestriction = null;
    public PredicateList restrictionList;
    SubqueryList projectSubquerys;
    public SubqueryList restrictSubquerys;
    private ArrayList<String> remoteInListCols = null;
    private boolean accessPathModified;
    private boolean accessPathConsidered;
    private boolean childResultOptimized;
    private boolean materialize;
    private boolean getTableNumberHere;

    @Override
    public void init(Object childResult, Object projection, Object restriction, Object restrictionList, Object projectSubquerys, Object restrictSubquerys, Object tableProperties) {
        super.init(childResult, tableProperties);
        this.resultColumns = (ResultColumnList)projection;
        this.restriction = (ValueNode)restriction;
        this.restrictionList = (PredicateList)restrictionList;
        this.projectSubquerys = (SubqueryList)projectSubquerys;
        this.restrictSubquerys = (SubqueryList)restrictSubquerys;
        if (tableProperties != null && childResult instanceof Optimizable) {
            ((Optimizable)childResult).setProperties(this.getProperties());
            this.setProperties(null);
        }
    }

    @Override
    public boolean nextAccessPath(Optimizer optimizer, OptimizablePredicateList predList, RowOrdering rowOrdering) throws StandardException {
        if (this.childResult instanceof Optimizable) {
            return ((Optimizable)((Object)this.childResult)).nextAccessPath(optimizer, this.restrictionList, rowOrdering);
        }
        return super.nextAccessPath(optimizer, predList, rowOrdering);
    }

    @Override
    public void rememberAsBest(int planType, Optimizer optimizer) throws StandardException {
        super.rememberAsBest(planType, optimizer);
        if (this.childResult instanceof Optimizable) {
            ((Optimizable)((Object)this.childResult)).rememberAsBest(planType, optimizer);
        }
    }

    void printRememberingBestAccessPath(int planType, AccessPath bestPath) {
    }

    @Override
    public void startOptimizing(Optimizer optimizer, RowOrdering rowOrdering) {
        if (this.childResult instanceof Optimizable) {
            ((Optimizable)((Object)this.childResult)).startOptimizing(optimizer, rowOrdering);
        } else {
            this.accessPathConsidered = false;
            super.startOptimizing(optimizer, rowOrdering);
        }
    }

    @Override
    public int getTableNumber() {
        if (this.getTableNumberHere) {
            return super.getTableNumber();
        }
        if (this.childResult instanceof Optimizable) {
            return ((Optimizable)((Object)this.childResult)).getTableNumber();
        }
        return super.getTableNumber();
    }

    @Override
    public CostEstimate optimizeIt(Optimizer optimizer, OptimizablePredicateList predList, CostEstimate outerCost, RowOrdering rowOrdering) throws StandardException {
        this.costEstimate = this.getCostEstimate(optimizer);
        this.updateBestPlanMap((short)1, this);
        if (this.childResult instanceof Optimizable) {
            CostEstimate childCost = ((Optimizable)((Object)this.childResult)).optimizeIt(optimizer, this.restrictionList, outerCost, rowOrdering);
            this.costEstimate.setCost(childCost.getEstimatedCost(), childCost.rowCount(), childCost.singleScanRowCount());
        } else if (!this.accessPathModified) {
            if (!(this.childResult instanceof SelectNode) && !(this.childResult instanceof RowResultSetNode)) {
                SanityManager.THROWASSERT((String)("childResult is expected to be instanceof SelectNode or RowResultSetNode - it is a " + this.childResult.getClass().getName()));
            }
            this.childResult = this.childResult.optimize(optimizer.getDataDictionary(), this.restrictionList, outerCost.rowCount());
            CostEstimate childCost = this.childResult.costEstimate;
            this.costEstimate.setCost(childCost.getEstimatedCost(), childCost.rowCount(), childCost.singleScanRowCount());
            optimizer.considerCost(this, this.restrictionList, this.getCostEstimate(), outerCost);
        }
        return this.costEstimate;
    }

    @Override
    public boolean feasibleJoinStrategy(OptimizablePredicateList predList, Optimizer optimizer) throws StandardException {
        if (this.childResult instanceof Optimizable) {
            if (this.childResult instanceof UnionNode) {
                ((UnionNode)this.childResult).pullOptPredicates(this.restrictionList, null);
            }
            return ((Optimizable)((Object)this.childResult)).feasibleJoinStrategy(this.restrictionList, optimizer);
        }
        return super.feasibleJoinStrategy(this.restrictionList, optimizer);
    }

    @Override
    public AccessPath getCurrentAccessPath() {
        if (this.childResult instanceof Optimizable) {
            return ((Optimizable)((Object)this.childResult)).getCurrentAccessPath();
        }
        return super.getCurrentAccessPath();
    }

    @Override
    public AccessPath getBestAccessPath() {
        if (this.childResult instanceof Optimizable) {
            return ((Optimizable)((Object)this.childResult)).getBestAccessPath();
        }
        return super.getBestAccessPath();
    }

    @Override
    public AccessPath getBestSortAvoidancePath() {
        if (this.childResult instanceof Optimizable) {
            return ((Optimizable)((Object)this.childResult)).getBestSortAvoidancePath();
        }
        return super.getBestSortAvoidancePath();
    }

    @Override
    public AccessPath getTrulyTheBestAccessPath() {
        if (this.hasTrulyTheBestAccessPath) {
            return super.getTrulyTheBestAccessPath();
        }
        if (this.childResult instanceof Optimizable) {
            return ((Optimizable)((Object)this.childResult)).getTrulyTheBestAccessPath();
        }
        return super.getTrulyTheBestAccessPath();
    }

    @Override
    public void rememberSortAvoidancePath() {
        if (this.childResult instanceof Optimizable) {
            ((Optimizable)((Object)this.childResult)).rememberSortAvoidancePath();
        } else {
            super.rememberSortAvoidancePath();
        }
    }

    @Override
    public boolean considerSortAvoidancePath() {
        if (this.childResult instanceof Optimizable) {
            return ((Optimizable)((Object)this.childResult)).considerSortAvoidancePath();
        }
        return super.considerSortAvoidancePath();
    }

    @Override
    public boolean pushOptPredicate(OptimizablePredicate optimizablePredicate) throws StandardException {
        SanityManager.ASSERT((boolean)(optimizablePredicate instanceof Predicate), (String)"optimizablePredicate expected to be instanceof Predicate");
        if (this.restrictionList == null) {
            this.restrictionList = (PredicateList)this.getNodeFactory().getNode(8, this.getContextManager());
        }
        this.restrictionList.addPredicate((Predicate)optimizablePredicate);
        Predicate pred = (Predicate)optimizablePredicate;
        if (!pred.remapScopedPred() && !pred.hasSubquery()) {
            RemapCRsVisitor rcrv = new RemapCRsVisitor(true);
            pred.getAndNode().accept(rcrv);
        }
        return true;
    }

    @Override
    public void pullOptPredicates(OptimizablePredicateList optimizablePredicates, JBitSet outerTables) throws StandardException {
        if (this.restrictionList != null) {
            if (this.childResult instanceof UnionNode) {
                ((UnionNode)this.childResult).pullOptPredicates(this.restrictionList, outerTables);
            }
            RemapCRsVisitor rcrv = new RemapCRsVisitor(false);
            RemapSubqueryVisitor sqv = null;
            for (int i = this.restrictionList.size() - 1; i >= 0; --i) {
                OptimizablePredicate optPred = this.restrictionList.getOptPredicate(i);
                Predicate pred = (Predicate)optPred;
                if (pred.hasSubquery()) {
                    if (sqv == null) {
                        sqv = new RemapSubqueryVisitor(false, outerTables, false);
                    }
                    pred.getAndNode().accept(sqv);
                } else {
                    pred.getAndNode().accept(rcrv);
                }
                optimizablePredicates.addOptPredicate(optPred);
                this.restrictionList.removeOptPredicate(i);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Optimizable modifyAccessPath(JBitSet outerTables) throws StandardException {
        FromBaseTable leftrs;
        boolean origChildOptimizable = true;
        if (this.accessPathModified) {
            return this;
        }
        boolean alreadyPushed = false;
        if (!(this.childResult instanceof Optimizable)) {
            origChildOptimizable = false;
            this.childResult = this.childResult.modifyAccessPaths(this.restrictionList);
            if (this.childResult instanceof ProjectRestrictNode) {
                ProjectRestrictNode prn = (ProjectRestrictNode)this.childResult;
                if (prn.childResult.getResultColumns().containsWindowFunctionResultColumn()) {
                    this.resultColumns.genVirtualColumnNodes(prn.childResult, prn.childResult.getResultColumns());
                }
            }
            this.hasTrulyTheBestAccessPath = true;
            if (!this.trulyTheBestAccessPath.getJoinStrategy().isHashJoin()) return (Optimizable)((Object)this.considerMaterialization(outerTables));
            SanityManager.ASSERT((this.restrictionList != null ? 1 : 0) != 0, (String)"restrictionList expected to be non-null");
            SanityManager.ASSERT((this.restrictionList.size() != 0 ? 1 : 0) != 0, (String)"restrictionList.size() expected to be non-zero");
            this.getTableNumberHere = true;
        } else if (!(this.childResult instanceof FromBaseTable)) {
            if (this.trulyTheBestAccessPath.getJoinStrategy() == null) {
                this.trulyTheBestAccessPath = (AccessPathImpl)((Optimizable)((Object)this.childResult)).getTrulyTheBestAccessPath();
            }
            if (this.childResult instanceof SetOperatorNode) {
                this.childResult = (ResultSetNode)((Object)((SetOperatorNode)this.childResult).modifyAccessPath(outerTables, this.restrictionList));
                alreadyPushed = true;
            } else {
                this.childResult = (ResultSetNode)((Object)((FromTable)this.childResult).modifyAccessPath(outerTables));
            }
        }
        boolean hashJoinWithThisPRN = this.hasTrulyTheBestAccessPath && this.trulyTheBestAccessPath.getJoinStrategy() != null && this.trulyTheBestAccessPath.getJoinStrategy().isHashJoin();
        boolean isLeftChildOfNCJoinOnRemote = false;
        CompilerContext cc = this.getCompilerContext();
        if (cc.isNCJoinOnRemote() && (leftrs = this.ncjGetOnlyOneFBTNode()) != null && (NcjHashMapWrapper.isTabForPull(cc.getNCJMetaDataOnRemote(), leftrs.ncjGetCorrelationName()) || NcjHashMapWrapper.isTabAtSecondPosition(cc.getNCJMetaDataOnRemote(), leftrs.ncjGetCorrelationName()))) {
            isLeftChildOfNCJoinOnRemote = true;
        }
        if (!(this.restrictionList == null || alreadyPushed || hashJoinWithThisPRN || isLeftChildOfNCJoinOnRemote)) {
            this.restrictionList.pushUsefulPredicates((Optimizable)((Object)this.childResult), true);
        }
        if (origChildOptimizable) {
            this.childResult = this.childResult.changeAccessPath();
        }
        this.accessPathModified = true;
        if (this.trulyTheBestAccessPath.getJoinStrategy() == null || !this.trulyTheBestAccessPath.getJoinStrategy().isHashJoin()) return (Optimizable)((Object)this.considerMaterialization(outerTables));
        return this.replaceWithHashTableNode();
    }

    private Optimizable replaceWithHashTableNode() throws StandardException {
        int i;
        if (this.hasTrulyTheBestAccessPath) {
            ((FromTable)this.childResult).trulyTheBestAccessPath = (AccessPathImpl)this.getTrulyTheBestAccessPath();
            if (this.childResult instanceof SingleChildResultSetNode) {
                ((SingleChildResultSetNode)this.childResult).hasTrulyTheBestAccessPath = this.hasTrulyTheBestAccessPath;
                this.childResult.getReferencedTableMap().set(this.tableNumber);
            }
        }
        PredicateList searchRestrictionList = (PredicateList)this.getNodeFactory().getNode(8, this.getContextManager());
        PredicateList joinQualifierList = (PredicateList)this.getNodeFactory().getNode(8, this.getContextManager());
        PredicateList requalificationRestrictionList = (PredicateList)this.getNodeFactory().getNode(8, this.getContextManager());
        this.trulyTheBestAccessPath.getJoinStrategy().divideUpPredicateLists(this, this.restrictionList, searchRestrictionList, joinQualifierList, requalificationRestrictionList, this.getDataDictionary());
        this.restrictionList = (PredicateList)this.getNodeFactory().getNode(8, this.getContextManager());
        for (i = 0; i < searchRestrictionList.size(); ++i) {
            requalificationRestrictionList.removeOptPredicate((Predicate)searchRestrictionList.elementAt(i));
        }
        for (i = 0; i < joinQualifierList.size(); ++i) {
            requalificationRestrictionList.removeOptPredicate((Predicate)joinQualifierList.elementAt(i));
        }
        joinQualifierList.transferNonQualifiers(this, this.restrictionList);
        requalificationRestrictionList.copyPredicatesToOtherList(this.restrictionList);
        ResultColumnList htRCList = this.childResult.getResultColumns();
        this.childResult.setResultColumns(htRCList.copyListAndObjects());
        htRCList.genVirtualColumnNodes(this.childResult, this.childResult.getResultColumns(), false);
        RemapCRsVisitor rcrv = new RemapCRsVisitor(true);
        searchRestrictionList.accept(rcrv);
        this.childResult = (ResultSetNode)this.getNodeFactory().getNode(148, this.childResult, this.tableProperties, htRCList, searchRestrictionList, joinQualifierList, this.trulyTheBestAccessPath, this.getCostEstimate(), this.projectSubquerys, this.restrictSubquerys, this.hashKeyColumns(), this.getContextManager());
        return this;
    }

    @Override
    public void verifyProperties(DataDictionary dDictionary) throws StandardException {
        if (this.childResult instanceof Optimizable) {
            ((Optimizable)((Object)this.childResult)).verifyProperties(dDictionary);
        } else {
            super.verifyProperties(dDictionary);
        }
    }

    @Override
    public boolean legalJoinOrder(JBitSet assignedTableMap) {
        if (this.childResult instanceof Optimizable) {
            return ((Optimizable)((Object)this.childResult)).legalJoinOrder(assignedTableMap);
        }
        return true;
    }

    @Override
    public double uniqueJoin(OptimizablePredicateList predList) throws StandardException {
        if (this.childResult instanceof Optimizable) {
            return ((Optimizable)((Object)this.childResult)).uniqueJoin(predList);
        }
        return super.uniqueJoin(predList);
    }

    PredicateList getRestrictionList() {
        return this.restrictionList;
    }

    @Override
    String getUserSpecifiedJoinStrategy() {
        if (this.childResult instanceof FromTable) {
            return ((FromTable)this.childResult).getUserSpecifiedJoinStrategy();
        }
        return this.userSpecifiedJoinStrategy;
    }

    @Override
    public void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this.restriction != null) {
            this.printLabel(depth, "restriction: ");
            this.restriction.treePrint(depth + 1);
        }
        if (this.restrictionList != null) {
            this.printLabel(depth, "restrictionList: ");
            this.restrictionList.treePrint(depth + 1);
        }
        if (this.projectSubquerys != null) {
            this.printLabel(depth, "projectSubquerys: ");
            this.projectSubquerys.treePrint(depth + 1);
        }
        if (this.restrictSubquerys != null) {
            this.printLabel(depth, "restrictSubquerys: ");
            this.restrictSubquerys.treePrint(depth + 1);
        }
    }

    @Override
    public ResultSetNode preprocess(int numTables, GroupByList gbl, FromList fromList) throws StandardException {
        this.childResult = this.childResult.preprocess(numTables, gbl, fromList);
        this.referencedTableMap = (JBitSet)this.childResult.getReferencedTableMap().clone();
        return this;
    }

    @Override
    public void pushExpressions(PredicateList predicateList) throws StandardException {
        PredicateList pushPList = null;
        SanityManager.ASSERT((predicateList != null ? 1 : 0) != 0, (String)"predicateList is expected to be non-null");
        if (this.childResult instanceof JoinNode) {
            ((FromTable)this.childResult).pushExpressions(predicateList);
        }
        if ((pushPList = predicateList.getPushablePredicates(this.referencedTableMap)) != null && this.childResult instanceof SelectNode && !this.resultColumns.containsWindowFunctionResultColumn()) {
            pushPList.pushExpressionsIntoSelect((SelectNode)this.childResult, false);
        }
        if (pushPList != null && this.childResult instanceof UnionNode) {
            ((UnionNode)this.childResult).pushExpressions(pushPList);
        }
        if (this.restrictionList == null) {
            this.restrictionList = pushPList;
        } else if (pushPList != null && pushPList.size() != 0) {
            this.restrictionList.destructiveAppend(pushPList);
        }
    }

    @Override
    public ResultSetNode addNewPredicate(Predicate predicate) throws StandardException {
        if (this.restrictionList == null) {
            this.restrictionList = (PredicateList)this.getNodeFactory().getNode(8, this.getContextManager());
        }
        this.restrictionList.addPredicate(predicate);
        return this;
    }

    @Override
    public boolean flattenableInFromSubquery(FromList fromList) {
        return false;
    }

    @Override
    public ResultSetNode ensurePredicateList(int numTables) throws StandardException {
        return this;
    }

    @Override
    public ResultSetNode optimize(DataDictionary dataDictionary, PredicateList predicates, double outerRows) throws StandardException {
        this.childResult = this.childResult.optimize(dataDictionary, this.restrictionList, outerRows);
        Optimizer optimizer = this.getOptimizer((FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this, this.getContextManager()), predicates, dataDictionary, null);
        this.costEstimate = optimizer.newCostEstimate();
        this.costEstimate.setCost(this.childResult.getCostEstimate().getEstimatedCost(), this.childResult.getCostEstimate().rowCount(), this.childResult.getCostEstimate().singleScanRowCount());
        return this;
    }

    @Override
    public CostEstimate getCostEstimate() {
        if (this.costEstimate == null) {
            return this.childResult.getCostEstimate();
        }
        return this.costEstimate;
    }

    @Override
    public CostEstimate getFinalCostEstimate() throws StandardException {
        if (this.finalCostEstimate != null) {
            return this.finalCostEstimate;
        }
        this.finalCostEstimate = this.childResult instanceof Optimizable ? this.childResult.getFinalCostEstimate() : this.getTrulyTheBestAccessPath().getCostEstimate();
        return this.finalCostEstimate;
    }

    @Override
    public void generate(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        SanityManager.ASSERT((this.resultColumns != null ? 1 : 0) != 0, (String)"Tree structure bad");
        this.generateMinion(acb, mb, false);
    }

    @Override
    public void generateResultSet(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        this.generateMinion(acb, mb, true);
    }

    public void handleSubqueryProcessing(SubqueryNode sqn, ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        if (this.restrictionList != null && this.restrictionList.size() > 0) {
            this.restrictionList.eliminateBooleanTrueAndBooleanTrue();
        }
        if (this.nopProjectRestrict()) {
            this.generateNOPProjectRestrict();
            sqn.generateGFEResultSet(acb, mb, -1, this.getCompilerContext());
            this.costEstimate = this.childResult.getFinalCostEstimate();
            return;
        }
        if (this.restrictionList != null) {
            this.constantRestriction = this.restrictionList.restoreConstantPredicates();
            this.restrictionList.removeRedundantPredicates();
            this.restriction = this.restrictionList.restorePredicates();
            this.restrictionList = null;
        }
        int[] mapArray = this.resultColumns.mapSourceColumns();
        int mapArrayItem = acb.addItem(new ReferencedColumnsDescriptorImpl(mapArray));
        boolean doesProjection = true;
        if (!this.reflectionNeededForProjection() && mapArray != null && mapArray.length == this.childResult.getResultColumns().size()) {
            int index;
            for (index = 0; index < mapArray.length && mapArray[index] == index + 1; ++index) {
            }
            if (index == mapArray.length) {
                doesProjection = false;
            }
        }
        int resultSetNumber = this.getCompilerContext().getNextResultSetNumber();
        acb.pushGetResultSetFactoryExpression(mb);
        sqn.generateGFEResultSet(acb, mb, resultSetNumber, this.getCompilerContext());
        if (this.childResult instanceof ProjectRestrictNode) {
            ((ProjectRestrictNode)this.childResult).assignResultSetNumber(resultSetNumber);
        }
        this.assignResultSetNumber();
        if (this.projectSubquerys != null && this.projectSubquerys.size() > 0) {
            this.projectSubquerys.setPointOfAttachment(resultSetNumber);
        }
        if (this.restrictSubquerys != null && this.restrictSubquerys.size() > 0) {
            this.restrictSubquerys.setPointOfAttachment(resultSetNumber);
        }
        this.costEstimate = this.getFinalCostEstimate();
        StringBuilder projectedColumns = new StringBuilder();
        projectedColumns.append("SELECT :");
        for (int i = 0; i < this.resultColumns.size(); ++i) {
            ResultColumn col = (ResultColumn)this.resultColumns.elementAt(i);
            if (col.getActualName() == null || col.getActualName().startsWith("##")) continue;
            projectedColumns.append(col.getActualName());
            projectedColumns.append(" ");
        }
        if (this.restriction == null) {
            mb.pushNull("com.pivotal.gemfirexd.internal.iapi.services.loader.GeneratedMethod");
        } else {
            MethodBuilder userExprFun = acb.newUserExprFun();
            this.restriction.generateExpression(acb, userExprFun);
            userExprFun.methodReturn();
            userExprFun.complete();
            acb.pushMethodReference(mb, userExprFun);
        }
        if (this.reflectionNeededForProjection()) {
            this.resultColumns.generateCore(acb, mb, false);
        } else {
            mb.pushNull("com.pivotal.gemfirexd.internal.iapi.services.loader.GeneratedMethod");
        }
        mb.push(resultSetNumber);
        if (this.constantRestriction == null) {
            mb.pushNull("com.pivotal.gemfirexd.internal.iapi.services.loader.GeneratedMethod");
        } else {
            MethodBuilder userExprFun = acb.newUserExprFun();
            projectedColumns.append("WHERE :");
            projectedColumns.append(this.restriction.printExplainInfo());
            this.constantRestriction.generateExpression(acb, userExprFun);
            userExprFun.methodReturn();
            userExprFun.complete();
            acb.pushMethodReference(mb, userExprFun);
        }
        mb.push(mapArrayItem);
        mb.push(this.resultColumns.reusableResult());
        mb.push(doesProjection);
        mb.push(this.childResultOptimized);
        if (projectedColumns.length() > 0) {
            mb.push(projectedColumns.toString());
        } else {
            mb.pushNull("java.lang.String");
        }
        mb.push(this.costEstimate.rowCount());
        mb.push(this.costEstimate.getEstimatedCost());
        mb.callMethod((short)185, null, "getProjectRestrictResultSet", "com.pivotal.gemfirexd.internal.iapi.sql.execute.NoPutResultSet", 12);
    }

    public void markChildOptimized() {
        this.childResultOptimized = true;
        if (this.childResult instanceof ProjectRestrictNode) {
            ((ProjectRestrictNode)this.childResult).markChildOptimized();
        }
    }

    private void generateMinion(ExpressionClassBuilder acb, MethodBuilder mb, boolean genChildResultSet) throws StandardException {
        if (this.restrictionList != null && this.restrictionList.size() > 0) {
            this.restrictionList.eliminateBooleanTrueAndBooleanTrue();
        }
        if (this.nopProjectRestrict()) {
            this.generateNOPProjectRestrict();
            if (genChildResultSet) {
                this.childResult.generateResultSet(acb, mb);
            } else {
                this.childResult.generate((ActivationClassBuilder)acb, mb);
            }
            this.costEstimate = this.childResult.getFinalCostEstimate();
            return;
        }
        if (this.restrictionList != null) {
            this.constantRestriction = this.restrictionList.restoreConstantPredicates();
            this.restrictionList.removeRedundantPredicates();
            this.restriction = this.restrictionList.restorePredicates();
            this.restrictionList = null;
        }
        int[] mapArray = this.resultColumns.mapSourceColumns();
        int mapArrayItem = acb.addItem(new ReferencedColumnsDescriptorImpl(mapArray));
        boolean doesProjection = true;
        if (!this.reflectionNeededForProjection() && mapArray != null && mapArray.length == this.childResult.getResultColumns().size()) {
            int index;
            for (index = 0; index < mapArray.length && mapArray[index] == index + 1; ++index) {
            }
            if (index == mapArray.length) {
                doesProjection = false;
            }
        }
        acb.pushGetResultSetFactoryExpression(mb);
        if (genChildResultSet) {
            this.childResult.generateResultSet(acb, mb);
        } else {
            this.childResult.generate((ActivationClassBuilder)acb, mb);
        }
        this.assignResultSetNumber();
        if (this.projectSubquerys != null && this.projectSubquerys.size() > 0) {
            this.projectSubquerys.setPointOfAttachment(this.resultSetNumber);
        }
        if (this.restrictSubquerys != null && this.restrictSubquerys.size() > 0) {
            this.restrictSubquerys.setPointOfAttachment(this.resultSetNumber);
        }
        this.costEstimate = this.getFinalCostEstimate();
        StringBuilder projectedColumns = new StringBuilder();
        projectedColumns.append("SELECT :");
        for (int i = 0; i < this.resultColumns.size(); ++i) {
            ResultColumn col = (ResultColumn)this.resultColumns.elementAt(i);
            if (col.getActualName() == null || col.getActualName().startsWith("##")) continue;
            projectedColumns.append(col.getActualName());
            projectedColumns.append(" ");
        }
        if (this.restriction == null) {
            mb.pushNull("com.pivotal.gemfirexd.internal.iapi.services.loader.GeneratedMethod");
        } else {
            MethodBuilder userExprFun = acb.newUserExprFun();
            projectedColumns.append("WHERE :");
            projectedColumns.append(this.restriction.printExplainInfo());
            this.restriction.generateExpression(acb, userExprFun);
            userExprFun.methodReturn();
            userExprFun.complete();
            acb.pushMethodReference(mb, userExprFun);
        }
        if (this.reflectionNeededForProjection()) {
            this.resultColumns.generateCore(acb, mb, false);
        } else {
            mb.pushNull("com.pivotal.gemfirexd.internal.iapi.services.loader.GeneratedMethod");
        }
        mb.push(this.resultSetNumber);
        if (this.constantRestriction == null) {
            mb.pushNull("com.pivotal.gemfirexd.internal.iapi.services.loader.GeneratedMethod");
        } else {
            MethodBuilder userExprFun = acb.newUserExprFun();
            this.constantRestriction.generateExpression(acb, userExprFun);
            userExprFun.methodReturn();
            userExprFun.complete();
            acb.pushMethodReference(mb, userExprFun);
        }
        mb.push(mapArrayItem);
        mb.push(this.resultColumns.reusableResult());
        mb.push(doesProjection);
        mb.push(this.childResultOptimized);
        if (projectedColumns.length() > 0) {
            mb.push(projectedColumns.toString());
        } else {
            mb.pushNull("java.lang.String");
        }
        mb.push(this.costEstimate.rowCount());
        mb.push(this.costEstimate.getEstimatedCost());
        mb.callMethod((short)185, null, "getProjectRestrictResultSet", "com.pivotal.gemfirexd.internal.iapi.sql.execute.NoPutResultSet", 12);
    }

    public boolean nopProjectRestrict() {
        if (this.restriction != null || this.restrictionList != null && this.restrictionList.size() > 0) {
            return false;
        }
        ResultColumnList childColumns = this.childResult.getResultColumns();
        ResultColumnList PRNColumns = this.getResultColumns();
        return PRNColumns.nopProjection(childColumns);
    }

    public void generateNOPProjectRestrict() throws StandardException {
        this.getResultColumns().setRedundant();
    }

    @Override
    public ResultSetNode considerMaterialization(JBitSet outerTables) throws StandardException {
        this.childResult = this.childResult.considerMaterialization(outerTables);
        if (this.childResult.performMaterialization(outerTables)) {
            boolean emptyRestrictionList;
            ReferencedTablesVisitor rtv = new ReferencedTablesVisitor((JBitSet)this.childResult.getReferencedTableMap().clone());
            boolean bl = emptyRestrictionList = this.restrictionList == null || this.restrictionList.size() == 0;
            if (!emptyRestrictionList) {
                this.restrictionList.accept(rtv);
            }
            if (emptyRestrictionList || this.childResult.getReferencedTableMap().contains(rtv.getTableMap())) {
                ResultColumnList prRCList = this.resultColumns;
                this.setResultColumns(this.resultColumns.copyListAndObjects());
                prRCList.genVirtualColumnNodes(this, this.resultColumns);
                MaterializeResultSetNode mrsn = (MaterializeResultSetNode)this.getNodeFactory().getNode(121, this, prRCList, this.tableProperties, this.getContextManager());
                if (this.referencedTableMap != null) {
                    mrsn.setReferencedTableMap((JBitSet)this.referencedTableMap.clone());
                }
                return mrsn;
            }
            ResultColumnList prRCList = this.childResult.getResultColumns();
            this.childResult.setResultColumns(prRCList.copyListAndObjects());
            prRCList.genVirtualColumnNodes(this.childResult, this.childResult.getResultColumns());
            MaterializeResultSetNode mrsn = (MaterializeResultSetNode)this.getNodeFactory().getNode(121, this.childResult, prRCList, this.tableProperties, this.getContextManager());
            if (this.childResult.getReferencedTableMap() != null) {
                mrsn.setReferencedTableMap((JBitSet)this.childResult.getReferencedTableMap().clone());
            }
            this.childResult = mrsn;
        }
        return this;
    }

    @Override
    protected FromTable getFromTableByName(String name, String schemaName, boolean exactMatch) throws StandardException {
        return this.childResult.getFromTableByName(name, schemaName, exactMatch);
    }

    @Override
    public int updateTargetLockMode() {
        if (this.restriction != null || this.constantRestriction != null) {
            return 6;
        }
        return this.childResult.updateTargetLockMode();
    }

    @Override
    boolean isPossibleDistinctScan(Set distinctColumns) {
        if (this.restriction != null || this.restrictionList != null && this.restrictionList.size() != 0) {
            return false;
        }
        HashSet<BaseColumnNode> columns = new HashSet<BaseColumnNode>();
        for (int i = 0; i < this.resultColumns.size(); ++i) {
            ResultColumn rc = (ResultColumn)this.resultColumns.elementAt(i);
            BaseColumnNode bc = rc.getBaseColumnNode();
            if (bc == null) {
                return false;
            }
            columns.add(bc);
        }
        return columns.equals(distinctColumns) && this.childResult.isPossibleDistinctScan(distinctColumns);
    }

    @Override
    void markForDistinctScan() {
        this.childResult.markForDistinctScan();
    }

    @Override
    public Visitable accept(Visitor v) throws StandardException {
        if (v.skipChildren(this)) {
            return v.visit(this);
        }
        Visitable returnNode = super.accept(v);
        if (this.restriction != null && !v.stopTraversal()) {
            this.restriction = (ValueNode)this.restriction.accept(v);
        }
        if (this.restrictionList != null && !v.stopTraversal()) {
            this.restrictionList = (PredicateList)this.restrictionList.accept(v);
        }
        return returnNode;
    }

    @Override
    public void setRefActionInfo(long fkIndexConglomId, int[] fkColArray, String parentResultSetId, boolean dependentScan) {
        this.childResult.setRefActionInfo(fkIndexConglomId, fkColArray, parentResultSetId, dependentScan);
    }

    public void setRestriction(ValueNode restriction) {
        this.restriction = restriction;
    }

    @Override
    public String toString() {
        return this.childResult != null ? this.childResult + super.toString() : super.toString();
    }

    @Override
    public void getTablesReferencedByRestrictionLists(JBitSet referencedTables) {
        if (this.childResult instanceof Optimizable) {
            ((Optimizable)((Object)this.childResult)).getTablesReferencedByRestrictionLists(referencedTables);
        }
    }

    @Override
    public ResultSetNode getInnerMostPRN() {
        if (this.childResult instanceof OrderByNode || this.childResult instanceof ProjectRestrictNode || this.childResult instanceof DistinctNode) {
            return this.childResult.getInnerMostPRN();
        }
        return this;
    }

    @Override
    public QueryInfo computeQueryInfo(QueryInfoContext qic) throws StandardException {
        return ProjectRestrictNode.getSelectQueryInfo(qic, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SelectQueryInfo getSelectQueryInfo(QueryInfoContext qic, QueryTreeNode qtNode) throws StandardException {
        SelectQueryInfo info = new SelectQueryInfo(qic, null);
        try {
            qic.setRootQueryInfo(info);
            qtNode.accept(info);
            info.init();
            SelectQueryInfo selectQueryInfo = info;
            return selectQueryInfo;
        }
        finally {
            qic.cleanUp();
        }
    }

    @Override
    protected void optimizeForOffHeap(boolean shouldOptimize) {
        shouldOptimize = shouldOptimize || this.reflectionNeededForProjection() && !this.nopProjectRestrict();
        super.optimizeForOffHeap(shouldOptimize);
        if (this.restrictionList != null) {
            this.restrictionList.optimizeForOffHeap(shouldOptimize);
        }
    }

    @Override
    public Optimizable getBaseTable() throws StandardException {
        if (this.childResult instanceof Optimizable) {
            return ((Optimizable)((Object)this.childResult)).getBaseTable();
        }
        return this;
    }

    @Override
    public void collectHashKeyColumns(Vector hashKeyVector, int tabNum, int colNum) throws StandardException {
        if (tabNum == -1 || colNum == -1) {
            return;
        }
        int colLength = this.getNumColumnsReturned();
        for (int colCtr = 0; colCtr < colLength; ++colCtr) {
            ResultColumn resCol = (ResultColumn)this.resultColumns.elementAt(colCtr);
            if (resCol.getTableNumber() != tabNum || resCol.getColumnPosition() != colNum) continue;
            hashKeyVector.addElement(colCtr);
        }
    }

    public ArrayList<String> getRemoteInListCols() {
        return this.remoteInListCols;
    }

    public void setRemoteInListCols(ArrayList<String> remoteJoinCols) {
        this.remoteInListCols = remoteJoinCols;
    }

    @Override
    public boolean assertProjectRestrictNode() {
        return true;
    }
}

