/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.catalog.TypeDescriptor;
import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.catalog.types.RoutineAliasInfo;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.depend.Provider;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.AliasDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SchemaDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TupleDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.compile.QueryTreeNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.RoutineDesignator;
import com.pivotal.gemfirexd.internal.impl.sql.compile.TableName;
import com.pivotal.gemfirexd.internal.impl.sql.compile.TablePrivilegesNode;
import com.pivotal.gemfirexd.internal.impl.sql.execute.PrivilegeInfo;
import java.util.HashMap;
import java.util.List;

public class PrivilegeNode
extends QueryTreeNode {
    public static final int TABLE_PRIVILEGES = 0;
    public static final int ROUTINE_PRIVILEGES = 1;
    private int objectType;
    private Object objectOfPrivilege;
    private TablePrivilegesNode specificPrivileges;

    @Override
    public void init(Object objectType, Object objectOfPrivilege, Object specificPrivileges) {
        this.objectType = (Integer)objectType;
        this.objectOfPrivilege = objectOfPrivilege;
        this.specificPrivileges = (TablePrivilegesNode)specificPrivileges;
        SanityManager.ASSERT((objectOfPrivilege != null ? 1 : 0) != 0, (String)"null privilge object");
        switch (this.objectType) {
            case 0: {
                SanityManager.ASSERT((boolean)(objectOfPrivilege instanceof TableName), (String)("incorrect name type, " + objectOfPrivilege.getClass().getName() + ", used with table privilege"));
                SanityManager.ASSERT((specificPrivileges != null ? 1 : 0) != 0, (String)"null specific privileges used with table privilege");
                break;
            }
            case 1: {
                SanityManager.ASSERT((boolean)(objectOfPrivilege instanceof RoutineDesignator), (String)("incorrect name type, " + objectOfPrivilege.getClass().getName() + ", used with table privilege"));
                SanityManager.ASSERT((specificPrivileges == null ? 1 : 0) != 0, (String)"non-null specific privileges used with execute privilege");
                break;
            }
            default: {
                SanityManager.THROWASSERT((String)("Invalid privilege objectType: " + this.objectType));
            }
        }
    }

    public QueryTreeNode bind(HashMap dependencies, List grantees, boolean isGrant) throws StandardException {
        TupleDescriptor dependencyProvider = null;
        SchemaDescriptor sd = null;
        switch (this.objectType) {
            case 0: {
                TableName tableName = (TableName)this.objectOfPrivilege;
                sd = this.getSchemaDescriptor(tableName.getSchemaName(), true);
                if (sd.isSystemSchema()) {
                    throw StandardException.newException("42509", tableName.getFullTableName());
                }
                TableDescriptor td = this.getTableDescriptor(tableName.getTableName(), sd);
                if (td == null) {
                    throw StandardException.newException("42X05", tableName.getFullTableName());
                }
                if (this.isSessionSchema(sd.getSchemaName())) {
                    throw StandardException.newException("XCL51.S");
                }
                if (td.getTableType() != 0 && td.getTableType() != 2 && td.getTableType() != 6) {
                    throw StandardException.newException("42509", tableName.getFullTableName());
                }
                if (grantees.contains(sd.getAuthorizationId())) {
                    throw StandardException.newException("42509", td.getQualifiedName());
                }
                this.specificPrivileges.bind(td, isGrant);
                dependencyProvider = td;
                break;
            }
            case 1: {
                UUID procID;
                RoutineDesignator rd = (RoutineDesignator)this.objectOfPrivilege;
                sd = this.getSchemaDescriptor(rd.name.getSchemaName(), true);
                AliasDescriptor proc = null;
                RoutineAliasInfo routineInfo = null;
                List list = this.getDataDictionary().getRoutineList(sd.getUUID().toString(), rd.name.getTableName(), rd.isFunction ? (char)'F' : 'P');
                if (grantees.contains(sd.getAuthorizationId())) {
                    throw StandardException.newException("42509", rd.name.getFullTableName());
                }
                if (rd.paramTypeList == null) {
                    if (list.size() > 1) {
                        throw StandardException.newException(rd.isFunction ? "42X46" : "42X47", rd.name.getFullTableName());
                    }
                    if (list.size() != 1) {
                        throw StandardException.newException("42Y03", (Object)rd.name.getFullTableName(), (Object)"");
                    }
                    proc = (AliasDescriptor)list.get(0);
                } else {
                    boolean found = false;
                    block4: for (int i = list.size() - 1; !found && i >= 0; --i) {
                        proc = (AliasDescriptor)list.get(i);
                        routineInfo = (RoutineAliasInfo)proc.getAliasInfo();
                        int parameterCount = routineInfo.getParameterCount();
                        if (parameterCount != rd.paramTypeList.size()) continue;
                        TypeDescriptor[] parameterTypes = routineInfo.getParameterTypes();
                        found = true;
                        for (int parmIdx = 0; parmIdx < parameterCount; ++parmIdx) {
                            if (parameterTypes[parmIdx].equals(rd.paramTypeList.get(parmIdx))) continue;
                            found = false;
                            continue block4;
                        }
                    }
                    if (!found) {
                        StringBuilder sb = new StringBuilder(rd.name.getFullTableName());
                        sb.append("(");
                        for (int i = 0; i < rd.paramTypeList.size(); ++i) {
                            if (i > 0) {
                                sb.append(",");
                            }
                            sb.append(rd.paramTypeList.get(i).toString());
                        }
                        throw StandardException.newException("42Y03", (Object)sb.toString(), (Object)"");
                    }
                }
                UUID uUID = procID = proc != null ? proc.getUUID() : null;
                if (!sd.isSchemaWithGrantableRoutines(procID)) {
                    throw StandardException.newException("42509", rd.name.getFullTableName());
                }
                rd.setAliasDescriptor(proc);
                dependencyProvider = proc;
            }
        }
        if (dependencyProvider != null && dependencies.get(dependencyProvider) == null) {
            this.getCompilerContext().createDependency((Provider)((Object)dependencyProvider));
            dependencies.put(dependencyProvider, dependencyProvider);
        }
        return this;
    }

    PrivilegeInfo makePrivilegeInfo() {
        switch (this.objectType) {
            case 0: {
                return this.specificPrivileges.makePrivilegeInfo();
            }
            case 1: {
                return ((RoutineDesignator)this.objectOfPrivilege).makePrivilegeInfo();
            }
        }
        return null;
    }
}

