/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.MethodBuilder;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Optimizable;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.OptimizablePredicate;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Visitable;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Visitor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.util.JBitSet;
import com.pivotal.gemfirexd.internal.impl.sql.compile.AndNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.BaseTableNumbersVisitor;
import com.pivotal.gemfirexd.internal.impl.sql.compile.BinaryRelationalOperatorNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ColumnReference;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ExpressionClassBuilder;
import com.pivotal.gemfirexd.internal.impl.sql.compile.InListOperatorNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.OrNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.QueryTreeNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.RelationalOperator;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultSetNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.VirtualColumnNode;
import java.util.Hashtable;

public final class Predicate
extends QueryTreeNode
implements OptimizablePredicate,
Comparable {
    AndNode andNode;
    boolean pushable;
    JBitSet referencedSet;
    int equivalenceClass = -1;
    int indexPosition;
    protected boolean startKey;
    protected boolean stopKey;
    protected boolean isQualifier;
    private Hashtable searchClauseHT;
    private boolean scoped;
    private int isColocated = 0;

    @Override
    public void init(Object andNode, Object referencedSet) {
        this.andNode = (AndNode)andNode;
        this.pushable = false;
        this.referencedSet = (JBitSet)referencedSet;
        this.scoped = false;
    }

    @Override
    public JBitSet getReferencedMap() {
        return this.referencedSet;
    }

    @Override
    public boolean hasSubquery() {
        return !this.pushable;
    }

    @Override
    public boolean hasMethodCall() {
        return !this.pushable;
    }

    @Override
    public void markStartKey() {
        this.startKey = true;
    }

    @Override
    public boolean isStartKey() {
        return this.startKey;
    }

    @Override
    public void markStopKey() {
        this.stopKey = true;
    }

    @Override
    public boolean isStopKey() {
        return this.stopKey;
    }

    @Override
    public void markQualifier() {
        this.isQualifier = true;
    }

    @Override
    public boolean isQualifier() {
        return this.isQualifier;
    }

    @Override
    public boolean compareWithKnownConstant(Optimizable optTable, boolean considerParameters) {
        boolean retval = false;
        RelationalOperator relop = this.getRelop();
        if (!this.isRelationalOpPredicate()) {
            return false;
        }
        if (relop.compareWithKnownConstant(optTable, considerParameters)) {
            retval = true;
        }
        return retval;
    }

    @Override
    public boolean compareWithParameterNode(Optimizable optTable) {
        boolean retval = false;
        RelationalOperator relop = this.getRelop();
        if (!this.isRelationalOpPredicate()) {
            return false;
        }
        return relop.compareWithParameterNode(optTable);
    }

    @Override
    public int hasEqualOnColumnList(int[] baseColumnPositions, Optimizable optTable) throws StandardException {
        RelationalOperator relop = this.getRelop();
        if (!this.isRelationalOpPredicate()) {
            return -1;
        }
        if (relop.getOperator() != 1) {
            return -1;
        }
        for (int i = 0; i < baseColumnPositions.length; ++i) {
            ColumnReference cr = relop.getColumnOperand(optTable, baseColumnPositions[i]);
            if (cr == null || relop.selfComparison(cr)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public DataValueDescriptor getCompareValue(Optimizable optTable) throws StandardException {
        SanityManager.ASSERT((boolean)this.compareWithKnownConstant(optTable, true), (String)"Cannot get the compare value if not comparing with a known constant.");
        RelationalOperator relop = this.getRelop();
        return relop.getCompareValue(optTable);
    }

    @Override
    public boolean equalsComparisonWithConstantExpression(Optimizable optTable) {
        boolean retval = false;
        if (this.isRelationalOpPredicate()) {
            retval = this.getRelop().equalsComparisonWithConstantExpression(optTable);
        }
        return retval;
    }

    @Override
    public double selectivity(Optimizable optTable) throws StandardException {
        return this.andNode.selectivity(optTable);
    }

    @Override
    public int getIndexPosition() {
        return this.indexPosition;
    }

    public int compareTo(Object other) {
        boolean otherIsBefore;
        boolean thisIsBefore;
        Predicate otherPred = (Predicate)other;
        int otherIndexPosition = otherPred.getIndexPosition();
        if (this.indexPosition < otherIndexPosition) {
            return -1;
        }
        if (this.indexPosition > otherIndexPosition) {
            return 1;
        }
        boolean thisIsEquals = false;
        boolean otherIsEquals = false;
        boolean thisIsNotEquals = true;
        boolean otherIsNotEquals = true;
        if (this.isRelationalOpPredicate() || this.isInListProbePredicate()) {
            int thisOperator = this.andNode.getLeftOperatorForCompare();
            thisIsEquals = thisOperator == 1 || thisOperator == 7;
            boolean bl = thisIsNotEquals = thisOperator == 2 || thisOperator == 8;
        }
        if (otherPred.isRelationalOpPredicate() || otherPred.isInListProbePredicate()) {
            int otherOperator = otherPred.getAndNode().getLeftOperatorForCompare();
            otherIsEquals = otherOperator == 1 || otherOperator == 7;
            otherIsNotEquals = otherOperator == 2 || otherOperator == 8;
        }
        boolean bl = thisIsBefore = thisIsEquals && !otherIsEquals || !thisIsNotEquals && otherIsNotEquals;
        if (thisIsBefore) {
            return -1;
        }
        boolean bl2 = otherIsBefore = otherIsEquals && !thisIsEquals || !otherIsNotEquals && thisIsNotEquals;
        if (otherIsBefore) {
            return 1;
        }
        return 0;
    }

    public AndNode getAndNode() {
        return this.andNode;
    }

    public void setAndNode(AndNode andNode) {
        this.andNode = andNode;
    }

    public boolean getPushable() {
        return this.pushable;
    }

    public void setPushable(boolean pushable) {
        this.pushable = pushable;
    }

    public JBitSet getReferencedSet() {
        return this.referencedSet;
    }

    void setEquivalenceClass(int equivalenceClass) {
        this.equivalenceClass = equivalenceClass;
    }

    int getEquivalenceClass() {
        return this.equivalenceClass;
    }

    public void categorize() throws StandardException {
        this.pushable = this.andNode.categorize(this.referencedSet, false);
    }

    public RelationalOperator getRelop() {
        if (this.andNode.getLeftOperand() instanceof RelationalOperator) {
            return (RelationalOperator)((Object)this.andNode.getLeftOperand());
        }
        return null;
    }

    public final boolean isOrList() {
        return this.andNode.getLeftOperand() instanceof OrNode;
    }

    public final boolean isStoreQualifier() {
        return this.andNode.getLeftOperand() instanceof RelationalOperator || this.andNode.getLeftOperand() instanceof OrNode;
    }

    public final boolean isPushableOrClause(Optimizable optTable) throws StandardException {
        boolean ret_val = true;
        if (this.andNode.getLeftOperand() instanceof OrNode) {
            ValueNode node = this.andNode.getLeftOperand();
            while (node instanceof OrNode) {
                OrNode or_node = (OrNode)node;
                if (or_node.getLeftOperand() instanceof RelationalOperator) {
                    if (!((RelationalOperator)((Object)or_node.getLeftOperand())).isQualifier(optTable, true)) {
                        return false;
                    }
                    node = or_node.getRightOperand();
                    continue;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    boolean transitiveSearchClauseAdded(RelationalOperator ro) {
        return this.searchClauseHT != null && this.searchClauseHT.get(ro.getOperator()) != null;
    }

    void setTransitiveSearchClauseAdded(RelationalOperator ro) {
        if (this.searchClauseHT == null) {
            this.searchClauseHT = new Hashtable();
        }
        Integer i = ro.getOperator();
        this.searchClauseHT.put(i, i);
    }

    public int getStartOperator(Optimizable optTable) {
        SanityManager.ASSERT((boolean)this.startKey, (String)"Getting a start operator from a Predicate that's not a start key.");
        if (this.andNode.getLeftOperand() instanceof InListOperatorNode) {
            return 1;
        }
        return this.getRelop().getStartOperator(optTable);
    }

    public int getStopOperator(Optimizable optTable) {
        SanityManager.ASSERT((boolean)this.stopKey, (String)"Getting a stop operator from a Predicate that's not a stop key.");
        if (this.andNode.getLeftOperand() instanceof InListOperatorNode) {
            return -1;
        }
        return this.getRelop().getStopOperator(optTable);
    }

    public void setIndexPosition(int indexPosition) {
        this.indexPosition = indexPosition;
    }

    void clearScanFlags() {
        this.startKey = false;
        this.stopKey = false;
        this.isQualifier = false;
    }

    void clearQualifierFlag() {
        this.isQualifier = false;
    }

    void generateExpressionOperand(Optimizable optTable, int columnPosition, ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        this.getRelop().generateExpressionOperand(optTable, columnPosition, acb, mb);
    }

    void generateAbsoluteColumnId(MethodBuilder mb, Optimizable optTable) {
        this.getRelop().generateAbsoluteColumnId(mb, optTable);
    }

    void generateRelativeColumnId(MethodBuilder mb, Optimizable optTable) {
        this.getRelop().generateRelativeColumnId(mb, optTable);
    }

    void generateOperator(MethodBuilder mb, Optimizable optTable) {
        this.getRelop().generateOperator(mb, optTable);
    }

    void generateQualMethod(ExpressionClassBuilder acb, MethodBuilder mb, Optimizable optTable) throws StandardException {
        this.getRelop().generateQualMethod(acb, mb, optTable);
    }

    void generateOrderedNulls(MethodBuilder mb) {
        this.getRelop().generateOrderedNulls(mb);
    }

    void generateNegate(MethodBuilder mb, Optimizable optTable) {
        this.getRelop().generateNegate(mb, optTable);
    }

    void generateOrderableVariantType(MethodBuilder mb, Optimizable optTable) throws StandardException {
        int variantType = this.getRelop().getOrderableVariantType(optTable);
        mb.push(variantType);
    }

    @Override
    public String toString() {
        return this.binaryRelOpColRefsToString() + "\nreferencedSet: " + this.referencedSet + "\npushable: " + this.pushable + "\n" + super.toString();
    }

    public String binaryRelOpColRefsToString() {
        if (!(this.getAndNode().getLeftOperand() instanceof BinaryRelationalOperatorNode)) {
            return "";
        }
        String DUMMY_VAL = "<expr>";
        StringBuilder sBuf = new StringBuilder();
        BinaryRelationalOperatorNode opNode = (BinaryRelationalOperatorNode)this.getAndNode().getLeftOperand();
        if (opNode.getLeftOperand() instanceof ColumnReference) {
            sBuf.append(((ColumnReference)opNode.getLeftOperand()).getTableName() + "." + ((ColumnReference)opNode.getLeftOperand()).getColumnName());
        } else {
            sBuf.append("<expr>");
        }
        sBuf.append(" " + opNode.operator + " ");
        if (opNode.getRightOperand() instanceof ColumnReference) {
            sBuf.append(((ColumnReference)opNode.getRightOperand()).getTableName() + "." + ((ColumnReference)opNode.getRightOperand()).getColumnName());
        } else {
            sBuf.append("<expr>");
        }
        return sBuf.toString();
    }

    @Override
    public void printSubNodes(int depth) {
        this.printLabel(depth, "andNode: ");
        this.andNode.treePrint(depth + 1);
        super.printSubNodes(depth);
    }

    @Override
    public Visitable accept(Visitor v) throws StandardException {
        if (v.skipChildren(this)) {
            return v.visit(this);
        }
        Visitable returnNode = super.accept(v);
        if (this.andNode != null && !v.stopTraversal()) {
            this.andNode = (AndNode)this.andNode.accept(v);
        }
        return returnNode;
    }

    public void copyFields(Predicate otherPred) {
        this.equivalenceClass = otherPred.getEquivalenceClass();
        this.indexPosition = otherPred.getIndexPosition();
        this.startKey = otherPred.isStartKey();
        this.stopKey = otherPred.isStopKey();
        this.isQualifier = otherPred.isQualifier();
        this.searchClauseHT = otherPred.getSearchClauseHT();
    }

    public Hashtable getSearchClauseHT() {
        return this.searchClauseHT;
    }

    protected boolean pushableToSubqueries() throws StandardException {
        if (!this.isJoinPredicate()) {
            return false;
        }
        BinaryRelationalOperatorNode opNode = (BinaryRelationalOperatorNode)this.getAndNode().getLeftOperand();
        JBitSet tNums = new JBitSet(this.getReferencedSet().size());
        BaseTableNumbersVisitor btnVis = new BaseTableNumbersVisitor(tNums);
        opNode.getLeftOperand().accept(btnVis);
        if (tNums.getFirstSetBit() == -1) {
            return false;
        }
        tNums.clearAll();
        opNode.getRightOperand().accept(btnVis);
        return tNums.getFirstSetBit() != -1;
    }

    protected boolean isJoinPredicate() {
        if (!(this.getAndNode().getLeftOperand() instanceof BinaryRelationalOperatorNode)) {
            return false;
        }
        BinaryRelationalOperatorNode opNode = (BinaryRelationalOperatorNode)this.getAndNode().getLeftOperand();
        return opNode.getLeftOperand() instanceof ColumnReference && opNode.getRightOperand() instanceof ColumnReference && ((ColumnReference)opNode.getLeftOperand()).getTableNumber() != ((ColumnReference)opNode.getRightOperand()).getTableNumber();
    }

    protected Predicate getPredScopedForResultSet(JBitSet parentRSNsTables, ResultSetNode childRSN, int[] whichRC) throws StandardException {
        if (!(this.getAndNode().getLeftOperand() instanceof BinaryRelationalOperatorNode)) {
            return this;
        }
        ValueNode trueNode = (ValueNode)this.getNodeFactory().getNode(38, Boolean.TRUE, this.getContextManager());
        BinaryRelationalOperatorNode opNode = (BinaryRelationalOperatorNode)this.getAndNode().getLeftOperand();
        BinaryRelationalOperatorNode newOpNode = (BinaryRelationalOperatorNode)this.getNodeFactory().getNode(opNode.getNodeType(), opNode.getScopedOperand(-1, parentRSNsTables, childRSN, whichRC), opNode.getScopedOperand(1, parentRSNsTables, childRSN, whichRC), this.getContextManager());
        newOpNode.bindComparisonOperator();
        AndNode newAnd = (AndNode)this.getNodeFactory().getNode(39, newOpNode, trueNode, this.getContextManager());
        newAnd.postBindFixup();
        JBitSet tableMap = new JBitSet(childRSN.getReferencedTableMap().size());
        newAnd.categorize(tableMap, false);
        Predicate newPred = (Predicate)this.getNodeFactory().getNode(78, newAnd, tableMap, this.getContextManager());
        newPred.clearScanFlags();
        newPred.copyFields(this);
        newPred.setPushable(this.getPushable());
        newPred.markAsScopedForPush();
        return newPred;
    }

    protected void markAsScopedForPush() {
        this.scoped = true;
    }

    protected boolean isScopedForPush() {
        return this.scoped;
    }

    protected boolean remapScopedPred() {
        if (!this.scoped) {
            return false;
        }
        BinaryRelationalOperatorNode binRelOp = (BinaryRelationalOperatorNode)this.andNode.getLeftOperand();
        ValueNode operand = null;
        operand = binRelOp.getLeftOperand();
        boolean leftIsScoped = !(operand instanceof ColumnReference) || ((ColumnReference)operand).isScoped();
        operand = binRelOp.getRightOperand();
        boolean rightIsScoped = !(operand instanceof ColumnReference) || ((ColumnReference)operand).isScoped();
        SanityManager.ASSERT((boolean)(leftIsScoped ^ rightIsScoped), (String)("All scoped predicates should have exactly one scoped operand, but '" + this.binaryRelOpColRefsToString() + "' has " + (leftIsScoped ? "TWO" : "NONE") + "."));
        operand = binRelOp.getLeftOperand();
        if (operand instanceof ColumnReference && ((ColumnReference)operand).isScoped()) {
            ((ColumnReference)operand).remapColumnReferences();
        } else {
            operand = binRelOp.getRightOperand();
            if (operand instanceof ColumnReference && ((ColumnReference)operand).isScoped()) {
                ((ColumnReference)operand).remapColumnReferences();
            }
        }
        return true;
    }

    protected boolean isScopedToSourceResultSet() throws StandardException {
        if (!this.scoped) {
            return false;
        }
        BinaryRelationalOperatorNode binRelOp = (BinaryRelationalOperatorNode)this.andNode.getLeftOperand();
        ValueNode operand = binRelOp.getLeftOperand();
        if (!(operand instanceof ColumnReference)) {
            return false;
        }
        ValueNode exp = null;
        ColumnReference cRef = (ColumnReference)operand;
        if (cRef.isScoped()) {
            exp = cRef.getSource().getExpression();
            return exp instanceof VirtualColumnNode || exp instanceof ColumnReference;
        }
        operand = binRelOp.getRightOperand();
        if (!(operand instanceof ColumnReference)) {
            return false;
        }
        cRef = (ColumnReference)operand;
        if (!cRef.isScoped()) {
            SanityManager.ASSERT((boolean)cRef.isScoped(), (String)("All scoped predicates should have exactly one scoped operand, but '" + this.binaryRelOpColRefsToString() + "has NONE."));
        }
        return (exp = cRef.getSource().getExpression()) instanceof VirtualColumnNode || exp instanceof ColumnReference;
    }

    protected boolean isRelationalOpPredicate() {
        return this.andNode.getLeftOperand().isRelationalOperator();
    }

    public boolean isInListProbePredicate() {
        return this.andNode.getLeftOperand().isInListProbeNode();
    }

    public InListOperatorNode getSourceInList() {
        return this.getSourceInList(false);
    }

    protected InListOperatorNode getSourceInList(boolean probePredOnly) {
        ValueNode vn = this.andNode.getLeftOperand();
        if (this.isInListProbePredicate()) {
            return ((BinaryRelationalOperatorNode)vn).getInListOp();
        }
        if (probePredOnly) {
            return null;
        }
        if (vn instanceof InListOperatorNode) {
            return (InListOperatorNode)vn;
        }
        return null;
    }

    @Override
    protected void optimizeForOffHeap(boolean shouldOptimize) {
        this.andNode.optimizeForOffHeap(shouldOptimize);
    }

    public int setColocatedWith(Optimizable src, Optimizable tgt, JBitSet srcPCols, JBitSet tgtPCols) throws StandardException {
        this.isColocated = 0;
        BinaryRelationalOperatorNode opNode = (BinaryRelationalOperatorNode)this.getRelop();
        if (this.isJoinPredicate()) {
            int ret = opNode.setColocatedWith(src, tgt, srcPCols, tgtPCols);
            this.isColocated = ret == 0 ? ret : (srcPCols.equals(tgtPCols) ? (srcPCols.hasAllBitSet() && tgtPCols.hasAllBitSet() ? 1 : 2) : ret);
        }
        return this.isColocated;
    }
}

