/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.impl.sql.compile.OrderedColumn;
import com.pivotal.gemfirexd.internal.impl.sql.compile.QueryTreeNodeVector;
import com.pivotal.gemfirexd.internal.impl.sql.execute.IndexColumnOrder;
import java.util.Hashtable;

public abstract class OrderedColumnList
extends QueryTreeNodeVector {
    public IndexColumnOrder[] getColumnOrdering() {
        int numCols = this.size();
        IndexColumnOrder[] ordering = new IndexColumnOrder[numCols];
        Hashtable<Integer, Integer> hashColumns = new Hashtable<Integer, Integer>();
        int actualCols = 0;
        for (int i = 0; i < numCols; ++i) {
            OrderedColumn oc = (OrderedColumn)this.elementAt(i);
            int position = oc.getColumnPosition() - 1;
            Integer posInt = position;
            if (hashColumns.containsKey(posInt)) continue;
            ordering[i] = new IndexColumnOrder(position, oc.isAscending(), oc.isNullsOrderedLow());
            ++actualCols;
            hashColumns.put(posInt, posInt);
        }
        if (actualCols < numCols) {
            IndexColumnOrder[] newOrdering = new IndexColumnOrder[actualCols];
            System.arraycopy(ordering, 0, newOrdering, 0, actualCols);
            ordering = newOrdering;
        }
        return ordering;
    }

    public OrderedColumn getOrderedColumn(int position) {
        SanityManager.ASSERT((position >= 0 && position < this.size() ? 1 : 0) != 0);
        return (OrderedColumn)this.elementAt(position);
    }
}

