/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.catalog.TypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.LocalField;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.MethodBuilder;
import com.pivotal.gemfirexd.internal.iapi.services.i18n.MessageService;
import com.pivotal.gemfirexd.internal.iapi.services.loader.ClassInspector;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.util.JBitSet;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ExpressionClassBuilder;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.JavaValueNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.MethodCallNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SubqueryList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.TableName;
import java.lang.reflect.Member;
import java.util.Vector;

public class NewInvocationNode
extends MethodCallNode {
    private boolean singleInstantiation = false;
    private boolean delimitedIdentifier;
    private boolean isBuiltinVTI = false;

    @Override
    public void init(Object javaClassName, Object params, Object delimitedIdentifier) throws StandardException {
        super.init("<init>");
        this.addParms((Vector)params);
        this.javaClassName = (String)javaClassName;
        this.delimitedIdentifier = (Boolean)delimitedIdentifier;
    }

    @Override
    public void init(Object vtiTableFuncName, Object tableDescriptor, Object params, Object delimitedIdentifier) throws StandardException {
        boolean isTableFunctionVTI;
        super.init("<init>");
        this.addParms((Vector)params);
        SanityManager.ASSERT((vtiTableFuncName == null && tableDescriptor != null || vtiTableFuncName != null && tableDescriptor == null ? 1 : 0) != 0, (String)"Exactly one of vtiTableFuncName or tableDescriptor should be null, but neither or both of them were null.");
        TableName vtiName = (TableName)vtiTableFuncName;
        TableDescriptor td = (TableDescriptor)tableDescriptor;
        boolean bl = isTableFunctionVTI = vtiTableFuncName != null;
        if (isTableFunctionVTI) {
            td = new TableDescriptor(this.getDataDictionary(), vtiName.getTableName(), this.getSchemaDescriptor(vtiName.getSchemaName()), 5, 'R');
        }
        this.javaClassName = this.getDataDictionary().getVTIClass(td, isTableFunctionVTI);
        boolean bl2 = this.isBuiltinVTI = this.getDataDictionary().getBuiltinVTIClass(td, isTableFunctionVTI) != null;
        if (this.javaClassName == null) {
            if (!isTableFunctionVTI) {
                vtiName = this.makeTableName(td.getSchemaName(), td.getDescriptorName());
            }
            throw StandardException.newException(isTableFunctionVTI ? "42Y03" : "42X05", (Object)vtiName.getFullTableName(), (Object)"");
        }
        this.delimitedIdentifier = (Boolean)delimitedIdentifier;
    }

    public boolean isBuiltinVTI() {
        return this.isBuiltinVTI;
    }

    void setSingleInstantiation() {
        this.singleInstantiation = true;
    }

    @Override
    public JavaValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector aggregateVector) throws StandardException {
        TypeDescriptor returnType;
        this.bindParameters(fromList, subqueryList, aggregateVector);
        this.verifyClassExist(this.javaClassName);
        String[] parmTypeNames = this.getObjectSignature();
        boolean[] isParam = this.getIsParam();
        ClassInspector classInspector = this.getClassFactory().getClassInspector();
        try {
            this.method = classInspector.findPublicConstructor(this.javaClassName, parmTypeNames, null, isParam);
            if (this.method == null) {
                String[] primParmTypeNames = this.getPrimitiveSignature(false);
                this.method = classInspector.findPublicConstructor(this.javaClassName, parmTypeNames, primParmTypeNames, isParam);
            }
        }
        catch (ClassNotFoundException e) {
            this.method = null;
        }
        if (this.method == null) {
            String parmTypes = "";
            for (int i = 0; i < parmTypeNames.length; ++i) {
                if (i != 0) {
                    parmTypes = parmTypes + ", ";
                }
                parmTypes = parmTypes + (parmTypeNames[i].length() != 0 ? parmTypeNames[i] : MessageService.getTextMessage("42Z01.U"));
            }
            throw StandardException.newException("42X75", (Object)this.javaClassName, (Object)parmTypes);
        }
        this.methodParameterTypes = classInspector.getParameterTypes(this.method);
        for (int i = 0; i < this.methodParameterTypes.length; ++i) {
            if (!ClassInspector.primitiveType(this.methodParameterTypes[i])) continue;
            this.methodParms[i].castToPrimitive(true);
        }
        if (this.someParametersAreNull()) {
            this.setNullParameterInfo(this.methodParameterTypes);
        }
        SanityManager.ASSERT((boolean)this.javaClassName.equals(classInspector.getType(this.method)), (String)("Constructor is wrong type, expected " + this.javaClassName + " actual is " + classInspector.getType(this.method)));
        this.setJavaTypeName(this.javaClassName);
        if (this.routineInfo != null && (returnType = this.routineInfo.getReturnType()) != null) {
            this.setCollationType(returnType.getCollationType());
        }
        return this;
    }

    @Override
    public boolean categorize(JBitSet referencedTabs, boolean simplePredsOnly) throws StandardException {
        if (simplePredsOnly) {
            return false;
        }
        boolean pushable = true;
        pushable = pushable && super.categorize(referencedTabs, simplePredsOnly);
        return pushable;
    }

    protected boolean assignableTo(String toClassName) throws StandardException {
        ClassInspector classInspector = this.getClassFactory().getClassInspector();
        return classInspector.assignableTo(this.javaClassName, toClassName);
    }

    protected Member findPublicMethod(String methodName, boolean staticMethod) throws StandardException {
        Member publicMethod;
        String[] parmTypeNames = this.getObjectSignature();
        boolean[] isParam = this.getIsParam();
        ClassInspector classInspector = this.getClassFactory().getClassInspector();
        try {
            publicMethod = classInspector.findPublicMethod(this.javaClassName, methodName, parmTypeNames, null, isParam, staticMethod, false);
            if (publicMethod == null) {
                String[] primParmTypeNames = this.getPrimitiveSignature(false);
                publicMethod = classInspector.findPublicMethod(this.javaClassName, methodName, parmTypeNames, primParmTypeNames, isParam, staticMethod, false);
            }
        }
        catch (ClassNotFoundException e) {
            SanityManager.THROWASSERT((String)"Unexpected exception", (Throwable)e);
            return null;
        }
        return publicMethod;
    }

    @Override
    public void generateExpression(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        LocalField objectFieldLF = null;
        if (this.singleInstantiation) {
            objectFieldLF = acb.newFieldDeclaration(2, this.javaClassName);
            mb.getField(objectFieldLF);
            mb.conditionalIfNull();
        }
        mb.pushNewStart(this.javaClassName);
        int nargs = this.generateParameters(acb, mb);
        mb.pushNewComplete(nargs);
        if (this.singleInstantiation) {
            mb.putField(objectFieldLF);
            mb.startElseCode();
            mb.getField(objectFieldLF);
            mb.completeConditional();
        }
    }
}

