/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.CompilerContext;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConglomerateDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SchemaDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ConstantAction;
import com.pivotal.gemfirexd.internal.impl.sql.compile.MiscellaneousStatementNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.TableName;

public class LockTableNode
extends MiscellaneousStatementNode {
    private TableName tableName;
    private boolean exclusiveMode;
    private long conglomerateNumber;
    private TableDescriptor lockTableDescriptor;

    @Override
    public void init(Object tableName, Object exclusiveMode) {
        this.tableName = (TableName)tableName;
        this.exclusiveMode = (Boolean)exclusiveMode;
    }

    @Override
    public String toString() {
        return "tableName: " + this.tableName + "\nexclusiveMode: " + this.exclusiveMode + "\nconglomerateNumber: " + this.conglomerateNumber + "\n" + super.toString();
    }

    @Override
    public String statementToString() {
        return "LOCK TABLE";
    }

    @Override
    public void bindStatement() throws StandardException {
        CompilerContext cc = this.getCompilerContext();
        DataDictionary dd = this.getDataDictionary();
        String schemaName = this.tableName.getSchemaName();
        SchemaDescriptor sd = this.getSchemaDescriptor(schemaName);
        if (sd.isSystemSchema()) {
            throw StandardException.newException("42X62", (Object)this.statementToString(), (Object)schemaName);
        }
        this.lockTableDescriptor = this.getTableDescriptor(this.tableName.getTableName(), sd);
        if (this.lockTableDescriptor == null) {
            TableName synonymTab = this.resolveTableToSynonym(this.tableName);
            if (synonymTab == null) {
                throw StandardException.newException("42X05", this.tableName.getFullTableName());
            }
            this.tableName = synonymTab;
            sd = this.getSchemaDescriptor(this.tableName.getSchemaName());
            this.lockTableDescriptor = this.getTableDescriptor(synonymTab.getTableName(), sd);
            if (this.lockTableDescriptor == null) {
                throw StandardException.newException("42X05", this.tableName.getFullTableName());
            }
        }
        if (this.lockTableDescriptor.getTableType() == 3) {
            throw StandardException.newException("42995");
        }
        this.conglomerateNumber = this.lockTableDescriptor.getHeapConglomerateId();
        ConglomerateDescriptor cd = this.lockTableDescriptor.getConglomerateDescriptor(this.conglomerateNumber);
        cc.createDependency(this.lockTableDescriptor);
        cc.createDependency(cd);
        if (this.isPrivilegeCollectionRequired()) {
            cc.pushCurrentPrivType(0);
            cc.addRequiredTablePriv(this.lockTableDescriptor);
            cc.popCurrentPrivType();
        }
    }

    @Override
    public boolean referencesSessionSchema() throws StandardException {
        return this.isSessionSchema(this.lockTableDescriptor.getSchemaName());
    }

    @Override
    public ConstantAction makeConstantAction() throws StandardException {
        return this.getGenericConstantActionFactory().getLockTableConstantAction(this.tableName.getFullTableName(), this.conglomerateNumber, this.exclusiveMode);
    }
}

