/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.iapi.services.loader.ClassFactory;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.TypeId;
import com.pivotal.gemfirexd.internal.impl.sql.compile.BaseTypeCompiler;

public class LOBTypeCompiler
extends BaseTypeCompiler {
    @Override
    public boolean convertible(TypeId otherType, boolean forDataTypeFunction) {
        int otherJDBCTypeId = otherType.getJDBCTypeId();
        return otherJDBCTypeId == 2004 || otherJDBCTypeId == -2 || otherJDBCTypeId == -3;
    }

    @Override
    public boolean compatible(TypeId otherType) {
        return this.convertible(otherType, false);
    }

    @Override
    public boolean storable(TypeId otherType, ClassFactory cf) {
        int otherJDBCTypeId = otherType.getJDBCTypeId();
        return otherJDBCTypeId == 2004 || otherJDBCTypeId == -2 || otherJDBCTypeId == -3;
    }

    @Override
    public String interfaceName() {
        return "com.pivotal.gemfirexd.internal.iapi.types.BitDataValue";
    }

    @Override
    public String getCorrespondingPrimitiveTypeName() {
        int formatId = this.getStoredFormatIdFromTypeId();
        switch (formatId) {
            case 440: {
                return "java.sql.Blob";
            }
        }
        SanityManager.THROWASSERT((String)("unexpected formatId in getCorrespondingPrimitiveTypeName() - " + formatId));
        return null;
    }

    @Override
    public int getCastToCharWidth(DataTypeDescriptor dts) {
        return dts.getMaximumWidth();
    }

    @Override
    String nullMethodName() {
        int formatId = this.getStoredFormatIdFromTypeId();
        switch (formatId) {
            case 440: {
                return "getNullBlob";
            }
        }
        SanityManager.THROWASSERT((String)("unexpected formatId in nullMethodName() - " + formatId));
        return null;
    }

    @Override
    String dataValueMethodName() {
        int formatId = this.getStoredFormatIdFromTypeId();
        switch (formatId) {
            case 440: {
                return "getBlobDataValue";
            }
        }
        SanityManager.THROWASSERT((String)("unexpected formatId in dataValueMethodName() - " + formatId));
        return null;
    }
}

