/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.MethodBuilder;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.CostEstimate;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Optimizable;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.OptimizablePredicate;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.OptimizablePredicateList;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Optimizer;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.RowOrdering;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Visitable;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Visitor;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.VisitorAdaptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.TypeId;
import com.pivotal.gemfirexd.internal.iapi.util.JBitSet;
import com.pivotal.gemfirexd.internal.iapi.util.PropertyUtil;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ActivationClassBuilder;
import com.pivotal.gemfirexd.internal.impl.sql.compile.AndNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.BinaryComparisonOperatorNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.CollectAndEliminateColumnsVisitor;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ColumnReference;
import com.pivotal.gemfirexd.internal.impl.sql.compile.DMLStatementNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromTable;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromVTI;
import com.pivotal.gemfirexd.internal.impl.sql.compile.GroupByList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.HalfOuterJoinNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.Predicate;
import com.pivotal.gemfirexd.internal.impl.sql.compile.PredicateList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.RemapCRsVisitor;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumn;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumnList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultSetNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SubqueryList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.TableName;
import com.pivotal.gemfirexd.internal.impl.sql.compile.TableOperatorNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.VirtualColumnNode;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Vector;

public class JoinNode
extends TableOperatorNode {
    public static final int INNERJOIN = 1;
    public static final int CROSSJOIN = 2;
    public static final int LEFTOUTERJOIN = 3;
    public static final int RIGHTOUTERJOIN = 4;
    public static final int FULLOUTERJOIN = 5;
    public static final int UNIONJOIN = 6;
    private boolean optimized;
    private PredicateList leftPredicateList;
    private PredicateList rightPredicateList;
    protected boolean flattenableJoin = true;
    Vector aggregateVector;
    SubqueryList subqueryList;
    ValueNode joinClause;
    boolean joinClauseNormalized;
    PredicateList joinPredicates;
    ResultColumnList usingClause;
    Properties joinOrderStrategyProperties;
    private String joinResultSetString = null;

    public String getJoinResultSetString() {
        return this.joinResultSetString;
    }

    public void setJoinResultSetString(String joinResultSetString) {
        this.joinResultSetString = joinResultSetString;
    }

    @Override
    public void init(Object leftResult, Object rightResult, Object onClause, Object usingClause, Object selectList, Object tableProperties, Object joinOrderStrategyProperties) throws StandardException {
        super.init(leftResult, rightResult, tableProperties);
        this.resultColumns = (ResultColumnList)selectList;
        this.joinClause = (ValueNode)onClause;
        this.joinClauseNormalized = false;
        this.usingClause = (ResultColumnList)usingClause;
        this.joinOrderStrategyProperties = (Properties)joinOrderStrategyProperties;
        if (this.resultColumns != null) {
            SanityManager.ASSERT((this.leftResultSet.getReferencedTableMap() != null && this.rightResultSet.getReferencedTableMap() != null || this.leftResultSet.getReferencedTableMap() == null && this.rightResultSet.getReferencedTableMap() == null ? 1 : 0) != 0, (String)"left and right referencedTableMaps are expected to either both be non-null or both be null");
            if (this.leftResultSet.getReferencedTableMap() != null) {
                this.referencedTableMap = (JBitSet)this.leftResultSet.getReferencedTableMap().clone();
                this.referencedTableMap.or(this.rightResultSet.getReferencedTableMap());
            }
        }
        this.joinPredicates = (PredicateList)this.getNodeFactory().getNode(8, this.getContextManager());
    }

    @Override
    public CostEstimate optimizeIt(Optimizer optimizer, OptimizablePredicateList predList, CostEstimate outerCost, RowOrdering rowOrdering) throws StandardException {
        optimizer.trace(27, 0, 0, 0.0, null);
        this.updateBestPlanMap((short)1, this);
        this.leftResultSet = this.optimizeSource(optimizer, this.leftResultSet, this.getLeftPredicateList(), outerCost);
        for (int index = this.joinPredicates.size() - 1; index >= 0; --index) {
            Predicate predicate = (Predicate)this.joinPredicates.elementAt(index);
            if (!predicate.getPushable()) continue;
            this.joinPredicates.removeElementAt(index);
            this.getRightPredicateList().addElement(predicate);
        }
        this.rightResultSet = this.optimizeSource(optimizer, this.rightResultSet, this.getRightPredicateList(), this.leftResultSet.getCostEstimate());
        this.costEstimate = this.getCostEstimate(optimizer);
        this.costEstimate.setCost(this.leftResultSet.getCostEstimate().getEstimatedCost() + this.rightResultSet.getCostEstimate().getEstimatedCost(), this.rightResultSet.getCostEstimate().rowCount(), this.rightResultSet.getCostEstimate().rowCount());
        this.adjustNumberOfRowsReturned(this.costEstimate);
        this.getCurrentAccessPath().getJoinStrategy().estimateCost(this, predList, null, outerCost, optimizer, this.costEstimate);
        optimizer.considerCost(this, predList, this.costEstimate, outerCost);
        if (!this.optimized && this.subqueryList != null) {
            this.subqueryList.optimize(optimizer.getDataDictionary(), this.costEstimate.rowCount());
            this.subqueryList.modifyAccessPaths();
        }
        this.optimized = true;
        return this.costEstimate;
    }

    @Override
    public boolean pushOptPredicate(OptimizablePredicate optimizablePredicate) throws StandardException {
        SanityManager.ASSERT((boolean)(optimizablePredicate instanceof Predicate), (String)"optimizablePredicate expected to be instanceof Predicate");
        SanityManager.ASSERT((!optimizablePredicate.hasSubquery() && !optimizablePredicate.hasMethodCall() ? 1 : 0) != 0, (String)"optimizablePredicate either has a subquery or a method call");
        this.joinPredicates.addPredicate((Predicate)optimizablePredicate);
        RemapCRsVisitor rcrv = new RemapCRsVisitor(true);
        ((Predicate)optimizablePredicate).getAndNode().accept(rcrv);
        return true;
    }

    @Override
    public Optimizable modifyAccessPath(JBitSet outerTables) throws StandardException {
        super.modifyAccessPath(outerTables);
        if (this.getLeftPredicateList().size() != 0) {
            SanityManager.THROWASSERT((String)("getLeftPredicateList().size() expected to be 0, not " + this.getLeftPredicateList().size()));
        }
        if (this.getRightPredicateList().size() != 0) {
            SanityManager.THROWASSERT((String)("getRightPredicateList().size() expected to be 0, not " + this.getRightPredicateList().size()));
        }
        return this;
    }

    protected void adjustNumberOfRowsReturned(CostEstimate costEstimate) {
    }

    @Override
    public ResultColumnList getAllResultColumns(TableName allTableName) throws StandardException {
        if (this.usingClause == null) {
            return this.getAllResultColumnsNoUsing(allTableName);
        }
        ResultSetNode logicalLeftRS = this.getLogicalLeftResultSet();
        ResultColumnList joinRCL = logicalLeftRS.getAllResultColumns(null).getJoinColumns(this.usingClause);
        ResultColumnList leftRCL = this.leftResultSet.getAllResultColumns(allTableName);
        ResultColumnList rightRCL = this.rightResultSet.getAllResultColumns(allTableName);
        if (leftRCL != null) {
            leftRCL.removeJoinColumns(this.usingClause);
        }
        if (rightRCL != null) {
            rightRCL.removeJoinColumns(this.usingClause);
        }
        if (leftRCL == null) {
            rightRCL.resetVirtualColumnIds();
            return rightRCL;
        }
        if (rightRCL == null) {
            leftRCL.resetVirtualColumnIds();
            return leftRCL;
        }
        if (allTableName != null) {
            SanityManager.THROWASSERT((String)("allTableName (" + allTableName + ") expected to be null"));
        }
        joinRCL.destructiveAppend(leftRCL);
        joinRCL.destructiveAppend(rightRCL);
        joinRCL.resetVirtualColumnIds();
        return joinRCL;
    }

    private ResultColumnList getAllResultColumnsNoUsing(TableName allTableName) throws StandardException {
        ResultColumnList leftRCL = this.leftResultSet.getAllResultColumns(allTableName);
        ResultColumnList rightRCL = this.rightResultSet.getAllResultColumns(allTableName);
        if (leftRCL == null) {
            return rightRCL;
        }
        if (rightRCL == null) {
            return leftRCL;
        }
        if (allTableName != null) {
            SanityManager.THROWASSERT((String)("allTableName (" + allTableName + ") expected to be null"));
        }
        ResultColumnList tempList = (ResultColumnList)this.getNodeFactory().getNode(9, this.getContextManager());
        tempList.nondestructiveAppend(leftRCL);
        tempList.nondestructiveAppend(rightRCL);
        return tempList;
    }

    @Override
    public ResultColumn getMatchingColumn(ColumnReference columnReference) throws StandardException {
        ResultSetNode logicalLeftRS = this.getLogicalLeftResultSet();
        ResultSetNode logicalRightRS = this.getLogicalRightResultSet();
        ResultColumn leftRC = null;
        ResultColumn resultColumn = null;
        ResultColumn rightRC = null;
        ResultColumn usingRC = null;
        leftRC = logicalLeftRS.getMatchingColumn(columnReference);
        if (leftRC != null) {
            resultColumn = leftRC;
            if (this.usingClause != null) {
                usingRC = this.usingClause.getResultColumn(leftRC.getName());
            }
        }
        if (usingRC == null) {
            rightRC = logicalRightRS.getMatchingColumn(columnReference);
        }
        if (rightRC != null) {
            if (leftRC != null) {
                throw StandardException.newException("42X03", columnReference.getSQLColumnName());
            }
            resultColumn = rightRC;
        }
        if (this.resultColumns != null) {
            int rclSize = this.resultColumns.size();
            for (int index = 0; index < rclSize; ++index) {
                ResultColumn rc = (ResultColumn)this.resultColumns.elementAt(index);
                VirtualColumnNode vcn = (VirtualColumnNode)rc.getExpression();
                if (resultColumn != vcn.getSourceColumn()) continue;
                resultColumn = rc;
                break;
            }
        }
        return resultColumn;
    }

    @Override
    public void bindResultColumns(FromList fromListParam) throws StandardException {
        super.bindResultColumns(fromListParam);
        this.buildRCL();
        this.deferredBindExpressions(fromListParam);
    }

    @Override
    public void bindResultColumns(TableDescriptor targetTableDescriptor, FromVTI targetVTI, ResultColumnList targetColumnList, DMLStatementNode statement, FromList fromListParam) throws StandardException {
        super.bindResultColumns(targetTableDescriptor, targetVTI, targetColumnList, statement, fromListParam);
        this.buildRCL();
        this.deferredBindExpressions(fromListParam);
    }

    private void buildRCL() throws StandardException {
        if (this.resultColumns != null) {
            return;
        }
        this.resultColumns = this.leftResultSet.getResultColumns();
        ResultColumnList leftRCL = this.resultColumns.copyListAndObjects();
        this.leftResultSet.setResultColumns(leftRCL);
        this.resultColumns.genVirtualColumnNodes(this.leftResultSet, leftRCL, false);
        if (this instanceof HalfOuterJoinNode && ((HalfOuterJoinNode)this).isRightOuterJoin()) {
            this.resultColumns.setNullability(true);
        }
        ResultColumnList tmpRCL = this.rightResultSet.getResultColumns();
        ResultColumnList rightRCL = tmpRCL.copyListAndObjects();
        this.rightResultSet.setResultColumns(rightRCL);
        tmpRCL.genVirtualColumnNodes(this.rightResultSet, rightRCL, false);
        tmpRCL.adjustVirtualColumnIds(this.resultColumns.size());
        if (this instanceof HalfOuterJoinNode && !((HalfOuterJoinNode)this).isRightOuterJoin()) {
            tmpRCL.setNullability(true);
        }
        this.resultColumns.nondestructiveAppend(tmpRCL);
    }

    private void deferredBindExpressions(FromList fromListParam) throws StandardException {
        this.subqueryList = (SubqueryList)this.getNodeFactory().getNode(11, this.getContextManager());
        this.aggregateVector = new Vector();
        if (this.joinClause != null) {
            FromList fromList = (FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this.getContextManager());
            fromList.addElement((FromTable)this.leftResultSet);
            fromList.addElement((FromTable)this.rightResultSet);
            fromListParam.insertElementAt(this.rightResultSet, 0);
            fromListParam.insertElementAt(this.leftResultSet, 0);
            this.joinClause = this.joinClause.bindExpression(fromListParam, this.subqueryList, this.aggregateVector);
            try {
                this.joinClause = this.joinClause.bindExpression(fromList, this.subqueryList, this.aggregateVector);
            }
            catch (StandardException se) {
                if (se.getSQLState().equals("42X04")) {
                    throw StandardException.newException("42972");
                }
                throw se;
            }
            if (this.subqueryList.size() > 0) {
                throw StandardException.newException("42972");
            }
            if (this.aggregateVector.size() > 0) {
                throw StandardException.newException("42Z07");
            }
            fromListParam.removeElementAt(0);
            fromListParam.removeElementAt(0);
        } else if (this.usingClause != null) {
            this.joinClause = (AndNode)this.getNodeFactory().getNode(39, null, null, this.getContextManager());
            AndNode currAnd = (AndNode)this.joinClause;
            ValueNode trueNode = (ValueNode)this.getNodeFactory().getNode(38, Boolean.TRUE, this.getContextManager());
            int usingSize = this.usingClause.size();
            for (int index = 0; index < usingSize; ++index) {
                ResultColumn rc = (ResultColumn)this.usingClause.elementAt(index);
                if (currAnd.getLeftOperand() != null) {
                    currAnd.setRightOperand((AndNode)this.getNodeFactory().getNode(39, null, null, this.getContextManager()));
                    currAnd = (AndNode)currAnd.getRightOperand();
                }
                fromListParam.insertElementAt(this.leftResultSet, 0);
                ColumnReference leftCR = (ColumnReference)this.getNodeFactory().getNode(62, rc.getName(), ((FromTable)this.leftResultSet).getTableName(), this.getContextManager());
                leftCR = (ColumnReference)leftCR.bindExpression(fromListParam, this.subqueryList, this.aggregateVector);
                fromListParam.removeElementAt(0);
                fromListParam.insertElementAt(this.rightResultSet, 0);
                ColumnReference rightCR = (ColumnReference)this.getNodeFactory().getNode(62, rc.getName(), ((FromTable)this.rightResultSet).getTableName(), this.getContextManager());
                rightCR = (ColumnReference)rightCR.bindExpression(fromListParam, this.subqueryList, this.aggregateVector);
                fromListParam.removeElementAt(0);
                BinaryComparisonOperatorNode equalsNode = (BinaryComparisonOperatorNode)this.getNodeFactory().getNode(41, leftCR, rightCR, this.getContextManager());
                equalsNode.bindComparisonOperator();
                currAnd.setLeftOperand(equalsNode);
                currAnd.setRightOperand(trueNode);
                currAnd.postBindFixup();
            }
        }
        if (this.joinClause != null) {
            TypeId joinTypeId;
            if (this.joinClause.requiresTypeFromContext()) {
                this.joinClause.setType(new DataTypeDescriptor(TypeId.BOOLEAN_ID, true));
            }
            if ((joinTypeId = this.joinClause.getTypeId()).userType()) {
                this.joinClause = this.joinClause.genSQLJavaSQLTree();
            }
            if (!this.joinClause.getTypeServices().getTypeId().equals(TypeId.BOOLEAN_ID)) {
                throw StandardException.newException("42Y12", this.joinClause.getTypeServices().getTypeId().getSQLTypeName());
            }
        }
    }

    @Override
    public ResultSetNode preprocess(int numTables, GroupByList gbl, FromList fromList) throws StandardException {
        ResultSetNode newTreeTop = super.preprocess(numTables, gbl, fromList);
        if (this.joinClause != null) {
            this.normExpressions();
            if (this.subqueryList != null) {
                this.joinClause.preprocess(numTables, (FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this.getContextManager()), (SubqueryList)this.getNodeFactory().getNode(11, this.getContextManager()), (PredicateList)this.getNodeFactory().getNode(8, this.getContextManager()));
            }
            this.joinPredicates.pullExpressions(numTables, this.joinClause);
            this.joinPredicates.categorize();
            this.joinClause = null;
        }
        return newTreeTop;
    }

    @Override
    void projectResultColumns() throws StandardException {
        this.leftResultSet.projectResultColumns();
        this.rightResultSet.projectResultColumns();
        this.resultColumns.pullVirtualIsReferenced();
        super.projectResultColumns();
    }

    public void normExpressions() throws StandardException {
        if (this.joinClauseNormalized) {
            return;
        }
        this.joinClause = this.joinClause.eliminateNots(false);
        if (!this.joinClause.verifyEliminateNots()) {
            this.joinClause.treePrint();
            SanityManager.THROWASSERT((String)("joinClause in invalid form: " + this.joinClause));
        }
        this.joinClause = this.joinClause.putAndsOnTop();
        if (!(this.joinClause instanceof AndNode) || !this.joinClause.verifyPutAndsOnTop()) {
            this.joinClause.treePrint();
            SanityManager.THROWASSERT((String)("joinClause in invalid form: " + this.joinClause));
        }
        this.joinClause = this.joinClause.changeToCNF(false);
        if (!(this.joinClause instanceof AndNode) || !this.joinClause.verifyChangeToCNF()) {
            this.joinClause.treePrint();
            SanityManager.THROWASSERT((String)("joinClause in invalid form: " + this.joinClause));
        }
        this.joinClauseNormalized = true;
    }

    @Override
    public void pushExpressions(PredicateList outerPredicateList) throws StandardException {
        FromTable leftFromTable = (FromTable)this.leftResultSet;
        FromTable rightFromTable = (FromTable)this.rightResultSet;
        if (this instanceof HalfOuterJoinNode) {
            SanityManager.THROWASSERT((String)("JN.pushExpressions() not expected to be called for " + this.getClass().getName()));
        }
        this.pushExpressionsToLeft(outerPredicateList);
        leftFromTable.pushExpressions(this.getLeftPredicateList());
        this.pushExpressionsToRight(outerPredicateList);
        rightFromTable.pushExpressions(this.getRightPredicateList());
        this.grabJoinPredicates(outerPredicateList);
        if (this.getLeftPredicateList().size() != 0) {
            SanityManager.THROWASSERT((String)("getLeftPredicateList().size() expected to be 0, not " + this.getLeftPredicateList().size()));
        }
        if (this.getRightPredicateList().size() != 0) {
            SanityManager.THROWASSERT((String)("getRightPredicateList().size() expected to be 0, not " + this.getRightPredicateList().size()));
        }
    }

    protected void pushExpressionsToLeft(PredicateList outerPredicateList) throws StandardException {
        FromTable leftFromTable = (FromTable)this.leftResultSet;
        JBitSet leftReferencedTableMap = leftFromTable.getReferencedTableMap();
        for (int index = outerPredicateList.size() - 1; index >= 0; --index) {
            JBitSet curBitSet;
            Predicate predicate = (Predicate)outerPredicateList.elementAt(index);
            if (!predicate.getPushable() || !leftReferencedTableMap.contains(curBitSet = predicate.getReferencedSet())) continue;
            this.getLeftPredicateList().addPredicate(predicate);
            RemapCRsVisitor rcrv = new RemapCRsVisitor(true);
            predicate.getAndNode().accept(rcrv);
            predicate.getAndNode().accept(rcrv);
            outerPredicateList.removeElementAt(index);
        }
    }

    private void pushExpressionsToRight(PredicateList outerPredicateList) throws StandardException {
        FromTable rightFromTable = (FromTable)this.rightResultSet;
        JBitSet rightReferencedTableMap = rightFromTable.getReferencedTableMap();
        for (int index = outerPredicateList.size() - 1; index >= 0; --index) {
            JBitSet curBitSet;
            Predicate predicate = (Predicate)outerPredicateList.elementAt(index);
            if (!predicate.getPushable() || !rightReferencedTableMap.contains(curBitSet = predicate.getReferencedSet())) continue;
            this.getRightPredicateList().addPredicate(predicate);
            RemapCRsVisitor rcrv = new RemapCRsVisitor(true);
            predicate.getAndNode().accept(rcrv);
            predicate.getAndNode().accept(rcrv);
            outerPredicateList.removeElementAt(index);
        }
    }

    private void grabJoinPredicates(PredicateList outerPredicateList) throws StandardException {
        FromTable leftFromTable = (FromTable)this.leftResultSet;
        FromTable rightFromTable = (FromTable)this.rightResultSet;
        JBitSet leftReferencedTableMap = leftFromTable.getReferencedTableMap();
        JBitSet rightReferencedTableMap = rightFromTable.getReferencedTableMap();
        for (int index = outerPredicateList.size() - 1; index >= 0; --index) {
            Predicate predicate = (Predicate)outerPredicateList.elementAt(index);
            if (!predicate.getPushable()) continue;
            JBitSet curBitSet = predicate.getReferencedSet();
            JBitSet innerBitSet = (JBitSet)rightReferencedTableMap.clone();
            innerBitSet.or(leftReferencedTableMap);
            if (!innerBitSet.contains(curBitSet)) continue;
            this.joinPredicates.addPredicate(predicate);
            RemapCRsVisitor rcrv = new RemapCRsVisitor(true);
            predicate.getAndNode().accept(rcrv);
            predicate.getAndNode().accept(rcrv);
            outerPredicateList.removeElementAt(index);
        }
    }

    @Override
    public FromList flatten(ResultColumnList rcl, PredicateList outerPList, SubqueryList sql, GroupByList gbl) throws StandardException {
        if (this instanceof HalfOuterJoinNode) {
            SanityManager.THROWASSERT((String)("JN.flatten() not expected to be called for " + this.getClass().getName()));
        }
        FromList fromList = (FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this.getContextManager());
        fromList.addElement((FromTable)this.leftResultSet);
        fromList.addElement((FromTable)this.rightResultSet);
        this.resultColumns.setRedundant();
        rcl.remapColumnReferencesToExpressions();
        outerPList.remapColumnReferencesToExpressions();
        if (gbl != null) {
            gbl.remapColumnReferencesToExpressions();
        }
        if (this.joinPredicates.size() > 0) {
            outerPList.destructiveAppend(this.joinPredicates);
        }
        if (this.subqueryList != null && this.subqueryList.size() > 0) {
            sql.destructiveAppend(this.subqueryList);
        }
        return fromList;
    }

    @Override
    public boolean LOJ_reorderable(int numTables) throws StandardException {
        return false;
    }

    @Override
    public FromTable transformOuterJoins(ValueNode predicateTree, int numTables) throws StandardException {
        if (predicateTree == null) {
            return this;
        }
        this.leftResultSet = ((FromTable)this.leftResultSet).transformOuterJoins(predicateTree, numTables);
        this.rightResultSet = ((FromTable)this.rightResultSet).transformOuterJoins(predicateTree, numTables);
        return this;
    }

    @Override
    public void generate(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        this.generateCore(acb, mb, 1, null, null);
    }

    public void generateCore(ActivationClassBuilder acb, MethodBuilder mb, int joinType) throws StandardException {
        this.generateCore(acb, mb, joinType, this.joinClause, this.subqueryList);
    }

    protected void generateCore(ActivationClassBuilder acb, MethodBuilder mb, int joinType, ValueNode joinClause, SubqueryList subquerys) throws StandardException {
        if (this.joinPredicates != null) {
            joinClause = this.joinPredicates.restorePredicates();
            this.joinPredicates = null;
        }
        this.assignResultSetNumber();
        if (subquerys != null && subquerys.size() > 0) {
            subquerys.setPointOfAttachment(this.resultSetNumber);
        }
        if (joinType == 3) {
            this.joinResultSetString = ((Optimizable)((Object)this.rightResultSet)).getTrulyTheBestAccessPath().getJoinStrategy().halfOuterJoinResultSetMethodName();
        } else if (this.joinResultSetString == null) {
            this.joinResultSetString = ((Optimizable)((Object)this.rightResultSet)).getTrulyTheBestAccessPath().getJoinStrategy().joinResultSetMethodName();
        }
        acb.pushGetResultSetFactoryExpression(mb);
        int nargs = this.getJoinArguments(acb, mb, joinClause);
        mb.callMethod((short)185, null, this.joinResultSetString, "com.pivotal.gemfirexd.internal.iapi.sql.execute.NoPutResultSet", nargs);
    }

    private int getJoinArguments(ActivationClassBuilder acb, MethodBuilder mb, ValueNode joinClause) throws StandardException {
        int numArgs = this.getNumJoinArguments();
        this.leftResultSet.generate(acb, mb);
        mb.push(this.leftResultSet.resultColumns.size());
        this.rightResultSet.generate(acb, mb);
        mb.push(this.rightResultSet.resultColumns.size());
        this.costEstimate = this.getFinalCostEstimate();
        if (joinClause == null) {
            mb.pushNull("com.pivotal.gemfirexd.internal.iapi.services.loader.GeneratedMethod");
        } else {
            MethodBuilder userExprFun = acb.newUserExprFun();
            joinClause.generate(acb, userExprFun);
            userExprFun.methodReturn();
            userExprFun.complete();
            acb.pushMethodReference(mb, userExprFun);
        }
        mb.push(this.resultSetNumber);
        this.addOuterJoinArguments(acb, mb);
        this.oneRowRightSide(acb, mb);
        mb.push(this.costEstimate.rowCount());
        mb.push(this.costEstimate.getEstimatedCost());
        if (this.joinOrderStrategyProperties != null) {
            mb.push(PropertyUtil.sortProperties(this.joinOrderStrategyProperties));
        } else {
            mb.pushNull("java.lang.String");
        }
        boolean rsColumnNameSet = false;
        if (SanityManager.DEBUG_ON((String)"PrintRCList")) {
            mb.push(acb.addItem(JoinNode.getTableColumnDetails(this.leftResultSet)));
            mb.push(acb.addItem(JoinNode.getTableColumnDetails(this.rightResultSet)));
            rsColumnNameSet = true;
        }
        if (!rsColumnNameSet) {
            mb.push(-1);
            mb.push(-1);
        }
        return numArgs += 2;
    }

    protected static String[] getTableColumnDetails(ResultSetNode rs) throws StandardException {
        final ArrayList tables = new ArrayList();
        VisitorAdaptor findLeftTables = new VisitorAdaptor(){

            @Override
            public Visitable visit(Visitable node) throws StandardException {
                if (node instanceof FromTable) {
                    tables.add("{" + ((FromTable)node).getCorrelationName() + " " + ((FromTable)node).getOrigTableName() + "}");
                }
                return node;
            }
        };
        rs.accept(findLeftTables);
        String involvedTables = tables.toString();
        String[] leftRSColumns = rs.resultColumns.getColumnNames();
        String[] rsColumnsWithTables = new String[leftRSColumns.length + 1];
        rsColumnsWithTables[0] = involvedTables;
        System.arraycopy(leftRSColumns, 0, rsColumnsWithTables, 1, leftRSColumns.length);
        return rsColumnsWithTables;
    }

    @Override
    public CostEstimate getFinalCostEstimate() throws StandardException {
        if (this.finalCostEstimate != null) {
            return this.finalCostEstimate;
        }
        CostEstimate leftCE = this.leftResultSet.getFinalCostEstimate();
        CostEstimate rightCE = this.rightResultSet.getFinalCostEstimate();
        this.finalCostEstimate = this.getNewCostEstimate();
        this.finalCostEstimate.setCost(leftCE.getEstimatedCost() + rightCE.getEstimatedCost(), rightCE.rowCount(), rightCE.rowCount());
        return this.finalCostEstimate;
    }

    protected void oneRowRightSide(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        mb.push(this.rightResultSet.isOneRowResultSet());
        mb.push(this.rightResultSet.isNotExists());
    }

    protected int getNumJoinArguments() {
        return 11;
    }

    protected int addOuterJoinArguments(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        return 0;
    }

    public static String joinTypeToString(int joinType) {
        switch (joinType) {
            case 1: {
                return "INNER JOIN";
            }
            case 2: {
                return "CROSS JOIN";
            }
            case 3: {
                return "LEFT OUTER JOIN";
            }
            case 4: {
                return "RIGHT OUTER JOIN";
            }
            case 5: {
                return "FULL OUTER JOIN";
            }
            case 6: {
                return "UNION JOIN";
            }
        }
        SanityManager.ASSERT((boolean)false, (String)"Unexpected joinType");
        return null;
    }

    protected PredicateList getLeftPredicateList() throws StandardException {
        if (this.leftPredicateList == null) {
            this.leftPredicateList = (PredicateList)this.getNodeFactory().getNode(8, this.getContextManager());
        }
        return this.leftPredicateList;
    }

    protected PredicateList getRightPredicateList() throws StandardException {
        if (this.rightPredicateList == null) {
            this.rightPredicateList = (PredicateList)this.getNodeFactory().getNode(8, this.getContextManager());
        }
        return this.rightPredicateList;
    }

    @Override
    public int updateTargetLockMode() {
        return 6;
    }

    @Override
    void notFlattenableJoin() {
        this.flattenableJoin = false;
        this.leftResultSet.notFlattenableJoin();
        this.rightResultSet.notFlattenableJoin();
    }

    @Override
    public boolean isFlattenableJoinNode() {
        return this.flattenableJoin;
    }

    @Override
    boolean isOrderedOn(ColumnReference[] crs, boolean permuteOrdering, Vector fbtVector) throws StandardException {
        return this.leftResultSet.isOrderedOn(crs, permuteOrdering, fbtVector);
    }

    @Override
    public void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this.subqueryList != null) {
            this.printLabel(depth, "subqueryList: ");
            this.subqueryList.treePrint(depth + 1);
        }
        if (this.joinClause != null) {
            this.printLabel(depth, "joinClause: ");
            this.joinClause.treePrint(depth + 1);
        }
        if (this.joinPredicates.size() != 0) {
            this.printLabel(depth, "joinPredicates: ");
            this.joinPredicates.treePrint(depth + 1);
        }
        if (this.usingClause != null) {
            this.printLabel(depth, "usingClause: ");
            this.usingClause.treePrint(depth + 1);
        }
    }

    void setSubqueryList(SubqueryList subqueryList) {
        this.subqueryList = subqueryList;
    }

    void setAggregateVector(Vector aggregateVector) {
        this.aggregateVector = aggregateVector;
    }

    ResultSetNode getLogicalLeftResultSet() {
        return this.leftResultSet;
    }

    ResultSetNode getLogicalRightResultSet() {
        return this.rightResultSet;
    }

    @Override
    public Visitable accept(Visitor v) throws StandardException {
        if (v.skipChildren(this)) {
            return v.visit(this);
        }
        Visitable returnNode = super.accept(v);
        if (this.resultColumns != null && !v.stopTraversal()) {
            this.resultColumns = (ResultColumnList)this.resultColumns.accept(v);
        }
        if (this.joinClause != null && !v.stopTraversal()) {
            this.joinClause = (ValueNode)this.joinClause.accept(v);
        }
        if (this.usingClause != null && !v.stopTraversal()) {
            this.usingClause = (ResultColumnList)this.usingClause.accept(v);
        }
        return returnNode;
    }

    @Override
    public JBitSet LOJgetReferencedTables(int numTables) throws StandardException {
        JBitSet map = new JBitSet(numTables);
        map = this.leftResultSet.LOJgetReferencedTables(numTables);
        if (map == null) {
            return null;
        }
        map.or(this.rightResultSet.LOJgetReferencedTables(numTables));
        return map;
    }

    @Override
    public void collectHashKeyColumns(Vector hashKeyVector, int tabNum, int colNum) throws StandardException {
        if (tabNum == -1 || colNum == -1) {
            return;
        }
        int colLength = this.getNumColumnsReturned();
        for (int colCtr = 0; colCtr < colLength; ++colCtr) {
            ResultColumn resCol = (ResultColumn)this.resultColumns.elementAt(colCtr);
            if (resCol.getTableNumber() != tabNum || resCol.getColumnPosition() != colNum) continue;
            hashKeyVector.addElement(colCtr);
        }
    }

    @Override
    public int convertAbsoluteToRelativeColumnPosition(int absolutePosition, ColumnReference ref) {
        if (ref != null) {
            int colLength = this.getNumColumnsReturned();
            for (int colCtr = 0; colCtr < colLength; ++colCtr) {
                ResultColumn resCol = (ResultColumn)this.resultColumns.elementAt(colCtr);
                try {
                    if (resCol.getTableNumber() == ref.getTableNumber() && resCol.getColumnPosition() == ref.getColumnNumber()) {
                        return colCtr;
                    }
                    continue;
                }
                catch (StandardException e) {
                    e.printStackTrace();
                }
            }
        }
        return absolutePosition;
    }

    @Override
    public void eliminateUnUsedColumns(ResultColumnList parentResultColumn, CollectAndEliminateColumnsVisitor finder) throws StandardException {
        super.eliminateUnUsedColumns(this.resultColumns.mergeColumnList(parentResultColumn, this.leftPredicateList, this.rightPredicateList, this.joinPredicates, this.usingClause), finder);
    }

    @Override
    protected void optimizeForOffHeap(boolean shouldOptimize) {
        this.leftResultSet.optimizeForOffHeap(true);
        this.rightResultSet.optimizeForOffHeap(true);
    }

    @Override
    protected boolean isJoinNode() {
        return true;
    }
}

