/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.MethodBuilder;
import com.pivotal.gemfirexd.internal.impl.sql.compile.BinaryLogicalOperatorNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ExpressionClassBuilder;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SubqueryList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNode;
import java.util.Vector;

public class IsNode
extends BinaryLogicalOperatorNode {
    private boolean notMe;

    @Override
    public void init(Object leftOperand, Object rightOperand, Object notMe) {
        super.init(leftOperand, rightOperand, "is");
        this.notMe = (Boolean)notMe;
    }

    @Override
    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector aggregateVector) throws StandardException {
        super.bindExpression(fromList, subqueryList, aggregateVector);
        this.leftOperand.checkIsBoolean();
        this.rightOperand.checkIsBoolean();
        this.setType(this.leftOperand.getTypeServices());
        return this;
    }

    @Override
    public ValueNode eliminateNots(boolean underNotNode) throws StandardException {
        if (underNotNode) {
            this.notMe = !this.notMe;
        }
        this.leftOperand = this.leftOperand.eliminateNots(false);
        this.rightOperand = this.rightOperand.eliminateNots(false);
        return this;
    }

    @Override
    public ValueNode putAndsOnTop() throws StandardException {
        this.leftOperand = this.leftOperand.putAndsOnTop();
        this.rightOperand = this.rightOperand.putAndsOnTop();
        return this;
    }

    @Override
    public boolean verifyPutAndsOnTop() {
        return this.leftOperand.verifyPutAndsOnTop() && this.rightOperand.verifyPutAndsOnTop();
    }

    @Override
    public ValueNode changeToCNF(boolean underTopAndNode) throws StandardException {
        this.leftOperand = this.leftOperand.changeToCNF(false);
        this.rightOperand = this.rightOperand.changeToCNF(false);
        return this;
    }

    @Override
    public boolean verifyChangeToCNF() {
        return this.leftOperand.verifyChangeToCNF() && this.rightOperand.verifyChangeToCNF();
    }

    @Override
    public void generateExpression(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        String evaluatorMethodName = this.notMe ? "isNot" : "is";
        this.leftOperand.generateExpression(acb, mb);
        this.rightOperand.generateExpression(acb, mb);
        mb.callMethod((short)185, "com.pivotal.gemfirexd.internal.iapi.types.BooleanDataValue", evaluatorMethodName, "com.pivotal.gemfirexd.internal.iapi.types.BooleanDataValue", 1);
    }
}

