/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.Constants;
import com.pivotal.gemfirexd.internal.catalog.TypeDescriptor;
import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.catalog.types.RoutineAliasInfo;
import com.pivotal.gemfirexd.internal.engine.GfxdVTITemplate;
import com.pivotal.gemfirexd.internal.engine.GfxdVTITemplateNoAllNodesRoute;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfoContext;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.LocalField;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.MethodBuilder;
import com.pivotal.gemfirexd.internal.iapi.services.io.DynamicByteArrayOutputStream;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatIdOutputStream;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatIdUtil;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableHashtable;
import com.pivotal.gemfirexd.internal.iapi.services.loader.ClassInspector;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.CompilerContext;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.CostEstimate;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Optimizable;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.OptimizablePredicate;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.OptimizablePredicateList;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Optimizer;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.RowOrdering;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Visitable;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Visitor;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ColumnDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ColumnDescriptorList;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConglomerateDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecutionContext;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.util.JBitSet;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ActivationClassBuilder;
import com.pivotal.gemfirexd.internal.impl.sql.compile.CollectNodesVisitor;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ColumnReference;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromTable;
import com.pivotal.gemfirexd.internal.impl.sql.compile.GroupByList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.JavaValueNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.MethodCallNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.NewInvocationNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ParameterNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.Predicate;
import com.pivotal.gemfirexd.internal.impl.sql.compile.PredicateList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.RemapCRsVisitor;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumn;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumnList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultSetNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SubqueryList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.TableName;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNode;
import com.pivotal.gemfirexd.internal.vti.DeferModification;
import com.pivotal.gemfirexd.internal.vti.VTICosting;
import com.pivotal.gemfirexd.internal.vti.VTIEnvironment;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Vector;

public class FromVTI
extends FromTable
implements VTIEnvironment {
    JBitSet correlationMap;
    JBitSet dependencyMap;
    MethodCallNode methodCall;
    TableName exposedName;
    SubqueryList subqueryList;
    boolean implementsVTICosting;
    boolean optimized;
    boolean materializable;
    boolean isTarget;
    boolean isDerbyStyleTableFunction;
    ResultSet rs;
    private FormatableHashtable compileTimeConstants;
    protected int numVTICols;
    private PredicateList restrictionList;
    private boolean forUpdatePresent;
    private boolean emptyForUpdate;
    double estimatedCost = 100000.0;
    double estimatedRowCount = 10000.0;
    boolean supportsMultipleInstantiations = true;
    boolean vtiCosted;
    protected boolean version2;
    private boolean implementsPushable;
    private PreparedStatement ps;
    private JavaValueNode[] methodParms;
    private boolean controlsDeferral;
    private boolean isInsensitive;
    private int resultSetType = 1003;
    private boolean isVTIDistributable;
    private boolean isGFXDVTI;
    static final String validQueryHintProperites = (Object)((Object)Constants.QueryHints.joinStrategy) + "," + (Object)((Object)Constants.QueryHints.hashInitialCapacity) + "," + (Object)((Object)Constants.QueryHints.hashLoadFactor) + "," + (Object)((Object)Constants.QueryHints.hashMaxCapacity) + "," + (Object)((Object)Constants.QueryHints.withSecondaries) + "," + (Object)((Object)Constants.QueryHints.sizerHints) + "," + (Object)((Object)Constants.QueryHints.queryHDFS);

    @Override
    public void init(Object invocation, Object correlationName, Object derivedRCL, Object tableProperties) throws StandardException {
        this.init(invocation, correlationName, derivedRCL, tableProperties, this.makeTableName(null, (String)correlationName));
    }

    @Override
    public void init(Object invocation, Object correlationName, Object derivedRCL, Object tableProperties, Object exposedTableName) throws StandardException {
        super.init(correlationName, tableProperties);
        this.methodCall = (MethodCallNode)invocation;
        this.resultColumns = (ResultColumnList)derivedRCL;
        this.subqueryList = (SubqueryList)this.getNodeFactory().getNode(11, this.getContextManager());
        this.exposedName = (TableName)exposedTableName;
    }

    @Override
    public CostEstimate estimateCost(OptimizablePredicateList predList, ConglomerateDescriptor cd, CostEstimate outerCost, Optimizer optimizer, RowOrdering rowOrdering) throws StandardException {
        this.costEstimate = this.getCostEstimate(optimizer);
        if (this.implementsVTICosting && !this.vtiCosted) {
            try {
                VTICosting vtic = this.getVTICosting();
                this.estimatedCost = vtic.getEstimatedCostPerInstantiation(this);
                this.estimatedRowCount = vtic.getEstimatedRowCount(this);
                this.supportsMultipleInstantiations = vtic.supportsMultipleInstantiations(this);
                if (this.ps != null) {
                    this.ps.close();
                    this.ps = null;
                }
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
            }
            catch (SQLException sqle) {
                throw StandardException.unexpectedUserException(sqle);
            }
            this.vtiCosted = true;
        }
        this.costEstimate.setCost(this.estimatedCost, this.estimatedRowCount, this.estimatedRowCount);
        if (this.getCurrentAccessPath().getJoinStrategy().multiplyBaseCostByOuterRows()) {
            this.costEstimate.multiply(outerCost.rowCount(), this.costEstimate);
        }
        if (!this.optimized) {
            this.subqueryList.optimize(optimizer.getDataDictionary(), this.costEstimate.rowCount());
            this.subqueryList.modifyAccessPaths();
        }
        this.optimized = true;
        return this.costEstimate;
    }

    @Override
    public boolean legalJoinOrder(JBitSet assignedTableMap) {
        JBitSet tempBitSet = assignedTableMap;
        tempBitSet.or(this.correlationMap);
        return tempBitSet.contains(this.dependencyMap);
    }

    @Override
    public boolean isMaterializable() {
        return this.materializable;
    }

    @Override
    public boolean supportsMultipleInstantiations() {
        return this.supportsMultipleInstantiations;
    }

    @Override
    public void adjustForSortElimination() {
    }

    @Override
    public Optimizable modifyAccessPath(JBitSet outerTables) throws StandardException {
        if (this.rs != null) {
            try {
                this.rs.close();
                this.rs = null;
            }
            catch (Throwable t) {
                throw StandardException.unexpectedUserException(t);
            }
        }
        return super.modifyAccessPath(outerTables);
    }

    @Override
    public boolean pushOptPredicate(OptimizablePredicate optimizablePredicate) throws StandardException {
        if (!this.implementsPushable) {
            return false;
        }
        if (!optimizablePredicate.getReferencedMap().hasSingleBitSet()) {
            return false;
        }
        if (this.restrictionList == null) {
            this.restrictionList = (PredicateList)this.getNodeFactory().getNode(8, this.getContextManager());
        }
        this.restrictionList.addPredicate((Predicate)optimizablePredicate);
        return true;
    }

    @Override
    public void verifyProperties(DataDictionary dDictionary) throws StandardException {
        if (this.tableProperties == null) {
            return;
        }
        boolean indexSpecified = false;
        Enumeration<Object> e = this.tableProperties.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = (String)this.tableProperties.get(key);
            if (key.equals(Constants.QueryHints.joinStrategy.name())) {
                this.setUserSpecifiedJoinStrategy(value);
                continue;
            }
            if (key.equals(Constants.QueryHints.hashInitialCapacity.name())) {
                this.initialCapacity = this.getIntProperty(value, key);
                if (this.initialCapacity > 0) continue;
                throw StandardException.newException("42Y59", String.valueOf(this.initialCapacity));
            }
            if (key.equals(Constants.QueryHints.hashLoadFactor.name())) {
                try {
                    this.loadFactor = Float.valueOf(value).floatValue();
                }
                catch (NumberFormatException nfe) {
                    throw StandardException.newException("42Y58", (Object)value, (Object)key);
                }
                if (!((double)this.loadFactor <= 0.0) && !((double)this.loadFactor > 1.0)) continue;
                throw StandardException.newException("42Y60", value);
            }
            if (key.equals(Constants.QueryHints.hashMaxCapacity.name())) {
                this.maxCapacity = this.getIntProperty(value, key);
                if (this.maxCapacity > 0) continue;
                throw StandardException.newException("42Y61", String.valueOf(this.maxCapacity));
            }
            if (key.equals(Constants.QueryHints.withSecondaries.name())) {
                this.explicitSecondaryBucketSet = true;
                this.includeSecondaryBuckets = Misc.parseBoolean(value);
                CompilerContext cc = this.getCompilerContext();
                cc.setOptimizeForWrite(!this.includeSecondaryBuckets);
                cc.setWithSecondaries(this.includeSecondaryBuckets);
                if (value.length() <= 0) continue;
                this.setSharedState(Constants.QueryHints.withSecondaries.name(), (Serializable)((Object)Boolean.toString(this.includeSecondaryBuckets)));
                continue;
            }
            if (key.equals(Constants.QueryHints.sizerHints.name())) {
                if (value == null || value.length() <= 0) {
                    SanityManager.DEBUG_PRINT((String)"warning:objectsizer: ", (String)"sizer hint is blank.");
                }
                String[] valConstants = value.split(";");
                StringBuilder sb = new StringBuilder();
                for (String v : valConstants) {
                    if (v == null || v.length() <= 0) continue;
                    try {
                        Constants.QueryHints.SizerHints hint = Constants.QueryHints.SizerHints.valueOf(v.trim());
                        sb.append(hint.name()).append(",");
                    }
                    catch (IllegalArgumentException warn) {
                        throw StandardException.newException("42X67", v);
                    }
                }
                this.setSharedState("gemfirexd.__rt..sizerHints", (Serializable)((Object)sb.toString()));
                continue;
            }
            if (key.equals(Constants.QueryHints.queryHDFS.name())) {
                this.queryHDFS = Misc.parseBoolean(value);
                this.getCompilerContext().setQueryHDFS(this.queryHDFS);
                this.getCompilerContext().setHasQueryHDFS(true);
                continue;
            }
            throw StandardException.newException("42Y44", (Object)key, (Object)validQueryHintProperites);
        }
    }

    @Override
    public String toString() {
        return "materializable: " + this.materializable + "\n" + super.toString();
    }

    @Override
    public void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this.methodCall != null) {
            this.printLabel(depth, "methodCall: ");
            this.methodCall.treePrint(depth + 1);
        }
        if (this.exposedName != null) {
            this.printLabel(depth, "exposedName: ");
            this.exposedName.treePrint(depth + 1);
        }
        if (this.subqueryList != null) {
            this.printLabel(depth, "subqueryList: ");
            this.subqueryList.treePrint(depth + 1);
        }
    }

    public boolean isConstructor() {
        return this.methodCall instanceof NewInvocationNode;
    }

    public MethodCallNode getMethodCall() {
        return this.methodCall;
    }

    @Override
    public String getExposedName() {
        return this.correlationName;
    }

    public TableName getExposedTableName() {
        return this.exposedName;
    }

    void setTarget() {
        this.isTarget = true;
        this.version2 = true;
    }

    @Override
    public ResultSetNode bindNonVTITables(DataDictionary dataDictionary, FromList fromListParam) throws StandardException {
        if (this.tableNumber == -1) {
            this.tableNumber = this.getCompilerContext().getNextTableNumber();
        }
        return this;
    }

    String getVTIName() {
        return this.methodCall.getJavaClassName();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ResultSetNode bindVTITables(FromList fromListParam) throws StandardException {
        UUID triggerTableId;
        ResultColumnList derivedRCL = this.resultColumns;
        LanguageConnectionContext lcc = this.getLanguageConnectionContext();
        Vector aggregateVector = new Vector();
        this.methodCall.bindExpression(fromListParam, this.subqueryList, aggregateVector);
        this.methodParms = this.methodCall.getMethodParms();
        RoutineAliasInfo routineInfo = this.methodCall.getRoutineInfo();
        if (routineInfo != null && routineInfo.getReturnType().isRowMultiSet() && routineInfo.getParameterStyle() == 1) {
            this.isDerbyStyleTableFunction = true;
        }
        if (this.isConstructor()) {
            NewInvocationNode constructor = (NewInvocationNode)this.methodCall;
            if (!constructor.assignableTo("java.sql.PreparedStatement")) {
                if (this.version2) {
                    if (!constructor.assignableTo("java.sql.ResultSet")) throw StandardException.newException("42X08", (Object)this.getVTIName(), (Object)"java.sql.PreparedStatement");
                    this.version2 = false;
                } else if (!constructor.assignableTo("java.sql.ResultSet")) {
                    throw StandardException.newException("42X08", (Object)this.getVTIName(), (Object)"java.sql.ResultSet");
                }
            } else {
                this.version2 = true;
            }
            this.isGFXDVTI = constructor.assignableTo(GfxdVTITemplate.class.getName());
            if (this.version2 || this.isGFXDVTI) {
                this.implementsPushable = constructor.assignableTo("com.pivotal.gemfirexd.internal.vti.IQualifyable");
            }
            this.implementsVTICosting = constructor.assignableTo("com.pivotal.gemfirexd.internal.vti.VTICosting");
            boolean bl = this.isVTIDistributable = this.isGFXDVTI && !constructor.assignableTo(GfxdVTITemplateNoAllNodesRoute.class.getName());
        }
        if (this.isDerbyStyleTableFunction) {
            this.implementsVTICosting = this.implementsDerbyStyleVTICosting(this.methodCall.getJavaClassName());
        }
        if (this.isConstructor() && (triggerTableId = this.getSpecialTriggerVTITableName(lcc, this.methodCall.getJavaClassName())) != null) {
            TableDescriptor td = this.getDataDictionary().getTableDescriptor(triggerTableId);
            this.resultColumns = this.genResultColList(td);
            this.vtiCosted = true;
            this.estimatedCost = 50.0;
            this.estimatedRowCount = 5.0;
            this.supportsMultipleInstantiations = true;
        } else {
            this.resultColumns = (ResultColumnList)this.getNodeFactory().getNode(9, this.getContextManager());
            if (this.isDerbyStyleTableFunction) {
                this.createResultColumnsForTableFunction(routineInfo.getReturnType());
            } else {
                ResultSetMetaData rsmd = this.getResultSetMetaData();
                if (rsmd == null) {
                    throw StandardException.newException("42X43", this.getVTIName());
                }
                try {
                    this.numVTICols = rsmd.getColumnCount();
                }
                catch (SQLException sqle) {
                    this.numVTICols = 0;
                }
                this.resultColumns.createListFromResultSetMetaData(rsmd, this.exposedName, this.getVTIName());
            }
        }
        this.numVTICols = this.resultColumns.size();
        if (derivedRCL == null) return this;
        this.resultColumns.propagateDCLInfo(derivedRCL, this.correlationName);
        return this;
    }

    public ResultSetMetaData getResultSetMetaData() throws StandardException {
        ResultSetMetaData rsmd;
        block10: {
            rsmd = null;
            try {
                if (this.version2) {
                    this.ps = (PreparedStatement)this.getNewInstance();
                    if (this.ps.getResultSetConcurrency() != 1008) {
                        throw StandardException.newException("42Z90", this.getVTIName());
                    }
                    rsmd = this.ps.getMetaData();
                    this.controlsDeferral = this.ps instanceof DeferModification;
                    try {
                        this.resultSetType = this.ps.getResultSetType();
                    }
                    catch (SQLException sQLException) {
                    }
                    catch (AbstractMethodError abstractMethodError) {
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        // empty catch block
                    }
                    boolean bl = this.isInsensitive = this.resultSetType == 1004;
                    if (!this.implementsVTICosting) {
                        this.ps.close();
                        this.ps = null;
                    }
                    break block10;
                }
                this.rs = (ResultSet)this.getNewInstance();
                rsmd = this.rs.getMetaData();
                if (!this.implementsVTICosting) {
                    this.rs.close();
                    this.rs = null;
                }
            }
            catch (Throwable t) {
                throw StandardException.unexpectedUserException(t);
            }
        }
        return rsmd;
    }

    private Object getNewInstance() throws StandardException {
        NewInvocationNode constructor = (NewInvocationNode)this.methodCall;
        Class[] paramTypeClasses = constructor.getMethodParameterClasses();
        Object[] paramObjects = null;
        if (paramTypeClasses != null) {
            paramObjects = new Object[paramTypeClasses.length];
            for (int index = 0; index < paramTypeClasses.length; ++index) {
                Class paramClass = paramTypeClasses[index];
                paramObjects[index] = this.methodParms[index].getConstantValueAsObject();
                if (paramObjects[index] != null && paramClass.isPrimitive()) {
                    if (paramClass.equals(Short.TYPE)) {
                        paramObjects[index] = ((Integer)paramObjects[index]).shortValue();
                    } else if (paramClass.equals(Byte.TYPE)) {
                        paramObjects[index] = ((Integer)paramObjects[index]).byteValue();
                    }
                }
                if (paramObjects[index] != null || !paramClass.isPrimitive()) continue;
                if (paramClass.equals(Integer.TYPE)) {
                    paramObjects[index] = 0;
                    continue;
                }
                if (paramClass.equals(Short.TYPE)) {
                    paramObjects[index] = (short)0;
                    continue;
                }
                if (paramClass.equals(Byte.TYPE)) {
                    paramObjects[index] = (byte)0;
                    continue;
                }
                if (paramClass.equals(Long.TYPE)) {
                    paramObjects[index] = 0L;
                    continue;
                }
                if (paramClass.equals(Float.TYPE)) {
                    paramObjects[index] = new Float(0.0f);
                    continue;
                }
                if (paramClass.equals(Double.TYPE)) {
                    paramObjects[index] = new Double(0.0);
                    continue;
                }
                if (paramClass.equals(Boolean.TYPE)) {
                    paramObjects[index] = Boolean.FALSE;
                    continue;
                }
                if (!paramClass.equals(Character.TYPE)) continue;
                paramObjects[index] = Character.valueOf('\u0000');
            }
        } else {
            paramTypeClasses = new Class[]{};
            paramObjects = new Object[]{};
        }
        try {
            ClassInspector classInspector = this.getClassFactory().getClassInspector();
            String javaClassName = this.methodCall.getJavaClassName();
            Constructor constr = classInspector.getClass(javaClassName).getConstructor(paramTypeClasses);
            return constr.newInstance(paramObjects);
        }
        catch (Throwable t) {
            if (t instanceof InvocationTargetException) {
                InvocationTargetException ite = (InvocationTargetException)t;
                Throwable wrappedThrowable = ite.getTargetException();
                if (wrappedThrowable instanceof StandardException) {
                    throw (StandardException)wrappedThrowable;
                }
                if (wrappedThrowable instanceof SQLException) {
                    throw Misc.wrapSQLException((SQLException)wrappedThrowable, wrappedThrowable);
                }
            }
            throw StandardException.unexpectedUserException(t);
        }
    }

    public DeferModification getDeferralControl() throws StandardException {
        if (!this.controlsDeferral) {
            return null;
        }
        try {
            return (DeferModification)this.getNewInstance();
        }
        catch (Throwable t) {
            throw StandardException.unexpectedUserException(t);
        }
    }

    public int getResultSetType() {
        return this.resultSetType;
    }

    @Override
    public void bindExpressions(FromList fromListParam) throws StandardException {
        ResultColumnList derivedRCL = this.resultColumns;
        this.materializable = this.methodCall.areParametersQueryInvariant();
        Vector colRefs = this.getNodesFromParameters(ColumnReference.class);
        Vector aggregateVector = null;
        Enumeration e = colRefs.elements();
        while (e.hasMoreElements()) {
            ColumnReference ref = (ColumnReference)e.nextElement();
            if (ref.getTableNumber() != -1) continue;
            if (aggregateVector == null) {
                aggregateVector = new Vector();
            }
            ref.bindExpression(fromListParam, this.subqueryList, aggregateVector);
        }
    }

    Vector getNodesFromParameters(Class nodeClass) throws StandardException {
        CollectNodesVisitor getCRs = new CollectNodesVisitor(nodeClass);
        this.methodCall.accept(getCRs);
        return getCRs.getList();
    }

    @Override
    public ResultColumnList getAllResultColumns(TableName allTableName) throws StandardException {
        ResultColumnList rcList = null;
        TableName toCompare = allTableName != null ? this.makeTableName(allTableName.getSchemaName(), this.correlationName) : this.makeTableName(null, this.correlationName);
        if (allTableName != null && !allTableName.equals(toCompare)) {
            return null;
        }
        rcList = (ResultColumnList)this.getNodeFactory().getNode(9, this.getContextManager());
        int rclSize = this.resultColumns.size();
        for (int index = 0; index < rclSize; ++index) {
            ResultColumn resultColumn = (ResultColumn)this.resultColumns.elementAt(index);
            if (resultColumn.isGenerated()) continue;
            String columnName = resultColumn.getName();
            ValueNode valueNode = (ValueNode)this.getNodeFactory().getNode(62, columnName, this.exposedName, this.getContextManager());
            resultColumn = (ResultColumn)this.getNodeFactory().getNode(80, columnName, valueNode, this.getContextManager());
            rcList.addResultColumn(resultColumn);
        }
        return rcList;
    }

    @Override
    public ResultColumn getMatchingColumn(ColumnReference columnReference) throws StandardException {
        if (this.resultColumns == null) {
            return null;
        }
        ResultColumn resultColumn = null;
        TableName columnsTableName = columnReference.getTableNameNode();
        if ((columnsTableName == null || columnsTableName.equals(this.exposedName)) && (resultColumn = this.resultColumns.getResultColumn(columnReference.getColumnName())) != null) {
            columnReference.setTableNumber(this.tableNumber);
        }
        return resultColumn;
    }

    @Override
    public ResultSetNode preprocess(int numTables, GroupByList gbl, FromList fromList) throws StandardException {
        this.methodCall.preprocess(numTables, (FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this.getContextManager()), (SubqueryList)this.getNodeFactory().getNode(11, this.getContextManager()), (PredicateList)this.getNodeFactory().getNode(8, this.getContextManager()));
        this.referencedTableMap = new JBitSet(numTables);
        this.referencedTableMap.set(this.tableNumber);
        this.dependencyMap = new JBitSet(numTables);
        this.methodCall.categorize(this.dependencyMap, false);
        this.dependencyMap.clear(this.tableNumber);
        this.correlationMap = new JBitSet(numTables);
        this.methodCall.getCorrelationTables(this.correlationMap);
        return this.genProjectRestrict(numTables);
    }

    @Override
    protected ResultSetNode genProjectRestrict(int numTables) throws StandardException {
        ResultColumnList prRCList = this.resultColumns;
        this.resultColumns = this.resultColumns.copyListAndObjects();
        prRCList.genVirtualColumnNodes(this, this.resultColumns, false);
        prRCList.doProjection();
        return (ResultSetNode)this.getNodeFactory().getNode(151, this, prRCList, null, null, null, null, this.tableProperties, this.getContextManager());
    }

    @Override
    public boolean performMaterialization(JBitSet outerTables) throws StandardException {
        return outerTables.getFirstSetBit() != -1 && !outerTables.hasSingleBitSet() && !this.getTrulyTheBestAccessPath().getJoinStrategy().doesMaterialization() && this.isMaterializable() && !this.supportsMultipleInstantiations;
    }

    @Override
    public void generate(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        RemapCRsVisitor rcrv = new RemapCRsVisitor(true);
        this.methodCall.accept(rcrv);
        this.assignResultSetNumber();
        acb.pushGetResultSetFactoryExpression(mb);
        int nargs = this.getScanArguments(acb, mb);
        mb.callMethod((short)185, null, "getVTIResultSet", "com.pivotal.gemfirexd.internal.iapi.sql.execute.NoPutResultSet", nargs);
    }

    private int getScanArguments(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        int rclSize = this.resultColumns.size();
        FormatableBitSet referencedCols = new FormatableBitSet(rclSize);
        int erdNumber = -1;
        int numSet = 0;
        this.costEstimate = this.getFinalCostEstimate();
        for (int index = 0; index < rclSize; ++index) {
            ResultColumn rc = (ResultColumn)this.resultColumns.elementAt(index);
            if (!rc.isReferenced()) continue;
            referencedCols.set(index);
            ++numSet;
        }
        if (numSet != this.numVTICols) {
            erdNumber = acb.addItem(referencedCols);
        }
        int ctcNumber = acb.addItem(this.compileTimeConstants);
        acb.pushThisAsActivation(mb);
        this.resultColumns.generateHolder(acb, mb);
        boolean reuseablePs = this.version2 && this.getNodesFromParameters(ParameterNode.class).size() == 0 && this.getNodesFromParameters(ColumnReference.class).size() == 0;
        mb.push(this.resultSetNumber);
        this.generateConstructor(acb, mb, reuseablePs);
        mb.push(this.methodCall.getJavaClassName());
        if (this.restrictionList != null) {
            this.restrictionList.generateQualifiers(acb, mb, this, true);
        } else {
            mb.pushNull("com.pivotal.gemfirexd.internal.iapi.store.access.Qualifier[][]");
        }
        mb.push(erdNumber);
        mb.push(this.version2);
        mb.push(reuseablePs);
        mb.push(ctcNumber);
        mb.push(this.isTarget);
        mb.push(this.getCompilerContext().getScanIsolationLevel());
        mb.push(this.costEstimate.rowCount());
        mb.push(this.costEstimate.getEstimatedCost());
        mb.push(this.isDerbyStyleTableFunction);
        if (this.isDerbyStyleTableFunction) {
            String returnType = this.freezeReturnType(this.methodCall.getRoutineInfo().getReturnType());
            mb.push(returnType);
        } else {
            mb.pushNull(String.class.getName());
        }
        return 16;
    }

    private void generateConstructor(ActivationClassBuilder acb, MethodBuilder mb, boolean reuseablePs) throws StandardException {
        LocalField psHolder;
        String vtiType = this.version2 ? "java.sql.PreparedStatement" : "java.sql.ResultSet";
        MethodBuilder userExprFun = acb.newGeneratedFun(vtiType, 1);
        userExprFun.addThrownException("java.lang.Exception");
        LocalField localField = psHolder = reuseablePs ? acb.newFieldDeclaration(2, "java.sql.PreparedStatement") : null;
        if (reuseablePs) {
            userExprFun.getField(psHolder);
            userExprFun.conditionalIfNull();
        }
        this.methodCall.generateExpression(acb, userExprFun);
        userExprFun.upCast(vtiType);
        if (reuseablePs) {
            userExprFun.putField(psHolder);
            userExprFun.startElseCode();
            userExprFun.getField(psHolder);
            userExprFun.completeConditional();
        }
        userExprFun.methodReturn();
        userExprFun.complete();
        acb.pushMethodReference(mb, userExprFun);
        if (reuseablePs) {
            MethodBuilder closeActivationMethod = acb.getCloseActivationMethod();
            closeActivationMethod.getField(psHolder);
            closeActivationMethod.conditionalIfNull();
            closeActivationMethod.push(0);
            closeActivationMethod.startElseCode();
            closeActivationMethod.getField(psHolder);
            closeActivationMethod.callMethod((short)185, "java.sql.Statement", "close", "void", 0);
            closeActivationMethod.push(0);
            closeActivationMethod.completeConditional();
            closeActivationMethod.endStatement();
        }
    }

    @Override
    public boolean referencesTarget(String name, boolean baseTable) throws StandardException {
        return !baseTable && name.equals(this.methodCall.getJavaClassName());
    }

    @Override
    public Visitable accept(Visitor v) throws StandardException {
        if (v.skipChildren(this)) {
            return v.visit(this);
        }
        Visitable returnNode = super.accept(v);
        if (!v.stopTraversal()) {
            this.methodCall = (MethodCallNode)this.methodCall.accept(v);
        }
        return returnNode;
    }

    private UUID getSpecialTriggerVTITableName(LanguageConnectionContext lcc, String className) throws StandardException {
        if (className.equals("com.pivotal.gemfirexd.internal.catalog.TriggerNewTransitionRows") || className.equals("com.pivotal.gemfirexd.internal.catalog.TriggerOldTransitionRows")) {
            if (lcc.getTriggerTable() != null) {
                return lcc.getTriggerTable().getUUID();
            }
            if (lcc.getTriggerExecutionContext() != null) {
                return lcc.getTriggerExecutionContext().getTargetTableId();
            }
            throw StandardException.newException("42Y45", className);
        }
        return null;
    }

    private ResultColumnList genResultColList(TableDescriptor td) throws StandardException {
        ResultColumnList rcList = null;
        ColumnDescriptor colDesc = null;
        TableName tableName = this.makeTableName(td.getSchemaName(), td.getName());
        rcList = (ResultColumnList)this.getNodeFactory().getNode(9, this.getContextManager());
        ColumnDescriptorList cdl = td.getColumnDescriptorList();
        int cdlSize = cdl.size();
        for (int index = 0; index < cdlSize; ++index) {
            colDesc = cdl.elementAt(index);
            ValueNode valueNode = (ValueNode)this.getNodeFactory().getNode(94, colDesc.getColumnName(), this.exposedName, colDesc.getType(), this.getContextManager());
            ResultColumn resultColumn = (ResultColumn)this.getNodeFactory().getNode(80, colDesc, valueNode, this.getContextManager());
            rcList.addResultColumn(resultColumn);
        }
        return rcList;
    }

    @Override
    public boolean needsSpecialRCLBinding() {
        return true;
    }

    boolean isUpdatableCursor() throws StandardException {
        return true;
    }

    @Override
    protected void markUpdatableByCursor(Vector updateColumns) {
        super.markUpdatableByCursor(updateColumns);
        this.forUpdatePresent = true;
        this.emptyForUpdate = updateColumns == null || updateColumns.size() == 0;
    }

    private int[] getForUpdateColumnList() {
        int[] list;
        int[] tempList = new int[this.getNumColumnsReturned()];
        int offset = 0;
        for (int col = 0; col < tempList.length; ++col) {
            if (!this.resultColumns.updatableByCursor(col)) continue;
            tempList[offset++] = col + 1;
        }
        if (offset == tempList.length) {
            list = tempList;
        } else {
            list = new int[offset];
            System.arraycopy(tempList, 0, list, 0, offset);
        }
        return list;
    }

    @Override
    public final boolean isCompileTime() {
        return true;
    }

    @Override
    public String getOriginalSQL() {
        return this.getCompilerContext().getParser().getSQLtext();
    }

    @Override
    public final int getStatementIsolationLevel() {
        return ExecutionContext.CS_TO_JDBC_ISOLATION_LEVEL_MAP[this.getCompilerContext().getScanIsolationLevel()];
    }

    @Override
    public void setSharedState(String key, Serializable value) {
        if (key == null) {
            return;
        }
        if (this.compileTimeConstants == null) {
            this.compileTimeConstants = new FormatableHashtable();
        }
        this.compileTimeConstants.put(key, value);
    }

    @Override
    public Object getSharedState(String key) {
        if (key == null || this.compileTimeConstants == null) {
            return null;
        }
        return this.compileTimeConstants.get(key);
    }

    private void createResultColumnsForTableFunction(TypeDescriptor td) throws StandardException {
        String[] columnNames = td.getRowColumnNames();
        TypeDescriptor[] types = td.getRowTypes();
        for (int i = 0; i < columnNames.length; ++i) {
            this.resultColumns.addColumn(this.exposedName, columnNames[i], DataTypeDescriptor.getType(types[i]));
        }
    }

    private boolean implementsDerbyStyleVTICosting(String className) throws StandardException {
        Constructor constructor = null;
        Class vtiClass = this.lookupClass(className);
        Class vtiCostingClass = this.lookupClass(VTICosting.class.getName());
        try {
            if (!vtiCostingClass.isAssignableFrom(vtiClass)) {
                return false;
            }
        }
        catch (Throwable t) {
            throw StandardException.unexpectedUserException(t);
        }
        try {
            constructor = vtiClass.getConstructor(new Class[0]);
        }
        catch (Throwable t) {
            throw StandardException.newException("42ZB5", t, (Object)className);
        }
        if (Modifier.isPublic(constructor.getModifiers())) {
            return true;
        }
        throw StandardException.newException("42ZB5", className);
    }

    private VTICosting getVTICosting() throws StandardException {
        if (!this.isDerbyStyleTableFunction) {
            return this.version2 ? (VTICosting)((Object)this.ps) : (VTICosting)((Object)this.rs);
        }
        String className = this.methodCall.getJavaClassName();
        Class vtiClass = this.lookupClass(className);
        try {
            Constructor constructor = vtiClass.getConstructor(new Class[0]);
            VTICosting result = (VTICosting)constructor.newInstance(null);
            return result;
        }
        catch (Throwable t) {
            throw StandardException.unexpectedUserException(t);
        }
    }

    private String freezeReturnType(TypeDescriptor td) throws StandardException {
        try {
            DynamicByteArrayOutputStream dbaos = new DynamicByteArrayOutputStream();
            FormatIdOutputStream fios = new FormatIdOutputStream((OutputStream)((Object)dbaos));
            fios.writeObject(td);
            dbaos.flush();
            byte[] rawResult = dbaos.getByteArray();
            int count = dbaos.getUsed();
            String retval = FormatIdUtil.toString(rawResult, count);
            return retval;
        }
        catch (Throwable t) {
            throw StandardException.unexpectedUserException(t);
        }
    }

    private Class lookupClass(String className) throws StandardException {
        try {
            return this.getClassFactory().getClassInspector().getClass(className);
        }
        catch (ClassNotFoundException t) {
            throw StandardException.unexpectedUserException(t);
        }
    }

    @Override
    public final QueryInfo computeQueryInfo(QueryInfoContext qic) throws StandardException {
        if (!this.isDerbyStyleTableFunction && this.isGFXDVTI) {
            qic.setHasVirtualTable(this.getVTIName(), this.isVTIDistributable);
        }
        return super.computeQueryInfo(qic);
    }
}

