/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.ClassBuilder;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.JavaFactory;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.LocalField;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.MethodBuilder;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableArrayHolder;
import com.pivotal.gemfirexd.internal.iapi.services.loader.GeneratedClass;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.CompilerContext;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.ExpressionClassBuilderInterface;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.TypeCompiler;
import com.pivotal.gemfirexd.internal.iapi.store.access.ColumnOrdering;
import com.pivotal.gemfirexd.internal.iapi.types.TypeId;
import com.pivotal.gemfirexd.internal.iapi.util.ByteArray;
import com.pivotal.gemfirexd.internal.impl.sql.compile.OrderedColumnList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumnList;
import com.pivotal.gemfirexd.internal.impl.sql.execute.IndexColumnOrder;
import java.io.Serializable;

public abstract class ExpressionClassBuilder
implements ExpressionClassBuilderInterface {
    protected static final String currentDatetimeFieldName = "cdt";
    protected ClassBuilder cb;
    protected GeneratedClass gc;
    protected int nextExprNum;
    protected int nextNonFastExpr;
    protected int nextFieldNum;
    protected MethodBuilder constructor;
    protected CompilerContext myCompCtx;
    protected MethodBuilder executeMethod;
    protected LocalField cdtField;
    private String currentRowScanResultSetName;
    private Object getDVF;
    private Object getRSF;
    private Object getEF;

    protected ExpressionClassBuilder(String superClass, String className, CompilerContext cc) throws StandardException {
        int modifiers = 17;
        this.myCompCtx = cc;
        JavaFactory javaFac = this.myCompCtx.getJavaFactory();
        if (className == null) {
            className = this.myCompCtx.getUniqueClassName();
        }
        this.cb = javaFac.newClassBuilder(this.myCompCtx.getClassFactory(), this.getPackageName(), modifiers, className, superClass);
        this.beginConstructor();
    }

    protected abstract String getPackageName();

    protected abstract int getRowCount() throws StandardException;

    protected abstract void setNumSubqueries() throws StandardException;

    protected abstract String getBaseClassName();

    public MethodBuilder getConstructor() {
        return this.constructor;
    }

    public ClassBuilder getClassBuilder() {
        return this.cb;
    }

    MethodBuilder getExecuteMethod() {
        return this.executeMethod;
    }

    private final void beginConstructor() {
        MethodBuilder realConstructor = this.cb.newConstructorBuilder(1);
        realConstructor.callSuper();
        realConstructor.methodReturn();
        realConstructor.complete();
        this.constructor = this.cb.newMethodBuilder(1, "void", "postConstructor");
        this.constructor.addThrownException("com.pivotal.gemfirexd.internal.iapi.error.StandardException");
    }

    void finishConstructor() throws StandardException {
        this.setNumSubqueries();
        int numResultSets = this.getRowCount();
        if (numResultSets >= 1) {
            this.addNewArrayOfRows(numResultSets);
        }
        this.constructor.methodReturn();
        this.constructor.complete();
    }

    protected void addNewArrayOfRows(int numResultSets) {
        this.constructor.pushThis();
        this.constructor.pushNewArray("com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow", numResultSets);
        this.constructor.putField("com.pivotal.gemfirexd.internal.impl.sql.execute.BaseActivation", "row", "com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow[]");
        this.constructor.endStatement();
    }

    LocalField newFieldDeclaration(int modifiers, String type, String name) {
        return this.cb.addField(type, name, modifiers);
    }

    public LocalField newFieldDeclaration(int modifiers, String type) {
        return this.cb.addField(type, this.newFieldName(), modifiers);
    }

    MethodBuilder newGeneratedFun(String returnType, int modifiers) {
        return this.newGeneratedFun(returnType, modifiers, null);
    }

    MethodBuilder newGeneratedFun(String returnType, int modifiers, String[] params) {
        String exprName = "g".concat(Integer.toString(this.nextNonFastExpr++));
        return this.newGeneratedFun(exprName, returnType, modifiers, params);
    }

    private MethodBuilder newGeneratedFun(String exprName, String returnType, int modifiers, String[] params) {
        MethodBuilder exprMethod = params == null ? this.cb.newMethodBuilder(modifiers, returnType, exprName) : this.cb.newMethodBuilder(modifiers, returnType, exprName, params);
        exprMethod.addThrownException("com.pivotal.gemfirexd.internal.iapi.error.StandardException");
        return exprMethod;
    }

    protected MethodBuilder newExprFun() {
        String exprName = "e".concat(Integer.toString(this.nextExprNum++));
        return this.newGeneratedFun(exprName, "java.lang.Object", 1, null);
    }

    void pushMethodReference(MethodBuilder mb, MethodBuilder exprMethod) {
        mb.pushThis();
        mb.push(exprMethod.getName());
        mb.callMethod((short)185, "com.pivotal.gemfirexd.internal.iapi.services.loader.GeneratedByteCode", "getMethod", "com.pivotal.gemfirexd.internal.iapi.services.loader.GeneratedMethod", 1);
    }

    MethodBuilder newUserExprFun() {
        MethodBuilder mb = this.newExprFun();
        mb.addThrownException("java.lang.Exception");
        return mb;
    }

    void getCurrentDateExpression(MethodBuilder mb) {
        LocalField lf = this.getCurrentSetup();
        mb.getField(lf);
        mb.callMethod((short)182, null, "getCurrentDate", "java.sql.Date", 0);
    }

    void getCurrentTimeExpression(MethodBuilder mb) {
        LocalField lf = this.getCurrentSetup();
        mb.getField(lf);
        mb.callMethod((short)182, null, "getCurrentTime", "java.sql.Time", 0);
    }

    void getCurrentTimestampExpression(MethodBuilder mb) {
        LocalField lf = this.getCurrentSetup();
        mb.getField(lf);
        mb.callMethod((short)182, null, "getCurrentTimestamp", "java.sql.Timestamp", 0);
    }

    FormatableArrayHolder getColumnOrdering(ResultColumnList rclist) {
        int i;
        int numCols = rclist == null ? 0 : rclist.size();
        int numRealCols = 0;
        for (i = 0; i < numCols; ++i) {
            if (rclist.getResultColumn(i + 1).isGeneratedForUnmatchedColumnInInsert()) continue;
            ++numRealCols;
        }
        Object[] ordering = new IndexColumnOrder[numRealCols];
        int j = 0;
        for (i = 0; i < numCols; ++i) {
            if (rclist.getResultColumn(i + 1).isGeneratedForUnmatchedColumnInInsert()) continue;
            ordering[j] = new IndexColumnOrder(i);
            ++j;
        }
        return new FormatableArrayHolder(ordering);
    }

    FormatableArrayHolder addColumnToOrdering(FormatableArrayHolder orderingHolder, int columnNum) {
        ColumnOrdering[] ordering = (ColumnOrdering[])orderingHolder.getArray(ColumnOrdering.class);
        int length = ordering.length;
        for (int i = 0; i < length; ++i) {
            if (ordering[i].getColumnId() != columnNum) continue;
            return orderingHolder;
        }
        Object[] newOrdering = new IndexColumnOrder[length + 1];
        System.arraycopy(ordering, 0, newOrdering, 0, length);
        newOrdering[length] = new IndexColumnOrder(columnNum);
        return new FormatableArrayHolder(newOrdering);
    }

    FormatableArrayHolder getColumnOrdering(OrderedColumnList oclist) {
        int numCols;
        int n = numCols = oclist == null ? 0 : oclist.size();
        if (numCols == 0) {
            return new FormatableArrayHolder(new IndexColumnOrder[0]);
        }
        return new FormatableArrayHolder(oclist.getColumnOrdering());
    }

    public int addItem(Object o) {
        if (o != null && !(o instanceof Serializable)) {
            SanityManager.THROWASSERT((String)("o (" + o.getClass().getName() + ") expected to be instanceof java.io.Serializable"));
        }
        return this.myCompCtx.addSavedObject(o);
    }

    void pushDataValueFactory(MethodBuilder mb) {
        if (this.getDVF == null) {
            this.getDVF = mb.describeMethod((short)182, this.getBaseClassName(), "getDataValueFactory", "com.pivotal.gemfirexd.internal.iapi.types.DataValueFactory");
        }
        mb.pushThis();
        mb.callMethod(this.getDVF);
    }

    void pushGetResultSetFactoryExpression(MethodBuilder mb) {
        if (this.getRSF == null) {
            this.getRSF = mb.describeMethod((short)182, this.getBaseClassName(), "getResultSetFactory", "com.pivotal.gemfirexd.internal.iapi.sql.execute.ResultSetFactory");
        }
        mb.pushThis();
        mb.callMethod(this.getRSF);
    }

    public void pushGetExecutionFactoryExpression(MethodBuilder mb) {
        if (this.getEF == null) {
            this.getEF = mb.describeMethod((short)182, this.getBaseClassName(), "getExecutionFactory", "com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecutionFactory");
        }
        mb.pushThis();
        mb.callMethod(this.getEF);
    }

    void pushColumnReference(MethodBuilder mb, int rsNumber, int colId) {
        mb.pushThis();
        mb.push(rsNumber);
        mb.push(colId);
        mb.callMethod((short)182, "com.pivotal.gemfirexd.internal.impl.sql.execute.BaseActivation", "getColumnFromRow", "com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor", 2);
    }

    void pushPVSReference(MethodBuilder mb) {
        mb.pushThis();
        mb.getField("com.pivotal.gemfirexd.internal.impl.sql.execute.BaseActivation", "pvs", "com.pivotal.gemfirexd.internal.iapi.sql.ParameterValueSet");
    }

    protected LocalField getCurrentSetup() {
        if (this.cdtField != null) {
            return this.cdtField;
        }
        this.cdtField = this.newFieldDeclaration(2, "com.pivotal.gemfirexd.internal.impl.sql.execute.CurrentDatetime", currentDatetimeFieldName);
        this.constructor.pushNewStart("com.pivotal.gemfirexd.internal.impl.sql.execute.CurrentDatetime");
        this.constructor.pushNewComplete(0);
        this.constructor.setField(this.cdtField);
        return this.cdtField;
    }

    private String newFieldName() {
        return "e".concat(Integer.toString(this.nextFieldNum++));
    }

    protected TypeCompiler getTypeCompiler(TypeId typeId) {
        return this.myCompCtx.getTypeCompilerFactory().getTypeCompiler(typeId);
    }

    protected GeneratedClass getGeneratedClass(ByteArray savedBytes) throws StandardException {
        if (this.gc != null) {
            return this.gc;
        }
        if (savedBytes != null) {
            ByteArray classBytecode = this.cb.getClassBytecode();
            savedBytes.setBytes(classBytecode.getArray());
            savedBytes.setLength(classBytecode.getLength());
        }
        this.gc = this.cb.getGeneratedClass();
        return this.gc;
    }

    public void pushThisAsActivation(MethodBuilder mb) {
        mb.pushThis();
        mb.upCast("com.pivotal.gemfirexd.internal.iapi.sql.Activation");
    }

    void generateNull(MethodBuilder mb, TypeCompiler tc, int collationType) {
        this.pushDataValueFactory(mb);
        mb.pushNull(tc.interfaceName());
        tc.generateNull(mb, collationType);
    }

    void generateNullWithExpress(MethodBuilder mb, TypeCompiler tc, int collationType) {
        this.pushDataValueFactory(mb);
        mb.swap();
        mb.cast(tc.interfaceName());
        tc.generateNull(mb, collationType);
    }

    void generateDataValue(MethodBuilder mb, TypeCompiler tc, int collationType, LocalField field) {
        this.pushDataValueFactory(mb);
        mb.swap();
        tc.generateDataValue(mb, collationType, field);
    }

    String newRowLocationScanResultSetName() {
        this.currentRowScanResultSetName = this.newFieldName();
        return this.currentRowScanResultSetName;
    }

    String getRowLocationScanResultSetName() {
        return this.currentRowScanResultSetName;
    }
}

