/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.CompilerContext;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConglomerateDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConstraintDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SchemaDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ConstantAction;
import com.pivotal.gemfirexd.internal.impl.sql.compile.DDLStatementNode;

public class DropIndexNode
extends DDLStatementNode {
    private ConglomerateDescriptor cd;
    private TableDescriptor td;
    private boolean onlyIfExists;

    @Override
    public String statementToString() {
        return "DROP INDEX";
    }

    @Override
    public void init(Object indexName, Object onlyIfExists) throws StandardException {
        super.init(indexName);
        this.onlyIfExists = (Boolean)onlyIfExists;
    }

    @Override
    public void bindStatement() throws StandardException {
        ConstraintDescriptor conDesc;
        SchemaDescriptor sd;
        CompilerContext cc = this.getCompilerContext();
        DataDictionary dd = this.getDataDictionary();
        try {
            sd = this.getSchemaDescriptor();
        }
        catch (StandardException e) {
            if (e.getSQLState().equals("42Y07") && this.onlyIfExists) {
                return;
            }
            throw e;
        }
        if (sd.getUUID() != null) {
            this.cd = dd.getConglomerateDescriptor(this.getRelativeName(), sd, false);
        }
        if (this.cd == null) {
            if (this.onlyIfExists) {
                return;
            }
            throw StandardException.newException("42X65", this.getFullName());
        }
        this.td = this.getTableDescriptor(this.cd.getTableID());
        if (this.cd.isConstraint() && (conDesc = dd.getConstraintDescriptor(this.td, this.cd.getUUID())) != null) {
            String constraintName = conDesc.getConstraintName();
            throw StandardException.newException("42X84", (Object)this.getFullName(), (Object)constraintName);
        }
        cc.createDependency(this.td);
        cc.createDependency(this.cd);
    }

    @Override
    public ConstantAction makeConstantAction() throws StandardException {
        SchemaDescriptor sd;
        block2: {
            sd = null;
            try {
                sd = this.getSchemaDescriptor();
            }
            catch (StandardException e) {
                if (e.getSQLState().equals("42Y07") && this.onlyIfExists) break block2;
                throw e;
            }
        }
        return this.getGenericConstantActionFactory().getDropIndexConstantAction(this.getFullName(), this.getRelativeName(), this.getRelativeName(), sd == null ? null : this.getSchemaDescriptor().getSchemaName(), this.td == null ? null : this.td.getUUID(), this.td == null ? 0L : this.td.getHeapConglomerateId(), this.onlyIfExists);
    }
}

