/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.MethodBuilder;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.CompilerContext;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.NodeFactory;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Parser;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.depend.Dependent;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ColumnDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ColumnDescriptorList;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConglomerateDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConstraintDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConstraintDescriptorList;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ForeignKeyConstraintDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.GenericDescriptorList;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.IndexRowGenerator;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ReferencedKeyConstraintDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SchemaDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TriggerDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ActivationClassBuilder;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ColumnReference;
import com.pivotal.gemfirexd.internal.impl.sql.compile.CursorNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.DMLStatementNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ExpressionClassBuilder;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromBaseTable;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromVTI;
import com.pivotal.gemfirexd.internal.impl.sql.compile.QueryTreeNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumn;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumnList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SelectNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.StatementNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.TableName;
import com.pivotal.gemfirexd.internal.impl.sql.compile.TestConstraintNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNode;
import com.pivotal.gemfirexd.internal.impl.sql.execute.FKInfo;
import com.pivotal.gemfirexd.internal.impl.sql.execute.TriggerInfo;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public abstract class DMLModStatementNode
extends DMLStatementNode {
    public FromVTI targetVTI;
    protected TableName targetTableName;
    protected ResultColumnList resultColumnList;
    protected int lockMode;
    protected FKInfo[] fkInfo;
    protected TriggerInfo triggerInfo;
    public TableDescriptor targetTableDescriptor;
    public IndexRowGenerator[] indicesToMaintain;
    public long[] indexConglomerateNumbers;
    public String[] indexNames;
    protected ConstraintDescriptorList relevantCdl;
    protected GenericDescriptorList relevantTriggers;
    private boolean requiresDeferredProcessing;
    private int statementType;
    private boolean bound;
    private ValueNode checkConstraints;
    protected String[] fkTableNames;
    protected int[] fkRefActions;
    protected ColumnDescriptorList[] fkColDescriptors;
    protected long[] fkIndexConglomNumbers;
    protected boolean isDependentTable;
    protected int[][] fkColArrays;
    protected Hashtable graphHashTable;
    protected TableName synonymTableName;

    @Override
    public void init(Object resultSet) {
        super.init(resultSet);
        this.statementType = this.getStatementType();
    }

    @Override
    public void init(Object resultSet, Object statementType) {
        super.init(resultSet);
        this.statementType = (Integer)statementType;
    }

    void setTarget(QueryTreeNode targetName) {
        if (targetName instanceof TableName) {
            this.targetTableName = (TableName)targetName;
        } else {
            if (!(targetName instanceof FromVTI)) {
                SanityManager.THROWASSERT((String)("targetName expected to be FromVTI, not " + targetName.getClass().getName()));
            }
            this.targetVTI = (FromVTI)targetName;
            this.targetVTI.setTarget();
        }
    }

    public TableName getTargetTable() {
        return this.targetTableName;
    }

    protected void generateCodeForTemporaryTable(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        if (this.targetTableDescriptor != null && this.targetTableDescriptor.getTableType() == 3 && this.targetTableDescriptor.isOnRollbackDeleteRows()) {
            mb.pushThis();
            mb.callMethod((short)185, "com.pivotal.gemfirexd.internal.iapi.sql.Activation", "getLanguageConnectionContext", "com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext", 0);
            mb.push(this.targetTableDescriptor.getName());
            mb.callMethod((short)185, null, "markTempTableAsModifiedInUnitOfWork", "void", 1);
            mb.endStatement();
        }
    }

    void verifyTargetTable() throws StandardException {
        DataDictionary dataDictionary = this.getDataDictionary();
        if (this.targetTableName != null) {
            SchemaDescriptor sdtc = this.getSchemaDescriptor(this.targetTableName.getSchemaName());
            this.targetTableDescriptor = this.getTableDescriptor(this.targetTableName.getTableName(), sdtc);
            if (this.targetTableDescriptor == null) {
                TableName synonymTab = this.resolveTableToSynonym(this.targetTableName);
                if (synonymTab == null) {
                    throw StandardException.newException("42X05", this.targetTableName.getFullTableName());
                }
                this.synonymTableName = this.targetTableName;
                this.targetTableName = synonymTab;
                sdtc = this.getSchemaDescriptor(this.targetTableName.getSchemaName());
                this.targetTableDescriptor = this.getTableDescriptor(synonymTab.getTableName(), sdtc);
                if (this.targetTableDescriptor == null) {
                    throw StandardException.newException("42X05", this.targetTableName.getFullTableName());
                }
            }
            switch (this.targetTableDescriptor.getTableType()) {
                case 2: {
                    throw StandardException.newException("42Y24", this.targetTableName);
                }
                case 1: 
                case 5: {
                    throw StandardException.newException("42Y25", this.targetTableName);
                }
            }
            this.targetTableDescriptor = this.lockTableForCompilation(this.targetTableDescriptor, false);
            this.getCompilerContext().createDependency(this.targetTableDescriptor);
        } else {
            FromList dummyFromList = new FromList();
            this.targetVTI = (FromVTI)this.targetVTI.bindNonVTITables(dataDictionary, dummyFromList);
            this.targetVTI = (FromVTI)this.targetVTI.bindVTITables(dummyFromList);
        }
    }

    @Override
    public boolean isAtomic() {
        return true;
    }

    public SchemaDescriptor getSchemaDescriptor() throws StandardException {
        SchemaDescriptor sd = this.getSchemaDescriptor(this.targetTableName.getSchemaName());
        return sd;
    }

    public static int[] getReadColMap(int column_map_length, FormatableBitSet readColsBitSet) {
        if (readColsBitSet == null) {
            return null;
        }
        int partial_col_cnt = 0;
        int[] column_map = new int[column_map_length];
        int readColsBitSetSize = readColsBitSet.getLength();
        for (int base_index = 0; base_index < column_map.length; ++base_index) {
            column_map[base_index] = readColsBitSetSize > base_index && readColsBitSet.get(base_index + 1) ? partial_col_cnt++ : -1;
        }
        return column_map;
    }

    protected void getResultColumnList() throws StandardException {
        if (this.targetVTI == null) {
            this.getResultColumnList(null);
        } else {
            this.resultColumnList = this.targetVTI.getResultColumns();
        }
    }

    protected FromBaseTable getResultColumnList(ResultColumnList inputRcl) throws StandardException {
        FromBaseTable fbt = (FromBaseTable)this.getNodeFactory().getNode(135, this.synonymTableName != null ? this.synonymTableName : this.targetTableName, null, null, null, this.getContextManager());
        fbt.bindNonVTITables(this.getDataDictionary(), (FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this.getContextManager()));
        this.getResultColumnList(fbt, inputRcl);
        return fbt;
    }

    private void getResultColumnList(FromBaseTable fromBaseTable, ResultColumnList inputRcl) throws StandardException {
        if (inputRcl == null) {
            this.resultColumnList = fromBaseTable.getAllResultColumns(null);
            this.resultColumnList.bindResultColumnsByPosition(this.targetTableDescriptor);
        } else {
            this.resultColumnList = fromBaseTable.getResultColumnsForList(null, inputRcl, fromBaseTable.getTableNameField());
            this.resultColumnList.bindResultColumnsByName(this.targetTableDescriptor, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ValueNode bindConstraints(DataDictionary dataDictionary, NodeFactory nodeFactory, TableDescriptor targetTableDescriptor, Dependent dependent, ResultColumnList sourceRCL, int[] changedColumnIds, FormatableBitSet readColsBitSet, boolean skipCheckConstraints, boolean includeTriggers) throws StandardException {
        this.bound = true;
        if (this.targetVTI != null) {
            return null;
        }
        this.getCompilerContext().pushCurrentPrivType(-1);
        try {
            this.getAllRelevantConstraints(dataDictionary, targetTableDescriptor, skipCheckConstraints, changedColumnIds);
            this.createConstraintDependencies(dataDictionary, this.relevantCdl, dependent);
            this.generateFKInfo(this.relevantCdl, dataDictionary, targetTableDescriptor, readColsBitSet);
            this.getAllRelevantTriggers(dataDictionary, targetTableDescriptor, changedColumnIds, includeTriggers);
            this.createTriggerDependencies(this.relevantTriggers, dependent);
            this.generateTriggerInfo(this.relevantTriggers, targetTableDescriptor, changedColumnIds);
            if (skipCheckConstraints) {
                ValueNode valueNode = null;
                return valueNode;
            }
            this.checkConstraints = this.generateCheckTree(this.relevantCdl, targetTableDescriptor);
            if (this.checkConstraints != null) {
                this.bindCheckConstraint(nodeFactory, targetTableDescriptor, sourceRCL, this.checkConstraints);
            }
        }
        finally {
            this.getCompilerContext().popCurrentPrivType();
        }
        return this.checkConstraints;
    }

    void bindCheckConstraint(NodeFactory nodeFactory, TableDescriptor targetTableDescriptor, ResultColumnList sourceRCL, ValueNode checkConstraint) throws StandardException {
        TableName targetTableName = this.makeTableName(targetTableDescriptor.getSchemaName(), targetTableDescriptor.getName());
        FromList fakeFromList = (FromList)nodeFactory.getNode(37, nodeFactory.doJoinOrderOptimization(), this.getContextManager());
        FromBaseTable table = (FromBaseTable)nodeFactory.getNode(135, targetTableName, null, sourceRCL, null, this.getContextManager());
        table.setTableNumber(0);
        fakeFromList.addFromTable(table);
        checkConstraint = checkConstraint.bindExpression(fakeFromList, null, null);
    }

    protected boolean hasCheckConstraints(DataDictionary dd, TableDescriptor td) throws StandardException {
        ConstraintDescriptorList cdl = dd.getConstraintDescriptors(td);
        if (cdl == null) {
            return false;
        }
        ConstraintDescriptorList ccCDL = cdl.getSubList(4);
        return ccCDL.size() > 0;
    }

    private ValueNode generateCheckTree(ConstraintDescriptorList cdl, TableDescriptor td) throws StandardException {
        ConstraintDescriptorList ccCDL = cdl.getSubList(4);
        int ccCDLSize = ccCDL.size();
        ValueNode checkTree = null;
        for (int index = 0; index < ccCDLSize; ++index) {
            ConstraintDescriptor cd = ccCDL.elementAt(index);
            String constraintText = cd.getConstraintText();
            ValueNode oneConstraint = this.parseCheckConstraint(constraintText, td);
            TestConstraintNode tcn = (TestConstraintNode)this.getNodeFactory().getNode(1, oneConstraint, "23513", td.getQualifiedName(), cd.getConstraintName(), this.getContextManager());
            checkTree = checkTree == null ? tcn : (ValueNode)this.getNodeFactory().getNode(39, tcn, checkTree, this.getContextManager());
        }
        return checkTree;
    }

    private void generateFKInfo(ConstraintDescriptorList cdl, DataDictionary dd, TableDescriptor td, FormatableBitSet readColsBitSet) throws StandardException {
        Vector<FKInfo> fkVector = new Vector<FKInfo>(10);
        UUID[] uuids = null;
        long[] conglomNumbers = null;
        String[] fkNames = null;
        ConstraintDescriptorList activeList = dd.getActiveConstraintDescriptors(cdl);
        int[] rowMap = this.getRowMap(readColsBitSet, td);
        int[] raRules = null;
        Vector<String> refTableNames = new Vector<String>(1);
        Vector<Long> refIndexConglomNum = new Vector<Long>(1);
        Vector<Integer> refActions = new Vector<Integer>(1);
        Vector<ColumnDescriptorList> refColDescriptors = new Vector<ColumnDescriptorList>(1);
        Vector<int[]> fkColMap = new Vector<int[]>(1);
        int activeSize = activeList.size();
        for (int index = 0; index < activeSize; ++index) {
            boolean[] isSelfReferencingFK;
            ReferencedKeyConstraintDescriptor refcd;
            int type;
            ConstraintDescriptor cd = activeList.elementAt(index);
            if (cd instanceof ForeignKeyConstraintDescriptor) {
                type = 1;
                refcd = ((ForeignKeyConstraintDescriptor)cd).getReferencedConstraint();
                uuids = new UUID[1];
                conglomNumbers = new long[1];
                fkNames = new String[1];
                isSelfReferencingFK = new boolean[1];
                raRules = new int[1];
                this.fkSetupArrays(dd, (ForeignKeyConstraintDescriptor)cd, 0, uuids, conglomNumbers, fkNames, isSelfReferencingFK, raRules);
                fkNames[0] = cd.getConstraintName();
            } else {
                if (!(cd instanceof ReferencedKeyConstraintDescriptor)) continue;
                refcd = (ReferencedKeyConstraintDescriptor)cd;
                type = 2;
                ConstraintDescriptorList fkcdl = dd.getActiveConstraintDescriptors(((ReferencedKeyConstraintDescriptor)cd).getForeignKeyConstraints(1));
                int size = fkcdl.size();
                if (size == 0) continue;
                uuids = new UUID[size];
                fkNames = new String[size];
                conglomNumbers = new long[size];
                isSelfReferencingFK = new boolean[size];
                raRules = new int[size];
                ForeignKeyConstraintDescriptor fkcd = null;
                int[] colArray = this.remapReferencedColumns(cd, rowMap);
                for (int inner = 0; inner < size; ++inner) {
                    fkcd = (ForeignKeyConstraintDescriptor)fkcdl.elementAt(inner);
                    this.fkSetupArrays(dd, fkcd, inner, uuids, conglomNumbers, fkNames, isSelfReferencingFK, raRules);
                    if (raRules[inner] != 0 && raRules[inner] != 3) continue;
                    TableDescriptor fktd = fkcd.getTableDescriptor();
                    refTableNames.addElement(fktd.getSchemaName() + "." + fktd.getName());
                    refActions.addElement(raRules[inner]);
                    int[] refColumns = fkcd.getReferencedColumns();
                    ColumnDescriptorList coldl = fktd.getColumnDescriptorList();
                    ColumnDescriptorList releventColDes = new ColumnDescriptorList();
                    for (int i = 0; i < refColumns.length; ++i) {
                        ColumnDescriptor cold = coldl.elementAt(refColumns[i] - 1);
                        releventColDes.add(cold);
                    }
                    refColDescriptors.addElement(releventColDes);
                    refIndexConglomNum.addElement(conglomNumbers[inner]);
                    fkColMap.addElement(colArray);
                }
            }
            TableDescriptor pktd = refcd.getTableDescriptor();
            UUID pkuuid = refcd.getIndexId();
            ConglomerateDescriptor pkIndexConglom = pktd.getConglomerateDescriptor(pkuuid);
            TableDescriptor refTd = cd.getTableDescriptor();
            fkVector.addElement(new FKInfo(fkNames, refTd.getName(), this.statementType, type, pkuuid, pkIndexConglom.getConglomerateNumber(), uuids, conglomNumbers, isSelfReferencingFK, this.remapReferencedColumns(cd, rowMap), dd.getRowLocationTemplate(this.getLanguageConnectionContext(), refTd), raRules));
        }
        int size = fkVector.size();
        if (size > 0) {
            this.fkInfo = new FKInfo[size];
            for (int i = 0; i < size; ++i) {
                this.fkInfo[i] = (FKInfo)fkVector.elementAt(i);
            }
        }
        if ((size = refActions.size()) > 0) {
            this.fkTableNames = new String[size];
            this.fkRefActions = new int[size];
            this.fkColDescriptors = new ColumnDescriptorList[size];
            this.fkIndexConglomNumbers = new long[size];
            this.fkColArrays = new int[size][];
            for (int i = 0; i < size; ++i) {
                this.fkTableNames[i] = (String)refTableNames.elementAt(i);
                this.fkRefActions[i] = (Integer)refActions.elementAt(i);
                this.fkColDescriptors[i] = (ColumnDescriptorList)refColDescriptors.elementAt(i);
                this.fkIndexConglomNumbers[i] = (Long)refIndexConglomNum.elementAt(i);
                this.fkColArrays[i] = (int[])fkColMap.elementAt(i);
            }
        }
    }

    private void fkSetupArrays(DataDictionary dd, ForeignKeyConstraintDescriptor fkcd, int index, UUID[] uuids, long[] conglomNumbers, String[] fkNames, boolean[] isSelfReferencingFK, int[] raRules) throws StandardException {
        fkNames[index] = fkcd.getConstraintName();
        uuids[index] = fkcd.getIndexId();
        conglomNumbers[index] = fkcd.getIndexConglomerateDescriptor(dd).getConglomerateNumber();
        isSelfReferencingFK[index] = fkcd.isSelfReferencingFK();
        if (this.statementType == 4) {
            raRules[index] = fkcd.getRaDeleteRule();
        } else if (this.statementType == 3) {
            raRules[index] = fkcd.getRaUpdateRule();
        }
    }

    private void generateTriggerInfo(GenericDescriptorList triggerList, TableDescriptor td, int[] changedCols) throws StandardException {
        if (triggerList != null && triggerList.size() > 0) {
            this.triggerInfo = new TriggerInfo(td, changedCols, triggerList);
        }
    }

    public FKInfo[] getFKInfo() {
        SanityManager.ASSERT((boolean)this.bound, (String)"attempt to access FKInfo before binding");
        return this.fkInfo;
    }

    public TriggerInfo getTriggerInfo() {
        SanityManager.ASSERT((boolean)this.bound, (String)"attempt to access TriggerInfo before binding");
        return this.triggerInfo;
    }

    public ValueNode getCheckConstraints() {
        SanityManager.ASSERT((boolean)this.bound, (String)"attempt to access FKInfo before binding");
        return this.checkConstraints;
    }

    private void createTriggerDependencies(GenericDescriptorList tdl, Dependent dependent) throws StandardException {
        CompilerContext compilerContext = this.getCompilerContext();
        Enumeration descs = tdl.elements();
        while (descs.hasMoreElements()) {
            TriggerDescriptor td = (TriggerDescriptor)descs.nextElement();
            if (dependent == null) {
                compilerContext.createDependency(td);
                continue;
            }
            compilerContext.createDependency(dependent, td);
        }
    }

    protected GenericDescriptorList getAllRelevantTriggers(DataDictionary dd, TableDescriptor td, int[] changedColumnIds, boolean includeTriggers) throws StandardException {
        if (this.relevantTriggers != null) {
            return this.relevantTriggers;
        }
        this.relevantTriggers = new GenericDescriptorList();
        if (!includeTriggers) {
            return this.relevantTriggers;
        }
        td.getAllRelevantTriggers(this.statementType, changedColumnIds, this.relevantTriggers);
        this.adjustDeferredFlag(this.relevantTriggers.size() > 0);
        return this.relevantTriggers;
    }

    protected void adjustDeferredFlag(boolean adjustment) {
        if (!this.requiresDeferredProcessing) {
            this.requiresDeferredProcessing = adjustment;
        }
    }

    private void createConstraintDependencies(DataDictionary dd, ConstraintDescriptorList cdl, Dependent dependent) throws StandardException {
        CompilerContext compilerContext = this.getCompilerContext();
        int cdlSize = cdl.size();
        for (int index = 0; index < cdlSize; ++index) {
            ConstraintDescriptor cd = cdl.elementAt(index);
            if (dependent == null) {
                compilerContext.createDependency(cd);
            } else {
                compilerContext.createDependency(dependent, cd);
            }
            if (cd instanceof ReferencedKeyConstraintDescriptor) {
                ConstraintDescriptorList fkcdl = dd.getActiveConstraintDescriptors(((ReferencedKeyConstraintDescriptor)cd).getForeignKeyConstraints(1));
                int fklSize = fkcdl.size();
                for (int inner = 0; inner < fklSize; ++inner) {
                    ConstraintDescriptor fkcd = fkcdl.elementAt(inner);
                    if (dependent == null) {
                        compilerContext.createDependency(fkcd);
                        compilerContext.createDependency(fkcd.getTableDescriptor());
                        continue;
                    }
                    compilerContext.createDependency(dependent, fkcd);
                    compilerContext.createDependency(dependent, fkcd.getTableDescriptor());
                }
                continue;
            }
            if (!(cd instanceof ForeignKeyConstraintDescriptor)) continue;
            ForeignKeyConstraintDescriptor fkcd = (ForeignKeyConstraintDescriptor)cd;
            if (dependent == null) {
                compilerContext.createDependency(fkcd.getReferencedConstraint().getTableDescriptor());
                continue;
            }
            compilerContext.createDependency(dependent, fkcd.getReferencedConstraint().getTableDescriptor());
        }
    }

    protected ConstraintDescriptorList getAllRelevantConstraints(DataDictionary dd, TableDescriptor td, boolean skipCheckConstraints, int[] changedColumnIds) throws StandardException {
        if (this.relevantCdl != null) {
            return this.relevantCdl;
        }
        boolean[] needsDeferredProcessing = new boolean[1];
        this.relevantCdl = new ConstraintDescriptorList();
        needsDeferredProcessing[0] = this.requiresDeferredProcessing;
        td.getAllRelevantConstraints(this.statementType, skipCheckConstraints, changedColumnIds, needsDeferredProcessing, this.relevantCdl);
        this.adjustDeferredFlag(needsDeferredProcessing[0]);
        return this.relevantCdl;
    }

    public boolean requiresDeferredProcessing() {
        return this.requiresDeferredProcessing;
    }

    public ValueNode parseCheckConstraint(String checkConstraintText, TableDescriptor td) throws StandardException {
        CursorNode cn;
        LanguageConnectionContext lcc = this.getLanguageConnectionContext();
        CompilerContext compilerContext = this.getCompilerContext();
        String select = "SELECT * FROM " + td.getQualifiedName() + " WHERE " + checkConstraintText;
        CompilerContext newCC = lcc.pushCompilerContext();
        newCC.allowOptimizeLiteral(false);
        Parser p = newCC.getParser();
        StatementNode qt = p.parseStatement(select);
        if (!(qt instanceof CursorNode)) {
            SanityManager.THROWASSERT((String)("qt expected to be instanceof CursorNode, not " + qt.getClass().getName()));
        }
        if (!((cn = (CursorNode)qt).getResultSetNode() instanceof SelectNode)) {
            SanityManager.THROWASSERT((String)("cn.getResultSetNode() expected to be instanceof SelectNode, not " + cn.getResultSetNode().getClass().getName()));
        }
        ValueNode checkTree = ((SelectNode)((CursorNode)qt).getResultSetNode()).getWhereClause();
        lcc.popCompilerContext(newCC);
        return checkTree;
    }

    public void generateCheckConstraints(ValueNode checkConstraints, ExpressionClassBuilder ecb, MethodBuilder mb) throws StandardException {
        if (checkConstraints == null) {
            mb.pushNull("com.pivotal.gemfirexd.internal.iapi.services.loader.GeneratedMethod");
        } else {
            MethodBuilder userExprFun = this.generateCheckConstraints(checkConstraints, ecb);
            ecb.pushMethodReference(mb, userExprFun);
        }
    }

    public MethodBuilder generateCheckConstraints(ValueNode checkConstraints, ExpressionClassBuilder ecb) throws StandardException {
        MethodBuilder userExprFun = ecb.newUserExprFun();
        checkConstraints.generateExpression(ecb, userExprFun);
        userExprFun.methodReturn();
        userExprFun.complete();
        return userExprFun;
    }

    @Override
    public void optimizeStatement() throws StandardException {
        super.optimizeStatement();
        this.lockMode = 6;
    }

    protected void getAffectedIndexes(TableDescriptor td, ResultColumnList updatedColumns, FormatableBitSet colBitSet) throws StandardException {
        Vector conglomVector = new Vector();
        DMLModStatementNode.getXAffectedIndexes(td, updatedColumns, colBitSet, conglomVector);
        this.markAffectedIndexes(conglomVector);
    }

    static void getXAffectedIndexes(TableDescriptor baseTable, ResultColumnList updatedColumns, FormatableBitSet colBitSet, Vector conglomVector) throws StandardException {
        ConglomerateDescriptor[] cds = baseTable.getConglomerateDescriptors();
        long[] distinctConglomNums = new long[cds.length - 1];
        int distinctCount = 0;
        for (int index = 0; index < cds.length; ++index) {
            ConglomerateDescriptor cd = cds[index];
            if (!cd.isIndex() || updatedColumns != null && !updatedColumns.updateOverlaps(cd.getIndexDescriptor().baseColumnPositions())) continue;
            if (conglomVector != null) {
                int i;
                for (i = 0; i < distinctCount && distinctConglomNums[i] != cd.getConglomerateNumber(); ++i) {
                }
                if (i == distinctCount) {
                    distinctConglomNums[distinctCount++] = cd.getConglomerateNumber();
                    conglomVector.addElement(cd);
                }
            }
            IndexRowGenerator ixd = cd.getIndexDescriptor();
            int[] cols = ixd.baseColumnPositions();
            if (colBitSet == null) continue;
            for (int i = 0; i < cols.length; ++i) {
                colBitSet.set(cols[i]);
            }
        }
    }

    protected void markAffectedIndexes(Vector affectedConglomerates) throws StandardException {
        int indexCount = affectedConglomerates.size();
        CompilerContext cc = this.getCompilerContext();
        this.indicesToMaintain = new IndexRowGenerator[indexCount];
        this.indexConglomerateNumbers = new long[indexCount];
        this.indexNames = new String[indexCount];
        for (int ictr = 0; ictr < indexCount; ++ictr) {
            ConglomerateDescriptor cd = (ConglomerateDescriptor)affectedConglomerates.elementAt(ictr);
            this.indicesToMaintain[ictr] = cd.getIndexDescriptor();
            this.indexConglomerateNumbers[ictr] = cd.getConglomerateNumber();
            this.indexNames[ictr] = cd.isConstraint() ? null : cd.getConglomerateName();
            cc.createDependency(cd);
        }
    }

    @Override
    public String statementToString() {
        return "DML MOD";
    }

    private int[] remapReferencedColumns(ConstraintDescriptor cd, int[] rowMap) {
        int[] oldCols = cd.getReferencedColumns();
        if (rowMap == null) {
            return oldCols;
        }
        int[] newCols = new int[oldCols.length];
        for (int i = 0; i < oldCols.length; ++i) {
            newCols[i] = rowMap[oldCols[i]];
            SanityManager.ASSERT((newCols[i] != 0 ? 1 : 0) != 0, (String)("attempt to map a column " + oldCols[i] + " which is not in our new column map.  Something is wrong with the logic to do partial reads for an update stmt"));
        }
        return newCols;
    }

    private int[] getRowMap(FormatableBitSet bitSet, TableDescriptor td) throws StandardException {
        if (bitSet == null) {
            return null;
        }
        int size = td.getMaxColumnID();
        int[] iArray = new int[size + 1];
        int j = 1;
        for (int i = 1; i <= size; ++i) {
            if (!bitSet.get(i)) continue;
            iArray[i] = j++;
        }
        return iArray;
    }

    @Override
    public void setRefActionInfo(long fkIndexConglomId, int[] fkColArray, String parentResultSetId, boolean dependentScan) {
        this.resultSet.setRefActionInfo(fkIndexConglomId, fkColArray, parentResultSetId, dependentScan);
    }

    public void normalizeSynonymColumns(ResultColumnList rcl, TableName targetTableName) throws StandardException {
        if (this.synonymTableName == null) {
            return;
        }
        String synTableName = this.synonymTableName.getTableName();
        int count = rcl.size();
        for (int i = 0; i < count; ++i) {
            String crTableName;
            ResultColumn column = (ResultColumn)rcl.elementAt(i);
            ColumnReference reference = column.getReference();
            if (reference == null || (crTableName = reference.getTableName()) == null) continue;
            if (synTableName.equals(crTableName)) {
                reference.setTableNameNode(targetTableName);
                continue;
            }
            throw StandardException.newException("42X55", (Object)synTableName, (Object)crTableName);
        }
    }
}

