/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.engine.ddl.GfxdAlterTableNode;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.MethodBuilder;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.CompilerContext;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SchemaDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ActivationClassBuilder;
import com.pivotal.gemfirexd.internal.impl.sql.compile.AlterTableNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.StatementNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.TableName;

public abstract class DDLStatementNode
extends StatementNode {
    public static final int UNKNOWN_TYPE = 0;
    public static final int ADD_TYPE = 1;
    public static final int DROP_TYPE = 2;
    public static final int MODIFY_TYPE = 3;
    public static final int LOCKING_TYPE = 4;
    private TableName objectName;
    private boolean initOk;
    boolean implicitCreateSchema;

    @Override
    public void init(Object objectName) throws StandardException {
        this.initAndCheck(objectName);
    }

    protected void initAndCheck(Object objectName) throws StandardException {
        this.objectName = (TableName)objectName;
        this.initOk = true;
    }

    @Override
    public boolean isAtomic() {
        return true;
    }

    public String getRelativeName() {
        return this.objectName.getTableName();
    }

    public String getFullName() {
        return this.objectName.getFullTableName();
    }

    public final TableName getObjectName() {
        return this.objectName;
    }

    @Override
    public String toString() {
        return (this.objectName == null ? "" : this.objectName.toString()) + super.toString();
    }

    @Override
    int activationKind() {
        return 5;
    }

    @Override
    public final void generate(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        if (!this.initOk) {
            SanityManager.THROWASSERT((String)(this.getClass() + " never called initAndCheck()"));
        }
        acb.pushGetResultSetFactoryExpression(mb);
        acb.pushThisAsActivation(mb);
        mb.callMethod((short)185, null, "getDDLResultSet", "com.pivotal.gemfirexd.internal.iapi.sql.ResultSet", 1);
    }

    protected final SchemaDescriptor getSchemaDescriptor() throws StandardException {
        return this.getSchemaDescriptor(true);
    }

    protected final SchemaDescriptor getSchemaDescriptor(boolean ownerCheck) throws StandardException {
        String schemaName = this.objectName.getSchemaName();
        boolean needError = !this.implicitCreateSchema;
        SchemaDescriptor sd = this.getSchemaDescriptor(schemaName, needError);
        CompilerContext cc = this.getCompilerContext();
        if (sd == null) {
            if (schemaName.startsWith("SYS")) {
                throw StandardException.newException("42X62", (Object)this.statementToString(), (Object)schemaName);
            }
            sd = new SchemaDescriptor(this.getDataDictionary(), schemaName, null, null, false);
            if (this.isPrivilegeCollectionRequired()) {
                cc.addRequiredSchemaPriv(schemaName, null, 16);
            }
        }
        if (ownerCheck && this.isPrivilegeCollectionRequired() && !(this instanceof AlterTableNode) && !(this instanceof GfxdAlterTableNode)) {
            cc.addRequiredSchemaPriv(sd.getSchemaName(), null, 17);
        }
        if (!this.getLanguageConnectionContext().getExplainSchema() && sd.isSystemSchema()) {
            throw StandardException.newException("42X62", (Object)this.statementToString(), (Object)sd);
        }
        return sd;
    }

    protected final TableDescriptor getTableDescriptor() throws StandardException {
        return this.getTableDescriptor(this.objectName);
    }

    protected final TableDescriptor getTableDescriptor(UUID tableId) throws StandardException {
        TableDescriptor td = this.getDataDictionary().getTableDescriptor(tableId);
        td = this.checkTableDescriptor(td);
        return td;
    }

    protected final TableDescriptor getTableDescriptor(TableName tableName) throws StandardException {
        String schemaName = tableName.getSchemaName();
        SchemaDescriptor sd = this.getSchemaDescriptor(schemaName);
        TableDescriptor td = this.getTableDescriptor(tableName.getTableName(), sd);
        if (td == null) {
            throw StandardException.newException("42Y55", (Object)this.statementToString(), (Object)((sd != null ? sd.getSchemaName() + "." : "") + tableName.getTableName()));
        }
        td = this.checkTableDescriptor(td);
        return td;
    }

    private TableDescriptor checkTableDescriptor(TableDescriptor td) throws StandardException {
        String sqlState = null;
        switch (td.getTableType()) {
            case 1: 
            case 5: {
                sqlState = "X0Y56.S";
                break;
            }
            case 0: 
            case 6: {
                return this.lockTableForCompilation(td, false);
            }
            case 3: {
                return td;
            }
            case 2: {
                sqlState = "42Y62";
            }
        }
        throw StandardException.newException(sqlState, (Object)this.statementToString(), (Object)td.getQualifiedName());
    }

    void bindName(DataDictionary dataDictionary) throws StandardException {
        if (this.objectName != null) {
            this.objectName.bind(dataDictionary);
        }
    }

    public String getSchemaNameIfExplicitlySet() {
        if (this.objectName != null) {
            return this.objectName.schemaName;
        }
        return null;
    }
}

