/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.gemstone.gnu.trove.THashMap;
import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.JavaFactory;
import com.pivotal.gemfirexd.internal.iapi.services.context.ContextImpl;
import com.pivotal.gemfirexd.internal.iapi.services.context.ContextManager;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.services.loader.ClassFactory;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.CompilerContext;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.NodeFactory;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Parser;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.TypeCompiler;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.TypeCompilerFactory;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionFactory;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.StatementContext;
import com.pivotal.gemfirexd.internal.iapi.sql.depend.DependencyManager;
import com.pivotal.gemfirexd.internal.iapi.sql.depend.Dependent;
import com.pivotal.gemfirexd.internal.iapi.sql.depend.Provider;
import com.pivotal.gemfirexd.internal.iapi.sql.depend.ProviderList;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.AliasDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ColumnDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SchemaDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.StatementColumnPermission;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.StatementRolePermission;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.StatementRoutinePermission;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.StatementSchemaPermission;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.StatementTablePermission;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.store.access.SortCostController;
import com.pivotal.gemfirexd.internal.iapi.store.access.StoreCostController;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.util.ReuseFactory;
import com.pivotal.gemfirexd.internal.impl.sql.GenericPreparedStatement;
import com.pivotal.gemfirexd.internal.impl.sql.StatementStats;
import com.pivotal.gemfirexd.internal.impl.sql.compile.Token;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNode;
import com.pivotal.gemfirexd.internal.impl.sql.rules.ExecutionEngineRule;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.Vector;

public final class CompilerContextImpl
extends ContextImpl
implements CompilerContext {
    private final Parser parser;
    private final Parser matcher;
    private final LanguageConnectionContext lcc;
    private final LanguageConnectionFactory lcf;
    private final TypeCompilerFactory typeCompilerFactory;
    private Dependent currentDependent;
    private DependencyManager dm;
    private boolean firstOnStack;
    private boolean inUse;
    private int reliability = 1024;
    private int nextColumnNumber = 1;
    private int nextTableNumber;
    private int nextSubqueryNumber;
    private int nextResultSetNumber;
    private int scanIsolationLevel;
    private int nextEquivalenceClass = -1;
    private long nextClassName;
    private Vector savedObjects;
    private final String classPrefix;
    private SchemaDescriptor compilationSchema;
    private ProviderList currentAPL;
    private boolean returnParameterFlag;
    private final Vector storeCostControllers = new Vector();
    private final Vector storeCostConglomIds = new Vector();
    private SortCostController sortCostController;
    private Vector<ValueNode> parameterList;
    private DataTypeDescriptor[] parameterDescriptors;
    private List<TypeCompiler> originalParamTypeCompilers;
    private Object cursorInfo;
    private SQLWarning warnings;
    private final Stack privTypeStack = new Stack();
    private int currPrivType = -1;
    private HashMap requiredColumnPrivileges;
    private HashMap requiredTablePrivileges;
    private HashMap requiredSchemaPrivileges;
    private HashMap requiredRoutinePrivileges;
    private HashMap requiredRolePrivileges;
    private ArrayList<com.pivotal.gemfirexd.internal.engine.sql.compile.Token> constantTokenList;
    private ArrayList<Token> dynamicTokenList;
    private boolean createQueryInfo = true;
    private boolean isPreparedStatement = false;
    private GenericPreparedStatement preparedStatement = null;
    private String generalizedQuery = null;
    private boolean allTablesReplicatedOnRemote = false;
    private boolean allowSubqueryFlattening = true;
    private boolean foundNoncorrelatedsubquery = false;
    private boolean allowOrListOptimization = false;
    private boolean hasOrList = false;
    private boolean optimizeForWrite;
    private boolean orderByListNullified = false;
    private boolean isOffsetOrFetchNext = false;
    private boolean withSecondaries;
    private String statementAlias;
    private StatementStats statementStats;
    private boolean allowStatementOptimization = false;
    private boolean currentQueryStatementOptimization = false;
    private boolean scope = true;
    private boolean cohort = false;
    private THashMap ncjMetaData = null;
    private GenericPreparedStatement parentPS = null;
    private boolean queryHDFS = false;
    private boolean hasQueryHDFS = false;
    private boolean convertCharConstToVarchar = false;
    private boolean ddlForSnappyUse = false;
    private boolean snappyForcedDDLRouting = false;
    private ExecutionEngineRule.ExecutionEngine executionEngine = ExecutionEngineRule.ExecutionEngine.NOT_DECIDED;
    private short originalExecFlags = 0;
    private final Stack<DMLScope> scopes = new Stack();

    @Override
    public void cleanupOnError(Throwable error) throws StandardException {
        this.setInUse(false);
        this.resetContext();
        if (error instanceof StandardException) {
            StandardException se = (StandardException)error;
            int severity = se.getSeverity();
            if (severity < 50000) {
                if (this.currentDependent != null) {
                    this.currentDependent.makeInvalid(0, this.lcc);
                }
                this.closeStoreCostControllers();
                this.closeSortCostControllers();
            }
            if (severity >= 40000) {
                this.popMe();
            }
        }
    }

    @Override
    public void resetContext() {
        this.nextColumnNumber = 1;
        this.nextTableNumber = 0;
        this.nextSubqueryNumber = 0;
        this.resetNextResultSetNumber();
        this.nextEquivalenceClass = -1;
        this.compilationSchema = null;
        this.parameterList = null;
        this.parameterDescriptors = null;
        this.scanIsolationLevel = 0;
        this.warnings = null;
        this.savedObjects = null;
        this.reliability = 1024;
        this.returnParameterFlag = false;
        this.initRequiredPriv();
        this.scope = true;
        this.cohort = false;
        this.createQueryInfo = true;
        this.optimizeForWrite = false;
        this.statementAlias = null;
        this.scopes.clear();
        this.currentQueryStatementOptimization = false;
        this.isPreparedStatement = false;
        this.allowStatementOptimization = false;
        if (this.constantTokenList != null) {
            this.constantTokenList = new ArrayList();
        }
        if (this.dynamicTokenList != null) {
            this.dynamicTokenList = new ArrayList();
        }
        this.originalParamTypeCompilers = new ArrayList<TypeCompiler>(5);
        this.preparedStatement = null;
        this.generalizedQuery = null;
        this.allTablesReplicatedOnRemote = false;
        this.ncjMetaData = null;
        this.orderByListNullified = false;
        this.isOffsetOrFetchNext = false;
        this.allowSubqueryFlattening = true;
        this.foundNoncorrelatedsubquery = false;
        this.allowOrListOptimization = false;
        this.hasOrList = false;
        this.statementStats = null;
        this.hasQueryHDFS = false;
        this.queryHDFS = false;
        this.originalExecFlags = 0;
        this.convertCharConstToVarchar = false;
        this.ddlForSnappyUse = false;
        this.snappyForcedDDLRouting = false;
        this.executionEngine = ExecutionEngineRule.ExecutionEngine.NOT_DECIDED;
    }

    @Override
    public void resetNumTables() {
        this.nextTableNumber = 0;
        this.nextColumnNumber = 1;
        this.nextSubqueryNumber = 0;
    }

    @Override
    public Parser getParser() {
        return this.parser;
    }

    @Override
    public Parser getMatcher() {
        return this.matcher;
    }

    @Override
    public NodeFactory getNodeFactory() {
        return this.lcf.getNodeFactory();
    }

    @Override
    public int getNextColumnNumber() {
        return this.nextColumnNumber++;
    }

    @Override
    public int getNextTableNumber() {
        return this.nextTableNumber++;
    }

    @Override
    public int getNumTables() {
        return this.nextTableNumber;
    }

    @Override
    public int getNextSubqueryNumber() {
        return this.nextSubqueryNumber++;
    }

    @Override
    public int getNumSubquerys() {
        return this.nextSubqueryNumber;
    }

    @Override
    public int getNextResultSetNumber() {
        return this.nextResultSetNumber++;
    }

    @Override
    public void resetNextResultSetNumber() {
        this.nextResultSetNumber = 0;
    }

    @Override
    public int getNumResultSets() {
        return this.nextResultSetNumber;
    }

    @Override
    public String getUniqueClassName() {
        SanityManager.ASSERT((this.nextClassName <= Long.MAX_VALUE ? 1 : 0) != 0);
        return this.classPrefix.concat(Long.toHexString(this.nextClassName++));
    }

    @Override
    public int getNextEquivalenceClass() {
        return ++this.nextEquivalenceClass;
    }

    @Override
    public ClassFactory getClassFactory() {
        return this.lcf.getClassFactory();
    }

    @Override
    public JavaFactory getJavaFactory() {
        return this.lcf.getJavaFactory();
    }

    @Override
    public void setCurrentDependent(Dependent d) {
        this.currentDependent = d;
    }

    public Dependent getCurrentDependent() {
        return this.currentDependent;
    }

    @Override
    public ProviderList getCurrentAuxiliaryProviderList() {
        return this.currentAPL;
    }

    @Override
    public void setCurrentAuxiliaryProviderList(ProviderList apl) {
        this.currentAPL = apl;
    }

    @Override
    public void createDependency(Provider p) throws StandardException {
        SanityManager.ASSERT((this.currentDependent != null ? 1 : 0) != 0, (String)"no current dependent for compilation");
        if (this.dm == null) {
            this.dm = this.lcc.getDataDictionary().getDependencyManager();
        }
        this.dm.addDependency(this.currentDependent, p, this.getContextManager());
        this.addProviderToAuxiliaryList(p);
    }

    @Override
    public void createDependency(Dependent d, Provider p) throws StandardException {
        if (this.dm == null) {
            this.dm = this.lcc.getDataDictionary().getDependencyManager();
        }
        this.dm.addDependency(d, p, this.getContextManager());
        this.addProviderToAuxiliaryList(p);
    }

    private void addProviderToAuxiliaryList(Provider p) {
        if (this.currentAPL != null) {
            this.currentAPL.addProvider(p);
        }
    }

    @Override
    public int addSavedObject(Object obj) {
        if (this.savedObjects == null) {
            this.savedObjects = new Vector();
        }
        this.savedObjects.addElement(obj);
        return this.savedObjects.size() - 1;
    }

    @Override
    public Object[] getSavedObjects() {
        if (this.savedObjects == null) {
            return null;
        }
        Object[] retVal = new Object[this.savedObjects.size()];
        this.savedObjects.copyInto(retVal);
        this.savedObjects = null;
        return retVal;
    }

    @Override
    public void setSavedObjects(Object[] objs) {
        if (objs == null) {
            return;
        }
        for (int i = 0; i < objs.length; ++i) {
            this.addSavedObject(objs[i]);
        }
    }

    @Override
    public void setCursorInfo(Object cursorInfo) {
        this.cursorInfo = cursorInfo;
    }

    @Override
    public Object getCursorInfo() {
        return this.cursorInfo;
    }

    @Override
    public void firstOnStack() {
        this.firstOnStack = true;
    }

    @Override
    public boolean isFirstOnStack() {
        return this.firstOnStack;
    }

    @Override
    public void setInUse(boolean inUse) {
        this.inUse = inUse;
        if (!inUse) {
            this.closeStoreCostControllers();
            this.closeSortCostControllers();
        }
    }

    @Override
    public boolean getInUse() {
        return this.inUse;
    }

    @Override
    public void setReliability(int reliability) {
        this.reliability = reliability;
    }

    @Override
    public int getReliability() {
        return this.reliability;
    }

    @Override
    public StoreCostController getStoreCostController(long conglomerateNumber) throws StandardException {
        for (int i = 0; i < this.storeCostConglomIds.size(); ++i) {
            Long conglomId = (Long)this.storeCostConglomIds.elementAt(i);
            if (conglomId != conglomerateNumber) continue;
            return (StoreCostController)this.storeCostControllers.elementAt(i);
        }
        StoreCostController retval = this.lcc.getTransactionCompile().openStoreCost(conglomerateNumber);
        this.storeCostControllers.insertElementAt(retval, this.storeCostControllers.size());
        this.storeCostConglomIds.insertElementAt(conglomerateNumber, this.storeCostConglomIds.size());
        return retval;
    }

    private void closeStoreCostControllers() {
        for (int i = 0; i < this.storeCostControllers.size(); ++i) {
            StoreCostController scc = (StoreCostController)this.storeCostControllers.elementAt(i);
            try {
                scc.close();
                continue;
            }
            catch (StandardException standardException) {
                // empty catch block
            }
        }
        this.storeCostControllers.removeAllElements();
        this.storeCostConglomIds.removeAllElements();
    }

    @Override
    public SortCostController getSortCostController() throws StandardException {
        if (this.sortCostController == null) {
            this.sortCostController = this.lcc.getTransactionCompile().openSortCostController(null);
        }
        return this.sortCostController;
    }

    private void closeSortCostControllers() {
        if (this.sortCostController != null) {
            this.sortCostController.close();
            this.sortCostController = null;
        }
    }

    @Override
    public SchemaDescriptor getCompilationSchema() {
        return this.compilationSchema;
    }

    @Override
    public SchemaDescriptor setCompilationSchema(SchemaDescriptor newDefault) {
        SchemaDescriptor tmpSchema = this.compilationSchema;
        this.compilationSchema = newDefault;
        return tmpSchema;
    }

    @Override
    public void setParameterList(Vector<ValueNode> parameterList) {
        int numberOfParameters;
        this.parameterList = parameterList;
        int n = numberOfParameters = parameterList == null ? 0 : parameterList.size();
        if (numberOfParameters > 0) {
            this.parameterDescriptors = new DataTypeDescriptor[numberOfParameters];
            this.originalParamTypeCompilers = new ArrayList<TypeCompiler>(numberOfParameters);
            for (int i = 0; i < numberOfParameters; ++i) {
                this.originalParamTypeCompilers.add(null);
            }
        }
    }

    @Override
    public Vector<ValueNode> getParameterList() {
        return this.parameterList;
    }

    @Override
    public void setReturnParameterFlag() {
        this.returnParameterFlag = true;
    }

    @Override
    public boolean getReturnParameterFlag() {
        return this.returnParameterFlag;
    }

    @Override
    public DataTypeDescriptor[] getParameterTypes() {
        return this.parameterDescriptors;
    }

    @Override
    public List<TypeCompiler> getOriginalParameterTypeCompilers() {
        return this.originalParamTypeCompilers;
    }

    @Override
    public void setScanIsolationLevel(int isolationLevel) {
        this.scanIsolationLevel = isolationLevel;
    }

    @Override
    public int getScanIsolationLevel() {
        return this.scanIsolationLevel;
    }

    @Override
    public TypeCompilerFactory getTypeCompilerFactory() {
        return this.typeCompilerFactory;
    }

    @Override
    public void addWarning(SQLWarning warning) {
        if (this.warnings == null) {
            this.warnings = warning;
        } else {
            this.warnings.setNextWarning(warning);
        }
    }

    @Override
    public SQLWarning getWarnings() {
        return this.warnings;
    }

    public CompilerContextImpl(ContextManager cm, LanguageConnectionContext lcc, TypeCompilerFactory typeCompilerFactory) {
        super(cm, "CompilerContext");
        this.lcc = lcc;
        this.lcf = lcc.getLanguageConnectionFactory();
        this.parser = this.lcf.newParser(this);
        this.matcher = this.lcf.newParser(this);
        this.typeCompilerFactory = typeCompilerFactory;
        this.classPrefix = "ac" + this.lcf.getUUIDFactory().createUUID().toString().replace('-', 'x');
        this.constantTokenList = new ArrayList();
        this.originalParamTypeCompilers = new ArrayList<TypeCompiler>();
        this.dynamicTokenList = new ArrayList();
        this.initRequiredPriv();
    }

    private void initRequiredPriv() {
        this.currPrivType = -1;
        this.privTypeStack.clear();
        this.requiredColumnPrivileges = null;
        this.requiredTablePrivileges = null;
        this.requiredSchemaPrivileges = null;
        this.requiredRoutinePrivileges = null;
        this.requiredRolePrivileges = null;
        if (GemFireXDUtils.TraceAuthentication) {
            StatementContext stmctx = this.lcc.getStatementContext();
            SanityManager.DEBUG_PRINT((String)"TraceAuthentication", (String)(stmctx != null ? stmctx.getStatementText() : " NULL (mostly because lcc.GeneralizedStatement.pushCompilerContext )  using SqlAuthorization = " + this.lcc.usesSqlAuthorization()));
        }
        if (this.lcc.usesSqlAuthorization()) {
            this.requiredColumnPrivileges = new HashMap();
            this.requiredTablePrivileges = new HashMap();
            this.requiredSchemaPrivileges = new HashMap();
            this.requiredRoutinePrivileges = new HashMap();
            this.requiredRolePrivileges = new HashMap();
        }
    }

    @Override
    public void pushCurrentPrivType(int privType) {
        this.privTypeStack.push(ReuseFactory.getInteger(this.currPrivType));
        this.currPrivType = privType;
    }

    @Override
    public void popCurrentPrivType() {
        this.currPrivType = (Integer)this.privTypeStack.pop();
    }

    @Override
    public void addRequiredColumnPriv(ColumnDescriptor column) {
        if (this.requiredColumnPrivileges == null || this.currPrivType == -1 || this.currPrivType == 4 || this.currPrivType == 3 || this.currPrivType == 5 || this.currPrivType == 7 || this.currPrivType == 6 || column == null) {
            return;
        }
        TableDescriptor td = column.getTableDescriptor();
        if (td == null) {
            return;
        }
        if (td.getTableType() == 3) {
            return;
        }
        UUID tableUUID = td.getUUID();
        StatementTablePermission key = new StatementTablePermission(tableUUID, this.currPrivType);
        StatementColumnPermission tableColumnPrivileges = (StatementColumnPermission)this.requiredColumnPrivileges.get(key);
        if (tableColumnPrivileges == null) {
            tableColumnPrivileges = new StatementColumnPermission(tableUUID, this.currPrivType, new FormatableBitSet(td.getNumberOfColumns()));
            this.requiredColumnPrivileges.put(key, tableColumnPrivileges);
        }
        tableColumnPrivileges.getColumns().set(column.getPosition() - 1);
    }

    @Override
    public void addRequiredTablePriv(TableDescriptor table) {
        if (GemFireXDUtils.TraceAuthentication) {
            SanityManager.DEBUG_PRINT((String)"TraceAuthentication", (String)("adding privilege for Table Descriptor=" + SanityManager.lineSeparator + table + SanityManager.lineSeparator + " Required Table Privileges=" + this.requiredTablePrivileges));
        }
        if (this.requiredTablePrivileges == null || table == null) {
            return;
        }
        if (table.getTableType() == 3) {
            return;
        }
        StatementTablePermission key = new StatementTablePermission(table.getUUID(), this.currPrivType);
        this.requiredTablePrivileges.put(key, key);
    }

    @Override
    public void addRequiredRoutinePriv(AliasDescriptor routine) {
        if (this.requiredRoutinePrivileges == null || routine == null) {
            return;
        }
        if (routine.getSchemaUUID().toString().equals("c013800d-00fb-2642-07ec-000000134f30")) {
            return;
        }
        if (this.requiredRoutinePrivileges.get(routine.getUUID()) == null) {
            this.requiredRoutinePrivileges.put(routine.getUUID(), ReuseFactory.getInteger(1));
        }
    }

    @Override
    public void addRequiredSchemaPriv(String schemaName, String aid, int privType) {
        if (this.requiredSchemaPrivileges == null || schemaName == null) {
            return;
        }
        StatementSchemaPermission key = new StatementSchemaPermission(schemaName, aid, privType);
        this.requiredSchemaPrivileges.put(key, key);
    }

    @Override
    public void addRequiredRolePriv(String roleName, int privType) {
        if (this.requiredRolePrivileges == null) {
            return;
        }
        StatementRolePermission key = new StatementRolePermission(roleName, privType);
        this.requiredRolePrivileges.put(key, key);
    }

    @Override
    public List getRequiredPermissionsList() {
        Iterator<Object> itr;
        int size = 0;
        if (this.requiredRoutinePrivileges != null) {
            size += this.requiredRoutinePrivileges.size();
        }
        if (this.requiredTablePrivileges != null) {
            size += this.requiredTablePrivileges.size();
        }
        if (this.requiredSchemaPrivileges != null) {
            size += this.requiredSchemaPrivileges.size();
        }
        if (this.requiredColumnPrivileges != null) {
            size += this.requiredColumnPrivileges.size();
        }
        if (this.requiredRolePrivileges != null) {
            size += this.requiredRolePrivileges.size();
        }
        ArrayList<Object> list = new ArrayList<Object>(size);
        if (this.requiredRoutinePrivileges != null) {
            for (UUID routineUUID : this.requiredRoutinePrivileges.keySet()) {
                list.add(new StatementRoutinePermission(routineUUID));
            }
        }
        if (this.requiredTablePrivileges != null) {
            itr = this.requiredTablePrivileges.values().iterator();
            while (itr.hasNext()) {
                list.add(itr.next());
            }
        }
        if (this.requiredSchemaPrivileges != null) {
            itr = this.requiredSchemaPrivileges.values().iterator();
            while (itr.hasNext()) {
                list.add(itr.next());
            }
        }
        if (this.requiredColumnPrivileges != null) {
            itr = this.requiredColumnPrivileges.values().iterator();
            while (itr.hasNext()) {
                list.add(itr.next());
            }
        }
        if (this.requiredRolePrivileges != null) {
            itr = this.requiredRolePrivileges.values().iterator();
            while (itr.hasNext()) {
                list.add(itr.next());
            }
        }
        if (GemFireXDUtils.TraceAuthentication) {
            SanityManager.DEBUG_PRINT((String)"TraceAuthentication", (String)("Returning required perimission list " + list));
        }
        return list;
    }

    @Override
    public void setGlobalScope() {
        this.scope = true;
    }

    @Override
    public void setLocalScope() {
        this.scope = false;
    }

    @Override
    public boolean isGlobalScope() {
        return this.scope;
    }

    @Override
    public boolean isCohort() {
        return this.cohort;
    }

    @Override
    public void setCohortFlag(boolean flag) {
        this.cohort = flag;
    }

    @Override
    public void clearWarnings() {
        this.warnings = null;
    }

    @Override
    public void disableQueryInfoCreation() {
        this.createQueryInfo = false;
    }

    @Override
    public boolean createQueryInfo() {
        return this.createQueryInfo;
    }

    @Override
    public final boolean isPreparedStatement() {
        return this.isPreparedStatement;
    }

    @Override
    public final void setPreparedStatement() {
        this.isPreparedStatement = true;
    }

    @Override
    public final void addConstantTokenToList(com.pivotal.gemfirexd.internal.engine.sql.compile.Token constnode) {
        this.constantTokenList.add(constnode);
    }

    @Override
    public final void storeTypeCompilerForParam(TypeCompiler tc) {
        this.originalParamTypeCompilers.add(tc);
    }

    @Override
    public final ArrayList<com.pivotal.gemfirexd.internal.engine.sql.compile.Token> getConstantTokenLists() {
        return this.constantTokenList;
    }

    @Override
    public final boolean canOptimizeLiteral() {
        return this.currentQueryStatementOptimization;
    }

    @Override
    public final void allowOptimizeLiteral(boolean onOff) {
        this.allowStatementOptimization = onOff;
    }

    @Override
    public final boolean isOptimizeLiteralAllowed() {
        return this.allowStatementOptimization;
    }

    @Override
    public void pushDML(int parenthesisCount) {
        if (this.scopes.size() > 0) {
            this.scopes.peek().setOptimizationFlag(this.currentQueryStatementOptimization);
        }
        this.currentQueryStatementOptimization = this.allowStatementOptimization;
        this.scopes.push(new DMLScope(parenthesisCount));
    }

    @Override
    public final boolean switchOptimizeLiteral(boolean onOff) {
        boolean existingVal = this.currentQueryStatementOptimization;
        this.currentQueryStatementOptimization = onOff;
        return existingVal;
    }

    @Override
    public boolean popDML(int parenthesisCount) {
        if (this.scopes.size() > 0 && parenthesisCount == this.scopes.peek().getParenthesisCount() - 1) {
            this.scopes.pop();
            if (this.scopes.size() > 0) {
                this.currentQueryStatementOptimization = this.scopes.peek().getOptimizationFlag();
            }
            return true;
        }
        return false;
    }

    @Override
    public GenericPreparedStatement getPreparedStatement() {
        return this.preparedStatement;
    }

    @Override
    public void setPreparedStatement(GenericPreparedStatement preparedSt) throws StandardException {
        this.preparedStatement = preparedSt;
        this.parameterDescriptors = this.preparedStatement.getParameterTypes();
        this.originalParamTypeCompilers = this.preparedStatement.getOriginalParameterTypeCompilers();
    }

    @Override
    public void setSubqueryFlatteningFlag(boolean allowed) {
        this.allowSubqueryFlattening = allowed;
    }

    @Override
    public boolean subqueryFlatteningAllowed() {
        return this.allowSubqueryFlattening;
    }

    @Override
    public boolean containsNoncorrelatedSubquery() {
        return this.foundNoncorrelatedsubquery;
    }

    @Override
    public void setNoncorrelatedSubqueryFound() {
        this.foundNoncorrelatedsubquery = true;
    }

    @Override
    public boolean orListOptimizationAllowed() {
        return this.allowOrListOptimization;
    }

    @Override
    public void setOrListOptimizationFlag(boolean allowed) {
        this.allowOrListOptimization = allowed;
    }

    @Override
    public boolean hasOrList() {
        return this.hasOrList;
    }

    @Override
    public void setHasOrList(boolean flag) {
        this.hasOrList = flag;
    }

    @Override
    public boolean optimizeForWrite() {
        return this.optimizeForWrite;
    }

    @Override
    public boolean withSecondaries() {
        return this.withSecondaries;
    }

    @Override
    public void setOptimizeForWrite(boolean onlyPrimaries) {
        this.optimizeForWrite = onlyPrimaries;
    }

    @Override
    public void setWithSecondaries(boolean includeSecondaries) {
        this.withSecondaries = includeSecondaries;
    }

    @Override
    public void setStatementAlias(String alias) {
        this.statementAlias = alias;
    }

    @Override
    public String getStatementAlias() {
        return this.statementAlias;
    }

    @Override
    public void setStatementStats(StatementStats stats) {
        this.statementStats = stats;
    }

    @Override
    public StatementStats getStatementStats() {
        return this.statementStats;
    }

    @Override
    public void setParentPS(GenericPreparedStatement gps) {
        this.parentPS = gps;
    }

    @Override
    public GenericPreparedStatement getParentPS() {
        return this.parentPS;
    }

    @Override
    public boolean allTablesAreReplicatedOnRemote() {
        return this.allTablesReplicatedOnRemote;
    }

    @Override
    public void setAllTablesAreReplicatedOnRemote(boolean allReplicated) {
        this.allTablesReplicatedOnRemote = allReplicated;
    }

    @Override
    public boolean isNCJoinOnRemote() {
        return this.ncjMetaData != null;
    }

    @Override
    public THashMap getNCJMetaDataOnRemote() {
        return this.ncjMetaData;
    }

    @Override
    public void setNCJoinOnRemote(THashMap ncjMetaData) {
        this.ncjMetaData = ncjMetaData;
    }

    @Override
    public void setOrderByListNullified() {
        this.orderByListNullified = true;
    }

    @Override
    public boolean isOrderByListNullified() {
        return this.orderByListNullified;
    }

    @Override
    public void setIsOffsetOrFetchNext() {
        this.isOffsetOrFetchNext = true;
    }

    @Override
    public boolean isOffsetOrFetchNext() {
        return this.isOffsetOrFetchNext;
    }

    @Override
    public void setGeneralizedQueryString(String query) {
        this.generalizedQuery = query;
    }

    @Override
    public String getGeneralizedQueryString() {
        return this.generalizedQuery;
    }

    @Override
    public void setQueryHDFS(boolean val) {
        this.queryHDFS = val;
    }

    @Override
    public boolean getQueryHDFS() {
        return this.queryHDFS;
    }

    @Override
    public boolean getHasQueryHDFS() {
        return this.hasQueryHDFS;
    }

    @Override
    public void setHasQueryHDFS(boolean hasQueryHDFS) {
        this.hasQueryHDFS = hasQueryHDFS;
    }

    @Override
    public void setExecutionEngine(ExecutionEngineRule.ExecutionEngine engine) {
        this.executionEngine = engine;
    }

    @Override
    public ExecutionEngineRule.ExecutionEngine getExecutionEngine() {
        return this.executionEngine;
    }

    @Override
    public void setOriginalExecFlags(short execFlags) {
        this.originalExecFlags = execFlags;
    }

    @Override
    public short getOriginalExecFlags() {
        return this.originalExecFlags;
    }

    @Override
    public boolean convertCharConstToVarchar() {
        return this.convertCharConstToVarchar;
    }

    @Override
    public void setConvertCharConstToVarchar(boolean flag) {
        this.convertCharConstToVarchar = flag;
    }

    @Override
    public boolean isMarkedAsDDLForSnappyUse() {
        return this.ddlForSnappyUse;
    }

    @Override
    public void markAsDDLForSnappyUse(boolean flag) {
        this.ddlForSnappyUse = flag;
    }

    @Override
    public boolean isForcedDDLrouting() {
        return this.snappyForcedDDLRouting;
    }

    @Override
    public void setForcedDDLrouting(boolean flag) {
        this.snappyForcedDDLRouting = flag;
    }

    @Override
    public void addDynamicTokenToList(Token token) {
        this.dynamicTokenList.add(token);
    }

    @Override
    public ArrayList<Token> getDynamicTokenList() {
        return this.dynamicTokenList;
    }

    private static class DMLScope {
        private final int parenthesisCount;
        private boolean shouldOptimizeLiteral;

        DMLScope(int paren) {
            this.parenthesisCount = paren;
        }

        public final boolean getOptimizationFlag() {
            return this.shouldOptimizeLiteral;
        }

        public final void setOptimizationFlag(boolean onOff) {
            this.shouldOptimizeLiteral = onOff;
        }

        public int getParenthesisCount() {
            return this.parenthesisCount;
        }
    }
}

