/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.iapi.services.loader.ClassFactory;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.TypeId;
import com.pivotal.gemfirexd.internal.impl.sql.compile.BaseTypeCompiler;

public class BooleanTypeCompiler
extends BaseTypeCompiler {
    @Override
    public boolean convertible(TypeId otherType, boolean forDataTypeFunction) {
        int otherJDBCTypeId = otherType.getJDBCTypeId();
        return otherJDBCTypeId != 91 && otherJDBCTypeId != 92 && otherJDBCTypeId != 93 && otherJDBCTypeId != 2000;
    }

    @Override
    public boolean compatible(TypeId otherType) {
        return this.convertible(otherType, false);
    }

    @Override
    public boolean storable(TypeId otherType, ClassFactory cf) {
        if (otherType.isBooleanTypeId() || otherType.isStringTypeId() || otherType.isNumericTypeId()) {
            return true;
        }
        return this.userTypeStorable(this.getTypeId(), otherType, cf);
    }

    @Override
    public String interfaceName() {
        return "com.pivotal.gemfirexd.internal.iapi.types.BooleanDataValue";
    }

    @Override
    public String getCorrespondingPrimitiveTypeName() {
        return "boolean";
    }

    @Override
    public String getPrimitiveMethodName() {
        return "getBoolean";
    }

    @Override
    public int getCastToCharWidth(DataTypeDescriptor dts) {
        return 5;
    }

    @Override
    String nullMethodName() {
        return "getNullBoolean";
    }
}

