/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.MethodBuilder;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.compile.BinaryOperatorNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ExpressionClassBuilder;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SubqueryList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNode;
import java.util.Vector;

abstract class BinaryLogicalOperatorNode
extends BinaryOperatorNode {
    boolean shortCircuitValue;

    BinaryLogicalOperatorNode() {
    }

    @Override
    public void init(Object leftOperand, Object rightOperand, Object methodName) {
        super.init(leftOperand, rightOperand, methodName, methodName, "com.pivotal.gemfirexd.internal.iapi.types.BooleanDataValue", "com.pivotal.gemfirexd.internal.iapi.types.BooleanDataValue");
    }

    @Override
    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector aggregateVector) throws StandardException {
        if (this.leftOperand.isParameterNode() || this.rightOperand.isParameterNode()) {
            throw StandardException.newException("42X19", "PARAMETER");
        }
        super.bindExpression(fromList, subqueryList, aggregateVector);
        return this;
    }

    @Override
    public boolean verifyEliminateNots() {
        return this.leftOperand.verifyEliminateNots() && this.rightOperand.verifyEliminateNots();
    }

    @Override
    public void generateExpression(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        this.leftOperand.generateExpression(acb, mb);
        mb.dup();
        mb.push(this.shortCircuitValue);
        mb.callMethod((short)185, null, "equals", "boolean", 1);
        mb.conditionalIf();
        mb.callMethod((short)185, null, "getImmutable", "com.pivotal.gemfirexd.internal.iapi.types.BooleanDataValue", 0);
        mb.startElseCode();
        this.rightOperand.generateExpression(acb, mb);
        mb.upCast("com.pivotal.gemfirexd.internal.iapi.types.BooleanDataValue");
        mb.callMethod((short)185, null, this.methodName, "com.pivotal.gemfirexd.internal.iapi.types.BooleanDataValue", 1);
        mb.completeConditional();
    }

    DataTypeDescriptor resolveLogicalBinaryOperator(DataTypeDescriptor leftType, DataTypeDescriptor rightType) throws StandardException {
        if (!leftType.getTypeId().isBooleanTypeId() || !rightType.getTypeId().isBooleanTypeId()) {
            throw StandardException.newException("42Y94");
        }
        return leftType.getNullabilityType(leftType.isNullable() || rightType.isNullable());
    }
}

