/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfoContext;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.MethodBuilder;
import com.pivotal.gemfirexd.internal.iapi.services.context.ContextManager;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.NodeFactory;
import com.pivotal.gemfirexd.internal.impl.sql.compile.AndNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.BinaryComparisonOperatorNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.BinaryListOperatorNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ColumnReference;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ExpressionClassBuilder;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.OrNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.PredicateList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.QueryTreeNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SubqueryList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNodeList;

public class BetweenOperatorNode
extends BinaryListOperatorNode {
    @Override
    public void init(Object leftOperand, Object betweenValues) {
        ValueNodeList betweenVals = (ValueNodeList)betweenValues;
        SanityManager.ASSERT((betweenVals.size() == 2 ? 1 : 0) != 0, (String)("betweenValues.size() (" + betweenVals.size() + ") is expected to be 2"));
        super.init(leftOperand, betweenValues, "BETWEEN", null);
    }

    @Override
    public ValueNode eliminateNots(boolean underNotNode) throws StandardException {
        if (this.rightOperandList.size() != 2) {
            SanityManager.ASSERT((this.rightOperandList.size() == 2 ? 1 : 0) != 0, (String)("rightOperandList.size() (" + this.rightOperandList.size() + ") is expected to be 2"));
        }
        if (!underNotNode) {
            return this;
        }
        NodeFactory nodeFactory = this.getNodeFactory();
        ContextManager cm = this.getContextManager();
        BinaryComparisonOperatorNode leftBCO = (BinaryComparisonOperatorNode)nodeFactory.getNode(45, this.leftOperand, this.rightOperandList.elementAt(0), cm);
        leftBCO.bindComparisonOperator();
        BinaryComparisonOperatorNode rightBCO = (BinaryComparisonOperatorNode)nodeFactory.getNode(43, this.leftOperand, this.rightOperandList.elementAt(1), cm);
        rightBCO.bindComparisonOperator();
        OrNode newOr = (OrNode)nodeFactory.getNode(52, leftBCO, rightBCO, cm);
        newOr.postBindFixup();
        leftBCO.setBetweenSelectivity();
        rightBCO.setBetweenSelectivity();
        return newOr;
    }

    @Override
    public ValueNode preprocess(int numTables, FromList outerFromList, SubqueryList outerSubqueryList, PredicateList outerPredicateList) throws StandardException {
        super.preprocess(numTables, outerFromList, outerSubqueryList, outerPredicateList);
        if (!(this.leftOperand instanceof ColumnReference)) {
            return this;
        }
        ValueNode leftClone1 = this.leftOperand.getClone();
        NodeFactory nodeFactory = this.getNodeFactory();
        ContextManager cm = this.getContextManager();
        QueryTreeNode trueNode = nodeFactory.getNode(38, Boolean.TRUE, cm);
        BinaryComparisonOperatorNode lessEqual = (BinaryComparisonOperatorNode)nodeFactory.getNode(44, leftClone1, this.rightOperandList.elementAt(1), cm);
        lessEqual.bindComparisonOperator();
        AndNode newAnd = (AndNode)nodeFactory.getNode(39, lessEqual, trueNode, cm);
        newAnd.postBindFixup();
        BinaryComparisonOperatorNode greaterEqual = (BinaryComparisonOperatorNode)nodeFactory.getNode(42, this.leftOperand, this.rightOperandList.elementAt(0), cm);
        greaterEqual.bindComparisonOperator();
        newAnd = (AndNode)nodeFactory.getNode(39, greaterEqual, newAnd, cm);
        newAnd.postBindFixup();
        lessEqual.setBetweenSelectivity();
        greaterEqual.setBetweenSelectivity();
        return newAnd;
    }

    @Override
    public void generateExpression(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        SanityManager.ASSERT((this.rightOperandList.size() == 2 ? 1 : 0) != 0, (String)("rightOperandList.size() (" + this.rightOperandList.size() + ") is expected to be 2"));
        NodeFactory nodeFactory = this.getNodeFactory();
        ContextManager cm = this.getContextManager();
        BinaryComparisonOperatorNode leftBCO = (BinaryComparisonOperatorNode)nodeFactory.getNode(42, this.leftOperand, this.rightOperandList.elementAt(0), cm);
        leftBCO.bindComparisonOperator();
        BinaryComparisonOperatorNode rightBCO = (BinaryComparisonOperatorNode)nodeFactory.getNode(44, this.leftOperand, this.rightOperandList.elementAt(1), cm);
        rightBCO.bindComparisonOperator();
        AndNode newAnd = (AndNode)nodeFactory.getNode(39, leftBCO, rightBCO, cm);
        newAnd.postBindFixup();
        newAnd.generateExpression(acb, mb);
    }

    @Override
    public QueryInfo computeQueryInfo(QueryInfoContext qic) throws StandardException {
        return null;
    }

    @Override
    public String ncjGenerateSql() {
        String leftSql = this.leftOperand.ncjGenerateSql();
        if (leftSql == null) {
            return null;
        }
        StringBuilder sqlStr = new StringBuilder();
        sqlStr.append(leftSql);
        sqlStr.append(" ");
        sqlStr.append(this.operator);
        sqlStr.append(" ");
        for (int index = 0; index < this.rightOperandList.size(); ++index) {
            ValueNode vNode = (ValueNode)this.rightOperandList.elementAt(index);
            if (index != 0) {
                sqlStr.append(" and ");
            }
            sqlStr.append(vNode.ncjGenerateSql());
        }
        sqlStr.append(" ");
        return sqlStr.toString();
    }
}

