/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.gemstone.gemfire.InternalGemFireError;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Visitable;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.VisitorAdaptor;
import com.pivotal.gemfirexd.internal.iapi.util.JBitSet;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ColumnReference;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromBaseTable;
import com.pivotal.gemfirexd.internal.impl.sql.compile.PredicateList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumn;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SelectNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SubqueryNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.VirtualColumnNode;

public class BaseTableNumbersVisitor
extends VisitorAdaptor {
    private JBitSet tableMap;
    private int columnNumber;
    private JBitSet origTableMap;

    public BaseTableNumbersVisitor(JBitSet tableMap) {
        this.tableMap = tableMap;
        this.columnNumber = -1;
    }

    protected void setTableMap(JBitSet tableMap) {
        this.tableMap = tableMap;
    }

    protected void reset() {
        this.tableMap.clearAll();
        this.columnNumber = -1;
    }

    protected int getColumnNumber() {
        return this.columnNumber;
    }

    @Override
    public Visitable visit(Visitable node) throws StandardException {
        ResultColumn rc = null;
        if (node instanceof ColumnReference) {
            rc = ((ColumnReference)node).getSource();
            if (rc == null) {
                return node;
            }
        } else if (node instanceof ResultColumn) {
            rc = (ResultColumn)node;
        } else if (node instanceof SelectNode) {
            ((SelectNode)node).getFromList().accept(this);
        } else if (node instanceof FromBaseTable) {
            this.tableMap.set(((FromBaseTable)node).getTableNumber());
        }
        if (rc != null) {
            int baseTableNumber = rc.getTableNumber();
            if (baseTableNumber >= 0) {
                ValueNode rcExpr = rc.getExpression();
                while (rcExpr instanceof VirtualColumnNode) {
                    rc = ((VirtualColumnNode)rcExpr).getSourceColumn();
                    rcExpr = rc.getExpression();
                }
                if (rcExpr instanceof ColumnReference) {
                    rcExpr.accept(this);
                } else {
                    this.tableMap.set(baseTableNumber);
                    this.columnNumber = rc.getColumnPosition();
                }
            } else if (node instanceof ColumnReference) {
                ColumnReference cr = (ColumnReference)node;
                cr.getTablesReferenced(this.tableMap);
                this.columnNumber = cr.getColumnNumber();
            }
        } else if (node instanceof SubqueryNode) {
            ((SubqueryNode)node).categorize(this.tableMap, false);
        }
        return node;
    }

    @Override
    public boolean skipChildren(Visitable node) {
        return node instanceof FromBaseTable || node instanceof SelectNode || node instanceof PredicateList;
    }

    @Override
    public boolean stopTraversal() {
        return false;
    }

    @Override
    public boolean supportsDeltaMerge() {
        return true;
    }

    @Override
    public boolean initForDeltaState() {
        if (this.origTableMap == null) {
            this.origTableMap = this.tableMap;
            this.tableMap = new JBitSet(this.origTableMap.size());
            return true;
        }
        return false;
    }

    @Override
    public Object getAndResetDeltaState() {
        if (this.origTableMap != null) {
            TableNumbersState deltaState = new TableNumbersState(this.tableMap, this.columnNumber);
            this.origTableMap.or(this.tableMap);
            this.tableMap = this.origTableMap;
            this.origTableMap = null;
            return deltaState;
        }
        throw new InternalGemFireError("unexpected invocation");
    }

    @Override
    public Visitable mergeDeltaState(Object delta, Visitable node) {
        TableNumbersState deltaState = (TableNumbersState)delta;
        this.tableMap.or(deltaState.tableMap);
        this.columnNumber = deltaState.columnNumber;
        return node;
    }

    static final class TableNumbersState {
        final JBitSet tableMap;
        final int columnNumber;

        TableNumbersState(JBitSet tableMap, int columnNumber) {
            this.tableMap = tableMap;
            this.columnNumber = columnNumber;
        }
    }
}

