/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.gemstone.gemfire.cache.hdfs.HDFSStoreMutator;
import com.gemstone.gemfire.cache.hdfs.internal.HDFSStoreMutatorImpl;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ConstantAction;
import com.pivotal.gemfirexd.internal.iapi.util.StringUtil;
import com.pivotal.gemfirexd.internal.impl.sql.compile.DDLStatementNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.NumericConstantNode;
import com.pivotal.gemfirexd.internal.shared.common.SharedUtils;
import java.util.Map;

public final class AlterHDFSStoreNode
extends DDLStatementNode {
    private String hdfsStoreName;
    private HDFSStoreMutator mutator;
    private Map<Object, Object> otherAttribs;
    public static final String BATCHSIZE = "batchsize";
    public static final String BATCHTIMEINTERVAL = "batchtimeinterval";
    public static final String MINORCOMPACT = "minorcompact";
    public static final String MAJORCOMPACT = "majorcompact";
    public static final String MAXINPUTFILESIZE = "maxinputfilesize";
    public static final String MININPUTFILECOUNT = "mininputfilecount";
    public static final String MAXINPUTFILECOUNT = "maxinputfilecount";
    public static final String MINORCOMPACTIONTHREADS = "minorcompactionthreads";
    public static final String MAJORCOMPACTIONINTERVAL = "majorcompactioninterval";
    public static final String MAJORCOMPACTIONTHREADS = "majorcompactionthreads";
    public static final String MAXWRITEONLYFILESIZE = "maxwriteonlyfilesize";
    public static final String WRITEONLYFILEROLLOVERINTERVAL = "writeonlyfilerolloverinterval";
    public static final String PURGEINTERVAL = "purgeinterval";

    @Override
    public void init(Object arg1, Object arg2) throws StandardException {
        this.hdfsStoreName = SharedUtils.SQLToUpperCase((String)((String)arg1));
        this.otherAttribs = (Map)arg2;
        this.mutator = new HDFSStoreMutatorImpl();
        HDFSStoreMutator.HDFSCompactionConfigMutator compactionMutator = this.mutator.getCompactionConfigMutator();
        HDFSStoreMutator.HDFSEventQueueAttributesMutator qMutator = this.mutator.getHDFSEventQueueAttributesMutator();
        for (Map.Entry<Object, Object> entry : this.otherAttribs.entrySet()) {
            int concurrency;
            String val;
            NumericConstantNode ncn;
            String key = (String)entry.getKey();
            Object vn = entry.getValue();
            if (key.equalsIgnoreCase(BATCHSIZE)) {
                ncn = (NumericConstantNode)vn;
                qMutator.setBatchSizeMB(ncn.getValue().getInt());
                continue;
            }
            if (key.equalsIgnoreCase(BATCHTIMEINTERVAL)) {
                ncn = (NumericConstantNode)vn;
                qMutator.setBatchTimeInterval(ncn.getValue().getInt());
                continue;
            }
            if (key.equalsIgnoreCase(MINORCOMPACT)) {
                val = (String)vn;
                if (val.equalsIgnoreCase("true")) {
                    compactionMutator.setAutoCompaction(Boolean.TRUE.booleanValue());
                    continue;
                }
                if (val.equalsIgnoreCase("false")) {
                    compactionMutator.setAutoCompaction(Boolean.FALSE.booleanValue());
                    continue;
                }
                throw StandardException.newException("XCY00.S", (Object)StringUtil.SQLToUpperCase(MINORCOMPACT), (Object)val);
            }
            if (key.equalsIgnoreCase(MAJORCOMPACT)) {
                val = (String)vn;
                if (val.equalsIgnoreCase("true")) {
                    compactionMutator.setAutoMajorCompaction(Boolean.TRUE.booleanValue());
                    continue;
                }
                if (val.equalsIgnoreCase("false")) {
                    compactionMutator.setAutoMajorCompaction(Boolean.FALSE.booleanValue());
                    continue;
                }
                throw StandardException.newException("XCY00.S", (Object)StringUtil.SQLToUpperCase(MAJORCOMPACT), (Object)val);
            }
            if (key.equalsIgnoreCase(MAXINPUTFILESIZE)) {
                ncn = (NumericConstantNode)vn;
                compactionMutator.setMaxInputFileSizeMB(ncn.getValue().getInt());
                continue;
            }
            if (key.equalsIgnoreCase(MININPUTFILECOUNT)) {
                ncn = (NumericConstantNode)vn;
                compactionMutator.setMinInputFileCount(ncn.getValue().getInt());
                continue;
            }
            if (key.equalsIgnoreCase(MAXINPUTFILECOUNT)) {
                ncn = (NumericConstantNode)vn;
                compactionMutator.setMaxInputFileCount(ncn.getValue().getInt());
                continue;
            }
            if (key.equalsIgnoreCase(MINORCOMPACTIONTHREADS)) {
                ncn = (NumericConstantNode)vn;
                concurrency = ncn.getValue().getInt();
                if (concurrency <= 0) {
                    throw StandardException.newException("XCY00.S", (Object)StringUtil.SQLToUpperCase(MINORCOMPACTIONTHREADS), (Object)concurrency);
                }
                compactionMutator.setMaxThreads(concurrency);
                continue;
            }
            if (key.equalsIgnoreCase(MAJORCOMPACTIONINTERVAL)) {
                ncn = (NumericConstantNode)vn;
                compactionMutator.setMajorCompactionIntervalMins(ncn.getValue().getInt());
                continue;
            }
            if (key.equalsIgnoreCase(MAJORCOMPACTIONTHREADS)) {
                ncn = (NumericConstantNode)vn;
                concurrency = ncn.getValue().getInt();
                if (concurrency <= 0) {
                    throw StandardException.newException("XCY00.S", (Object)StringUtil.SQLToUpperCase(MAJORCOMPACTIONTHREADS), (Object)concurrency);
                }
                compactionMutator.setMajorCompactionMaxThreads(concurrency);
                continue;
            }
            if (key.equalsIgnoreCase(MAXWRITEONLYFILESIZE)) {
                ncn = (NumericConstantNode)vn;
                this.mutator.setMaxFileSize(ncn.getValue().getInt());
                continue;
            }
            if (key.equalsIgnoreCase(WRITEONLYFILEROLLOVERINTERVAL)) {
                ncn = (NumericConstantNode)vn;
                this.mutator.setFileRolloverInterval(ncn.getValue().getInt());
                continue;
            }
            if (!key.equalsIgnoreCase(PURGEINTERVAL)) continue;
            ncn = (NumericConstantNode)vn;
            compactionMutator.setOldFilesCleanupIntervalMins(ncn.getValue().getInt());
        }
    }

    @Override
    public String statementToString() {
        return "ALTER HDFSSTORE";
    }

    @Override
    public ConstantAction makeConstantAction() {
        return this.getGenericConstantActionFactory().getAlterHDFSStoreConstantAction(this.hdfsStoreName, this.mutator);
    }
}

