/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.AccessPath;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.CostEstimate;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.JoinStrategy;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Optimizer;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConglomerateDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConstraintDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;

class AccessPathImpl
implements AccessPath {
    ConglomerateDescriptor cd = null;
    private CostEstimate costEstimate = null;
    boolean coveringIndexScan = false;
    boolean nonMatchingIndexScan = false;
    JoinStrategy joinStrategy = null;
    int lockMode;
    Optimizer optimizer;
    private String accessPathName = "";
    private boolean supportsMoveToNextKey = false;

    AccessPathImpl(Optimizer optimizer) {
        this.optimizer = optimizer;
    }

    @Override
    public void setConglomerateDescriptor(ConglomerateDescriptor cd) {
        this.cd = cd;
    }

    @Override
    public ConglomerateDescriptor getConglomerateDescriptor() {
        return this.cd;
    }

    @Override
    public void setCostEstimate(CostEstimate costEstimate) {
        if (this.costEstimate == null) {
            if (costEstimate != null) {
                this.costEstimate = costEstimate.cloneMe();
            }
        } else if (costEstimate == null) {
            this.costEstimate = null;
        } else {
            this.costEstimate.setCost(costEstimate);
        }
    }

    @Override
    public CostEstimate getCostEstimate() {
        return this.costEstimate;
    }

    @Override
    public void setCoveringIndexScan(boolean coveringIndexScan) {
        this.coveringIndexScan = coveringIndexScan;
    }

    @Override
    public boolean getCoveringIndexScan() {
        return this.coveringIndexScan;
    }

    @Override
    public void setNonMatchingIndexScan(boolean nonMatchingIndexScan) {
        this.nonMatchingIndexScan = nonMatchingIndexScan;
    }

    @Override
    public boolean getNonMatchingIndexScan() {
        return this.nonMatchingIndexScan;
    }

    @Override
    public void setJoinStrategy(JoinStrategy joinStrategy) {
        this.joinStrategy = joinStrategy;
    }

    @Override
    public JoinStrategy getJoinStrategy() {
        return this.joinStrategy;
    }

    @Override
    public void setLockMode(int lockMode) {
        this.lockMode = lockMode;
    }

    @Override
    public int getLockMode() {
        return this.lockMode;
    }

    @Override
    public void copy(AccessPath copyFrom) {
        this.setConglomerateDescriptor(copyFrom.getConglomerateDescriptor());
        this.setCostEstimate(copyFrom.getCostEstimate());
        this.setCoveringIndexScan(copyFrom.getCoveringIndexScan());
        this.setNonMatchingIndexScan(copyFrom.getNonMatchingIndexScan());
        this.setJoinStrategy(copyFrom.getJoinStrategy());
        this.setLockMode(copyFrom.getLockMode());
        this.setSupportsMoveToNextKey(copyFrom.getFlagSupportsMoveToNextKey());
    }

    @Override
    public Optimizer getOptimizer() {
        return this.optimizer;
    }

    public String toString() {
        return "cd == " + this.cd + ", costEstimate == " + this.costEstimate + ", coveringIndexScan == " + this.coveringIndexScan + ", nonMatchingIndexScan == " + this.nonMatchingIndexScan + ", joinStrategy == " + this.joinStrategy + ", lockMode == " + this.lockMode + ", optimizer level == " + this.optimizer.getLevel();
    }

    @Override
    public void initializeAccessPathName(DataDictionary dd, TableDescriptor td) throws StandardException {
        if (this.cd == null) {
            return;
        }
        if (this.cd.isConstraint()) {
            ConstraintDescriptor constraintDesc = dd.getConstraintDescriptor(td, this.cd.getUUID());
            if (constraintDesc == null) {
                throw StandardException.newException("42X94", (Object)"CONSTRAINT on TABLE", (Object)td.getName());
            }
            this.accessPathName = constraintDesc.getConstraintName();
        } else {
            this.accessPathName = this.cd.isIndex() ? this.cd.getConglomerateName() : "";
        }
    }

    @Override
    public void setSupportsMoveToNextKey(boolean supports) {
        this.supportsMoveToNextKey = supports;
    }

    @Override
    public boolean getFlagSupportsMoveToNextKey() {
        return this.supportsMoveToNextKey;
    }
}

